/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.urls;

import ai.org.jfree.chart.urls.XYURLGenerator;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.util.ObjectUtilities;
import java.io.Serializable;

public class StandardXYURLGenerator
implements XYURLGenerator,
Serializable {
    private static final long serialVersionUID = -1771624523496595382L;
    public static final String DEFAULT_PREFIX = "index.html";
    public static final String DEFAULT_SERIES_PARAMETER = "series";
    public static final String DEFAULT_ITEM_PARAMETER = "item";
    private String prefix;
    private String seriesParameterName;
    private String itemParameterName;

    public StandardXYURLGenerator() {
        this(DEFAULT_PREFIX, DEFAULT_SERIES_PARAMETER, DEFAULT_ITEM_PARAMETER);
    }

    public StandardXYURLGenerator(String string) {
        this(string, DEFAULT_SERIES_PARAMETER, DEFAULT_ITEM_PARAMETER);
    }

    public StandardXYURLGenerator(String string, String string2, String string3) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'prefix' argument.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Null 'seriesParameterName' argument.");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("Null 'itemParameterName' argument.");
        }
        this.prefix = string;
        this.seriesParameterName = string2;
        this.itemParameterName = string3;
    }

    public String generateURL(XYDataset xYDataset, int n, int n2) {
        String string = this.prefix;
        boolean bl = string.indexOf("?") == -1;
        string = string + (bl ? "?" : "&amp;");
        string = string + this.seriesParameterName + "=" + n + "&amp;" + this.itemParameterName + "=" + n2;
        return string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardXYURLGenerator)) {
            return false;
        }
        StandardXYURLGenerator standardXYURLGenerator = (StandardXYURLGenerator)object;
        if (!ObjectUtilities.equal(standardXYURLGenerator.prefix, this.prefix)) {
            return false;
        }
        if (!ObjectUtilities.equal(standardXYURLGenerator.seriesParameterName, this.seriesParameterName)) {
            return false;
        }
        return ObjectUtilities.equal(standardXYURLGenerator.itemParameterName, this.itemParameterName);
    }
}

