/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.xy;

import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.labels.ItemLabelPosition;
import ai.org.jfree.chart.labels.XYItemLabelGenerator;
import ai.org.jfree.chart.plot.CrosshairState;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRendererState;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.xy.IntervalXYDataset;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.text.TextUtilities;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PublicCloneable;
import ai.org.jfree.util.ShapeUtilities;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class YIntervalRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -2951586537224143260L;
    private XYItemLabelGenerator additionalItemLabelGenerator = null;

    public XYItemLabelGenerator getAdditionalItemLabelGenerator() {
        return this.additionalItemLabelGenerator;
    }

    public void setAdditionalItemLabelGenerator(XYItemLabelGenerator xYItemLabelGenerator) {
        this.additionalItemLabelGenerator = xYItemLabelGenerator;
        this.fireChangeEvent();
    }

    public Range findRangeBounds(XYDataset xYDataset) {
        return this.findRangeBounds(xYDataset, true);
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        EntityCollection entityCollection = null;
        if (plotRenderingInfo != null) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
        double d = intervalXYDataset.getXValue(n, n2);
        double d2 = intervalXYDataset.getStartYValue(n, n2);
        double d3 = intervalXYDataset.getEndYValue(n, n2);
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d4 = valueAxis.valueToJava2D(d, rectangle2D, rectangleEdge);
        double d5 = valueAxis2.valueToJava2D(d2, rectangle2D, rectangleEdge2);
        double d6 = valueAxis2.valueToJava2D(d3, rectangle2D, rectangleEdge2);
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        Line2D.Double double_ = null;
        Shape shape = this.getItemShape(n, n2);
        Shape shape2 = null;
        Shape shape3 = null;
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(d5, d4, d6, d4);
            shape2 = ShapeUtilities.createTranslatedShape(shape, d6, d4);
            shape3 = ShapeUtilities.createTranslatedShape(shape, d5, d4);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(d4, d5, d4, d6);
            shape2 = ShapeUtilities.createTranslatedShape(shape, d4, d6);
            shape3 = ShapeUtilities.createTranslatedShape(shape, d4, d5);
        }
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        graphics2D.draw(double_);
        graphics2D.fill(shape2);
        graphics2D.fill(shape3);
        if (this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, plotOrientation, xYDataset, n, n2, d4, d6, false);
            this.drawAdditionalItemLabel(graphics2D, plotOrientation, xYDataset, n, n2, d4, d5);
        }
        if (entityCollection != null) {
            this.addEntity(entityCollection, double_.getBounds(), xYDataset, n, n2, 0.0, 0.0);
        }
    }

    private void drawAdditionalItemLabel(Graphics2D graphics2D, PlotOrientation plotOrientation, XYDataset xYDataset, int n, int n2, double d, double d2) {
        if (this.additionalItemLabelGenerator == null) {
            return;
        }
        Font font = this.getItemLabelFont(n, n2);
        Paint paint = this.getItemLabelPaint(n, n2);
        graphics2D.setFont(font);
        graphics2D.setPaint(paint);
        String string = this.additionalItemLabelGenerator.generateLabel(xYDataset, n, n2);
        ItemLabelPosition itemLabelPosition = this.getNegativeItemLabelPosition(n, n2);
        Point2D point2D = this.calculateLabelAnchorPoint(itemLabelPosition.getItemLabelAnchor(), d, d2, plotOrientation);
        TextUtilities.drawRotatedString(string, graphics2D, (float)point2D.getX(), (float)point2D.getY(), itemLabelPosition.getTextAnchor(), itemLabelPosition.getAngle(), itemLabelPosition.getRotationAnchor());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof YIntervalRenderer)) {
            return false;
        }
        YIntervalRenderer yIntervalRenderer = (YIntervalRenderer)object;
        if (!ObjectUtilities.equal(this.additionalItemLabelGenerator, yIntervalRenderer.additionalItemLabelGenerator)) {
            return false;
        }
        return super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

