/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.xy;

import ai.org.jfree.chart.HashUtilities;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.labels.XYToolTipGenerator;
import ai.org.jfree.chart.plot.CrosshairState;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.chart.renderer.xy.XYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRendererState;
import ai.org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import ai.org.jfree.chart.urls.XYURLGenerator;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.util.PublicCloneable;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class XYStepRenderer
extends XYLineAndShapeRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -8918141928884796108L;
    private double stepPoint = 1.0;

    public XYStepRenderer() {
        this(null, null);
    }

    public XYStepRenderer(XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        this.setBaseToolTipGenerator(xYToolTipGenerator);
        this.setURLGenerator(xYURLGenerator);
        this.setBaseShapesVisible(false);
    }

    public double getStepPoint() {
        return this.stepPoint;
    }

    public void setStepPoint(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Requires stepPoint in [0.0;1.0]");
        }
        this.stepPoint = d;
        this.fireChangeEvent();
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        double d;
        double d2;
        double d3;
        if (!this.getItemVisible(n, n2)) {
            return;
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        double d4 = xYDataset.getXValue(n, n2);
        double d5 = xYDataset.getYValue(n, n2);
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d6 = valueAxis.valueToJava2D(d4, rectangle2D, rectangleEdge);
        double d7 = d3 = Double.isNaN(d5) ? Double.NaN : valueAxis2.valueToJava2D(d5, rectangle2D, rectangleEdge2);
        if (n3 == 0 && n2 > 0) {
            double d8;
            double d9;
            d2 = xYDataset.getXValue(n, n2 - 1);
            d = xYDataset.getYValue(n, n2 - 1);
            double d10 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
            double d11 = d9 = Double.isNaN(d) ? Double.NaN : valueAxis2.valueToJava2D(d, rectangle2D, rectangleEdge2);
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                if (d9 == d3) {
                    this.drawLine(graphics2D, xYItemRendererState.workingLine, d9, d10, d3, d6);
                } else {
                    d8 = d10 + this.getStepPoint() * (d6 - d10);
                    this.drawLine(graphics2D, xYItemRendererState.workingLine, d9, d10, d9, d8);
                    this.drawLine(graphics2D, xYItemRendererState.workingLine, d9, d8, d3, d8);
                    this.drawLine(graphics2D, xYItemRendererState.workingLine, d3, d8, d3, d6);
                }
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                if (d9 == d3) {
                    this.drawLine(graphics2D, xYItemRendererState.workingLine, d10, d9, d6, d3);
                } else {
                    d8 = d10 + this.getStepPoint() * (d6 - d10);
                    this.drawLine(graphics2D, xYItemRendererState.workingLine, d10, d9, d8, d9);
                    this.drawLine(graphics2D, xYItemRendererState.workingLine, d8, d9, d8, d3);
                    this.drawLine(graphics2D, xYItemRendererState.workingLine, d8, d3, d6, d3);
                }
            }
            int n4 = xYPlot.getDomainAxisIndex(valueAxis);
            int n5 = xYPlot.getRangeAxisIndex(valueAxis2);
            this.updateCrosshairValues(crosshairState, d4, d5, n4, n5, d6, d3, plotOrientation);
            EntityCollection entityCollection = xYItemRendererState.getEntityCollection();
            if (entityCollection != null) {
                this.addEntity(entityCollection, null, xYDataset, n, n2, d6, d3);
            }
        }
        if (n3 == 1 && this.isItemLabelVisible(n, n2)) {
            d2 = d6;
            d = d3;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d2 = d3;
                d = d6;
            }
            this.drawItemLabel(graphics2D, plotOrientation, xYDataset, n, n2, d2, d, d5 < 0.0);
        }
    }

    private void drawLine(Graphics2D graphics2D, Line2D line2D, double d, double d2, double d3, double d4) {
        if (Double.isNaN(d) || Double.isNaN(d3) || Double.isNaN(d2) || Double.isNaN(d4)) {
            return;
        }
        line2D.setLine(d, d2, d3, d4);
        graphics2D.draw(line2D);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYLineAndShapeRenderer)) {
            return false;
        }
        XYStepRenderer xYStepRenderer = (XYStepRenderer)object;
        if (this.stepPoint != xYStepRenderer.stepPoint) {
            return false;
        }
        return super.equals(object);
    }

    public int hashCode() {
        return HashUtilities.hashCode(super.hashCode(), this.stepPoint);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

