/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.xy;

import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.plot.CrosshairState;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.chart.renderer.xy.XYItemRendererState;
import ai.org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.xy.IntervalXYDataset;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PaintUtilities;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class XYErrorRenderer
extends XYLineAndShapeRenderer {
    static final long serialVersionUID = 5162283570955172424L;
    private boolean drawXError = true;
    private boolean drawYError = true;
    private double capLength = 4.0;
    private transient Paint errorPaint = null;
    private transient Stroke errorStroke = null;

    public XYErrorRenderer() {
        super(false, true);
    }

    public boolean getDrawXError() {
        return this.drawXError;
    }

    public void setDrawXError(boolean bl) {
        if (this.drawXError != bl) {
            this.drawXError = bl;
            this.fireChangeEvent();
        }
    }

    public boolean getDrawYError() {
        return this.drawYError;
    }

    public void setDrawYError(boolean bl) {
        if (this.drawYError != bl) {
            this.drawYError = bl;
            this.fireChangeEvent();
        }
    }

    public double getCapLength() {
        return this.capLength;
    }

    public void setCapLength(double d) {
        this.capLength = d;
        this.fireChangeEvent();
    }

    public Paint getErrorPaint() {
        return this.errorPaint;
    }

    public void setErrorPaint(Paint paint) {
        this.errorPaint = paint;
        this.fireChangeEvent();
    }

    public Stroke getErrorStroke() {
        return this.errorStroke;
    }

    public void setErrorStroke(Stroke stroke) {
        this.errorStroke = stroke;
        this.fireChangeEvent();
    }

    public Range findDomainBounds(XYDataset xYDataset) {
        return this.findDomainBounds(xYDataset, true);
    }

    public Range findRangeBounds(XYDataset xYDataset) {
        return this.findRangeBounds(xYDataset, true);
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        if (n3 == 0 && xYDataset instanceof IntervalXYDataset && this.getItemVisible(n, n2)) {
            Line2D.Double double_;
            double d;
            Line2D.Double double_2;
            Line2D.Double double_3;
            double d2;
            double d3;
            double d4;
            RectangleEdge rectangleEdge;
            double d5;
            double d6;
            double d7;
            IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            if (this.drawXError) {
                d7 = intervalXYDataset.getStartXValue(n, n2);
                d6 = intervalXYDataset.getEndXValue(n, n2);
                d5 = intervalXYDataset.getYValue(n, n2);
                rectangleEdge = xYPlot.getDomainAxisEdge();
                d4 = valueAxis.valueToJava2D(d7, rectangle2D, rectangleEdge);
                d3 = valueAxis.valueToJava2D(d6, rectangle2D, rectangleEdge);
                d2 = valueAxis2.valueToJava2D(d5, rectangle2D, xYPlot.getRangeAxisEdge());
                double_3 = null;
                double_2 = null;
                d = this.capLength / 2.0;
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    double_ = new Line2D.Double(d4, d2, d3, d2);
                    double_3 = new Line2D.Double(d4, d2 - d, d4, d2 + d);
                    double_2 = new Line2D.Double(d3, d2 - d, d3, d2 + d);
                } else {
                    double_ = new Line2D.Double(d2, d4, d2, d3);
                    double_3 = new Line2D.Double(d2 - d, d4, d2 + d, d4);
                    double_2 = new Line2D.Double(d2 - d, d3, d2 + d, d3);
                }
                if (this.errorPaint != null) {
                    graphics2D.setPaint(this.errorPaint);
                } else {
                    graphics2D.setPaint(this.getItemPaint(n, n2));
                }
                if (this.errorStroke != null) {
                    graphics2D.setStroke(this.errorStroke);
                } else {
                    graphics2D.setStroke(this.getItemStroke(n, n2));
                }
                graphics2D.draw(double_);
                graphics2D.draw(double_3);
                graphics2D.draw(double_2);
            }
            if (this.drawYError) {
                d7 = intervalXYDataset.getStartYValue(n, n2);
                d6 = intervalXYDataset.getEndYValue(n, n2);
                d5 = intervalXYDataset.getXValue(n, n2);
                rectangleEdge = xYPlot.getRangeAxisEdge();
                d4 = valueAxis2.valueToJava2D(d7, rectangle2D, rectangleEdge);
                d3 = valueAxis2.valueToJava2D(d6, rectangle2D, rectangleEdge);
                d2 = valueAxis.valueToJava2D(d5, rectangle2D, xYPlot.getDomainAxisEdge());
                double_3 = null;
                double_2 = null;
                d = this.capLength / 2.0;
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    double_ = new Line2D.Double(d2, d4, d2, d3);
                    double_3 = new Line2D.Double(d2 - d, d4, d2 + d, d4);
                    double_2 = new Line2D.Double(d2 - d, d3, d2 + d, d3);
                } else {
                    double_ = new Line2D.Double(d4, d2, d3, d2);
                    double_3 = new Line2D.Double(d4, d2 - d, d4, d2 + d);
                    double_2 = new Line2D.Double(d3, d2 - d, d3, d2 + d);
                }
                if (this.errorPaint != null) {
                    graphics2D.setPaint(this.errorPaint);
                } else {
                    graphics2D.setPaint(this.getItemPaint(n, n2));
                }
                if (this.errorStroke != null) {
                    graphics2D.setStroke(this.errorStroke);
                } else {
                    graphics2D.setStroke(this.getItemStroke(n, n2));
                }
                graphics2D.draw(double_);
                graphics2D.draw(double_3);
                graphics2D.draw(double_2);
            }
        }
        super.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n, n2, crosshairState, n3);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYErrorRenderer)) {
            return false;
        }
        XYErrorRenderer xYErrorRenderer = (XYErrorRenderer)object;
        if (this.drawXError != xYErrorRenderer.drawXError) {
            return false;
        }
        if (this.drawYError != xYErrorRenderer.drawYError) {
            return false;
        }
        if (this.capLength != xYErrorRenderer.capLength) {
            return false;
        }
        if (!PaintUtilities.equal(this.errorPaint, xYErrorRenderer.errorPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.errorStroke, xYErrorRenderer.errorStroke)) {
            return false;
        }
        return super.equals(object);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.errorPaint = SerialUtilities.readPaint(objectInputStream);
        this.errorStroke = SerialUtilities.readStroke(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.errorPaint, objectOutputStream);
        SerialUtilities.writeStroke(this.errorStroke, objectOutputStream);
    }
}

