/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.xy;

import ai.org.jfree.chart.LegendItem;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.entity.XYItemEntity;
import ai.org.jfree.chart.event.RendererChangeEvent;
import ai.org.jfree.chart.labels.XYToolTipGenerator;
import ai.org.jfree.chart.plot.CrosshairState;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRendererState;
import ai.org.jfree.chart.urls.XYURLGenerator;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.util.PaintUtilities;
import ai.org.jfree.util.PublicCloneable;
import ai.org.jfree.util.ShapeUtilities;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.LinkedList;

public class XYDifferenceRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
PublicCloneable {
    private static final long serialVersionUID = -8447915602375584857L;
    private transient Paint positivePaint;
    private transient Paint negativePaint;
    private boolean shapesVisible;
    private transient Shape legendLine;
    private boolean roundXCoordinates;

    public XYDifferenceRenderer() {
        this(Color.green, Color.red, false);
    }

    public XYDifferenceRenderer(Paint paint, Paint paint2, boolean bl) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'positivePaint' argument.");
        }
        if (paint2 == null) {
            throw new IllegalArgumentException("Null 'negativePaint' argument.");
        }
        this.positivePaint = paint;
        this.negativePaint = paint2;
        this.shapesVisible = bl;
        this.legendLine = new Line2D.Double(-7.0, 0.0, 7.0, 0.0);
        this.roundXCoordinates = false;
    }

    public Paint getPositivePaint() {
        return this.positivePaint;
    }

    public void setPositivePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.positivePaint = paint;
        this.fireChangeEvent();
    }

    public Paint getNegativePaint() {
        return this.negativePaint;
    }

    public void setNegativePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.negativePaint = paint;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getShapesVisible() {
        return this.shapesVisible;
    }

    public void setShapesVisible(boolean bl) {
        this.shapesVisible = bl;
        this.fireChangeEvent();
    }

    public Shape getLegendLine() {
        return this.legendLine;
    }

    public void setLegendLine(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'line' argument.");
        }
        this.legendLine = shape;
        this.fireChangeEvent();
    }

    public boolean getRoundXCoordinates() {
        return this.roundXCoordinates;
    }

    public void setRoundXCoordinates(boolean bl) {
        this.roundXCoordinates = bl;
        this.fireChangeEvent();
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        XYItemRendererState xYItemRendererState = super.initialise(graphics2D, rectangle2D, xYPlot, xYDataset, plotRenderingInfo);
        xYItemRendererState.setProcessVisibleItemsOnly(false);
        return xYItemRendererState;
    }

    public int getPassCount() {
        return 2;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        if (n3 == 0) {
            this.drawItemPass0(graphics2D, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n, n2, crosshairState);
        } else if (n3 == 1) {
            this.drawItemPass1(graphics2D, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n, n2, crosshairState);
        }
    }

    protected void drawItemPass0(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState) {
        boolean bl;
        boolean bl2;
        if (0 != n || 0 != n2) {
            return;
        }
        boolean bl3 = bl2 = 1 == xYDataset.getSeriesCount();
        if (this.isEitherSeriesDegenerate(xYDataset, bl2)) {
            return;
        }
        if (!bl2 && this.areSeriesDisjoint(xYDataset)) {
            return;
        }
        LinkedList<Double> linkedList = new LinkedList<Double>();
        LinkedList<Double> linkedList2 = new LinkedList<Double>();
        LinkedList<Double> linkedList3 = new LinkedList<Double>();
        LinkedList<Double> linkedList4 = new LinkedList<Double>();
        LinkedList<Double> linkedList5 = new LinkedList<Double>();
        LinkedList<Double> linkedList6 = new LinkedList<Double>();
        int n3 = 0;
        int n4 = xYDataset.getItemCount(0);
        Double d = null;
        Double d2 = null;
        Double d3 = null;
        Double d4 = null;
        double d5 = Double.NEGATIVE_INFINITY;
        double d6 = Double.POSITIVE_INFINITY;
        int n5 = 0;
        int n6 = 0;
        Double d7 = null;
        Double d8 = null;
        Double d9 = null;
        Double d10 = null;
        double d11 = Double.NEGATIVE_INFINITY;
        double d12 = Double.POSITIVE_INFINITY;
        if (bl2) {
            n5 = 0;
            n6 = 2;
            d7 = new Double(xYDataset.getXValue(0, 0));
            d8 = new Double(xYDataset.getXValue(0, n4 - 1));
            d9 = new Double(0.0);
            d10 = new Double(0.0);
            d11 = 0.0;
            d12 = 0.0;
            linkedList3.add(d7);
            linkedList4.add(d9);
        } else {
            n6 = xYDataset.getItemCount(1);
        }
        boolean bl4 = false;
        boolean bl5 = true;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = true;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = 0.0;
        double d18 = 0.0;
        double d19 = 0.0;
        double d20 = 0.0;
        boolean bl13 = false;
        while (!bl13) {
            double d21;
            d13 = xYDataset.getXValue(0, n3);
            d14 = xYDataset.getYValue(0, n3);
            d15 = xYDataset.getXValue(0, n3 + 1);
            d16 = xYDataset.getYValue(0, n3 + 1);
            d = new Double(d13);
            d3 = new Double(d14);
            d2 = new Double(d15);
            d4 = new Double(d16);
            if (bl2) {
                d17 = d7;
                d18 = d9;
                d19 = d8;
                d20 = d10;
            } else {
                d17 = xYDataset.getXValue(1, n5);
                d18 = xYDataset.getYValue(1, n5);
                d19 = xYDataset.getXValue(1, n5 + 1);
                d20 = xYDataset.getYValue(1, n5 + 1);
                d7 = new Double(d17);
                d9 = new Double(d18);
                d8 = new Double(d19);
                d10 = new Double(d20);
            }
            if (d15 <= d17) {
                ++n3;
                bl7 = true;
                continue;
            }
            if (d19 <= d13) {
                ++n5;
                bl11 = true;
                continue;
            }
            if (d17 < d13 && d13 < d19) {
                d21 = (d20 - d18) / (d19 - d17);
                d7 = d;
                d9 = new Double(d21 * d13 + (d18 - d21 * d17));
                linkedList3.add(d7);
                linkedList4.add(d9);
            }
            if (d13 < d17 && d17 < d15) {
                d21 = (d16 - d14) / (d15 - d13);
                d = d7;
                d3 = new Double(d21 * d17 + (d14 - d21 * d13));
                linkedList.add(d);
                linkedList2.add(d3);
            }
            d5 = d3;
            d6 = d3;
            d11 = d9;
            d12 = d9;
            bl13 = true;
        }
        while (!bl4 && !bl8) {
            double d22;
            if (!bl4 && !bl7 && bl5) {
                d13 = xYDataset.getXValue(0, n3);
                d14 = xYDataset.getYValue(0, n3);
                d = new Double(d13);
                d3 = new Double(d14);
                if (!bl6) {
                    linkedList.add(d);
                    linkedList2.add(d3);
                }
                d5 = Math.max(d5, d14);
                d6 = Math.min(d6, d14);
                d15 = xYDataset.getXValue(0, n3 + 1);
                d16 = xYDataset.getYValue(0, n3 + 1);
                d2 = new Double(d15);
                d4 = new Double(d16);
            }
            if (!bl2 && !bl8 && !bl11 && bl9) {
                d17 = xYDataset.getXValue(1, n5);
                d18 = xYDataset.getYValue(1, n5);
                d7 = new Double(d17);
                d9 = new Double(d18);
                if (!bl10) {
                    linkedList3.add(d7);
                    linkedList4.add(d9);
                }
                d11 = Math.max(d11, d18);
                d12 = Math.min(d12, d18);
                d19 = xYDataset.getXValue(1, n5 + 1);
                d20 = xYDataset.getYValue(1, n5 + 1);
                d8 = new Double(d19);
                d10 = new Double(d20);
            }
            bl7 = false;
            bl11 = false;
            Double d23 = null;
            Double d24 = null;
            boolean bl14 = false;
            bl6 = false;
            bl10 = false;
            if (d15 == d19 && d16 == d20) {
                if (d13 == d17 && d14 == d18) {
                    bl12 = true;
                } else {
                    d23 = new Double(d15);
                    d24 = new Double(d16);
                    bl14 = true;
                    bl6 = true;
                    bl10 = true;
                }
            } else {
                d22 = (d20 - d18) * (d15 - d13) - (d19 - d17) * (d16 - d14);
                double d25 = d14 - d18;
                double d26 = d13 - d17;
                double d27 = (d19 - d17) * d25 - (d20 - d18) * d26;
                double d28 = (d15 - d13) * d25 - (d16 - d14) * d26;
                if (0.0 == d27 && 0.0 == d28 && 0.0 == d22) {
                    bl12 = true;
                } else {
                    if (bl12) {
                        linkedList.clear();
                        linkedList2.clear();
                        linkedList3.clear();
                        linkedList4.clear();
                        linkedList5.clear();
                        linkedList6.clear();
                        bl12 = false;
                        boolean bl15 = d17 <= d13 && d13 <= d19;
                        linkedList5.add(bl15 ? d : d7);
                        linkedList6.add(bl15 ? d3 : d9);
                    }
                    double d29 = d27 / d22;
                    double d30 = d28 / d22;
                    if (0.0 < d29 && d29 <= 1.0 && 0.0 < d30 && d30 <= 1.0) {
                        double d31 = d13 + d29 * (d15 - d13);
                        double d32 = d14 + d29 * (d16 - d14);
                        d23 = new Double(d31);
                        d24 = new Double(d32);
                        bl14 = true;
                        bl6 = d31 == d15 && d32 == d16;
                        bl10 = d31 == d19 && d32 == d20;
                        d = d23;
                        d3 = d24;
                        d7 = d23;
                        d9 = d24;
                    }
                }
            }
            if (bl14) {
                linkedList5.addAll(linkedList);
                linkedList6.addAll(linkedList2);
                linkedList5.add(d23);
                linkedList6.add(d24);
                Collections.reverse(linkedList3);
                Collections.reverse(linkedList4);
                linkedList5.addAll(linkedList3);
                linkedList6.addAll(linkedList4);
                bl = d11 <= d5 && d12 <= d6;
                this.createPolygon(graphics2D, rectangle2D, xYPlot, valueAxis, valueAxis2, bl, linkedList5, linkedList6);
                linkedList.clear();
                linkedList2.clear();
                linkedList3.clear();
                linkedList4.clear();
                linkedList5.clear();
                linkedList6.clear();
                d5 = d22 = d24.doubleValue();
                d11 = d22;
                d6 = d22;
                d12 = d22;
                linkedList5.add(d23);
                linkedList6.add(d24);
            }
            if (d15 <= d19) {
                ++n3;
                bl5 = true;
            } else {
                bl5 = false;
            }
            if (d19 <= d15) {
                ++n5;
                bl9 = true;
            } else {
                bl9 = false;
            }
            bl4 = n3 == n4 - 1;
            bl8 = n5 == n6 - 1;
        }
        if (bl4 && d17 < d15 && d15 < d19) {
            double d33 = (d20 - d18) / (d19 - d17);
            d8 = d2;
            d10 = new Double(d33 * d15 + (d18 - d33 * d17));
        }
        if (bl8 && d13 < d19 && d19 < d15) {
            double d34 = (d16 - d14) / (d15 - d13);
            d2 = d8;
            d4 = new Double(d34 * d19 + (d14 - d34 * d13));
        }
        d5 = Math.max(d5, d4);
        d11 = Math.max(d11, d10);
        d6 = Math.min(d6, d4);
        d12 = Math.min(d12, d10);
        linkedList.add(d2);
        linkedList2.add(d4);
        linkedList3.add(d8);
        linkedList4.add(d10);
        linkedList5.addAll(linkedList);
        linkedList6.addAll(linkedList2);
        Collections.reverse(linkedList3);
        Collections.reverse(linkedList4);
        linkedList5.addAll(linkedList3);
        linkedList6.addAll(linkedList4);
        bl = d11 <= d5 && d12 <= d6;
        this.createPolygon(graphics2D, rectangle2D, xYPlot, valueAxis, valueAxis2, bl, linkedList5, linkedList6);
    }

    protected void drawItemPass1(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState) {
        Object object;
        Shape shape = null;
        EntityCollection entityCollection = null;
        if (null != plotRenderingInfo) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d = xYDataset.getXValue(n, n2);
        double d2 = xYDataset.getYValue(n, n2);
        double d3 = valueAxis.valueToJava2D(d, rectangle2D, rectangleEdge);
        double d4 = valueAxis2.valueToJava2D(d2, rectangle2D, rectangleEdge2);
        if (this.getShapesVisible()) {
            object = this.getItemShape(n, n2);
            object = plotOrientation == PlotOrientation.HORIZONTAL ? ShapeUtilities.createTranslatedShape((Shape)object, d4, d3) : ShapeUtilities.createTranslatedShape((Shape)object, d3, d4);
            if (object.intersects(rectangle2D)) {
                graphics2D.setPaint(this.getItemPaint(n, n2));
                graphics2D.fill((Shape)object);
            }
            shape = object;
        }
        if (null != entityCollection) {
            if (null == shape) {
                shape = new Rectangle2D.Double(d3 - 2.0, d4 - 2.0, 4.0, 4.0);
            }
            object = null;
            XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n, n2);
            if (null != xYToolTipGenerator) {
                object = xYToolTipGenerator.generateToolTip(xYDataset, n, n2);
            }
            String string = null;
            XYURLGenerator xYURLGenerator = this.getURLGenerator();
            if (null != xYURLGenerator) {
                string = xYURLGenerator.generateURL(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(shape, xYDataset, n, n2, (String)object, string);
            entityCollection.add(xYItemEntity);
        }
        if (this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, plotOrientation, xYDataset, n, n2, d3, d4, d4 < 0.0);
        }
        int n3 = xYPlot.getDomainAxisIndex(valueAxis);
        int n4 = xYPlot.getRangeAxisIndex(valueAxis2);
        this.updateCrosshairValues(crosshairState, d, d2, n3, n4, d3, d4, plotOrientation);
        if (0 == n2) {
            return;
        }
        double d5 = valueAxis.valueToJava2D(xYDataset.getXValue(n, n2 - 1), rectangle2D, rectangleEdge);
        double d6 = valueAxis2.valueToJava2D(xYDataset.getYValue(n, n2 - 1), rectangle2D, rectangleEdge2);
        Line2D.Double double_ = null;
        if (PlotOrientation.HORIZONTAL == plotOrientation) {
            double_ = new Line2D.Double(d4, d3, d6, d5);
        } else if (PlotOrientation.VERTICAL == plotOrientation) {
            double_ = new Line2D.Double(d3, d4, d5, d6);
        }
        if (null != double_ && double_.intersects(rectangle2D)) {
            graphics2D.setPaint(this.getItemPaint(n, n2));
            graphics2D.setStroke(this.getItemStroke(n, n2));
            graphics2D.draw(double_);
        }
    }

    private boolean isEitherSeriesDegenerate(XYDataset xYDataset, boolean bl) {
        if (bl) {
            return xYDataset.getItemCount(0) < 2;
        }
        return xYDataset.getItemCount(0) < 2 || xYDataset.getItemCount(1) < 2;
    }

    private boolean areSeriesDisjoint(XYDataset xYDataset) {
        int n = xYDataset.getItemCount(0);
        double d = xYDataset.getXValue(0, 0);
        double d2 = xYDataset.getXValue(0, n - 1);
        int n2 = xYDataset.getItemCount(1);
        double d3 = xYDataset.getXValue(1, 0);
        double d4 = xYDataset.getXValue(1, n2 - 1);
        return d2 < d3 || d4 < d;
    }

    private void createPolygon(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, boolean bl, LinkedList linkedList, LinkedList linkedList2) {
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        Object[] objectArray = linkedList.toArray();
        Object[] objectArray2 = linkedList2.toArray();
        GeneralPath generalPath = new GeneralPath();
        if (PlotOrientation.VERTICAL == plotOrientation) {
            double d = valueAxis.valueToJava2D((Double)objectArray[0], rectangle2D, rectangleEdge);
            if (this.roundXCoordinates) {
                d = Math.rint(d);
            }
            double d2 = valueAxis2.valueToJava2D((Double)objectArray2[0], rectangle2D, rectangleEdge2);
            generalPath.moveTo((float)d, (float)d2);
            for (int i = 1; i < objectArray.length; ++i) {
                d = valueAxis.valueToJava2D((Double)objectArray[i], rectangle2D, rectangleEdge);
                if (this.roundXCoordinates) {
                    d = Math.rint(d);
                }
                d2 = valueAxis2.valueToJava2D((Double)objectArray2[i], rectangle2D, rectangleEdge2);
                generalPath.lineTo((float)d, (float)d2);
            }
            generalPath.closePath();
        } else {
            double d = valueAxis.valueToJava2D((Double)objectArray[0], rectangle2D, rectangleEdge);
            if (this.roundXCoordinates) {
                d = Math.rint(d);
            }
            double d3 = valueAxis2.valueToJava2D((Double)objectArray2[0], rectangle2D, rectangleEdge2);
            generalPath.moveTo((float)d3, (float)d);
            for (int i = 1; i < objectArray.length; ++i) {
                d = valueAxis.valueToJava2D((Double)objectArray[i], rectangle2D, rectangleEdge);
                if (this.roundXCoordinates) {
                    d = Math.rint(d);
                }
                d3 = valueAxis2.valueToJava2D((Double)objectArray2[i], rectangle2D, rectangleEdge2);
                generalPath.lineTo((float)d3, (float)d);
            }
            generalPath.closePath();
        }
        if (generalPath.intersects(rectangle2D)) {
            graphics2D.setPaint(bl ? this.getPositivePaint() : this.getNegativePaint());
            graphics2D.fill(generalPath);
        }
    }

    public LegendItem getLegendItem(int n, int n2) {
        XYDataset xYDataset;
        LegendItem legendItem = null;
        XYPlot xYPlot = this.getPlot();
        if (xYPlot != null && (xYDataset = xYPlot.getDataset(n)) != null && this.getItemVisible(n2, 0)) {
            String string;
            String string2 = string = this.getLegendItemLabelGenerator().generateLabel(xYDataset, n2);
            String string3 = null;
            if (this.getLegendItemToolTipGenerator() != null) {
                string3 = this.getLegendItemToolTipGenerator().generateLabel(xYDataset, n2);
            }
            String string4 = null;
            if (this.getLegendItemURLGenerator() != null) {
                string4 = this.getLegendItemURLGenerator().generateLabel(xYDataset, n2);
            }
            Paint paint = this.lookupSeriesPaint(n2);
            Stroke stroke = this.lookupSeriesStroke(n2);
            Shape shape = this.getLegendLine();
            legendItem = new LegendItem(string, string2, string3, string4, shape, stroke, paint);
            legendItem.setLabelFont(this.lookupLegendTextFont(n2));
            Paint paint2 = this.lookupLegendTextPaint(n2);
            if (paint2 != null) {
                legendItem.setLabelPaint(paint2);
            }
            legendItem.setDataset(xYDataset);
            legendItem.setDatasetIndex(n);
            legendItem.setSeriesKey(xYDataset.getSeriesKey(n2));
            legendItem.setSeriesIndex(n2);
        }
        return legendItem;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYDifferenceRenderer)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        XYDifferenceRenderer xYDifferenceRenderer = (XYDifferenceRenderer)object;
        if (!PaintUtilities.equal(this.positivePaint, xYDifferenceRenderer.positivePaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.negativePaint, xYDifferenceRenderer.negativePaint)) {
            return false;
        }
        if (this.shapesVisible != xYDifferenceRenderer.shapesVisible) {
            return false;
        }
        if (!ShapeUtilities.equal(this.legendLine, xYDifferenceRenderer.legendLine)) {
            return false;
        }
        return this.roundXCoordinates == xYDifferenceRenderer.roundXCoordinates;
    }

    public Object clone() throws CloneNotSupportedException {
        XYDifferenceRenderer xYDifferenceRenderer = (XYDifferenceRenderer)super.clone();
        xYDifferenceRenderer.legendLine = ShapeUtilities.clone(this.legendLine);
        return xYDifferenceRenderer;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.positivePaint, objectOutputStream);
        SerialUtilities.writePaint(this.negativePaint, objectOutputStream);
        SerialUtilities.writeShape(this.legendLine, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.positivePaint = SerialUtilities.readPaint(objectInputStream);
        this.negativePaint = SerialUtilities.readPaint(objectInputStream);
        this.legendLine = SerialUtilities.readShape(objectInputStream);
    }
}

