/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.xy;

import ai.org.jfree.chart.HashUtilities;
import ai.org.jfree.chart.LegendItem;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.labels.XYSeriesLabelGenerator;
import ai.org.jfree.chart.labels.XYToolTipGenerator;
import ai.org.jfree.chart.plot.CrosshairState;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRendererState;
import ai.org.jfree.chart.urls.XYURLGenerator;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.ui.GradientPaintTransformer;
import ai.org.jfree.ui.StandardGradientPaintTransformer;
import ai.org.jfree.util.PublicCloneable;
import ai.org.jfree.util.ShapeUtilities;
import java.awt.BasicStroke;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class XYAreaRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
PublicCloneable {
    private static final long serialVersionUID = -4481971353973876747L;
    public static final int SHAPES = 1;
    public static final int LINES = 2;
    public static final int SHAPES_AND_LINES = 3;
    public static final int AREA = 4;
    public static final int AREA_AND_SHAPES = 5;
    private boolean plotShapes;
    private boolean plotLines;
    private boolean plotArea;
    private boolean showOutline;
    private transient Shape legendArea;
    private boolean useFillPaint;
    private GradientPaintTransformer gradientTransformer;

    public XYAreaRenderer() {
        this(4);
    }

    public XYAreaRenderer(int n) {
        this(n, null, null);
    }

    public XYAreaRenderer(int n, XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        this.setBaseToolTipGenerator(xYToolTipGenerator);
        this.setURLGenerator(xYURLGenerator);
        if (n == 1) {
            this.plotShapes = true;
        }
        if (n == 2) {
            this.plotLines = true;
        }
        if (n == 3) {
            this.plotShapes = true;
            this.plotLines = true;
        }
        if (n == 4) {
            this.plotArea = true;
        }
        if (n == 5) {
            this.plotArea = true;
            this.plotShapes = true;
        }
        this.showOutline = false;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, -4.0f);
        generalPath.lineTo(3.0f, -2.0f);
        generalPath.lineTo(4.0f, 4.0f);
        generalPath.lineTo(-4.0f, 4.0f);
        generalPath.lineTo(-3.0f, -2.0f);
        generalPath.closePath();
        this.legendArea = generalPath;
        this.useFillPaint = false;
        this.gradientTransformer = new StandardGradientPaintTransformer();
    }

    public boolean getPlotShapes() {
        return this.plotShapes;
    }

    public boolean getPlotLines() {
        return this.plotLines;
    }

    public boolean getPlotArea() {
        return this.plotArea;
    }

    public boolean isOutline() {
        return this.showOutline;
    }

    public void setOutline(boolean bl) {
        this.showOutline = bl;
        this.fireChangeEvent();
    }

    public Shape getLegendArea() {
        return this.legendArea;
    }

    public void setLegendArea(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'area' argument.");
        }
        this.legendArea = shape;
        this.fireChangeEvent();
    }

    public boolean getUseFillPaint() {
        return this.useFillPaint;
    }

    public void setUseFillPaint(boolean bl) {
        this.useFillPaint = bl;
        this.fireChangeEvent();
    }

    public GradientPaintTransformer getGradientTransformer() {
        return this.gradientTransformer;
    }

    public void setGradientTransformer(GradientPaintTransformer gradientPaintTransformer) {
        if (gradientPaintTransformer == null) {
            throw new IllegalArgumentException("Null 'transformer' argument.");
        }
        this.gradientTransformer = gradientPaintTransformer;
        this.fireChangeEvent();
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        XYAreaRendererState xYAreaRendererState = new XYAreaRendererState(plotRenderingInfo);
        xYAreaRendererState.setProcessVisibleItemsOnly(false);
        return xYAreaRendererState;
    }

    public LegendItem getLegendItem(int n, int n2) {
        XYDataset xYDataset;
        LegendItem legendItem = null;
        XYPlot xYPlot = this.getPlot();
        if (xYPlot != null && (xYDataset = xYPlot.getDataset(n)) != null) {
            String string;
            XYSeriesLabelGenerator xYSeriesLabelGenerator = this.getLegendItemLabelGenerator();
            String string2 = string = xYSeriesLabelGenerator.generateLabel(xYDataset, n2);
            String string3 = null;
            if (this.getLegendItemToolTipGenerator() != null) {
                string3 = this.getLegendItemToolTipGenerator().generateLabel(xYDataset, n2);
            }
            String string4 = null;
            if (this.getLegendItemURLGenerator() != null) {
                string4 = this.getLegendItemURLGenerator().generateLabel(xYDataset, n2);
            }
            Paint paint = this.lookupSeriesPaint(n2);
            legendItem = new LegendItem(string, string2, string3, string4, this.legendArea, paint);
            legendItem.setLabelFont(this.lookupLegendTextFont(n2));
            Paint paint2 = this.lookupLegendTextPaint(n2);
            if (paint2 != null) {
                legendItem.setLabelPaint(paint2);
            }
            legendItem.setDataset(xYDataset);
            legendItem.setDatasetIndex(n);
            legendItem.setSeriesKey(xYDataset.getSeriesKey(n2));
            legendItem.setSeriesIndex(n2);
        }
        return legendItem;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        Object object;
        if (!this.getItemVisible(n, n2)) {
            return;
        }
        XYAreaRendererState xYAreaRendererState = (XYAreaRendererState)xYItemRendererState;
        double d = xYDataset.getXValue(n, n2);
        double d2 = xYDataset.getYValue(n, n2);
        if (Double.isNaN(d2)) {
            d2 = 0.0;
        }
        double d3 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getDomainAxisEdge());
        double d4 = valueAxis2.valueToJava2D(d2, rectangle2D, xYPlot.getRangeAxisEdge());
        int n4 = xYDataset.getItemCount(n);
        double d5 = xYDataset.getXValue(n, Math.max(n2 - 1, 0));
        double d6 = xYDataset.getYValue(n, Math.max(n2 - 1, 0));
        if (Double.isNaN(d6)) {
            d6 = 0.0;
        }
        double d7 = valueAxis.valueToJava2D(d5, rectangle2D, xYPlot.getDomainAxisEdge());
        double d8 = valueAxis2.valueToJava2D(d6, rectangle2D, xYPlot.getRangeAxisEdge());
        double d9 = xYDataset.getXValue(n, Math.min(n2 + 1, n4 - 1));
        double d10 = xYDataset.getYValue(n, Math.min(n2 + 1, n4 - 1));
        if (Double.isNaN(d10)) {
            d10 = 0.0;
        }
        double d11 = valueAxis.valueToJava2D(d9, rectangle2D, xYPlot.getDomainAxisEdge());
        double d12 = valueAxis2.valueToJava2D(d10, rectangle2D, xYPlot.getRangeAxisEdge());
        double d13 = valueAxis2.valueToJava2D(0.0, rectangle2D, xYPlot.getRangeAxisEdge());
        GeneralPath generalPath = new GeneralPath();
        if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
            XYAreaRenderer.moveTo(generalPath, d13, (d7 + d3) / 2.0);
            XYAreaRenderer.lineTo(generalPath, (d8 + d4) / 2.0, (d7 + d3) / 2.0);
            XYAreaRenderer.lineTo(generalPath, d4, d3);
            XYAreaRenderer.lineTo(generalPath, (d4 + d12) / 2.0, (d3 + d11) / 2.0);
            XYAreaRenderer.lineTo(generalPath, d13, (d3 + d11) / 2.0);
        } else {
            XYAreaRenderer.moveTo(generalPath, (d7 + d3) / 2.0, d13);
            XYAreaRenderer.lineTo(generalPath, (d7 + d3) / 2.0, (d8 + d4) / 2.0);
            XYAreaRenderer.lineTo(generalPath, d3, d4);
            XYAreaRenderer.lineTo(generalPath, (d3 + d11) / 2.0, (d4 + d12) / 2.0);
            XYAreaRenderer.lineTo(generalPath, (d3 + d11) / 2.0, d13);
        }
        generalPath.closePath();
        if (n2 == 0) {
            xYAreaRendererState.area = new GeneralPath();
            double d14 = valueAxis2.valueToJava2D(0.0, rectangle2D, xYPlot.getRangeAxisEdge());
            if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                XYAreaRenderer.moveTo(xYAreaRendererState.area, d3, d14);
            } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                XYAreaRenderer.moveTo(xYAreaRendererState.area, d14, d3);
            }
        }
        if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
            XYAreaRenderer.lineTo(xYAreaRendererState.area, d3, d4);
        } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
            XYAreaRenderer.lineTo(xYAreaRendererState.area, d4, d3);
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        Shape shape = null;
        if (this.getPlotShapes()) {
            shape = this.getItemShape(n, n2);
            if (plotOrientation == PlotOrientation.VERTICAL) {
                shape = ShapeUtilities.createTranslatedShape(shape, d3, d4);
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                shape = ShapeUtilities.createTranslatedShape(shape, d4, d3);
            }
            graphics2D.draw(shape);
        }
        if (this.getPlotLines() && n2 > 0) {
            if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                xYAreaRendererState.line.setLine(d7, d8, d3, d4);
            } else if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                xYAreaRendererState.line.setLine(d8, d7, d4, d3);
            }
            graphics2D.draw(xYAreaRendererState.line);
        }
        if (this.getPlotArea() && n2 > 0 && n2 == n4 - 1) {
            Object object2;
            Object object3;
            if (plotOrientation == PlotOrientation.VERTICAL) {
                XYAreaRenderer.lineTo(xYAreaRendererState.area, d3, d13);
                xYAreaRendererState.area.closePath();
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                XYAreaRenderer.lineTo(xYAreaRendererState.area, d13, d3);
                xYAreaRendererState.area.closePath();
            }
            if (this.useFillPaint) {
                paint = this.lookupSeriesFillPaint(n);
            }
            if (paint instanceof GradientPaint) {
                object3 = (GradientPaint)paint;
                object2 = this.gradientTransformer.transform((GradientPaint)object3, rectangle2D);
                graphics2D.setPaint((Paint)object2);
            }
            graphics2D.fill(xYAreaRendererState.area);
            if (this.isOutline()) {
                object3 = xYAreaRendererState.area;
                object2 = this.lookupSeriesOutlineStroke(n);
                if (object2 instanceof BasicStroke && ((BasicStroke)(object = (BasicStroke)object2)).getDashArray() != null) {
                    Area area = new Area(xYAreaRendererState.area);
                    Area area2 = new Area(new Rectangle2D.Double(rectangle2D.getX() - 5.0, rectangle2D.getY() - 5.0, rectangle2D.getWidth() + 10.0, rectangle2D.getHeight() + 10.0));
                    area.intersect(area2);
                    object3 = area;
                }
                graphics2D.setStroke((Stroke)object2);
                graphics2D.setPaint(this.lookupSeriesOutlinePaint(n));
                graphics2D.draw((Shape)object3);
            }
        }
        int n5 = xYPlot.getDomainAxisIndex(valueAxis);
        int n6 = xYPlot.getRangeAxisIndex(valueAxis2);
        this.updateCrosshairValues(crosshairState, d, d2, n5, n6, d3, d4, plotOrientation);
        object = xYItemRendererState.getEntityCollection();
        if (object != null) {
            this.addEntity((EntityCollection)object, generalPath, xYDataset, n, n2, 0.0, 0.0);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        XYAreaRenderer xYAreaRenderer = (XYAreaRenderer)super.clone();
        xYAreaRenderer.legendArea = ShapeUtilities.clone(this.legendArea);
        return xYAreaRenderer;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYAreaRenderer)) {
            return false;
        }
        XYAreaRenderer xYAreaRenderer = (XYAreaRenderer)object;
        if (this.plotArea != xYAreaRenderer.plotArea) {
            return false;
        }
        if (this.plotLines != xYAreaRenderer.plotLines) {
            return false;
        }
        if (this.plotShapes != xYAreaRenderer.plotShapes) {
            return false;
        }
        if (this.showOutline != xYAreaRenderer.showOutline) {
            return false;
        }
        if (this.useFillPaint != xYAreaRenderer.useFillPaint) {
            return false;
        }
        if (!this.gradientTransformer.equals(xYAreaRenderer.gradientTransformer)) {
            return false;
        }
        return ShapeUtilities.equal(this.legendArea, xYAreaRenderer.legendArea);
    }

    public int hashCode() {
        int n = super.hashCode();
        n = HashUtilities.hashCode(n, this.plotArea);
        n = HashUtilities.hashCode(n, this.plotLines);
        n = HashUtilities.hashCode(n, this.plotShapes);
        n = HashUtilities.hashCode(n, this.useFillPaint);
        return n;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.legendArea = SerialUtilities.readShape(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.legendArea, objectOutputStream);
    }

    static class XYAreaRendererState
    extends XYItemRendererState {
        public GeneralPath area = new GeneralPath();
        public Line2D line = new Line2D.Double();

        public XYAreaRendererState(PlotRenderingInfo plotRenderingInfo) {
            super(plotRenderingInfo);
        }
    }
}

