/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.xy;

import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.plot.CrosshairState;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRendererState;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.xy.VectorXYDataset;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.util.PublicCloneable;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class VectorRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private double baseLength = 0.1;
    private double headLength = 0.14;

    public Range findDomainBounds(XYDataset xYDataset) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        int n = xYDataset.getSeriesCount();
        if (xYDataset instanceof VectorXYDataset) {
            VectorXYDataset vectorXYDataset = (VectorXYDataset)xYDataset;
            for (int i = 0; i < n; ++i) {
                int n2 = xYDataset.getItemCount(i);
                for (int j = 0; j < n2; ++j) {
                    double d3;
                    double d4;
                    double d5 = vectorXYDataset.getVectorXValue(i, j);
                    if (d5 < 0.0) {
                        d4 = vectorXYDataset.getXValue(i, j);
                        d3 = d4 + d5;
                    } else {
                        d3 = vectorXYDataset.getXValue(i, j);
                        d4 = d3 + d5;
                    }
                    d = Math.min(d, d3);
                    d2 = Math.max(d2, d4);
                }
            }
        } else {
            for (int i = 0; i < n; ++i) {
                int n3 = xYDataset.getItemCount(i);
                for (int j = 0; j < n3; ++j) {
                    double d6;
                    double d7 = d6 = xYDataset.getXValue(i, j);
                    d = Math.min(d, d6);
                    d2 = Math.max(d2, d7);
                }
            }
        }
        if (d > d2) {
            return null;
        }
        return new Range(d, d2);
    }

    public Range findRangeBounds(XYDataset xYDataset) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        int n = xYDataset.getSeriesCount();
        if (xYDataset instanceof VectorXYDataset) {
            VectorXYDataset vectorXYDataset = (VectorXYDataset)xYDataset;
            for (int i = 0; i < n; ++i) {
                int n2 = xYDataset.getItemCount(i);
                for (int j = 0; j < n2; ++j) {
                    double d3;
                    double d4;
                    double d5 = vectorXYDataset.getVectorYValue(i, j);
                    if (d5 < 0.0) {
                        d4 = vectorXYDataset.getYValue(i, j);
                        d3 = d4 + d5;
                    } else {
                        d3 = vectorXYDataset.getYValue(i, j);
                        d4 = d3 + d5;
                    }
                    d = Math.min(d, d3);
                    d2 = Math.max(d2, d4);
                }
            }
        } else {
            for (int i = 0; i < n; ++i) {
                int n3 = xYDataset.getItemCount(i);
                for (int j = 0; j < n3; ++j) {
                    double d6;
                    double d7 = d6 = xYDataset.getYValue(i, j);
                    d = Math.min(d, d6);
                    d2 = Math.max(d2, d7);
                }
            }
        }
        if (d > d2) {
            return null;
        }
        return new Range(d, d2);
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        double d = xYDataset.getXValue(n, n2);
        double d2 = xYDataset.getYValue(n, n2);
        double d3 = 0.0;
        double d4 = 0.0;
        if (xYDataset instanceof VectorXYDataset) {
            d3 = ((VectorXYDataset)xYDataset).getVectorXValue(n, n2);
            d4 = ((VectorXYDataset)xYDataset).getVectorYValue(n, n2);
        }
        double d5 = valueAxis.valueToJava2D(d, rectangle2D, xYPlot.getDomainAxisEdge());
        double d6 = valueAxis2.valueToJava2D(d2, rectangle2D, xYPlot.getRangeAxisEdge());
        double d7 = valueAxis.valueToJava2D(d + d3, rectangle2D, xYPlot.getDomainAxisEdge());
        double d8 = valueAxis2.valueToJava2D(d2 + d4, rectangle2D, xYPlot.getRangeAxisEdge());
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        Line2D.Double double_ = plotOrientation.equals(PlotOrientation.HORIZONTAL) ? new Line2D.Double(d6, d5, d8, d7) : new Line2D.Double(d5, d6, d7, d8);
        graphics2D.setPaint(this.getItemPaint(n, n2));
        graphics2D.setStroke(this.getItemStroke(n, n2));
        graphics2D.draw(double_);
        double d9 = d7 - d5;
        double d10 = d8 - d6;
        double d11 = d5 + (1.0 - this.baseLength) * d9;
        double d12 = d6 + (1.0 - this.baseLength) * d10;
        double d13 = d5 + (1.0 - this.headLength) * d9;
        double d14 = d6 + (1.0 - this.headLength) * d10;
        double d15 = 0.0;
        if (d9 != 0.0) {
            d15 = 1.5707963267948966 - Math.atan(d10 / d9);
        }
        double d16 = 2.0 * Math.cos(d15);
        double d17 = 2.0 * Math.sin(d15);
        double d18 = d13 + d16;
        double d19 = d14 - d17;
        double d20 = d13 - d16;
        double d21 = d14 + d17;
        GeneralPath generalPath = new GeneralPath();
        if (plotOrientation == PlotOrientation.VERTICAL) {
            generalPath.moveTo((float)d7, (float)d8);
            generalPath.lineTo((float)d20, (float)d21);
            generalPath.lineTo((float)d11, (float)d12);
            generalPath.lineTo((float)d18, (float)d19);
        } else {
            generalPath.moveTo((float)d8, (float)d7);
            generalPath.lineTo((float)d21, (float)d20);
            generalPath.lineTo((float)d12, (float)d11);
            generalPath.lineTo((float)d19, (float)d18);
        }
        generalPath.closePath();
        graphics2D.draw(generalPath);
        EntityCollection entityCollection = null;
        if (plotRenderingInfo != null && (entityCollection = plotRenderingInfo.getOwner().getEntityCollection()) != null) {
            this.addEntity(entityCollection, double_.getBounds(), xYDataset, n, n2, 0.0, 0.0);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof VectorRenderer)) {
            return false;
        }
        VectorRenderer vectorRenderer = (VectorRenderer)object;
        if (this.baseLength != vectorRenderer.baseLength) {
            return false;
        }
        if (this.headLength != vectorRenderer.headLength) {
            return false;
        }
        return super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

