/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.xy;

import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.labels.ItemLabelAnchor;
import ai.org.jfree.chart.labels.ItemLabelPosition;
import ai.org.jfree.chart.labels.XYItemLabelGenerator;
import ai.org.jfree.chart.plot.CrosshairState;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.chart.renderer.xy.XYBarRenderer;
import ai.org.jfree.chart.renderer.xy.XYItemRendererState;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.general.DatasetUtilities;
import ai.org.jfree.data.xy.IntervalXYDataset;
import ai.org.jfree.data.xy.TableXYDataset;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.ui.TextAnchor;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class StackedXYBarRenderer
extends XYBarRenderer {
    private static final long serialVersionUID = -7049101055533436444L;
    private boolean renderAsPercentages = false;

    public StackedXYBarRenderer() {
        this(0.0);
    }

    public StackedXYBarRenderer(double d) {
        super(d);
        ItemLabelPosition itemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER);
        this.setBasePositiveItemLabelPosition(itemLabelPosition);
        this.setBaseNegativeItemLabelPosition(itemLabelPosition);
        this.setPositiveItemLabelPositionFallback(null);
        this.setNegativeItemLabelPositionFallback(null);
    }

    public boolean getRenderAsPercentages() {
        return this.renderAsPercentages;
    }

    public void setRenderAsPercentages(boolean bl) {
        this.renderAsPercentages = bl;
        this.fireChangeEvent();
    }

    public int getPassCount() {
        return 3;
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        return new XYBarRenderer.XYBarRendererState(this, plotRenderingInfo);
    }

    public Range findRangeBounds(XYDataset xYDataset) {
        if (xYDataset != null) {
            if (this.renderAsPercentages) {
                return new Range(0.0, 1.0);
            }
            return DatasetUtilities.findStackedRangeBounds((TableXYDataset)xYDataset);
        }
        return null;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        double d;
        double d2;
        if (!this.getItemVisible(n, n2)) {
            return;
        }
        if (!(xYDataset instanceof IntervalXYDataset) || !(xYDataset instanceof TableXYDataset)) {
            String string = "dataset (type " + xYDataset.getClass().getName() + ") has wrong type:";
            boolean bl = false;
            if (!IntervalXYDataset.class.isAssignableFrom(xYDataset.getClass())) {
                string = string + " it is no IntervalXYDataset";
                bl = true;
            }
            if (!TableXYDataset.class.isAssignableFrom(xYDataset.getClass())) {
                if (bl) {
                    string = string + " and";
                }
                string = string + " it is no TableXYDataset";
            }
            throw new IllegalArgumentException(string);
        }
        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
        double d3 = intervalXYDataset.getYValue(n, n2);
        if (Double.isNaN(d3)) {
            return;
        }
        double d4 = 0.0;
        if (this.renderAsPercentages) {
            d4 = DatasetUtilities.calculateStackTotal((TableXYDataset)xYDataset, n2);
            d3 /= d4;
        }
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d7 = xYDataset.getYValue(i, n2);
            if (Double.isNaN(d7) || !this.isSeriesVisible(i)) continue;
            if (this.renderAsPercentages) {
                d7 /= d4;
            }
            if (d7 > 0.0) {
                d5 += d7;
                continue;
            }
            d6 += d7;
        }
        RectangleEdge rectangleEdge = xYPlot.getRangeAxisEdge();
        if (d3 > 0.0) {
            d2 = valueAxis2.valueToJava2D(d5, rectangle2D, rectangleEdge);
            d = valueAxis2.valueToJava2D(d5 + d3, rectangle2D, rectangleEdge);
        } else {
            d2 = valueAxis2.valueToJava2D(d6, rectangle2D, rectangleEdge);
            d = valueAxis2.valueToJava2D(d6 + d3, rectangle2D, rectangleEdge);
        }
        RectangleEdge rectangleEdge2 = xYPlot.getDomainAxisEdge();
        double d8 = intervalXYDataset.getStartXValue(n, n2);
        if (Double.isNaN(d8)) {
            return;
        }
        double d9 = valueAxis.valueToJava2D(d8, rectangle2D, rectangleEdge2);
        double d10 = intervalXYDataset.getEndXValue(n, n2);
        if (Double.isNaN(d10)) {
            return;
        }
        double d11 = valueAxis.valueToJava2D(d10, rectangle2D, rectangleEdge2);
        double d12 = Math.max(1.0, Math.abs(d11 - d9));
        double d13 = Math.abs(d - d2);
        if (this.getMargin() > 0.0) {
            double d14 = d12 * this.getMargin();
            d12 -= d14;
            d9 += d14 / 2.0;
        }
        Rectangle2D.Double double_ = null;
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Rectangle2D.Double(Math.min(d2, d), Math.min(d11, d9), d13, d12);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Rectangle2D.Double(Math.min(d9, d11), Math.min(d2, d), d12, d13);
        }
        boolean bl = d3 > 0.0;
        boolean bl2 = valueAxis2.isInverted();
        RectangleEdge rectangleEdge3 = plotOrientation == PlotOrientation.HORIZONTAL ? (bl && bl2 || !bl && !bl2 ? RectangleEdge.RIGHT : RectangleEdge.LEFT) : (bl && !bl2 || !bl && bl2 ? RectangleEdge.BOTTOM : RectangleEdge.TOP);
        if (n3 == 0) {
            if (this.getShadowsVisible()) {
                this.getBarPainter().paintBarShadow(graphics2D, this, n, n2, double_, rectangleEdge3, false);
            }
        } else if (n3 == 1) {
            EntityCollection entityCollection;
            this.getBarPainter().paintBar(graphics2D, this, n, n2, double_, rectangleEdge3);
            if (plotRenderingInfo != null && (entityCollection = plotRenderingInfo.getOwner().getEntityCollection()) != null) {
                this.addEntity(entityCollection, double_, xYDataset, n, n2, double_.getCenterX(), double_.getCenterY());
            }
        } else if (n3 == 2 && this.isItemLabelVisible(n, n2)) {
            XYItemLabelGenerator xYItemLabelGenerator = this.getItemLabelGenerator(n, n2);
            this.drawItemLabel(graphics2D, xYDataset, n, n2, xYPlot, xYItemLabelGenerator, double_, d3 < 0.0);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StackedXYBarRenderer)) {
            return false;
        }
        StackedXYBarRenderer stackedXYBarRenderer = (StackedXYBarRenderer)object;
        if (this.renderAsPercentages != stackedXYBarRenderer.renderAsPercentages) {
            return false;
        }
        return super.equals(object);
    }

    public int hashCode() {
        int n = super.hashCode();
        n = n * 37 + (this.renderAsPercentages ? 1 : 0);
        return n;
    }
}

