/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.xy;

import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.labels.XYToolTipGenerator;
import ai.org.jfree.chart.plot.CrosshairState;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.chart.renderer.xy.XYAreaRenderer2;
import ai.org.jfree.chart.renderer.xy.XYItemRendererState;
import ai.org.jfree.chart.urls.XYURLGenerator;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.xy.TableXYDataset;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.util.PublicCloneable;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class StackedXYAreaRenderer2
extends XYAreaRenderer2
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 7752676509764539182L;
    private boolean roundXCoordinates = true;

    public StackedXYAreaRenderer2() {
        this(null, null);
    }

    public StackedXYAreaRenderer2(XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        super(xYToolTipGenerator, xYURLGenerator);
    }

    public boolean getRoundXCoordinates() {
        return this.roundXCoordinates;
    }

    public void setRoundXCoordinates(boolean bl) {
        this.roundXCoordinates = bl;
        this.fireChangeEvent();
    }

    public Range findRangeBounds(XYDataset xYDataset) {
        if (xYDataset == null) {
            return null;
        }
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        TableXYDataset tableXYDataset = (TableXYDataset)xYDataset;
        int n = tableXYDataset.getItemCount();
        for (int i = 0; i < n; ++i) {
            double[] dArray = this.getStackValues((TableXYDataset)xYDataset, tableXYDataset.getSeriesCount(), i);
            d = Math.min(d, dArray[0]);
            d2 = Math.max(d2, dArray[1]);
        }
        if (d == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(d, d2);
    }

    public int getPassCount() {
        return 1;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        float f;
        float f2;
        float f3;
        GeneralPath generalPath = null;
        EntityCollection entityCollection = null;
        if (plotRenderingInfo != null) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        TableXYDataset tableXYDataset = (TableXYDataset)xYDataset;
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        double d = xYDataset.getXValue(n, n2);
        double d2 = xYDataset.getYValue(n, n2);
        if (Double.isNaN(d2)) {
            d2 = 0.0;
        }
        double[] dArray = this.getStackValues(tableXYDataset, n, n2);
        double d3 = xYDataset.getXValue(n, Math.max(n2 - 1, 0));
        double d4 = xYDataset.getYValue(n, Math.max(n2 - 1, 0));
        if (Double.isNaN(d4)) {
            d4 = 0.0;
        }
        double[] dArray2 = this.getStackValues(tableXYDataset, n, Math.max(n2 - 1, 0));
        int n4 = xYDataset.getItemCount(n);
        double d5 = xYDataset.getXValue(n, Math.min(n2 + 1, n4 - 1));
        double d6 = xYDataset.getYValue(n, Math.min(n2 + 1, n4 - 1));
        if (Double.isNaN(d6)) {
            d6 = 0.0;
        }
        double[] dArray3 = this.getStackValues(tableXYDataset, n, Math.min(n2 + 1, n4 - 1));
        double d7 = (d3 + d) / 2.0;
        double d8 = (d + d5) / 2.0;
        double[] dArray4 = this.averageStackValues(dArray2, dArray);
        double[] dArray5 = this.averageStackValues(dArray, dArray3);
        double[] dArray6 = this.adjustedStackValues(dArray2, dArray);
        double[] dArray7 = this.adjustedStackValues(dArray, dArray3);
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        float f4 = (float)valueAxis.valueToJava2D(d, rectangle2D, rectangleEdge);
        float f5 = (float)valueAxis.valueToJava2D(d7, rectangle2D, rectangleEdge);
        float f6 = (float)valueAxis.valueToJava2D(d8, rectangle2D, rectangleEdge);
        if (this.roundXCoordinates) {
            f4 = Math.round(f4);
            f5 = Math.round(f5);
            f6 = Math.round(f6);
        }
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        GeneralPath generalPath2 = new GeneralPath();
        GeneralPath generalPath3 = new GeneralPath();
        if (d2 >= 0.0) {
            f3 = (float)valueAxis2.valueToJava2D(d2 + dArray[1], rectangle2D, rectangleEdge2);
            f2 = (float)valueAxis2.valueToJava2D(dArray[1], rectangle2D, rectangleEdge2);
            f = (float)valueAxis2.valueToJava2D(dArray6[1], rectangle2D, rectangleEdge2);
            if (d4 >= 0.0) {
                double d9 = (d4 + d2) / 2.0 + dArray4[1];
                float f7 = (float)valueAxis2.valueToJava2D(d9, rectangle2D, rectangleEdge2);
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    generalPath2.moveTo(f4, f3);
                    generalPath2.lineTo(f4, f2);
                    generalPath2.lineTo(f5, f);
                    generalPath2.lineTo(f5, f7);
                } else {
                    generalPath2.moveTo(f3, f4);
                    generalPath2.lineTo(f2, f4);
                    generalPath2.lineTo(f, f5);
                    generalPath2.lineTo(f7, f5);
                }
                generalPath2.closePath();
            } else {
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    generalPath2.moveTo(f4, f2);
                    generalPath2.lineTo(f4, f3);
                    generalPath2.lineTo(f5, f);
                } else {
                    generalPath2.moveTo(f2, f4);
                    generalPath2.lineTo(f3, f4);
                    generalPath2.lineTo(f, f5);
                }
                generalPath2.closePath();
            }
            float f8 = (float)valueAxis2.valueToJava2D(dArray7[1], rectangle2D, rectangleEdge2);
            if (d6 >= 0.0) {
                double d10 = (d2 + d6) / 2.0 + dArray5[1];
                float f9 = (float)valueAxis2.valueToJava2D(d10, rectangle2D, rectangleEdge2);
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    generalPath3.moveTo(f4, f2);
                    generalPath3.lineTo(f4, f3);
                    generalPath3.lineTo(f6, f9);
                    generalPath3.lineTo(f6, f8);
                } else {
                    generalPath3.moveTo(f2, f4);
                    generalPath3.lineTo(f3, f4);
                    generalPath3.lineTo(f9, f6);
                    generalPath3.lineTo(f8, f6);
                }
                generalPath3.closePath();
            } else {
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    generalPath3.moveTo(f4, f2);
                    generalPath3.lineTo(f4, f3);
                    generalPath3.lineTo(f6, f8);
                } else {
                    generalPath3.moveTo(f2, f4);
                    generalPath3.lineTo(f3, f4);
                    generalPath3.lineTo(f8, f6);
                }
                generalPath3.closePath();
            }
        } else {
            f3 = (float)valueAxis2.valueToJava2D(d2 + dArray[0], rectangle2D, rectangleEdge2);
            f2 = (float)valueAxis2.valueToJava2D(dArray[0], rectangle2D, rectangleEdge2);
            f = (float)valueAxis2.valueToJava2D(dArray6[0], rectangle2D, rectangleEdge2);
            if (d4 >= 0.0) {
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    generalPath2.moveTo(f4, f2);
                    generalPath2.lineTo(f4, f3);
                    generalPath2.lineTo(f5, f);
                } else {
                    generalPath2.moveTo(f2, f4);
                    generalPath2.lineTo(f3, f4);
                    generalPath2.lineTo(f, f5);
                }
                generalPath2.clone();
            } else {
                double d11 = (d4 + d2) / 2.0 + dArray4[0];
                float f10 = (float)valueAxis2.valueToJava2D(d11, rectangle2D, rectangleEdge2);
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    generalPath2.moveTo(f4, f3);
                    generalPath2.lineTo(f4, f2);
                    generalPath2.lineTo(f5, f);
                    generalPath2.lineTo(f5, f10);
                } else {
                    generalPath2.moveTo(f3, f4);
                    generalPath2.lineTo(f2, f4);
                    generalPath2.lineTo(f, f5);
                    generalPath2.lineTo(f10, f5);
                }
                generalPath2.closePath();
            }
            float f11 = (float)valueAxis2.valueToJava2D(dArray7[0], rectangle2D, rectangleEdge2);
            if (d6 >= 0.0) {
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    generalPath3.moveTo(f4, f2);
                    generalPath3.lineTo(f4, f3);
                    generalPath3.lineTo(f6, f11);
                } else {
                    generalPath3.moveTo(f2, f4);
                    generalPath3.lineTo(f3, f4);
                    generalPath3.lineTo(f11, f6);
                }
                generalPath3.closePath();
            } else {
                double d12 = (d2 + d6) / 2.0 + dArray5[0];
                float f12 = (float)valueAxis2.valueToJava2D(d12, rectangle2D, rectangleEdge2);
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    generalPath3.moveTo(f4, f2);
                    generalPath3.lineTo(f4, f3);
                    generalPath3.lineTo(f6, f12);
                    generalPath3.lineTo(f6, f11);
                } else {
                    generalPath3.moveTo(f2, f4);
                    generalPath3.lineTo(f3, f4);
                    generalPath3.lineTo(f12, f6);
                    generalPath3.lineTo(f11, f6);
                }
                generalPath3.closePath();
            }
        }
        Paint paint = this.getItemPaint(n, n2);
        if (n3 == 0) {
            graphics2D.setPaint(paint);
            graphics2D.fill(generalPath2);
            graphics2D.fill(generalPath3);
        }
        if (entityCollection != null) {
            GeneralPath generalPath4 = new GeneralPath(generalPath2);
            generalPath4.append(generalPath3, false);
            generalPath = generalPath4;
            this.addEntity(entityCollection, generalPath, xYDataset, n, n2, f4, f3);
        }
    }

    private double[] getStackValues(TableXYDataset tableXYDataset, int n, int n2) {
        double[] dArray = new double[2];
        for (int i = 0; i < n; ++i) {
            double d = tableXYDataset.getYValue(i, n2);
            if (Double.isNaN(d)) continue;
            if (d >= 0.0) {
                dArray[1] = dArray[1] + d;
                continue;
            }
            dArray[0] = dArray[0] + d;
        }
        return dArray;
    }

    private double[] averageStackValues(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{(dArray[0] + dArray2[0]) / 2.0, (dArray[1] + dArray2[1]) / 2.0};
        return dArray3;
    }

    private double[] adjustedStackValues(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[]{dArray[0] == 0.0 || dArray2[0] == 0.0 ? 0.0 : (dArray[0] + dArray2[0]) / 2.0, dArray[1] == 0.0 || dArray2[1] == 0.0 ? 0.0 : (dArray[1] + dArray2[1]) / 2.0};
        return dArray3;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StackedXYAreaRenderer2)) {
            return false;
        }
        StackedXYAreaRenderer2 stackedXYAreaRenderer2 = (StackedXYAreaRenderer2)object;
        if (this.roundXCoordinates != stackedXYAreaRenderer2.roundXCoordinates) {
            return false;
        }
        return super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

