/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.xy;

import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.plot.CrosshairState;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.chart.renderer.xy.XYItemRendererState;
import ai.org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.xy.IntervalXYDataset;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.ui.RectangleEdge;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class DeviationRenderer
extends XYLineAndShapeRenderer {
    private float alpha;

    public DeviationRenderer() {
        this(true, true);
    }

    public DeviationRenderer(boolean bl, boolean bl2) {
        super(bl, bl2);
        super.setDrawSeriesLineAsPath(true);
        this.alpha = 0.5f;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Requires 'alpha' in the range 0.0 to 1.0.");
        }
        this.alpha = f;
        this.fireChangeEvent();
    }

    public void setDrawSeriesLineAsPath(boolean bl) {
    }

    public Range findRangeBounds(XYDataset xYDataset) {
        return this.findRangeBounds(xYDataset, true);
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        State state = new State(plotRenderingInfo);
        state.seriesPath = new GeneralPath();
        state.setProcessVisibleItemsOnly(false);
        return state;
    }

    public int getPassCount() {
        return 3;
    }

    protected boolean isItemPass(int n) {
        return n == 2;
    }

    protected boolean isLinePass(int n) {
        return n == 1;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        Object object;
        if (!this.getItemVisible(n, n2)) {
            return;
        }
        if (n3 == 0) {
            object = (IntervalXYDataset)xYDataset;
            State state = (State)xYItemRendererState;
            double d = object.getXValue(n, n2);
            double d2 = object.getStartYValue(n, n2);
            double d3 = object.getEndYValue(n, n2);
            RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
            RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
            double d4 = valueAxis.valueToJava2D(d, rectangle2D, rectangleEdge);
            double d5 = valueAxis2.valueToJava2D(d2, rectangle2D, rectangleEdge2);
            double d6 = valueAxis2.valueToJava2D(d3, rectangle2D, rectangleEdge2);
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                state.lowerCoordinates.add(new double[]{d5, d4});
                state.upperCoordinates.add(new double[]{d6, d4});
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                state.lowerCoordinates.add(new double[]{d4, d5});
                state.upperCoordinates.add(new double[]{d4, d6});
            }
            if (n2 == xYDataset.getItemCount(n) - 1) {
                int n4;
                Composite composite = graphics2D.getComposite();
                graphics2D.setComposite(AlphaComposite.getInstance(3, this.alpha));
                graphics2D.setPaint(this.getItemFillPaint(n, n2));
                GeneralPath generalPath = new GeneralPath();
                double[] dArray = (double[])state.lowerCoordinates.get(0);
                generalPath.moveTo((float)dArray[0], (float)dArray[1]);
                for (n4 = 1; n4 < state.lowerCoordinates.size(); ++n4) {
                    dArray = (double[])state.lowerCoordinates.get(n4);
                    generalPath.lineTo((float)dArray[0], (float)dArray[1]);
                }
                n4 = state.upperCoordinates.size();
                dArray = (double[])state.upperCoordinates.get(n4 - 1);
                generalPath.lineTo((float)dArray[0], (float)dArray[1]);
                for (int i = n4 - 2; i >= 0; --i) {
                    dArray = (double[])state.upperCoordinates.get(i);
                    generalPath.lineTo((float)dArray[0], (float)dArray[1]);
                }
                generalPath.closePath();
                graphics2D.fill(generalPath);
                graphics2D.setComposite(composite);
                state.lowerCoordinates.clear();
                state.upperCoordinates.clear();
            }
        }
        if (this.isLinePass(n3)) {
            if (n2 == 0) {
                object = (State)xYItemRendererState;
                ((State)object).seriesPath.reset();
                ((XYLineAndShapeRenderer.State)object).setLastPointGood(false);
            }
            if (this.getItemLineVisible(n, n2)) {
                this.drawPrimaryLineAsPath(xYItemRendererState, graphics2D, xYPlot, xYDataset, n3, n, n2, valueAxis, valueAxis2, rectangle2D);
            }
        } else if (this.isItemPass(n3)) {
            object = null;
            if (plotRenderingInfo != null) {
                object = plotRenderingInfo.getOwner().getEntityCollection();
            }
            this.drawSecondaryPass(graphics2D, xYPlot, xYDataset, n3, n, n2, valueAxis, rectangle2D, valueAxis2, crosshairState, (EntityCollection)object);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DeviationRenderer)) {
            return false;
        }
        DeviationRenderer deviationRenderer = (DeviationRenderer)object;
        if (this.alpha != deviationRenderer.alpha) {
            return false;
        }
        return super.equals(object);
    }

    public static class State
    extends XYLineAndShapeRenderer.State {
        public List upperCoordinates;
        public List lowerCoordinates = new ArrayList();

        public State(PlotRenderingInfo plotRenderingInfo) {
            super(plotRenderingInfo);
            this.upperCoordinates = new ArrayList();
        }
    }
}

