/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.category;

import ai.org.jfree.chart.axis.CategoryAxis;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.labels.CategoryItemLabelGenerator;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.renderer.category.BarRenderer;
import ai.org.jfree.chart.renderer.category.CategoryItemRendererState;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.ui.GradientPaintTransformType;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.ui.StandardGradientPaintTransformer;
import ai.org.jfree.util.PaintUtilities;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class WaterfallBarRenderer
extends BarRenderer {
    private static final long serialVersionUID = -2482910643727230911L;
    private transient Paint firstBarPaint;
    private transient Paint lastBarPaint;
    private transient Paint positiveBarPaint;
    private transient Paint negativeBarPaint;

    public WaterfallBarRenderer() {
        this(new GradientPaint(0.0f, 0.0f, new Color(34, 34, 255), 0.0f, 0.0f, new Color(102, 102, 255)), new GradientPaint(0.0f, 0.0f, new Color(34, 255, 34), 0.0f, 0.0f, new Color(102, 255, 102)), new GradientPaint(0.0f, 0.0f, new Color(255, 34, 34), 0.0f, 0.0f, new Color(255, 102, 102)), new GradientPaint(0.0f, 0.0f, new Color(255, 255, 34), 0.0f, 0.0f, new Color(255, 255, 102)));
    }

    public WaterfallBarRenderer(Paint paint, Paint paint2, Paint paint3, Paint paint4) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'firstBarPaint' argument");
        }
        if (paint2 == null) {
            throw new IllegalArgumentException("Null 'positiveBarPaint' argument");
        }
        if (paint3 == null) {
            throw new IllegalArgumentException("Null 'negativeBarPaint' argument");
        }
        if (paint4 == null) {
            throw new IllegalArgumentException("Null 'lastBarPaint' argument");
        }
        this.firstBarPaint = paint;
        this.lastBarPaint = paint4;
        this.positiveBarPaint = paint2;
        this.negativeBarPaint = paint3;
        this.setGradientPaintTransformer(new StandardGradientPaintTransformer(GradientPaintTransformType.CENTER_VERTICAL));
        this.setMinimumBarLength(1.0);
    }

    public Paint getFirstBarPaint() {
        return this.firstBarPaint;
    }

    public void setFirstBarPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument");
        }
        this.firstBarPaint = paint;
        this.fireChangeEvent();
    }

    public Paint getLastBarPaint() {
        return this.lastBarPaint;
    }

    public void setLastBarPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument");
        }
        this.lastBarPaint = paint;
        this.fireChangeEvent();
    }

    public Paint getPositiveBarPaint() {
        return this.positiveBarPaint;
    }

    public void setPositiveBarPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument");
        }
        this.positiveBarPaint = paint;
        this.fireChangeEvent();
    }

    public Paint getNegativeBarPaint() {
        return this.negativeBarPaint;
    }

    public void setNegativeBarPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument");
        }
        this.negativeBarPaint = paint;
        this.fireChangeEvent();
    }

    public Range findRangeBounds(CategoryDataset categoryDataset) {
        if (categoryDataset == null) {
            return null;
        }
        boolean bl = true;
        double d = 0.0;
        double d2 = 0.0;
        int n = categoryDataset.getColumnCount();
        for (int i = 0; i < categoryDataset.getRowCount(); ++i) {
            double d3 = 0.0;
            for (int j = 0; j <= n - 1; ++j) {
                Number number = categoryDataset.getValue(i, j);
                if (number == null) continue;
                bl = false;
                double d4 = number.doubleValue();
                d3 = j == n - 1 ? d4 : (d3 += d4);
                d = Math.min(d, d3);
                d2 = Math.max(d2, d3);
            }
        }
        if (!bl) {
            return new Range(d, d2);
        }
        return null;
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        Object object;
        Object object2;
        double d;
        double d2 = categoryItemRendererState.getSeriesRunningTotal();
        if (n2 == categoryDataset.getColumnCount() - 1) {
            d2 = 0.0;
        }
        double d3 = 0.0;
        Number number = categoryDataset.getValue(n, n2);
        if (number != null) {
            d3 = d2 + number.doubleValue();
        }
        categoryItemRendererState.setSeriesRunningTotal(d3);
        int n4 = this.getColumnCount();
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d4 = 0.0;
        double d5 = 0.0;
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        double d6 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
        double d7 = valueAxis.valueToJava2D(d3, rectangle2D, rectangleEdge);
        double d8 = d3 - d2;
        if (d7 < d6) {
            d = d7;
            d7 = d6;
            d6 = d;
        }
        d = categoryItemRendererState.getBarWidth();
        double d9 = Math.max(this.getMinimumBarLength(), Math.abs(d7 - d6));
        Comparable comparable = categoryDataset.getRowKey(n);
        Comparable comparable2 = categoryDataset.getColumnKey(n2);
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d5 = categoryAxis.getCategorySeriesMiddle(comparable2, comparable, categoryDataset, this.getItemMargin(), rectangle2D, RectangleEdge.LEFT);
            d4 = d6;
            d9 = categoryItemRendererState.getBarWidth();
            d5 -= d9 / 2.0;
            d = Math.max(this.getMinimumBarLength(), Math.abs(d7 - d6));
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            d4 = categoryAxis.getCategorySeriesMiddle(comparable2, comparable, categoryDataset, this.getItemMargin(), rectangle2D, RectangleEdge.TOP);
            d4 -= d / 2.0;
            d5 = d6;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d4, d5, d, d9);
        Paint paint = n2 == 0 ? this.getFirstBarPaint() : (n2 == n4 - 1 ? this.getLastBarPaint() : (d8 < 0.0 ? this.getNegativeBarPaint() : (d8 > 0.0 ? this.getPositiveBarPaint() : this.getLastBarPaint())));
        if (this.getGradientPaintTransformer() != null && paint instanceof GradientPaint) {
            object2 = (GradientPaint)paint;
            paint = this.getGradientPaintTransformer().transform((GradientPaint)object2, double_);
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
            object2 = this.getItemOutlineStroke(n, n2);
            object = this.getItemOutlinePaint(n, n2);
            if (object2 != null && object != null) {
                graphics2D.setStroke((Stroke)object2);
                graphics2D.setPaint((Paint)object);
                graphics2D.draw(double_);
            }
        }
        if ((object2 = this.getItemLabelGenerator(n, n2)) != null && this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, categoryDataset, n, n2, categoryPlot, (CategoryItemLabelGenerator)object2, double_, d8 < 0.0);
        }
        if ((object = categoryItemRendererState.getEntityCollection()) != null) {
            this.addItemEntity((EntityCollection)object, categoryDataset, n, n2, double_);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof WaterfallBarRenderer)) {
            return false;
        }
        WaterfallBarRenderer waterfallBarRenderer = (WaterfallBarRenderer)object;
        if (!PaintUtilities.equal(this.firstBarPaint, waterfallBarRenderer.firstBarPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.lastBarPaint, waterfallBarRenderer.lastBarPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.positiveBarPaint, waterfallBarRenderer.positiveBarPaint)) {
            return false;
        }
        return PaintUtilities.equal(this.negativeBarPaint, waterfallBarRenderer.negativeBarPaint);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.firstBarPaint, objectOutputStream);
        SerialUtilities.writePaint(this.lastBarPaint, objectOutputStream);
        SerialUtilities.writePaint(this.positiveBarPaint, objectOutputStream);
        SerialUtilities.writePaint(this.negativeBarPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.firstBarPaint = SerialUtilities.readPaint(objectInputStream);
        this.lastBarPaint = SerialUtilities.readPaint(objectInputStream);
        this.positiveBarPaint = SerialUtilities.readPaint(objectInputStream);
        this.negativeBarPaint = SerialUtilities.readPaint(objectInputStream);
    }
}

