/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.category;

import ai.org.jfree.chart.HashUtilities;
import ai.org.jfree.chart.axis.CategoryAxis;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.event.RendererChangeEvent;
import ai.org.jfree.chart.labels.CategoryItemLabelGenerator;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.renderer.category.BarRenderer3D;
import ai.org.jfree.chart.renderer.category.CategoryItemRendererState;
import ai.org.jfree.data.DataUtilities;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.data.general.DatasetUtilities;
import ai.org.jfree.util.BooleanUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class StackedBarRenderer3D
extends BarRenderer3D
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -5832945916493247123L;
    private boolean renderAsPercentages;
    private boolean ignoreZeroValues;

    public StackedBarRenderer3D() {
        this(false);
    }

    public StackedBarRenderer3D(double d, double d2) {
        super(d, d2);
    }

    public StackedBarRenderer3D(boolean bl) {
        this.renderAsPercentages = bl;
    }

    public StackedBarRenderer3D(double d, double d2, boolean bl) {
        super(d, d2);
        this.renderAsPercentages = bl;
    }

    public boolean getRenderAsPercentages() {
        return this.renderAsPercentages;
    }

    public void setRenderAsPercentages(boolean bl) {
        this.renderAsPercentages = bl;
        this.fireChangeEvent();
    }

    public boolean getIgnoreZeroValues() {
        return this.ignoreZeroValues;
    }

    public void setIgnoreZeroValues(boolean bl) {
        this.ignoreZeroValues = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public Range findRangeBounds(CategoryDataset categoryDataset) {
        if (categoryDataset == null) {
            return null;
        }
        if (this.renderAsPercentages) {
            return new Range(0.0, 1.0);
        }
        return DatasetUtilities.findStackedRangeBounds(categoryDataset);
    }

    protected void calculateBarWidth(CategoryPlot categoryPlot, Rectangle2D rectangle2D, int n, CategoryItemRendererState categoryItemRendererState) {
        CategoryAxis categoryAxis = this.getDomainAxis(categoryPlot, n);
        CategoryDataset categoryDataset = categoryPlot.getDataset(n);
        if (categoryDataset != null) {
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            double d = 0.0;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d = rectangle2D.getHeight();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                d = rectangle2D.getWidth();
            }
            double d2 = d * this.getMaximumBarWidth();
            int n2 = categoryDataset.getColumnCount();
            double d3 = 0.0;
            if (n2 > 1) {
                d3 = categoryAxis.getCategoryMargin();
            }
            double d4 = d * (1.0 - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin() - d3);
            if (n2 > 0) {
                categoryItemRendererState.setBarWidth(Math.min(d4 / (double)n2, d2));
            } else {
                categoryItemRendererState.setBarWidth(Math.min(d4, d2));
            }
        }
    }

    protected List createStackedValueList(CategoryDataset categoryDataset, Comparable comparable, double d, boolean bl) {
        int[] nArray = new int[categoryDataset.getRowCount()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        return this.createStackedValueList(categoryDataset, comparable, nArray, d, bl);
    }

    protected List createStackedValueList(CategoryDataset categoryDataset, Comparable comparable, int[] nArray, double d, boolean bl) {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        double d2 = d;
        double d3 = d;
        double d4 = 0.0;
        if (bl) {
            d4 = DataUtilities.calculateColumnTotal(categoryDataset, categoryDataset.getColumnIndex(comparable), nArray);
        }
        int n = -1;
        for (int n2 : nArray) {
            Number number = categoryDataset.getValue(categoryDataset.getRowKey(n2), comparable);
            if (number == null) continue;
            double d5 = number.doubleValue();
            if (bl) {
                d5 /= d4;
            }
            if (d5 > 0.0 || !this.ignoreZeroValues && d5 >= 0.0) {
                if (n < 0) {
                    arrayList.add(new Object[]{null, new Double(d)});
                    n = 0;
                }
                arrayList.add(new Object[]{new Integer(n2), new Double(d2 += d5)});
                continue;
            }
            if (!(d5 < 0.0)) continue;
            if (n < 0) {
                arrayList.add(new Object[]{null, new Double(d)});
                n = 0;
            }
            arrayList.add(0, new Object[]{new Integer(-n2 - 1), new Double(d3 += d5)});
            ++n;
        }
        return arrayList;
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        if (n < categoryDataset.getRowCount() - 1) {
            return;
        }
        Comparable comparable = categoryDataset.getColumnKey(n2);
        List list = this.createStackedValueList(categoryDataset, categoryDataset.getColumnKey(n2), categoryItemRendererState.getVisibleSeriesArray(), this.getBase(), this.renderAsPercentages);
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + this.getYOffset(), rectangle2D.getWidth() - this.getXOffset(), rectangle2D.getHeight() - this.getYOffset());
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            this.drawStackHorizontal(list, comparable, graphics2D, categoryItemRendererState, double_, categoryPlot, categoryAxis, valueAxis, categoryDataset);
        } else {
            this.drawStackVertical(list, comparable, graphics2D, categoryItemRendererState, double_, categoryPlot, categoryAxis, valueAxis, categoryDataset);
        }
    }

    protected void drawStackHorizontal(List list, Comparable comparable, Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset) {
        int n;
        Object object;
        int n2;
        int n3 = categoryDataset.getColumnIndex(comparable);
        double d = categoryAxis.getCategoryMiddle(n3, categoryDataset.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge()) - categoryItemRendererState.getBarWidth() / 2.0;
        double d2 = categoryItemRendererState.getBarWidth();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        boolean bl = valueAxis.isInverted();
        int n4 = list.size() - 1;
        for (n2 = 0; n2 < n4; ++n2) {
            Paint paint;
            int n5 = bl ? n4 - n2 - 1 : n2;
            Object[] objectArray = (Object[])list.get(n5);
            object = (Object[])list.get(n5 + 1);
            n = 0;
            if (object[0] == null) {
                n = -((Integer)objectArray[0]).intValue() - 1;
            } else {
                n = (Integer)object[0];
                if (n < 0) {
                    n = -((Integer)objectArray[0]).intValue() - 1;
                }
            }
            double d3 = (Double)objectArray[1];
            double d4 = valueAxis.valueToJava2D(d3, rectangle2D, categoryPlot.getRangeAxisEdge());
            double d5 = (Double)object[1];
            double d6 = valueAxis.valueToJava2D(d5, rectangle2D, categoryPlot.getRangeAxisEdge());
            Shape[] shapeArray = this.createHorizontalBlock(d, d2, d4, d6, bl);
            Paint paint2 = paint = this.getItemPaint(n, n3);
            if (paint2 instanceof Color) {
                paint2 = ((Color)paint).darker();
            }
            boolean bl2 = this.isDrawBarOutline();
            Paint paint3 = paint;
            if (bl2) {
                paint3 = this.getItemOutlinePaint(n, n3);
                graphics2D.setStroke(this.getItemOutlineStroke(n, n3));
            }
            for (int i = 0; i < 6; ++i) {
                if (i == 5) {
                    graphics2D.setPaint(paint);
                } else {
                    graphics2D.setPaint(paint2);
                }
                graphics2D.fill(shapeArray[i]);
                if (!bl2) continue;
                graphics2D.setPaint(paint3);
                graphics2D.draw(shapeArray[i]);
            }
            arrayList.add(new Object[]{new Integer(n), shapeArray[5].getBounds2D(), BooleanUtilities.valueOf(d3 < this.getBase())});
            EntityCollection entityCollection = categoryItemRendererState.getEntityCollection();
            if (entityCollection == null) continue;
            this.addItemEntity(entityCollection, categoryDataset, n, n3, shapeArray[5]);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            Object[] objectArray = (Object[])arrayList.get(n2);
            int n6 = (Integer)objectArray[0];
            object = (Rectangle2D)objectArray[1];
            n = ((Boolean)objectArray[2]).booleanValue();
            CategoryItemLabelGenerator categoryItemLabelGenerator = this.getItemLabelGenerator(n6, n3);
            if (categoryItemLabelGenerator == null || !this.isItemLabelVisible(n6, n3)) continue;
            this.drawItemLabel(graphics2D, categoryDataset, n6, n3, categoryPlot, categoryItemLabelGenerator, (Rectangle2D)object, n != 0);
        }
    }

    private Shape[] createHorizontalBlock(double d, double d2, double d3, double d4, boolean bl) {
        Shape[] shapeArray = new Shape[6];
        Point2D.Double double_ = new Point2D.Double(d3, d);
        Point2D.Double double_2 = new Point2D.Double(d3, d + d2);
        Point2D.Double double_3 = new Point2D.Double(((Point2D)double_2).getX() + this.getXOffset(), ((Point2D)double_2).getY() - this.getYOffset());
        Point2D.Double double_4 = new Point2D.Double(((Point2D)double_).getX() + this.getXOffset(), ((Point2D)double_).getY() - this.getYOffset());
        Point2D.Double double_5 = new Point2D.Double(d4, d);
        Point2D.Double double_6 = new Point2D.Double(d4, d + d2);
        Point2D.Double double_7 = new Point2D.Double(((Point2D)double_6).getX() + this.getXOffset(), ((Point2D)double_6).getY() - this.getYOffset());
        Point2D.Double double_8 = new Point2D.Double(((Point2D)double_5).getX() + this.getXOffset(), ((Point2D)double_5).getY() - this.getYOffset());
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)((Point2D)double_6).getX(), (float)((Point2D)double_6).getY());
        generalPath.lineTo((float)((Point2D)double_2).getX(), (float)((Point2D)double_2).getY());
        generalPath.lineTo((float)((Point2D)double_3).getX(), (float)((Point2D)double_3).getY());
        generalPath.lineTo((float)((Point2D)double_7).getX(), (float)((Point2D)double_7).getY());
        generalPath.closePath();
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo((float)((Point2D)double_5).getX(), (float)((Point2D)double_5).getY());
        generalPath2.lineTo((float)((Point2D)double_).getX(), (float)((Point2D)double_).getY());
        generalPath2.lineTo((float)((Point2D)double_4).getX(), (float)((Point2D)double_4).getY());
        generalPath2.lineTo((float)((Point2D)double_8).getX(), (float)((Point2D)double_8).getY());
        generalPath2.closePath();
        GeneralPath generalPath3 = new GeneralPath();
        generalPath3.moveTo((float)((Point2D)double_7).getX(), (float)((Point2D)double_7).getY());
        generalPath3.lineTo((float)((Point2D)double_3).getX(), (float)((Point2D)double_3).getY());
        generalPath3.lineTo((float)((Point2D)double_4).getX(), (float)((Point2D)double_4).getY());
        generalPath3.lineTo((float)((Point2D)double_8).getX(), (float)((Point2D)double_8).getY());
        generalPath3.closePath();
        GeneralPath generalPath4 = new GeneralPath();
        generalPath4.moveTo((float)((Point2D)double_5).getX(), (float)((Point2D)double_5).getY());
        generalPath4.lineTo((float)((Point2D)double_6).getX(), (float)((Point2D)double_6).getY());
        generalPath4.lineTo((float)((Point2D)double_2).getX(), (float)((Point2D)double_2).getY());
        generalPath4.lineTo((float)((Point2D)double_).getX(), (float)((Point2D)double_).getY());
        generalPath4.closePath();
        GeneralPath generalPath5 = new GeneralPath();
        generalPath5.moveTo((float)((Point2D)double_5).getX(), (float)((Point2D)double_5).getY());
        generalPath5.lineTo((float)((Point2D)double_6).getX(), (float)((Point2D)double_6).getY());
        generalPath5.lineTo((float)((Point2D)double_7).getX(), (float)((Point2D)double_7).getY());
        generalPath5.lineTo((float)((Point2D)double_8).getX(), (float)((Point2D)double_8).getY());
        generalPath5.closePath();
        GeneralPath generalPath6 = new GeneralPath();
        generalPath6.moveTo((float)((Point2D)double_).getX(), (float)((Point2D)double_).getY());
        generalPath6.lineTo((float)((Point2D)double_2).getX(), (float)((Point2D)double_2).getY());
        generalPath6.lineTo((float)((Point2D)double_3).getX(), (float)((Point2D)double_3).getY());
        generalPath6.lineTo((float)((Point2D)double_4).getX(), (float)((Point2D)double_4).getY());
        generalPath6.closePath();
        shapeArray[0] = generalPath;
        shapeArray[1] = generalPath3;
        if (bl) {
            shapeArray[2] = generalPath6;
            shapeArray[3] = generalPath5;
        } else {
            shapeArray[2] = generalPath5;
            shapeArray[3] = generalPath6;
        }
        shapeArray[4] = generalPath2;
        shapeArray[5] = generalPath4;
        return shapeArray;
    }

    protected void drawStackVertical(List list, Comparable comparable, Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset) {
        int n;
        Object object;
        int n2;
        int n3 = categoryDataset.getColumnIndex(comparable);
        double d = categoryAxis.getCategoryMiddle(n3, categoryDataset.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge()) - categoryItemRendererState.getBarWidth() / 2.0;
        double d2 = categoryItemRendererState.getBarWidth();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        boolean bl = valueAxis.isInverted();
        int n4 = list.size() - 1;
        for (n2 = 0; n2 < n4; ++n2) {
            Paint paint;
            int n5 = bl ? n4 - n2 - 1 : n2;
            Object[] objectArray = (Object[])list.get(n5);
            object = (Object[])list.get(n5 + 1);
            n = 0;
            if (object[0] == null) {
                n = -((Integer)objectArray[0]).intValue() - 1;
            } else {
                n = (Integer)object[0];
                if (n < 0) {
                    n = -((Integer)objectArray[0]).intValue() - 1;
                }
            }
            double d3 = (Double)objectArray[1];
            double d4 = valueAxis.valueToJava2D(d3, rectangle2D, categoryPlot.getRangeAxisEdge());
            double d5 = (Double)object[1];
            double d6 = valueAxis.valueToJava2D(d5, rectangle2D, categoryPlot.getRangeAxisEdge());
            Shape[] shapeArray = this.createVerticalBlock(d, d2, d4, d6, bl);
            Paint paint2 = paint = this.getItemPaint(n, n3);
            if (paint2 instanceof Color) {
                paint2 = ((Color)paint).darker();
            }
            boolean bl2 = this.isDrawBarOutline();
            Paint paint3 = paint;
            if (bl2) {
                paint3 = this.getItemOutlinePaint(n, n3);
                graphics2D.setStroke(this.getItemOutlineStroke(n, n3));
            }
            for (int i = 0; i < 6; ++i) {
                if (i == 5) {
                    graphics2D.setPaint(paint);
                } else {
                    graphics2D.setPaint(paint2);
                }
                graphics2D.fill(shapeArray[i]);
                if (!bl2) continue;
                graphics2D.setPaint(paint3);
                graphics2D.draw(shapeArray[i]);
            }
            arrayList.add(new Object[]{new Integer(n), shapeArray[5].getBounds2D(), BooleanUtilities.valueOf(d3 < this.getBase())});
            EntityCollection entityCollection = categoryItemRendererState.getEntityCollection();
            if (entityCollection == null) continue;
            this.addItemEntity(entityCollection, categoryDataset, n, n3, shapeArray[5]);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            Object[] objectArray = (Object[])arrayList.get(n2);
            int n6 = (Integer)objectArray[0];
            object = (Rectangle2D)objectArray[1];
            n = ((Boolean)objectArray[2]).booleanValue();
            CategoryItemLabelGenerator categoryItemLabelGenerator = this.getItemLabelGenerator(n6, n3);
            if (categoryItemLabelGenerator == null || !this.isItemLabelVisible(n6, n3)) continue;
            this.drawItemLabel(graphics2D, categoryDataset, n6, n3, categoryPlot, categoryItemLabelGenerator, (Rectangle2D)object, n != 0);
        }
    }

    private Shape[] createVerticalBlock(double d, double d2, double d3, double d4, boolean bl) {
        Shape[] shapeArray = new Shape[6];
        Point2D.Double double_ = new Point2D.Double(d, d3);
        Point2D.Double double_2 = new Point2D.Double(d + d2, d3);
        Point2D.Double double_3 = new Point2D.Double(((Point2D)double_2).getX() + this.getXOffset(), ((Point2D)double_2).getY() - this.getYOffset());
        Point2D.Double double_4 = new Point2D.Double(((Point2D)double_).getX() + this.getXOffset(), ((Point2D)double_).getY() - this.getYOffset());
        Point2D.Double double_5 = new Point2D.Double(d, d4);
        Point2D.Double double_6 = new Point2D.Double(d + d2, d4);
        Point2D.Double double_7 = new Point2D.Double(((Point2D)double_6).getX() + this.getXOffset(), ((Point2D)double_6).getY() - this.getYOffset());
        Point2D.Double double_8 = new Point2D.Double(((Point2D)double_5).getX() + this.getXOffset(), ((Point2D)double_5).getY() - this.getYOffset());
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)((Point2D)double_6).getX(), (float)((Point2D)double_6).getY());
        generalPath.lineTo((float)((Point2D)double_2).getX(), (float)((Point2D)double_2).getY());
        generalPath.lineTo((float)((Point2D)double_3).getX(), (float)((Point2D)double_3).getY());
        generalPath.lineTo((float)((Point2D)double_7).getX(), (float)((Point2D)double_7).getY());
        generalPath.closePath();
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo((float)((Point2D)double_5).getX(), (float)((Point2D)double_5).getY());
        generalPath2.lineTo((float)((Point2D)double_).getX(), (float)((Point2D)double_).getY());
        generalPath2.lineTo((float)((Point2D)double_4).getX(), (float)((Point2D)double_4).getY());
        generalPath2.lineTo((float)((Point2D)double_8).getX(), (float)((Point2D)double_8).getY());
        generalPath2.closePath();
        GeneralPath generalPath3 = new GeneralPath();
        generalPath3.moveTo((float)((Point2D)double_7).getX(), (float)((Point2D)double_7).getY());
        generalPath3.lineTo((float)((Point2D)double_3).getX(), (float)((Point2D)double_3).getY());
        generalPath3.lineTo((float)((Point2D)double_4).getX(), (float)((Point2D)double_4).getY());
        generalPath3.lineTo((float)((Point2D)double_8).getX(), (float)((Point2D)double_8).getY());
        generalPath3.closePath();
        GeneralPath generalPath4 = new GeneralPath();
        generalPath4.moveTo((float)((Point2D)double_5).getX(), (float)((Point2D)double_5).getY());
        generalPath4.lineTo((float)((Point2D)double_6).getX(), (float)((Point2D)double_6).getY());
        generalPath4.lineTo((float)((Point2D)double_2).getX(), (float)((Point2D)double_2).getY());
        generalPath4.lineTo((float)((Point2D)double_).getX(), (float)((Point2D)double_).getY());
        generalPath4.closePath();
        GeneralPath generalPath5 = new GeneralPath();
        generalPath5.moveTo((float)((Point2D)double_5).getX(), (float)((Point2D)double_5).getY());
        generalPath5.lineTo((float)((Point2D)double_6).getX(), (float)((Point2D)double_6).getY());
        generalPath5.lineTo((float)((Point2D)double_7).getX(), (float)((Point2D)double_7).getY());
        generalPath5.lineTo((float)((Point2D)double_8).getX(), (float)((Point2D)double_8).getY());
        generalPath5.closePath();
        GeneralPath generalPath6 = new GeneralPath();
        generalPath6.moveTo((float)((Point2D)double_).getX(), (float)((Point2D)double_).getY());
        generalPath6.lineTo((float)((Point2D)double_2).getX(), (float)((Point2D)double_2).getY());
        generalPath6.lineTo((float)((Point2D)double_3).getX(), (float)((Point2D)double_3).getY());
        generalPath6.lineTo((float)((Point2D)double_4).getX(), (float)((Point2D)double_4).getY());
        generalPath6.closePath();
        shapeArray[0] = generalPath6;
        shapeArray[1] = generalPath3;
        shapeArray[2] = generalPath2;
        shapeArray[3] = generalPath;
        shapeArray[4] = generalPath5;
        shapeArray[5] = generalPath4;
        if (bl) {
            shapeArray[0] = generalPath5;
            shapeArray[4] = generalPath6;
        }
        return shapeArray;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StackedBarRenderer3D)) {
            return false;
        }
        StackedBarRenderer3D stackedBarRenderer3D = (StackedBarRenderer3D)object;
        if (this.renderAsPercentages != stackedBarRenderer3D.getRenderAsPercentages()) {
            return false;
        }
        if (this.ignoreZeroValues != stackedBarRenderer3D.ignoreZeroValues) {
            return false;
        }
        return super.equals(object);
    }

    public int hashCode() {
        int n = super.hashCode();
        n = HashUtilities.hashCode(n, this.renderAsPercentages);
        n = HashUtilities.hashCode(n, this.ignoreZeroValues);
        return n;
    }
}

