/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.category;

import ai.org.jfree.chart.LegendItem;
import ai.org.jfree.chart.axis.CategoryAxis;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import ai.org.jfree.chart.renderer.category.CategoryItemRendererState;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.data.statistics.MultiValueCategoryDataset;
import ai.org.jfree.util.BooleanList;
import ai.org.jfree.util.BooleanUtilities;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PublicCloneable;
import ai.org.jfree.util.ShapeUtilities;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;

public class ScatterRenderer
extends AbstractCategoryItemRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private BooleanList seriesShapesFilled = new BooleanList();
    private boolean baseShapesFilled = true;
    private boolean useFillPaint = false;
    private boolean drawOutlines = false;
    private boolean useOutlinePaint = false;
    private boolean useSeriesOffset = true;
    private double itemMargin = 0.2;

    public boolean getUseSeriesOffset() {
        return this.useSeriesOffset;
    }

    public void setUseSeriesOffset(boolean bl) {
        this.useSeriesOffset = bl;
        this.fireChangeEvent();
    }

    public double getItemMargin() {
        return this.itemMargin;
    }

    public void setItemMargin(double d) {
        if (d < 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("Requires 0.0 <= margin < 1.0.");
        }
        this.itemMargin = d;
        this.fireChangeEvent();
    }

    public boolean getDrawOutlines() {
        return this.drawOutlines;
    }

    public void setDrawOutlines(boolean bl) {
        this.drawOutlines = bl;
        this.fireChangeEvent();
    }

    public boolean getUseOutlinePaint() {
        return this.useOutlinePaint;
    }

    public void setUseOutlinePaint(boolean bl) {
        this.useOutlinePaint = bl;
        this.fireChangeEvent();
    }

    public boolean getItemShapeFilled(int n, int n2) {
        return this.getSeriesShapesFilled(n);
    }

    public boolean getSeriesShapesFilled(int n) {
        Boolean bl = this.seriesShapesFilled.getBoolean(n);
        if (bl != null) {
            return bl;
        }
        return this.baseShapesFilled;
    }

    public void setSeriesShapesFilled(int n, Boolean bl) {
        this.seriesShapesFilled.setBoolean(n, bl);
        this.fireChangeEvent();
    }

    public void setSeriesShapesFilled(int n, boolean bl) {
        this.seriesShapesFilled.setBoolean(n, BooleanUtilities.valueOf(bl));
        this.fireChangeEvent();
    }

    public boolean getBaseShapesFilled() {
        return this.baseShapesFilled;
    }

    public void setBaseShapesFilled(boolean bl) {
        this.baseShapesFilled = bl;
        this.fireChangeEvent();
    }

    public boolean getUseFillPaint() {
        return this.useFillPaint;
    }

    public void setUseFillPaint(boolean bl) {
        this.useFillPaint = bl;
        this.fireChangeEvent();
    }

    public Range findRangeBounds(CategoryDataset categoryDataset) {
        return this.findRangeBounds(categoryDataset, true);
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        if (!this.getItemVisible(n, n2)) {
            return;
        }
        int n4 = categoryItemRendererState.getVisibleSeriesIndex(n);
        if (n4 < 0) {
            return;
        }
        int n5 = categoryItemRendererState.getVisibleSeriesCount();
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        MultiValueCategoryDataset multiValueCategoryDataset = (MultiValueCategoryDataset)categoryDataset;
        List list = multiValueCategoryDataset.getValues(n, n2);
        if (list == null) {
            return;
        }
        int n6 = list.size();
        for (int i = 0; i < n6; ++i) {
            double d = this.useSeriesOffset ? categoryAxis.getCategorySeriesMiddle(n2, categoryDataset.getColumnCount(), n4, n5, this.itemMargin, rectangle2D, categoryPlot.getDomainAxisEdge()) : categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
            Number number = (Number)list.get(i);
            double d2 = number.doubleValue();
            double d3 = valueAxis.valueToJava2D(d2, rectangle2D, categoryPlot.getRangeAxisEdge());
            Shape shape = this.getItemShape(n, n2);
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                shape = ShapeUtilities.createTranslatedShape(shape, d3, d);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                shape = ShapeUtilities.createTranslatedShape(shape, d, d3);
            }
            if (this.getItemShapeFilled(n, n2)) {
                if (this.useFillPaint) {
                    graphics2D.setPaint(this.getItemFillPaint(n, n2));
                } else {
                    graphics2D.setPaint(this.getItemPaint(n, n2));
                }
                graphics2D.fill(shape);
            }
            if (!this.drawOutlines) continue;
            if (this.useOutlinePaint) {
                graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
            } else {
                graphics2D.setPaint(this.getItemPaint(n, n2));
            }
            graphics2D.setStroke(this.getItemOutlineStroke(n, n2));
            graphics2D.draw(shape);
        }
    }

    public LegendItem getLegendItem(int n, int n2) {
        CategoryPlot categoryPlot = this.getPlot();
        if (categoryPlot == null) {
            return null;
        }
        if (this.isSeriesVisible(n2) && this.isSeriesVisibleInLegend(n2)) {
            String string;
            CategoryDataset categoryDataset = categoryPlot.getDataset(n);
            String string2 = string = this.getLegendItemLabelGenerator().generateLabel(categoryDataset, n2);
            String string3 = null;
            if (this.getLegendItemToolTipGenerator() != null) {
                string3 = this.getLegendItemToolTipGenerator().generateLabel(categoryDataset, n2);
            }
            String string4 = null;
            if (this.getLegendItemURLGenerator() != null) {
                string4 = this.getLegendItemURLGenerator().generateLabel(categoryDataset, n2);
            }
            Shape shape = this.lookupLegendShape(n2);
            Paint paint = this.lookupSeriesPaint(n2);
            Paint paint2 = this.useFillPaint ? this.getItemFillPaint(n2, 0) : paint;
            boolean bl = this.drawOutlines;
            Paint paint3 = this.useOutlinePaint ? this.getItemOutlinePaint(n2, 0) : paint;
            Stroke stroke = this.lookupSeriesOutlineStroke(n2);
            LegendItem legendItem = new LegendItem(string, string2, string3, string4, true, shape, this.getItemShapeFilled(n2, 0), paint2, bl, paint3, stroke, false, (Shape)new Line2D.Double(-7.0, 0.0, 7.0, 0.0), this.getItemStroke(n2, 0), this.getItemPaint(n2, 0));
            legendItem.setLabelFont(this.lookupLegendTextFont(n2));
            Paint paint4 = this.lookupLegendTextPaint(n2);
            if (paint4 != null) {
                legendItem.setLabelPaint(paint4);
            }
            legendItem.setDataset(categoryDataset);
            legendItem.setDatasetIndex(n);
            legendItem.setSeriesKey(categoryDataset.getRowKey(n2));
            legendItem.setSeriesIndex(n2);
            return legendItem;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ScatterRenderer)) {
            return false;
        }
        ScatterRenderer scatterRenderer = (ScatterRenderer)object;
        if (!ObjectUtilities.equal(this.seriesShapesFilled, scatterRenderer.seriesShapesFilled)) {
            return false;
        }
        if (this.baseShapesFilled != scatterRenderer.baseShapesFilled) {
            return false;
        }
        if (this.useFillPaint != scatterRenderer.useFillPaint) {
            return false;
        }
        if (this.drawOutlines != scatterRenderer.drawOutlines) {
            return false;
        }
        if (this.useOutlinePaint != scatterRenderer.useOutlinePaint) {
            return false;
        }
        if (this.useSeriesOffset != scatterRenderer.useSeriesOffset) {
            return false;
        }
        if (this.itemMargin != scatterRenderer.itemMargin) {
            return false;
        }
        return super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        ScatterRenderer scatterRenderer = (ScatterRenderer)super.clone();
        scatterRenderer.seriesShapesFilled = (BooleanList)this.seriesShapesFilled.clone();
        return scatterRenderer;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }
}

