/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.category;

import ai.org.jfree.chart.axis.CategoryAxis;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import ai.org.jfree.chart.renderer.category.CategoryItemRendererState;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.util.PaintUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.Icon;

public class MinMaxCategoryRenderer
extends AbstractCategoryItemRenderer {
    private static final long serialVersionUID = 2935615937671064911L;
    private boolean plotLines = false;
    private transient Paint groupPaint = Color.black;
    private transient Stroke groupStroke = new BasicStroke(1.0f);
    private transient Icon minIcon = this.getIcon((Shape)new Arc2D.Double(-4.0, -4.0, 8.0, 8.0, 0.0, 360.0, 0), null, Color.black);
    private transient Icon maxIcon = this.getIcon((Shape)new Arc2D.Double(-4.0, -4.0, 8.0, 8.0, 0.0, 360.0, 0), null, Color.black);
    private transient Icon objectIcon = this.getIcon((Shape)new Line2D.Double(-4.0, 0.0, 4.0, 0.0), false, true);
    private int lastCategory = -1;
    private double min;
    private double max;

    public boolean isDrawLines() {
        return this.plotLines;
    }

    public void setDrawLines(boolean bl) {
        if (this.plotLines != bl) {
            this.plotLines = bl;
            this.fireChangeEvent();
        }
    }

    public Paint getGroupPaint() {
        return this.groupPaint;
    }

    public void setGroupPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.groupPaint = paint;
        this.fireChangeEvent();
    }

    public Stroke getGroupStroke() {
        return this.groupStroke;
    }

    public void setGroupStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.groupStroke = stroke;
        this.fireChangeEvent();
    }

    public Icon getObjectIcon() {
        return this.objectIcon;
    }

    public void setObjectIcon(Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException("Null 'icon' argument.");
        }
        this.objectIcon = icon;
        this.fireChangeEvent();
    }

    public Icon getMaxIcon() {
        return this.maxIcon;
    }

    public void setMaxIcon(Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException("Null 'icon' argument.");
        }
        this.maxIcon = icon;
        this.fireChangeEvent();
    }

    public Icon getMinIcon() {
        return this.minIcon;
    }

    public void setMinIcon(Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException("Null 'icon' argument.");
        }
        this.minIcon = icon;
        this.fireChangeEvent();
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        Number number = categoryDataset.getValue(n, n2);
        if (number != null) {
            EntityCollection entityCollection;
            Number number2;
            double d = categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
            double d2 = valueAxis.valueToJava2D(number.doubleValue(), rectangle2D, categoryPlot.getRangeAxisEdge());
            graphics2D.setPaint(this.getItemPaint(n, n2));
            graphics2D.setStroke(this.getItemStroke(n, n2));
            Rectangle2D.Double double_ = null;
            double_ = new Rectangle2D.Double(d - 4.0, d2 - 4.0, 8.0, 8.0);
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            if (plotOrientation == PlotOrientation.VERTICAL) {
                this.objectIcon.paintIcon(null, graphics2D, (int)d, (int)d2);
            } else {
                this.objectIcon.paintIcon(null, graphics2D, (int)d2, (int)d);
            }
            if (this.lastCategory == n2) {
                if (this.min > number.doubleValue()) {
                    this.min = number.doubleValue();
                }
                if (this.max < number.doubleValue()) {
                    this.max = number.doubleValue();
                }
                if (categoryDataset.getRowCount() - 1 == n) {
                    graphics2D.setPaint(this.groupPaint);
                    graphics2D.setStroke(this.groupStroke);
                    double d3 = valueAxis.valueToJava2D(this.min, rectangle2D, categoryPlot.getRangeAxisEdge());
                    double d4 = valueAxis.valueToJava2D(this.max, rectangle2D, categoryPlot.getRangeAxisEdge());
                    if (plotOrientation == PlotOrientation.VERTICAL) {
                        graphics2D.draw(new Line2D.Double(d, d3, d, d4));
                        this.minIcon.paintIcon(null, graphics2D, (int)d, (int)d3);
                        this.maxIcon.paintIcon(null, graphics2D, (int)d, (int)d4);
                    } else {
                        graphics2D.draw(new Line2D.Double(d3, d, d4, d));
                        this.minIcon.paintIcon(null, graphics2D, (int)d3, (int)d);
                        this.maxIcon.paintIcon(null, graphics2D, (int)d4, (int)d);
                    }
                }
            } else {
                this.lastCategory = n2;
                this.min = number.doubleValue();
                this.max = number.doubleValue();
            }
            if (this.plotLines && n2 != 0 && (number2 = categoryDataset.getValue(n, n2 - 1)) != null) {
                double d5 = number2.doubleValue();
                double d6 = categoryAxis.getCategoryMiddle(n2 - 1, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
                double d7 = valueAxis.valueToJava2D(d5, rectangle2D, categoryPlot.getRangeAxisEdge());
                graphics2D.setPaint(this.getItemPaint(n, n2));
                graphics2D.setStroke(this.getItemStroke(n, n2));
                Line2D.Double double_2 = plotOrientation == PlotOrientation.VERTICAL ? new Line2D.Double(d6, d7, d, d2) : new Line2D.Double(d7, d6, d2, d);
                graphics2D.draw(double_2);
            }
            if ((entityCollection = categoryItemRendererState.getEntityCollection()) != null && double_ != null) {
                this.addItemEntity(entityCollection, categoryDataset, n, n2, double_);
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MinMaxCategoryRenderer)) {
            return false;
        }
        MinMaxCategoryRenderer minMaxCategoryRenderer = (MinMaxCategoryRenderer)object;
        if (this.plotLines != minMaxCategoryRenderer.plotLines) {
            return false;
        }
        if (!PaintUtilities.equal(this.groupPaint, minMaxCategoryRenderer.groupPaint)) {
            return false;
        }
        if (!this.groupStroke.equals(minMaxCategoryRenderer.groupStroke)) {
            return false;
        }
        return super.equals(object);
    }

    private Icon getIcon(Shape shape, final Paint paint, final Paint paint2) {
        final int n = shape.getBounds().width;
        final int n2 = shape.getBounds().height;
        final GeneralPath generalPath = new GeneralPath(shape);
        return new Icon(){

            public void paintIcon(Component component, Graphics graphics, int n3, int n22) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                generalPath.transform(AffineTransform.getTranslateInstance(n3, n22));
                if (paint != null) {
                    graphics2D.setPaint(paint);
                    graphics2D.fill(generalPath);
                }
                if (paint2 != null) {
                    graphics2D.setPaint(paint2);
                    graphics2D.draw(generalPath);
                }
                generalPath.transform(AffineTransform.getTranslateInstance(-n3, -n22));
            }

            public int getIconWidth() {
                return n;
            }

            public int getIconHeight() {
                return n2;
            }
        };
    }

    private Icon getIcon(Shape shape, final boolean bl, final boolean bl2) {
        final int n = shape.getBounds().width;
        final int n2 = shape.getBounds().height;
        final GeneralPath generalPath = new GeneralPath(shape);
        return new Icon(){

            public void paintIcon(Component component, Graphics graphics, int n3, int n22) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                generalPath.transform(AffineTransform.getTranslateInstance(n3, n22));
                if (bl) {
                    graphics2D.fill(generalPath);
                }
                if (bl2) {
                    graphics2D.draw(generalPath);
                }
                generalPath.transform(AffineTransform.getTranslateInstance(-n3, -n22));
            }

            public int getIconWidth() {
                return n;
            }

            public int getIconHeight() {
                return n2;
            }
        };
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeStroke(this.groupStroke, objectOutputStream);
        SerialUtilities.writePaint(this.groupPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.groupStroke = SerialUtilities.readStroke(objectInputStream);
        this.groupPaint = SerialUtilities.readPaint(objectInputStream);
        this.minIcon = this.getIcon((Shape)new Arc2D.Double(-4.0, -4.0, 8.0, 8.0, 0.0, 360.0, 0), null, Color.black);
        this.maxIcon = this.getIcon((Shape)new Arc2D.Double(-4.0, -4.0, 8.0, 8.0, 0.0, 360.0, 0), null, Color.black);
        this.objectIcon = this.getIcon((Shape)new Line2D.Double(-4.0, 0.0, 4.0, 0.0), false, true);
    }
}

