/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.category;

import ai.org.jfree.chart.axis.CategoryAxis;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.labels.CategoryItemLabelGenerator;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.renderer.category.BarPainter;
import ai.org.jfree.chart.renderer.category.BarRenderer;
import ai.org.jfree.chart.renderer.category.CategoryItemRendererState;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.data.category.IntervalCategoryDataset;
import ai.org.jfree.ui.RectangleEdge;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class IntervalBarRenderer
extends BarRenderer {
    private static final long serialVersionUID = -5068857361615528725L;

    public Range findRangeBounds(CategoryDataset categoryDataset) {
        return this.findRangeBounds(categoryDataset, true);
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        if (categoryDataset instanceof IntervalCategoryDataset) {
            IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)categoryDataset;
            this.drawInterval(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, intervalCategoryDataset, n, n2);
        } else {
            super.drawItem(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n, n2, n3);
        }
    }

    protected void drawInterval(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, IntervalCategoryDataset intervalCategoryDataset, int n, int n2) {
        EntityCollection entityCollection;
        double d;
        int n3 = categoryItemRendererState.getVisibleSeriesIndex(n);
        if (n3 < 0) {
            return;
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d2 = 0.0;
        double d3 = 0.0;
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        Number number = intervalCategoryDataset.getEndValue(n, n2);
        if (number == null) {
            return;
        }
        double d4 = valueAxis.valueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge);
        Number number2 = intervalCategoryDataset.getStartValue(n, n2);
        if (number2 == null) {
            return;
        }
        double d5 = valueAxis.valueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
        if (d5 < d4) {
            d = d5;
            d5 = d4;
            d4 = d;
        }
        d = categoryItemRendererState.getBarWidth();
        double d6 = Math.abs(d5 - d4);
        RectangleEdge rectangleEdge2 = RectangleEdge.LEFT;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d2 = d4;
            d3 = this.calculateBarW0(this.getPlot(), plotOrientation, rectangle2D, categoryAxis, categoryItemRendererState, n3, n2);
            d6 = categoryItemRendererState.getBarWidth();
            d = Math.abs(d5 - d4);
            rectangleEdge2 = RectangleEdge.LEFT;
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            d2 = this.calculateBarW0(this.getPlot(), plotOrientation, rectangle2D, categoryAxis, categoryItemRendererState, n3, n2);
            d3 = d4;
            rectangleEdge2 = RectangleEdge.BOTTOM;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d3, d, d6);
        BarPainter barPainter = this.getBarPainter();
        if (this.getShadowsVisible()) {
            barPainter.paintBarShadow(graphics2D, this, n, n2, double_, rectangleEdge2, false);
        }
        this.getBarPainter().paintBar(graphics2D, this, n, n2, double_, rectangleEdge2);
        CategoryItemLabelGenerator categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2);
        if (categoryItemLabelGenerator != null && this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, intervalCategoryDataset, n, n2, categoryPlot, categoryItemLabelGenerator, double_, false);
        }
        if ((entityCollection = categoryItemRendererState.getEntityCollection()) != null) {
            this.addItemEntity(entityCollection, intervalCategoryDataset, n, n2, double_);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntervalBarRenderer)) {
            return false;
        }
        return super.equals(object);
    }
}

