/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.category;

import ai.org.jfree.chart.axis.CategoryAxis;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.labels.CategoryItemLabelGenerator;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.renderer.category.CategoryItemRendererState;
import ai.org.jfree.chart.renderer.category.StackedBarRenderer;
import ai.org.jfree.data.KeyToGroupMap;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.data.general.DatasetUtilities;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.util.PublicCloneable;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class GroupedStackedBarRenderer
extends StackedBarRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -2725921399005922939L;
    private KeyToGroupMap seriesToGroupMap = new KeyToGroupMap();

    public void setSeriesToGroupMap(KeyToGroupMap keyToGroupMap) {
        if (keyToGroupMap == null) {
            throw new IllegalArgumentException("Null 'map' argument.");
        }
        this.seriesToGroupMap = keyToGroupMap;
        this.fireChangeEvent();
    }

    public Range findRangeBounds(CategoryDataset categoryDataset) {
        if (categoryDataset == null) {
            return null;
        }
        Range range = DatasetUtilities.findStackedRangeBounds(categoryDataset, this.seriesToGroupMap);
        return range;
    }

    protected void calculateBarWidth(CategoryPlot categoryPlot, Rectangle2D rectangle2D, int n, CategoryItemRendererState categoryItemRendererState) {
        CategoryAxis categoryAxis = categoryPlot.getDomainAxisForDataset(n);
        CategoryDataset categoryDataset = categoryPlot.getDataset(n);
        if (categoryDataset != null) {
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            double d = 0.0;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d = rectangle2D.getHeight();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                d = rectangle2D.getWidth();
            }
            double d2 = d * this.getMaximumBarWidth();
            int n2 = this.seriesToGroupMap.getGroupCount();
            int n3 = categoryDataset.getColumnCount();
            int n4 = n2 * n3;
            double d3 = 0.0;
            double d4 = 0.0;
            if (n3 > 1) {
                d3 = categoryAxis.getCategoryMargin();
            }
            if (n2 > 1) {
                d4 = this.getItemMargin();
            }
            double d5 = d * (1.0 - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin() - d3 - d4);
            if (n4 > 0) {
                categoryItemRendererState.setBarWidth(Math.min(d5 / (double)n4, d2));
            } else {
                categoryItemRendererState.setBarWidth(Math.min(d5, d2));
            }
        }
    }

    protected double calculateBarW0(CategoryPlot categoryPlot, PlotOrientation plotOrientation, Rectangle2D rectangle2D, CategoryAxis categoryAxis, CategoryItemRendererState categoryItemRendererState, int n, int n2) {
        double d = 0.0;
        d = plotOrientation == PlotOrientation.HORIZONTAL ? rectangle2D.getHeight() : rectangle2D.getWidth();
        double d2 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        int n3 = this.seriesToGroupMap.getGroupCount();
        int n4 = this.seriesToGroupMap.getGroupIndex(this.seriesToGroupMap.getGroup(categoryPlot.getDataset(categoryPlot.getIndexOf(this)).getRowKey(n)));
        int n5 = this.getColumnCount();
        if (n3 > 1) {
            double d3 = d * this.getItemMargin() / (double)(n5 * (n3 - 1));
            double d4 = this.calculateSeriesWidth(d, categoryAxis, n5, n3);
            d2 = d2 + (double)n4 * (d4 + d3) + d4 / 2.0 - categoryItemRendererState.getBarWidth() / 2.0;
        } else {
            d2 = categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge()) - categoryItemRendererState.getBarWidth() / 2.0;
        }
        return d2;
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        EntityCollection entityCollection;
        double d;
        double d2;
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return;
        }
        double d3 = number.doubleValue();
        Comparable comparable = this.seriesToGroupMap.getGroup(categoryDataset.getRowKey(n));
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d4 = this.calculateBarW0(categoryPlot, plotOrientation, rectangle2D, categoryAxis, categoryItemRendererState, n, n2);
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = 0; i < n; ++i) {
            Number number2;
            if (!comparable.equals(this.seriesToGroupMap.getGroup(categoryDataset.getRowKey(i))) || (number2 = categoryDataset.getValue(i, n2)) == null) continue;
            d2 = number2.doubleValue();
            if (d2 > 0.0) {
                d5 += d2;
                continue;
            }
            d6 += d2;
        }
        boolean bl = d3 > 0.0;
        boolean bl2 = valueAxis.isInverted();
        RectangleEdge rectangleEdge = plotOrientation == PlotOrientation.HORIZONTAL ? (bl && bl2 || !bl && !bl2 ? RectangleEdge.RIGHT : RectangleEdge.LEFT) : (bl && !bl2 || !bl && bl2 ? RectangleEdge.BOTTOM : RectangleEdge.TOP);
        RectangleEdge rectangleEdge2 = categoryPlot.getRangeAxisEdge();
        if (d3 > 0.0) {
            d = valueAxis.valueToJava2D(d5, rectangle2D, rectangleEdge2);
            d2 = valueAxis.valueToJava2D(d5 + d3, rectangle2D, rectangleEdge2);
        } else {
            d = valueAxis.valueToJava2D(d6, rectangle2D, rectangleEdge2);
            d2 = valueAxis.valueToJava2D(d6 + d3, rectangle2D, rectangleEdge2);
        }
        double d7 = Math.min(d, d2);
        double d8 = Math.max(Math.abs(d2 - d), this.getMinimumBarLength());
        Rectangle2D.Double double_ = null;
        double_ = plotOrientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(d7, d4, d8, categoryItemRendererState.getBarWidth()) : new Rectangle2D.Double(d4, d7, categoryItemRendererState.getBarWidth(), d8);
        this.getBarPainter().paintBar(graphics2D, this, n, n2, double_, rectangleEdge);
        CategoryItemLabelGenerator categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2);
        if (categoryItemLabelGenerator != null && this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, categoryDataset, n, n2, categoryPlot, categoryItemLabelGenerator, double_, d3 < 0.0);
        }
        if (categoryItemRendererState.getInfo() != null && (entityCollection = categoryItemRendererState.getEntityCollection()) != null) {
            this.addItemEntity(entityCollection, categoryDataset, n, n2, double_);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GroupedStackedBarRenderer)) {
            return false;
        }
        GroupedStackedBarRenderer groupedStackedBarRenderer = (GroupedStackedBarRenderer)object;
        if (!this.seriesToGroupMap.equals(groupedStackedBarRenderer.seriesToGroupMap)) {
            return false;
        }
        return super.equals(object);
    }
}

