/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.category;

import ai.org.jfree.chart.axis.CategoryAxis;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.labels.CategoryItemLabelGenerator;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.renderer.category.CategoryItemRendererState;
import ai.org.jfree.chart.renderer.category.IntervalBarRenderer;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.data.gantt.GanttCategoryDataset;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.util.PaintUtilities;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class GanttRenderer
extends IntervalBarRenderer
implements Serializable {
    private static final long serialVersionUID = -4010349116350119512L;
    private transient Paint completePaint;
    private transient Paint incompletePaint;
    private double startPercent;
    private double endPercent;

    public GanttRenderer() {
        this.setIncludeBaseInRange(false);
        this.completePaint = Color.green;
        this.incompletePaint = Color.red;
        this.startPercent = 0.35;
        this.endPercent = 0.65;
    }

    public Paint getCompletePaint() {
        return this.completePaint;
    }

    public void setCompletePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.completePaint = paint;
        this.fireChangeEvent();
    }

    public Paint getIncompletePaint() {
        return this.incompletePaint;
    }

    public void setIncompletePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.incompletePaint = paint;
        this.fireChangeEvent();
    }

    public double getStartPercent() {
        return this.startPercent;
    }

    public void setStartPercent(double d) {
        this.startPercent = d;
        this.fireChangeEvent();
    }

    public double getEndPercent() {
        return this.endPercent;
    }

    public void setEndPercent(double d) {
        this.endPercent = d;
        this.fireChangeEvent();
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        if (categoryDataset instanceof GanttCategoryDataset) {
            GanttCategoryDataset ganttCategoryDataset = (GanttCategoryDataset)categoryDataset;
            this.drawTasks(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, ganttCategoryDataset, n, n2);
        } else {
            super.drawItem(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n, n2, n3);
        }
    }

    protected void drawTasks(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, GanttCategoryDataset ganttCategoryDataset, int n, int n2) {
        int n3 = ganttCategoryDataset.getSubIntervalCount(n, n2);
        if (n3 == 0) {
            this.drawTask(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, ganttCategoryDataset, n, n2);
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        for (int i = 0; i < n3; ++i) {
            EntityCollection entityCollection;
            double d;
            RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
            Number number = ganttCategoryDataset.getStartValue(n, n2, i);
            if (number == null) {
                return;
            }
            double d2 = valueAxis.valueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge);
            Number number2 = ganttCategoryDataset.getEndValue(n, n2, i);
            if (number2 == null) {
                return;
            }
            double d3 = valueAxis.valueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
            if (d3 < d2) {
                d = d3;
                d3 = d2;
                d2 = d;
            }
            d = this.calculateBarW0(categoryPlot, categoryPlot.getOrientation(), rectangle2D, categoryAxis, categoryItemRendererState, n, n2);
            double d4 = Math.abs(d3 - d2);
            double d5 = categoryItemRendererState.getBarWidth();
            Rectangle2D.Double double_ = null;
            RectangleEdge rectangleEdge2 = null;
            if (categoryPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                double_ = new Rectangle2D.Double(d2, d, d4, d5);
                rectangleEdge2 = RectangleEdge.LEFT;
            } else if (categoryPlot.getOrientation() == PlotOrientation.VERTICAL) {
                double_ = new Rectangle2D.Double(d, d2, d5, d4);
                rectangleEdge2 = RectangleEdge.BOTTOM;
            }
            Rectangle2D.Double double_2 = null;
            Rectangle2D.Double double_3 = null;
            Number number3 = ganttCategoryDataset.getPercentComplete(n, n2, i);
            double d6 = this.getStartPercent();
            double d7 = this.getEndPercent();
            if (number3 != null) {
                double d8 = number3.doubleValue();
                if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    double_2 = new Rectangle2D.Double(d2, d + d6 * d5, d4 * d8, d5 * (d7 - d6));
                    double_3 = new Rectangle2D.Double(d2 + d4 * d8, d + d6 * d5, d4 * (1.0 - d8), d5 * (d7 - d6));
                } else if (plotOrientation == PlotOrientation.VERTICAL) {
                    double_2 = new Rectangle2D.Double(d + d6 * d5, d2 + d4 * (1.0 - d8), d5 * (d7 - d6), d4 * d8);
                    double_3 = new Rectangle2D.Double(d + d6 * d5, d2, d5 * (d7 - d6), d4 * (1.0 - d8));
                }
            }
            if (this.getShadowsVisible()) {
                this.getBarPainter().paintBarShadow(graphics2D, this, n, n2, double_, rectangleEdge2, true);
            }
            this.getBarPainter().paintBar(graphics2D, this, n, n2, double_, rectangleEdge2);
            if (double_2 != null) {
                graphics2D.setPaint(this.getCompletePaint());
                graphics2D.fill(double_2);
            }
            if (double_3 != null) {
                graphics2D.setPaint(this.getIncompletePaint());
                graphics2D.fill(double_3);
            }
            if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
                graphics2D.setStroke(this.getItemStroke(n, n2));
                graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
                graphics2D.draw(double_);
            }
            if (i == n3 - 1) {
                int n4 = categoryPlot.indexOf(ganttCategoryDataset);
                Comparable comparable = ganttCategoryDataset.getColumnKey(n2);
                Comparable comparable2 = ganttCategoryDataset.getRowKey(n);
                double d9 = categoryAxis.getCategorySeriesMiddle(comparable, comparable2, ganttCategoryDataset, this.getItemMargin(), rectangle2D, categoryPlot.getDomainAxisEdge());
                this.updateCrosshairValues(categoryItemRendererState.getCrosshairState(), ganttCategoryDataset.getRowKey(n), ganttCategoryDataset.getColumnKey(n2), number2.doubleValue(), n4, d9, d3, plotOrientation);
            }
            if (categoryItemRendererState.getInfo() == null || (entityCollection = categoryItemRendererState.getEntityCollection()) == null) continue;
            this.addItemEntity(entityCollection, ganttCategoryDataset, n, n2, double_);
        }
    }

    protected void drawTask(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, GanttCategoryDataset ganttCategoryDataset, int n, int n2) {
        CategoryItemLabelGenerator categoryItemLabelGenerator;
        double d;
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        Number number = ganttCategoryDataset.getEndValue(n, n2);
        if (number == null) {
            return;
        }
        double d2 = valueAxis.valueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge);
        Number number2 = ganttCategoryDataset.getStartValue(n, n2);
        if (number2 == null) {
            return;
        }
        double d3 = valueAxis.valueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
        if (d3 < d2) {
            d = d3;
            d3 = d2;
            d2 = d;
            number2 = number;
        }
        d = this.calculateBarW0(categoryPlot, plotOrientation, rectangle2D, categoryAxis, categoryItemRendererState, n, n2);
        double d4 = categoryItemRendererState.getBarWidth();
        double d5 = Math.abs(d3 - d2);
        Rectangle2D.Double double_ = null;
        RectangleEdge rectangleEdge2 = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Rectangle2D.Double(d2, d, d5, d4);
            rectangleEdge2 = RectangleEdge.LEFT;
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Rectangle2D.Double(d, d3, d4, d5);
            rectangleEdge2 = RectangleEdge.BOTTOM;
        }
        Rectangle2D.Double double_2 = null;
        Rectangle2D.Double double_3 = null;
        Number number3 = ganttCategoryDataset.getPercentComplete(n, n2);
        double d6 = this.getStartPercent();
        double d7 = this.getEndPercent();
        if (number3 != null) {
            double d8 = number3.doubleValue();
            if (categoryPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                double_2 = new Rectangle2D.Double(d2, d + d6 * d4, d5 * d8, d4 * (d7 - d6));
                double_3 = new Rectangle2D.Double(d2 + d5 * d8, d + d6 * d4, d5 * (1.0 - d8), d4 * (d7 - d6));
            } else if (categoryPlot.getOrientation() == PlotOrientation.VERTICAL) {
                double_2 = new Rectangle2D.Double(d + d6 * d4, d3 + d5 * (1.0 - d8), d4 * (d7 - d6), d5 * d8);
                double_3 = new Rectangle2D.Double(d + d6 * d4, d3, d4 * (d7 - d6), d5 * (1.0 - d8));
            }
        }
        if (this.getShadowsVisible()) {
            this.getBarPainter().paintBarShadow(graphics2D, this, n, n2, double_, rectangleEdge2, true);
        }
        this.getBarPainter().paintBar(graphics2D, this, n, n2, double_, rectangleEdge2);
        if (double_2 != null) {
            graphics2D.setPaint(this.getCompletePaint());
            graphics2D.fill(double_2);
        }
        if (double_3 != null) {
            graphics2D.setPaint(this.getIncompletePaint());
            graphics2D.fill(double_3);
        }
        if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
            Stroke stroke = this.getItemOutlineStroke(n, n2);
            Paint paint = this.getItemOutlinePaint(n, n2);
            if (stroke != null && paint != null) {
                graphics2D.setStroke(stroke);
                graphics2D.setPaint(paint);
                graphics2D.draw(double_);
            }
        }
        if ((categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2)) != null && this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, ganttCategoryDataset, n, n2, categoryPlot, categoryItemLabelGenerator, double_, false);
        }
        int n3 = categoryPlot.indexOf(ganttCategoryDataset);
        Comparable comparable = ganttCategoryDataset.getColumnKey(n2);
        Comparable comparable2 = ganttCategoryDataset.getRowKey(n);
        double d9 = categoryAxis.getCategorySeriesMiddle(comparable, comparable2, ganttCategoryDataset, this.getItemMargin(), rectangle2D, categoryPlot.getDomainAxisEdge());
        this.updateCrosshairValues(categoryItemRendererState.getCrosshairState(), ganttCategoryDataset.getRowKey(n), ganttCategoryDataset.getColumnKey(n2), number2.doubleValue(), n3, d9, d3, plotOrientation);
        EntityCollection entityCollection = categoryItemRendererState.getEntityCollection();
        if (entityCollection != null) {
            this.addItemEntity(entityCollection, ganttCategoryDataset, n, n2, double_);
        }
    }

    public double getItemMiddle(Comparable comparable, Comparable comparable2, CategoryDataset categoryDataset, CategoryAxis categoryAxis, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        return categoryAxis.getCategorySeriesMiddle(comparable2, comparable, categoryDataset, this.getItemMargin(), rectangle2D, rectangleEdge);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GanttRenderer)) {
            return false;
        }
        GanttRenderer ganttRenderer = (GanttRenderer)object;
        if (!PaintUtilities.equal(this.completePaint, ganttRenderer.completePaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.incompletePaint, ganttRenderer.incompletePaint)) {
            return false;
        }
        if (this.startPercent != ganttRenderer.startPercent) {
            return false;
        }
        if (this.endPercent != ganttRenderer.endPercent) {
            return false;
        }
        return super.equals(object);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.completePaint, objectOutputStream);
        SerialUtilities.writePaint(this.incompletePaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.completePaint = SerialUtilities.readPaint(objectInputStream);
        this.incompletePaint = SerialUtilities.readPaint(objectInputStream);
    }
}

