/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer.category;

import ai.org.jfree.chart.LegendItem;
import ai.org.jfree.chart.axis.CategoryAxis;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import ai.org.jfree.chart.renderer.category.CategoryItemRendererState;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.util.PublicCloneable;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class CategoryStepRenderer
extends AbstractCategoryItemRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -5121079703118261470L;
    public static final int STAGGER_WIDTH = 5;
    private boolean stagger = false;

    public CategoryStepRenderer() {
        this(false);
    }

    public CategoryStepRenderer(boolean bl) {
        this.stagger = bl;
        this.setBaseLegendShape(new Rectangle2D.Double(-4.0, -3.0, 8.0, 6.0));
    }

    public boolean getStagger() {
        return this.stagger;
    }

    public void setStagger(boolean bl) {
        this.stagger = bl;
        this.fireChangeEvent();
    }

    public LegendItem getLegendItem(int n, int n2) {
        String string;
        CategoryPlot categoryPlot = this.getPlot();
        if (categoryPlot == null) {
            return null;
        }
        if (!this.isSeriesVisible(n2) || !this.isSeriesVisibleInLegend(n2)) {
            return null;
        }
        CategoryDataset categoryDataset = categoryPlot.getDataset(n);
        String string2 = string = this.getLegendItemLabelGenerator().generateLabel(categoryDataset, n2);
        String string3 = null;
        if (this.getLegendItemToolTipGenerator() != null) {
            string3 = this.getLegendItemToolTipGenerator().generateLabel(categoryDataset, n2);
        }
        String string4 = null;
        if (this.getLegendItemURLGenerator() != null) {
            string4 = this.getLegendItemURLGenerator().generateLabel(categoryDataset, n2);
        }
        Shape shape = this.lookupLegendShape(n2);
        Paint paint = this.lookupSeriesPaint(n2);
        LegendItem legendItem = new LegendItem(string, string2, string3, string4, shape, paint);
        legendItem.setLabelFont(this.lookupLegendTextFont(n2));
        Paint paint2 = this.lookupLegendTextPaint(n2);
        if (paint2 != null) {
            legendItem.setLabelPaint(paint2);
        }
        legendItem.setSeriesKey(categoryDataset.getRowKey(n2));
        legendItem.setSeriesIndex(n2);
        legendItem.setDataset(categoryDataset);
        legendItem.setDatasetIndex(n);
        return legendItem;
    }

    protected CategoryItemRendererState createState(PlotRenderingInfo plotRenderingInfo) {
        return new State(plotRenderingInfo);
    }

    protected void drawLine(Graphics2D graphics2D, State state, PlotOrientation plotOrientation, double d, double d2, double d3, double d4) {
        if (plotOrientation == PlotOrientation.VERTICAL) {
            state.line.setLine(d, d2, d3, d4);
            graphics2D.draw(state.line);
        } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
            state.line.setLine(d2, d, d4, d3);
            graphics2D.draw(state.line);
        }
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        Object object;
        if (!this.getItemVisible(n, n2)) {
            return;
        }
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return;
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d2 = categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d3 = 2.0 * d2 - d;
        double d4 = valueAxis.valueToJava2D(number.doubleValue(), rectangle2D, categoryPlot.getRangeAxisEdge());
        graphics2D.setPaint(this.getItemPaint(n, n2));
        graphics2D.setStroke(this.getItemStroke(n, n2));
        if (n2 != 0 && (object = categoryDataset.getValue(n, n2 - 1)) != null) {
            double d5 = ((Number)object).doubleValue();
            double d6 = categoryAxis.getCategoryStart(n2 - 1, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
            double d7 = categoryAxis.getCategoryMiddle(n2 - 1, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
            double d8 = 2.0 * d7 - d6;
            double d9 = valueAxis.valueToJava2D(d5, rectangle2D, categoryPlot.getRangeAxisEdge());
            if (this.getStagger()) {
                int n4 = n * 5;
                if ((double)n4 > d - d8) {
                    n4 = (int)(d - d8);
                }
                d = d8 + (double)n4;
            }
            this.drawLine(graphics2D, (State)categoryItemRendererState, plotOrientation, d8, d9, d, d9);
            this.drawLine(graphics2D, (State)categoryItemRendererState, plotOrientation, d, d9, d, d4);
        }
        this.drawLine(graphics2D, (State)categoryItemRendererState, plotOrientation, d, d4, d3, d4);
        if (this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, plotOrientation, categoryDataset, n, n2, d2, d4, number.doubleValue() < 0.0);
        }
        if ((object = categoryItemRendererState.getEntityCollection()) != null) {
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            if (plotOrientation == PlotOrientation.VERTICAL) {
                ((Rectangle2D)double_).setRect(d, d4, d3 - d, 4.0);
            } else {
                ((Rectangle2D)double_).setRect(d4 - 2.0, d, 4.0, d3 - d);
            }
            this.addItemEntity((EntityCollection)object, categoryDataset, n, n2, double_);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CategoryStepRenderer)) {
            return false;
        }
        CategoryStepRenderer categoryStepRenderer = (CategoryStepRenderer)object;
        if (this.stagger != categoryStepRenderer.stagger) {
            return false;
        }
        return super.equals(object);
    }

    protected static class State
    extends CategoryItemRendererState {
        public Line2D line = new Line2D.Double();

        public State(PlotRenderingInfo plotRenderingInfo) {
            super(plotRenderingInfo);
        }
    }
}

