/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer;

import ai.org.jfree.chart.renderer.PaintScale;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.util.PaintUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LookupPaintScale
implements PaintScale,
PublicCloneable,
Serializable {
    static final long serialVersionUID = -5239384246251042006L;
    private double lowerBound;
    private double upperBound;
    private transient Paint defaultPaint;
    private List lookupTable;

    public LookupPaintScale() {
        this(0.0, 1.0, Color.lightGray);
    }

    public LookupPaintScale(double d, double d2, Paint paint) {
        if (d >= d2) {
            throw new IllegalArgumentException("Requires lowerBound < upperBound.");
        }
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.lowerBound = d;
        this.upperBound = d2;
        this.defaultPaint = paint;
        this.lookupTable = new ArrayList();
    }

    public Paint getDefaultPaint() {
        return this.defaultPaint;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void add(Number number, Paint paint) {
        this.add(number.doubleValue(), paint);
    }

    public void add(double d, Paint paint) {
        PaintItem paintItem = new PaintItem(d, paint);
        int n = Collections.binarySearch(this.lookupTable, paintItem);
        if (n >= 0) {
            this.lookupTable.set(n, paintItem);
        } else {
            this.lookupTable.add(-(n + 1), paintItem);
        }
    }

    public Paint getPaint(double d) {
        if (d < this.lowerBound) {
            return this.defaultPaint;
        }
        if (d > this.upperBound) {
            return this.defaultPaint;
        }
        int n = this.lookupTable.size();
        if (n == 0) {
            return this.defaultPaint;
        }
        PaintItem paintItem = (PaintItem)this.lookupTable.get(0);
        if (d < paintItem.value) {
            return this.defaultPaint;
        }
        int n2 = 0;
        int n3 = this.lookupTable.size() - 1;
        while (n3 - n2 > 1) {
            int n4 = (n2 + n3) / 2;
            paintItem = (PaintItem)this.lookupTable.get(n4);
            if (d >= paintItem.value) {
                n2 = n4;
                continue;
            }
            n3 = n4;
        }
        if (n3 > n2) {
            paintItem = (PaintItem)this.lookupTable.get(n3);
            if (d < paintItem.value) {
                paintItem = (PaintItem)this.lookupTable.get(n2);
            }
        }
        return paintItem != null ? paintItem.paint : this.defaultPaint;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LookupPaintScale)) {
            return false;
        }
        LookupPaintScale lookupPaintScale = (LookupPaintScale)object;
        if (this.lowerBound != lookupPaintScale.lowerBound) {
            return false;
        }
        if (this.upperBound != lookupPaintScale.upperBound) {
            return false;
        }
        if (!PaintUtilities.equal(this.defaultPaint, lookupPaintScale.defaultPaint)) {
            return false;
        }
        return this.lookupTable.equals(lookupPaintScale.lookupTable);
    }

    public Object clone() throws CloneNotSupportedException {
        LookupPaintScale lookupPaintScale = (LookupPaintScale)super.clone();
        lookupPaintScale.lookupTable = new ArrayList(this.lookupTable);
        return lookupPaintScale;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.defaultPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.defaultPaint = SerialUtilities.readPaint(objectInputStream);
    }

    static class PaintItem
    implements Comparable,
    Serializable {
        static final long serialVersionUID = 698920578512361570L;
        double value;
        transient Paint paint;

        public PaintItem(double d, Paint paint) {
            this.value = d;
            this.paint = paint;
        }

        public int compareTo(Object object) {
            PaintItem paintItem = (PaintItem)object;
            double d = this.value;
            double d2 = paintItem.value;
            if (d > d2) {
                return 1;
            }
            if (d < d2) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof PaintItem)) {
                return false;
            }
            PaintItem paintItem = (PaintItem)object;
            if (this.value != paintItem.value) {
                return false;
            }
            return PaintUtilities.equal(this.paint, paintItem.paint);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            SerialUtilities.writePaint(this.paint, objectOutputStream);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.paint = SerialUtilities.readPaint(objectInputStream);
        }
    }
}

