/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer;

import ai.org.jfree.chart.HashUtilities;
import ai.org.jfree.chart.renderer.PaintScale;
import ai.org.jfree.util.PublicCloneable;
import java.awt.Color;
import java.awt.Paint;
import java.io.Serializable;

public class GrayPaintScale
implements PaintScale,
PublicCloneable,
Serializable {
    private double lowerBound;
    private double upperBound;
    private int alpha;

    public GrayPaintScale() {
        this(0.0, 1.0);
    }

    public GrayPaintScale(double d, double d2) {
        this(d, d2, 255);
    }

    public GrayPaintScale(double d, double d2, int n) {
        if (d >= d2) {
            throw new IllegalArgumentException("Requires lowerBound < upperBound.");
        }
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("Requires alpha in the range 0 to 255.");
        }
        this.lowerBound = d;
        this.upperBound = d2;
        this.alpha = n;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public Paint getPaint(double d) {
        double d2 = Math.max(d, this.lowerBound);
        d2 = Math.min(d2, this.upperBound);
        int n = (int)((d2 - this.lowerBound) / (this.upperBound - this.lowerBound) * 255.0);
        return new Color(n, n, n, this.alpha);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GrayPaintScale)) {
            return false;
        }
        GrayPaintScale grayPaintScale = (GrayPaintScale)object;
        if (this.lowerBound != grayPaintScale.lowerBound) {
            return false;
        }
        if (this.upperBound != grayPaintScale.upperBound) {
            return false;
        }
        return this.alpha == grayPaintScale.alpha;
    }

    public int hashCode() {
        int n = 7;
        n = HashUtilities.hashCode(n, this.lowerBound);
        n = HashUtilities.hashCode(n, this.upperBound);
        n = 43 * n + this.alpha;
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

