/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.renderer;

import ai.org.jfree.chart.LegendItem;
import ai.org.jfree.chart.axis.NumberTick;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.entity.XYItemEntity;
import ai.org.jfree.chart.labels.XYSeriesLabelGenerator;
import ai.org.jfree.chart.labels.XYToolTipGenerator;
import ai.org.jfree.chart.plot.DrawingSupplier;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.PolarPlot;
import ai.org.jfree.chart.renderer.AbstractRenderer;
import ai.org.jfree.chart.renderer.PolarItemRenderer;
import ai.org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import ai.org.jfree.chart.urls.XYURLGenerator;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.text.TextUtilities;
import ai.org.jfree.util.BooleanList;
import ai.org.jfree.util.BooleanUtilities;
import ai.org.jfree.util.ObjectList;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PublicCloneable;
import ai.org.jfree.util.ShapeUtilities;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;

public class DefaultPolarItemRenderer
extends AbstractRenderer
implements PolarItemRenderer {
    private PolarPlot plot;
    private BooleanList seriesFilled = new BooleanList();
    private boolean drawOutlineWhenFilled = true;
    private transient Composite fillComposite = AlphaComposite.getInstance(3, 0.3f);
    private boolean useFillPaint = false;
    private transient Shape legendLine = new Line2D.Double(-7.0, 0.0, 7.0, 0.0);
    private boolean shapesVisible = true;
    private boolean connectFirstAndLastPoint = true;
    private ObjectList toolTipGeneratorList = new ObjectList();
    private XYToolTipGenerator baseToolTipGenerator;
    private XYURLGenerator urlGenerator = null;
    private XYSeriesLabelGenerator legendItemToolTipGenerator = null;
    private XYSeriesLabelGenerator legendItemURLGenerator = null;

    public void setPlot(PolarPlot polarPlot) {
        this.plot = polarPlot;
    }

    public PolarPlot getPlot() {
        return this.plot;
    }

    public boolean getDrawOutlineWhenFilled() {
        return this.drawOutlineWhenFilled;
    }

    public void setDrawOutlineWhenFilled(boolean bl) {
        this.drawOutlineWhenFilled = bl;
        this.fireChangeEvent();
    }

    public Composite getFillComposite() {
        return this.fillComposite;
    }

    public void setFillComposite(Composite composite) {
        if (composite == null) {
            throw new IllegalArgumentException("Null 'composite' argument.");
        }
        this.fillComposite = composite;
        this.fireChangeEvent();
    }

    public boolean getShapesVisible() {
        return this.shapesVisible;
    }

    public void setShapesVisible(boolean bl) {
        this.shapesVisible = bl;
        this.fireChangeEvent();
    }

    public boolean getConnectFirstAndLastPoint() {
        return this.connectFirstAndLastPoint;
    }

    public void setConnectFirstAndLastPoint(boolean bl) {
        this.connectFirstAndLastPoint = bl;
        this.fireChangeEvent();
    }

    public DrawingSupplier getDrawingSupplier() {
        DrawingSupplier drawingSupplier = null;
        PolarPlot polarPlot = this.getPlot();
        if (polarPlot != null) {
            drawingSupplier = polarPlot.getDrawingSupplier();
        }
        return drawingSupplier;
    }

    public boolean isSeriesFilled(int n) {
        boolean bl = false;
        Boolean bl2 = this.seriesFilled.getBoolean(n);
        if (bl2 != null) {
            bl = bl2;
        }
        return bl;
    }

    public void setSeriesFilled(int n, boolean bl) {
        this.seriesFilled.setBoolean(n, BooleanUtilities.valueOf(bl));
    }

    public boolean getUseFillPaint() {
        return this.useFillPaint;
    }

    public void setUseFillPaint(boolean bl) {
        this.useFillPaint = bl;
        this.fireChangeEvent();
    }

    public Shape getLegendLine() {
        return this.legendLine;
    }

    public void setLegendLine(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'line' argument.");
        }
        this.legendLine = shape;
        this.fireChangeEvent();
    }

    protected void addEntity(EntityCollection entityCollection, Shape shape, XYDataset xYDataset, int n, int n2, double d, double d2) {
        if (!this.getItemCreateEntity(n, n2)) {
            return;
        }
        Shape shape2 = shape;
        if (shape2 == null) {
            double d3 = this.getDefaultEntityRadius();
            double d4 = d3 * 2.0;
            shape2 = this.getPlot().getOrientation() == PlotOrientation.VERTICAL ? new Ellipse2D.Double(d - d3, d2 - d3, d4, d4) : new Ellipse2D.Double(d2 - d3, d - d3, d4, d4);
        }
        String string = null;
        XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n, n2);
        if (xYToolTipGenerator != null) {
            string = xYToolTipGenerator.generateToolTip(xYDataset, n, n2);
        }
        String string2 = null;
        if (this.getURLGenerator() != null) {
            string2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
        }
        XYItemEntity xYItemEntity = new XYItemEntity(shape2, xYDataset, n, n2, string, string2);
        entityCollection.add(xYItemEntity);
    }

    public void drawSeries(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, PolarPlot polarPlot, XYDataset xYDataset, int n) {
        Path2D path2D = null;
        ValueAxis valueAxis = polarPlot.getAxisForDataset(polarPlot.indexOf(xYDataset));
        int n2 = xYDataset.getItemCount(n);
        for (int i = 0; i < n2; ++i) {
            double d = xYDataset.getXValue(n, i);
            double d2 = xYDataset.getYValue(n, i);
            Point point = polarPlot.translateToJava2D(d, d2, valueAxis, rectangle2D);
            if (path2D == null) {
                path2D = new GeneralPath();
                ((Path2D.Float)path2D).moveTo(point.x, point.y);
                continue;
            }
            ((Path2D.Float)path2D).lineTo(point.x, point.y);
        }
        if (this.getConnectFirstAndLastPoint()) {
            path2D.closePath();
        }
        graphics2D.setPaint(this.lookupSeriesPaint(n));
        graphics2D.setStroke(this.lookupSeriesStroke(n));
        if (this.isSeriesFilled(n)) {
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(this.fillComposite);
            graphics2D.fill(path2D);
            graphics2D.setComposite(composite);
            if (this.drawOutlineWhenFilled) {
                graphics2D.setPaint(this.lookupSeriesOutlinePaint(n));
                graphics2D.draw(path2D);
            }
        } else {
            graphics2D.draw(path2D);
        }
        if (this.shapesVisible) {
            EntityCollection entityCollection = null;
            if (plotRenderingInfo != null) {
                entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
            }
            PathIterator pathIterator = ((Path2D.Float)path2D).getPathIterator(null);
            int n3 = 0;
            while (!pathIterator.isDone()) {
                float[] fArray = new float[6];
                int n4 = pathIterator.currentSegment(fArray);
                pathIterator.next();
                if (n4 != 1 && n4 != 0) continue;
                int n5 = Math.round(fArray[0]);
                int n6 = Math.round(fArray[1]);
                Shape shape = ShapeUtilities.createTranslatedShape(this.getItemShape(n, n3++), n5, n6);
                Paint paint = this.useFillPaint ? this.lookupSeriesFillPaint(n) : this.lookupSeriesPaint(n);
                graphics2D.setPaint(paint);
                graphics2D.fill(shape);
                if (this.isSeriesFilled(n) && this.drawOutlineWhenFilled) {
                    graphics2D.setPaint(this.lookupSeriesOutlinePaint(n));
                    graphics2D.setStroke(this.lookupSeriesOutlineStroke(n));
                    graphics2D.draw(shape);
                }
                if (entityCollection == null || !AbstractXYItemRenderer.isPointInRect(rectangle2D, n5, n6)) continue;
                this.addEntity(entityCollection, shape, xYDataset, n, n3 - 1, n5, n6);
            }
        }
    }

    public void drawAngularGridLines(Graphics2D graphics2D, PolarPlot polarPlot, List list, Rectangle2D rectangle2D) {
        graphics2D.setFont(polarPlot.getAngleLabelFont());
        graphics2D.setStroke(polarPlot.getAngleGridlineStroke());
        graphics2D.setPaint(polarPlot.getAngleGridlinePaint());
        double d = polarPlot.getAxis().getLowerBound();
        double d2 = polarPlot.getAxis().getUpperBound();
        Point point = polarPlot.translateValueThetaRadiusToJava2D(d, d, rectangle2D);
        for (NumberTick numberTick : list) {
            double d3 = numberTick.getNumber().doubleValue();
            Point point2 = polarPlot.translateValueThetaRadiusToJava2D(d3, d2, rectangle2D);
            graphics2D.setPaint(polarPlot.getAngleGridlinePaint());
            graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
            if (!polarPlot.isAngleLabelsVisible()) continue;
            int n = point2.x;
            int n2 = point2.y;
            graphics2D.setPaint(polarPlot.getAngleLabelPaint());
            TextUtilities.drawAlignedString(numberTick.getText(), graphics2D, n, n2, numberTick.getTextAnchor());
        }
    }

    public void drawRadialGridLines(Graphics2D graphics2D, PolarPlot polarPlot, ValueAxis valueAxis, List list, Rectangle2D rectangle2D) {
        graphics2D.setFont(valueAxis.getTickLabelFont());
        graphics2D.setPaint(polarPlot.getRadiusGridlinePaint());
        graphics2D.setStroke(polarPlot.getRadiusGridlineStroke());
        double d = valueAxis.getLowerBound();
        Point point = polarPlot.translateValueThetaRadiusToJava2D(d, d, rectangle2D);
        for (NumberTick numberTick : list) {
            double d2 = polarPlot.isCounterClockwise() ? polarPlot.getAngleOffset() : -polarPlot.getAngleOffset();
            Point point2 = polarPlot.translateValueThetaRadiusToJava2D(d2, numberTick.getNumber().doubleValue(), rectangle2D);
            int n = point2.x - point.x;
            int n2 = point.x - n;
            int n3 = point.y - n;
            int n4 = 2 * n;
            Ellipse2D.Double double_ = new Ellipse2D.Double(n2, n3, n4, n4);
            graphics2D.setPaint(polarPlot.getRadiusGridlinePaint());
            graphics2D.draw(double_);
        }
    }

    public LegendItem getLegendItem(int n) {
        String string;
        LegendItem legendItem = null;
        PolarPlot polarPlot = this.getPlot();
        if (polarPlot == null) {
            return null;
        }
        XYDataset xYDataset = polarPlot.getDataset(polarPlot.getIndexOf(this));
        if (xYDataset == null) {
            return null;
        }
        String string2 = null;
        if (this.getLegendItemToolTipGenerator() != null) {
            string2 = this.getLegendItemToolTipGenerator().generateLabel(xYDataset, n);
        }
        String string3 = null;
        if (this.getLegendItemURLGenerator() != null) {
            string3 = this.getLegendItemURLGenerator().generateLabel(xYDataset, n);
        }
        String string4 = string = xYDataset.getSeriesKey(n).toString();
        Shape shape = this.lookupSeriesShape(n);
        Paint paint = this.useFillPaint ? this.lookupSeriesFillPaint(n) : this.lookupSeriesPaint(n);
        Stroke stroke = this.lookupSeriesStroke(n);
        Paint paint2 = this.lookupSeriesOutlinePaint(n);
        Stroke stroke2 = this.lookupSeriesOutlineStroke(n);
        boolean bl = this.isSeriesFilled(n) && this.drawOutlineWhenFilled;
        legendItem = new LegendItem(string, string4, string2, string3, this.getShapesVisible(), shape, true, paint, bl, paint2, stroke2, true, this.legendLine, stroke, paint);
        legendItem.setToolTipText(string2);
        legendItem.setURLText(string3);
        legendItem.setDataset(xYDataset);
        return legendItem;
    }

    public XYToolTipGenerator getToolTipGenerator(int n, int n2) {
        XYToolTipGenerator xYToolTipGenerator = (XYToolTipGenerator)this.toolTipGeneratorList.get(n);
        if (xYToolTipGenerator == null) {
            xYToolTipGenerator = this.baseToolTipGenerator;
        }
        return xYToolTipGenerator;
    }

    public XYToolTipGenerator getSeriesToolTipGenerator(int n) {
        return (XYToolTipGenerator)this.toolTipGeneratorList.get(n);
    }

    public void setSeriesToolTipGenerator(int n, XYToolTipGenerator xYToolTipGenerator) {
        this.toolTipGeneratorList.set(n, xYToolTipGenerator);
        this.fireChangeEvent();
    }

    public XYToolTipGenerator getBaseToolTipGenerator() {
        return this.baseToolTipGenerator;
    }

    public void setBaseToolTipGenerator(XYToolTipGenerator xYToolTipGenerator) {
        this.baseToolTipGenerator = xYToolTipGenerator;
        this.fireChangeEvent();
    }

    public XYURLGenerator getURLGenerator() {
        return this.urlGenerator;
    }

    public void setURLGenerator(XYURLGenerator xYURLGenerator) {
        this.urlGenerator = xYURLGenerator;
        this.fireChangeEvent();
    }

    public XYSeriesLabelGenerator getLegendItemToolTipGenerator() {
        return this.legendItemToolTipGenerator;
    }

    public void setLegendItemToolTipGenerator(XYSeriesLabelGenerator xYSeriesLabelGenerator) {
        this.legendItemToolTipGenerator = xYSeriesLabelGenerator;
        this.fireChangeEvent();
    }

    public XYSeriesLabelGenerator getLegendItemURLGenerator() {
        return this.legendItemURLGenerator;
    }

    public void setLegendItemURLGenerator(XYSeriesLabelGenerator xYSeriesLabelGenerator) {
        this.legendItemURLGenerator = xYSeriesLabelGenerator;
        this.fireChangeEvent();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof DefaultPolarItemRenderer)) {
            return false;
        }
        DefaultPolarItemRenderer defaultPolarItemRenderer = (DefaultPolarItemRenderer)object;
        if (!this.seriesFilled.equals(defaultPolarItemRenderer.seriesFilled)) {
            return false;
        }
        if (this.drawOutlineWhenFilled != defaultPolarItemRenderer.drawOutlineWhenFilled) {
            return false;
        }
        if (!ObjectUtilities.equal(this.fillComposite, defaultPolarItemRenderer.fillComposite)) {
            return false;
        }
        if (this.useFillPaint != defaultPolarItemRenderer.useFillPaint) {
            return false;
        }
        if (!ShapeUtilities.equal(this.legendLine, defaultPolarItemRenderer.legendLine)) {
            return false;
        }
        if (this.shapesVisible != defaultPolarItemRenderer.shapesVisible) {
            return false;
        }
        if (this.connectFirstAndLastPoint != defaultPolarItemRenderer.connectFirstAndLastPoint) {
            return false;
        }
        if (!this.toolTipGeneratorList.equals(defaultPolarItemRenderer.toolTipGeneratorList)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseToolTipGenerator, defaultPolarItemRenderer.baseToolTipGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.urlGenerator, defaultPolarItemRenderer.urlGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendItemToolTipGenerator, defaultPolarItemRenderer.legendItemToolTipGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.legendItemURLGenerator, defaultPolarItemRenderer.legendItemURLGenerator)) {
            return false;
        }
        return super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultPolarItemRenderer defaultPolarItemRenderer = (DefaultPolarItemRenderer)super.clone();
        if (this.legendLine != null) {
            defaultPolarItemRenderer.legendLine = ShapeUtilities.clone(this.legendLine);
        }
        defaultPolarItemRenderer.seriesFilled = (BooleanList)this.seriesFilled.clone();
        defaultPolarItemRenderer.toolTipGeneratorList = (ObjectList)this.toolTipGeneratorList.clone();
        if (defaultPolarItemRenderer.baseToolTipGenerator instanceof PublicCloneable) {
            defaultPolarItemRenderer.baseToolTipGenerator = (XYToolTipGenerator)ObjectUtilities.clone(this.baseToolTipGenerator);
        }
        if (defaultPolarItemRenderer.urlGenerator instanceof PublicCloneable) {
            defaultPolarItemRenderer.urlGenerator = (XYURLGenerator)ObjectUtilities.clone(this.urlGenerator);
        }
        if (defaultPolarItemRenderer.legendItemToolTipGenerator instanceof PublicCloneable) {
            defaultPolarItemRenderer.legendItemToolTipGenerator = (XYSeriesLabelGenerator)ObjectUtilities.clone(this.legendItemToolTipGenerator);
        }
        if (defaultPolarItemRenderer.legendItemURLGenerator instanceof PublicCloneable) {
            defaultPolarItemRenderer.legendItemURLGenerator = (XYSeriesLabelGenerator)ObjectUtilities.clone(this.legendItemURLGenerator);
        }
        return defaultPolarItemRenderer;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.legendLine = SerialUtilities.readShape(objectInputStream);
        this.fillComposite = SerialUtilities.readComposite(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.legendLine, objectOutputStream);
        SerialUtilities.writeComposite(this.fillComposite, objectOutputStream);
    }
}

