/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.plot.dial;

import ai.org.jfree.chart.plot.dial.AbstractDialLayer;
import ai.org.jfree.chart.plot.dial.DialLayerChangeEvent;
import ai.org.jfree.chart.plot.dial.DialPlot;
import ai.org.jfree.chart.plot.dial.DialScale;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.text.TextUtilities;
import ai.org.jfree.ui.TextAnchor;
import ai.org.jfree.util.PaintUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class StandardDialScale
extends AbstractDialLayer
implements DialScale,
Cloneable,
PublicCloneable,
Serializable {
    static final long serialVersionUID = 3715644629665918516L;
    private double lowerBound;
    private double upperBound;
    private double startAngle;
    private double extent;
    private double tickRadius;
    private double majorTickIncrement;
    private double majorTickLength;
    private transient Paint majorTickPaint;
    private transient Stroke majorTickStroke;
    private int minorTickCount;
    private double minorTickLength;
    private transient Paint minorTickPaint;
    private transient Stroke minorTickStroke;
    private double tickLabelOffset;
    private Font tickLabelFont;
    private boolean tickLabelsVisible;
    private NumberFormat tickLabelFormatter;
    private boolean firstTickLabelVisible;
    private transient Paint tickLabelPaint;

    public StandardDialScale() {
        this(0.0, 100.0, 175.0, -170.0, 10.0, 4);
    }

    public StandardDialScale(double d, double d2, double d3, double d4, double d5, int n) {
        if (d5 <= 0.0) {
            throw new IllegalArgumentException("Requires 'majorTickIncrement' > 0.");
        }
        this.startAngle = d3;
        this.extent = d4;
        this.lowerBound = d;
        this.upperBound = d2;
        this.tickRadius = 0.7;
        this.tickLabelsVisible = true;
        this.tickLabelFormatter = new DecimalFormat("0.0");
        this.firstTickLabelVisible = true;
        this.tickLabelFont = new Font("Dialog", 1, 16);
        this.tickLabelPaint = Color.blue;
        this.tickLabelOffset = 0.1;
        this.majorTickIncrement = d5;
        this.majorTickLength = 0.04;
        this.majorTickPaint = Color.black;
        this.majorTickStroke = new BasicStroke(3.0f);
        this.minorTickCount = n;
        this.minorTickLength = 0.02;
        this.minorTickPaint = Color.black;
        this.minorTickStroke = new BasicStroke(1.0f);
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(double d) {
        this.lowerBound = d;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(double d) {
        this.upperBound = d;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double d) {
        this.startAngle = d;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getExtent() {
        return this.extent;
    }

    public void setExtent(double d) {
        this.extent = d;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getTickRadius() {
        return this.tickRadius;
    }

    public void setTickRadius(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("The 'radius' must be positive.");
        }
        this.tickRadius = d;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getMajorTickIncrement() {
        return this.majorTickIncrement;
    }

    public void setMajorTickIncrement(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("The 'increment' must be positive.");
        }
        this.majorTickIncrement = d;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getMajorTickLength() {
        return this.majorTickLength;
    }

    public void setMajorTickLength(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Negative 'length' argument.");
        }
        this.majorTickLength = d;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getMajorTickPaint() {
        return this.majorTickPaint;
    }

    public void setMajorTickPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.majorTickPaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Stroke getMajorTickStroke() {
        return this.majorTickStroke;
    }

    public void setMajorTickStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.majorTickStroke = stroke;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public int getMinorTickCount() {
        return this.minorTickCount;
    }

    public void setMinorTickCount(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("The 'count' cannot be negative.");
        }
        this.minorTickCount = n;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getMinorTickLength() {
        return this.minorTickLength;
    }

    public void setMinorTickLength(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Negative 'length' argument.");
        }
        this.minorTickLength = d;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getMinorTickPaint() {
        return this.minorTickPaint;
    }

    public void setMinorTickPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.minorTickPaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Stroke getMinorTickStroke() {
        return this.minorTickStroke;
    }

    public void setMinorTickStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.minorTickStroke = stroke;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getTickLabelOffset() {
        return this.tickLabelOffset;
    }

    public void setTickLabelOffset(double d) {
        this.tickLabelOffset = d;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Font getTickLabelFont() {
        return this.tickLabelFont;
    }

    public void setTickLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.tickLabelFont = font;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getTickLabelPaint() {
        return this.tickLabelPaint;
    }

    public void setTickLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.tickLabelPaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public boolean getTickLabelsVisible() {
        return this.tickLabelsVisible;
    }

    public void setTickLabelsVisible(boolean bl) {
        this.tickLabelsVisible = bl;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public NumberFormat getTickLabelFormatter() {
        return this.tickLabelFormatter;
    }

    public void setTickLabelFormatter(NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new IllegalArgumentException("Null 'formatter' argument.");
        }
        this.tickLabelFormatter = numberFormat;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public boolean getFirstTickLabelVisible() {
        return this.firstTickLabelVisible;
    }

    public void setFirstTickLabelVisible(boolean bl) {
        this.firstTickLabelVisible = bl;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public boolean isClippedToWindow() {
        return true;
    }

    public void draw(Graphics2D graphics2D, DialPlot dialPlot, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        Rectangle2D rectangle2D3 = DialPlot.rectangleByRadius(rectangle2D, this.tickRadius, this.tickRadius);
        Rectangle2D rectangle2D4 = DialPlot.rectangleByRadius(rectangle2D, this.tickRadius - this.majorTickLength, this.tickRadius - this.majorTickLength);
        Rectangle2D rectangle2D5 = rectangle2D3;
        if (this.minorTickCount > 0 && this.minorTickLength > 0.0) {
            rectangle2D5 = DialPlot.rectangleByRadius(rectangle2D, this.tickRadius - this.minorTickLength, this.tickRadius - this.minorTickLength);
        }
        Rectangle2D rectangle2D6 = DialPlot.rectangleByRadius(rectangle2D, this.tickRadius - this.tickLabelOffset, this.tickRadius - this.tickLabelOffset);
        boolean bl = true;
        Arc2D.Double double_ = new Arc2D.Double();
        Line2D.Double double_2 = new Line2D.Double();
        for (double d = this.lowerBound; d <= this.upperBound; d += this.majorTickIncrement) {
            double d2;
            double_.setArc(rectangle2D3, this.startAngle, this.valueToAngle(d) - this.startAngle, 0);
            Point2D point2D = double_.getEndPoint();
            double_.setArc(rectangle2D4, this.startAngle, this.valueToAngle(d) - this.startAngle, 0);
            Point2D point2D2 = double_.getEndPoint();
            graphics2D.setPaint(this.majorTickPaint);
            graphics2D.setStroke(this.majorTickStroke);
            double_2.setLine(point2D, point2D2);
            graphics2D.draw(double_2);
            double_.setArc(rectangle2D6, this.startAngle, this.valueToAngle(d) - this.startAngle, 0);
            Point2D point2D3 = double_.getEndPoint();
            if (this.tickLabelsVisible && (!bl || this.firstTickLabelVisible)) {
                graphics2D.setFont(this.tickLabelFont);
                graphics2D.setPaint(this.tickLabelPaint);
                TextUtilities.drawAlignedString(this.tickLabelFormatter.format(d), graphics2D, (float)point2D3.getX(), (float)point2D3.getY(), TextAnchor.CENTER);
            }
            bl = false;
            if (this.minorTickCount <= 0 || !(this.minorTickLength > 0.0)) continue;
            double d3 = this.majorTickIncrement / (double)(this.minorTickCount + 1);
            for (int i = 0; i < this.minorTickCount && !((d2 = d + (double)(i + 1) * d3) >= this.upperBound); ++i) {
                double d4 = this.valueToAngle(d2);
                double_.setArc(rectangle2D3, this.startAngle, d4 - this.startAngle, 0);
                point2D = double_.getEndPoint();
                double_.setArc(rectangle2D5, this.startAngle, d4 - this.startAngle, 0);
                Point2D point2D4 = double_.getEndPoint();
                graphics2D.setStroke(this.minorTickStroke);
                graphics2D.setPaint(this.minorTickPaint);
                double_2.setLine(point2D, point2D4);
                graphics2D.draw(double_2);
            }
        }
    }

    public double valueToAngle(double d) {
        double d2 = this.upperBound - this.lowerBound;
        double d3 = this.extent / d2;
        return this.startAngle + d3 * (d - this.lowerBound);
    }

    public double angleToValue(double d) {
        return Double.NaN;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardDialScale)) {
            return false;
        }
        StandardDialScale standardDialScale = (StandardDialScale)object;
        if (this.lowerBound != standardDialScale.lowerBound) {
            return false;
        }
        if (this.upperBound != standardDialScale.upperBound) {
            return false;
        }
        if (this.startAngle != standardDialScale.startAngle) {
            return false;
        }
        if (this.extent != standardDialScale.extent) {
            return false;
        }
        if (this.tickRadius != standardDialScale.tickRadius) {
            return false;
        }
        if (this.majorTickIncrement != standardDialScale.majorTickIncrement) {
            return false;
        }
        if (this.majorTickLength != standardDialScale.majorTickLength) {
            return false;
        }
        if (!PaintUtilities.equal(this.majorTickPaint, standardDialScale.majorTickPaint)) {
            return false;
        }
        if (!this.majorTickStroke.equals(standardDialScale.majorTickStroke)) {
            return false;
        }
        if (this.minorTickCount != standardDialScale.minorTickCount) {
            return false;
        }
        if (this.minorTickLength != standardDialScale.minorTickLength) {
            return false;
        }
        if (!PaintUtilities.equal(this.minorTickPaint, standardDialScale.minorTickPaint)) {
            return false;
        }
        if (!this.minorTickStroke.equals(standardDialScale.minorTickStroke)) {
            return false;
        }
        if (this.tickLabelsVisible != standardDialScale.tickLabelsVisible) {
            return false;
        }
        if (this.tickLabelOffset != standardDialScale.tickLabelOffset) {
            return false;
        }
        if (!this.tickLabelFont.equals(standardDialScale.tickLabelFont)) {
            return false;
        }
        if (!PaintUtilities.equal(this.tickLabelPaint, standardDialScale.tickLabelPaint)) {
            return false;
        }
        return super.equals(object);
    }

    public int hashCode() {
        int n = 193;
        long l = Double.doubleToLongBits(this.lowerBound);
        n = 37 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.upperBound);
        n = 37 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.startAngle);
        n = 37 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.extent);
        n = 37 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.tickRadius);
        n = 37 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.majorTickPaint, objectOutputStream);
        SerialUtilities.writeStroke(this.majorTickStroke, objectOutputStream);
        SerialUtilities.writePaint(this.minorTickPaint, objectOutputStream);
        SerialUtilities.writeStroke(this.minorTickStroke, objectOutputStream);
        SerialUtilities.writePaint(this.tickLabelPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.majorTickPaint = SerialUtilities.readPaint(objectInputStream);
        this.majorTickStroke = SerialUtilities.readStroke(objectInputStream);
        this.minorTickPaint = SerialUtilities.readPaint(objectInputStream);
        this.minorTickStroke = SerialUtilities.readStroke(objectInputStream);
        this.tickLabelPaint = SerialUtilities.readPaint(objectInputStream);
    }
}

