/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.plot.dial;

import ai.org.jfree.chart.HashUtilities;
import ai.org.jfree.chart.plot.dial.AbstractDialLayer;
import ai.org.jfree.chart.plot.dial.DialLayer;
import ai.org.jfree.chart.plot.dial.DialLayerChangeEvent;
import ai.org.jfree.chart.plot.dial.DialPlot;
import ai.org.jfree.chart.plot.dial.DialScale;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.util.PaintUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Arc2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class StandardDialRange
extends AbstractDialLayer
implements DialLayer,
Cloneable,
PublicCloneable,
Serializable {
    static final long serialVersionUID = 345515648249364904L;
    private int scaleIndex;
    private double lowerBound;
    private double upperBound;
    private transient Paint paint;
    private double innerRadius;
    private double outerRadius;

    public StandardDialRange() {
        this(0.0, 100.0, Color.white);
    }

    public StandardDialRange(double d, double d2, Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.scaleIndex = 0;
        this.lowerBound = d;
        this.upperBound = d2;
        this.innerRadius = 0.48;
        this.outerRadius = 0.52;
        this.paint = paint;
    }

    public int getScaleIndex() {
        return this.scaleIndex;
    }

    public void setScaleIndex(int n) {
        this.scaleIndex = n;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(double d) {
        if (d >= this.upperBound) {
            throw new IllegalArgumentException("Lower bound must be less than upper bound.");
        }
        this.lowerBound = d;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(double d) {
        if (d <= this.lowerBound) {
            throw new IllegalArgumentException("Lower bound must be less than upper bound.");
        }
        this.upperBound = d;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public void setBounds(double d, double d2) {
        if (d >= d2) {
            throw new IllegalArgumentException("Lower must be less than upper.");
        }
        this.lowerBound = d;
        this.upperBound = d2;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.paint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getInnerRadius() {
        return this.innerRadius;
    }

    public void setInnerRadius(double d) {
        this.innerRadius = d;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getOuterRadius() {
        return this.outerRadius;
    }

    public void setOuterRadius(double d) {
        this.outerRadius = d;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public boolean isClippedToWindow() {
        return true;
    }

    public void draw(Graphics2D graphics2D, DialPlot dialPlot, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        Rectangle2D rectangle2D3 = DialPlot.rectangleByRadius(rectangle2D, this.innerRadius, this.innerRadius);
        Rectangle2D rectangle2D4 = DialPlot.rectangleByRadius(rectangle2D, this.outerRadius, this.outerRadius);
        DialScale dialScale = dialPlot.getScale(this.scaleIndex);
        if (dialScale == null) {
            throw new RuntimeException("No scale for scaleIndex = " + this.scaleIndex);
        }
        double d = dialScale.valueToAngle(this.lowerBound);
        double d2 = dialScale.valueToAngle(this.upperBound);
        Arc2D.Double double_ = new Arc2D.Double(rectangle2D3, d, d2 - d, 0);
        Arc2D.Double double_2 = new Arc2D.Double(rectangle2D4, d2, d - d2, 0);
        graphics2D.setPaint(this.paint);
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.draw(double_);
        graphics2D.draw(double_2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardDialRange)) {
            return false;
        }
        StandardDialRange standardDialRange = (StandardDialRange)object;
        if (this.scaleIndex != standardDialRange.scaleIndex) {
            return false;
        }
        if (this.lowerBound != standardDialRange.lowerBound) {
            return false;
        }
        if (this.upperBound != standardDialRange.upperBound) {
            return false;
        }
        if (!PaintUtilities.equal(this.paint, standardDialRange.paint)) {
            return false;
        }
        if (this.innerRadius != standardDialRange.innerRadius) {
            return false;
        }
        if (this.outerRadius != standardDialRange.outerRadius) {
            return false;
        }
        return super.equals(object);
    }

    public int hashCode() {
        int n = 193;
        long l = Double.doubleToLongBits(this.lowerBound);
        n = 37 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.upperBound);
        n = 37 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.innerRadius);
        n = 37 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.outerRadius);
        n = 37 * n + (int)(l ^ l >>> 32);
        n = 37 * n + HashUtilities.hashCodeForPaint(this.paint);
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.paint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.paint = SerialUtilities.readPaint(objectInputStream);
    }
}

