/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.plot.dial;

import ai.org.jfree.chart.HashUtilities;
import ai.org.jfree.chart.plot.dial.AbstractDialLayer;
import ai.org.jfree.chart.plot.dial.DialFrame;
import ai.org.jfree.chart.plot.dial.DialLayerChangeEvent;
import ai.org.jfree.chart.plot.dial.DialPlot;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.util.PaintUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class StandardDialFrame
extends AbstractDialLayer
implements DialFrame,
Cloneable,
PublicCloneable,
Serializable {
    static final long serialVersionUID = 1016585407507121596L;
    private double radius = 0.95;
    private transient Paint backgroundPaint = Color.gray;
    private transient Paint foregroundPaint = Color.black;
    private transient Stroke stroke = new BasicStroke(2.0f);

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("The 'radius' must be positive.");
        }
        this.radius = d;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.backgroundPaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getForegroundPaint() {
        return this.foregroundPaint;
    }

    public void setForegroundPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.foregroundPaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.stroke = stroke;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Shape getWindow(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = DialPlot.rectangleByRadius(rectangle2D, this.radius, this.radius);
        return new Ellipse2D.Double(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight());
    }

    public boolean isClippedToWindow() {
        return false;
    }

    public void draw(Graphics2D graphics2D, DialPlot dialPlot, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        Shape shape = this.getWindow(rectangle2D);
        Rectangle2D rectangle2D3 = DialPlot.rectangleByRadius(rectangle2D, this.radius + 0.02, this.radius + 0.02);
        Ellipse2D.Double double_ = new Ellipse2D.Double(rectangle2D3.getX(), rectangle2D3.getY(), rectangle2D3.getWidth(), rectangle2D3.getHeight());
        Area area = new Area(double_);
        Area area2 = new Area(shape);
        area.subtract(area2);
        graphics2D.setPaint(this.backgroundPaint);
        graphics2D.fill(area);
        graphics2D.setStroke(this.stroke);
        graphics2D.setPaint(this.foregroundPaint);
        graphics2D.draw(shape);
        graphics2D.draw(double_);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardDialFrame)) {
            return false;
        }
        StandardDialFrame standardDialFrame = (StandardDialFrame)object;
        if (!PaintUtilities.equal(this.backgroundPaint, standardDialFrame.backgroundPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.foregroundPaint, standardDialFrame.foregroundPaint)) {
            return false;
        }
        if (this.radius != standardDialFrame.radius) {
            return false;
        }
        if (!this.stroke.equals(standardDialFrame.stroke)) {
            return false;
        }
        return super.equals(object);
    }

    public int hashCode() {
        int n = 193;
        long l = Double.doubleToLongBits(this.radius);
        n = 37 * n + (int)(l ^ l >>> 32);
        n = 37 * n + HashUtilities.hashCodeForPaint(this.backgroundPaint);
        n = 37 * n + HashUtilities.hashCodeForPaint(this.foregroundPaint);
        n = 37 * n + this.stroke.hashCode();
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.backgroundPaint, objectOutputStream);
        SerialUtilities.writePaint(this.foregroundPaint, objectOutputStream);
        SerialUtilities.writeStroke(this.stroke, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.backgroundPaint = SerialUtilities.readPaint(objectInputStream);
        this.foregroundPaint = SerialUtilities.readPaint(objectInputStream);
        this.stroke = SerialUtilities.readStroke(objectInputStream);
    }
}

