/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.plot.dial;

import ai.org.jfree.chart.HashUtilities;
import ai.org.jfree.chart.plot.dial.AbstractDialLayer;
import ai.org.jfree.chart.plot.dial.DialLayer;
import ai.org.jfree.chart.plot.dial.DialLayerChangeEvent;
import ai.org.jfree.chart.plot.dial.DialPlot;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.text.TextUtilities;
import ai.org.jfree.ui.TextAnchor;
import ai.org.jfree.util.PaintUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class DialTextAnnotation
extends AbstractDialLayer
implements DialLayer,
Cloneable,
PublicCloneable,
Serializable {
    static final long serialVersionUID = 3065267524054428071L;
    private String label;
    private Font font;
    private transient Paint paint;
    private double angle;
    private double radius;
    private TextAnchor anchor;

    public DialTextAnnotation(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'label' argument.");
        }
        this.angle = -90.0;
        this.radius = 0.3;
        this.font = new Font("Dialog", 1, 14);
        this.paint = Color.black;
        this.label = string;
        this.anchor = TextAnchor.TOP_CENTER;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'label' argument.");
        }
        this.label = string;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.font = font;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.paint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double d) {
        this.angle = d;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("The 'radius' cannot be negative.");
        }
        this.radius = d;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public TextAnchor getAnchor() {
        return this.anchor;
    }

    public void setAnchor(TextAnchor textAnchor) {
        if (textAnchor == null) {
            throw new IllegalArgumentException("Null 'anchor' argument.");
        }
        this.anchor = textAnchor;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public boolean isClippedToWindow() {
        return true;
    }

    public void draw(Graphics2D graphics2D, DialPlot dialPlot, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        Rectangle2D rectangle2D3 = DialPlot.rectangleByRadius(rectangle2D, this.radius, this.radius);
        Arc2D.Double double_ = new Arc2D.Double(rectangle2D3, this.angle, 0.0, 0);
        Point2D point2D = double_.getStartPoint();
        graphics2D.setPaint(this.paint);
        graphics2D.setFont(this.font);
        TextUtilities.drawAlignedString(this.label, graphics2D, (float)point2D.getX(), (float)point2D.getY(), this.anchor);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DialTextAnnotation)) {
            return false;
        }
        DialTextAnnotation dialTextAnnotation = (DialTextAnnotation)object;
        if (!this.label.equals(dialTextAnnotation.label)) {
            return false;
        }
        if (!this.font.equals(dialTextAnnotation.font)) {
            return false;
        }
        if (!PaintUtilities.equal(this.paint, dialTextAnnotation.paint)) {
            return false;
        }
        if (this.radius != dialTextAnnotation.radius) {
            return false;
        }
        if (this.angle != dialTextAnnotation.angle) {
            return false;
        }
        if (!this.anchor.equals(dialTextAnnotation.anchor)) {
            return false;
        }
        return super.equals(object);
    }

    public int hashCode() {
        int n = 193;
        n = 37 * n + HashUtilities.hashCodeForPaint(this.paint);
        n = 37 * n + this.font.hashCode();
        n = 37 * n + this.label.hashCode();
        n = 37 * n + this.anchor.hashCode();
        long l = Double.doubleToLongBits(this.angle);
        n = 37 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.radius);
        n = 37 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.paint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.paint = SerialUtilities.readPaint(objectInputStream);
    }
}

