/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.plot.dial;

import ai.org.jfree.chart.HashUtilities;
import ai.org.jfree.chart.plot.dial.AbstractDialLayer;
import ai.org.jfree.chart.plot.dial.DialLayer;
import ai.org.jfree.chart.plot.dial.DialLayerChangeEvent;
import ai.org.jfree.chart.plot.dial.DialPlot;
import ai.org.jfree.chart.plot.dial.DialScale;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.util.PaintUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public abstract class DialPointer
extends AbstractDialLayer
implements DialLayer,
Cloneable,
PublicCloneable,
Serializable {
    double radius = 0.9;
    int datasetIndex;

    protected DialPointer() {
        this(0);
    }

    protected DialPointer(int n) {
        this.datasetIndex = n;
    }

    public int getDatasetIndex() {
        return this.datasetIndex;
    }

    public void setDatasetIndex(int n) {
        this.datasetIndex = n;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d) {
        this.radius = d;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public boolean isClippedToWindow() {
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DialPointer)) {
            return false;
        }
        DialPointer dialPointer = (DialPointer)object;
        if (this.datasetIndex != dialPointer.datasetIndex) {
            return false;
        }
        if (this.radius != dialPointer.radius) {
            return false;
        }
        return super.equals(object);
    }

    public int hashCode() {
        int n = 23;
        n = HashUtilities.hashCode(n, this.radius);
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static class Pointer
    extends DialPointer {
        static final long serialVersionUID = -4180500011963176960L;
        private double widthRadius = 0.05;
        private transient Paint fillPaint = Color.gray;
        private transient Paint outlinePaint = Color.black;

        public Pointer() {
            this(0);
        }

        public Pointer(int n) {
            super(n);
        }

        public double getWidthRadius() {
            return this.widthRadius;
        }

        public void setWidthRadius(double d) {
            this.widthRadius = d;
            this.notifyListeners(new DialLayerChangeEvent(this));
        }

        public Paint getFillPaint() {
            return this.fillPaint;
        }

        public void setFillPaint(Paint paint) {
            if (paint == null) {
                throw new IllegalArgumentException("Null 'paint' argument.");
            }
            this.fillPaint = paint;
            this.notifyListeners(new DialLayerChangeEvent(this));
        }

        public Paint getOutlinePaint() {
            return this.outlinePaint;
        }

        public void setOutlinePaint(Paint paint) {
            if (paint == null) {
                throw new IllegalArgumentException("Null 'paint' argument.");
            }
            this.outlinePaint = paint;
            this.notifyListeners(new DialLayerChangeEvent(this));
        }

        public void draw(Graphics2D graphics2D, DialPlot dialPlot, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
            graphics2D.setPaint(Color.blue);
            graphics2D.setStroke(new BasicStroke(1.0f));
            Rectangle2D rectangle2D3 = DialPlot.rectangleByRadius(rectangle2D, this.radius, this.radius);
            Rectangle2D rectangle2D4 = DialPlot.rectangleByRadius(rectangle2D, this.widthRadius, this.widthRadius);
            double d = dialPlot.getValue(this.datasetIndex);
            DialScale dialScale = dialPlot.getScaleForDataset(this.datasetIndex);
            double d2 = dialScale.valueToAngle(d);
            Arc2D.Double double_ = new Arc2D.Double(rectangle2D3, d2, 0.0, 0);
            Point2D point2D = double_.getEndPoint();
            Arc2D.Double double_2 = new Arc2D.Double(rectangle2D4, d2 - 90.0, 180.0, 0);
            Point2D point2D2 = double_2.getStartPoint();
            Point2D point2D3 = double_2.getEndPoint();
            Arc2D.Double double_3 = new Arc2D.Double(rectangle2D4, d2 - 180.0, 0.0, 0);
            Point2D point2D4 = double_3.getStartPoint();
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
            generalPath.lineTo((float)point2D2.getX(), (float)point2D2.getY());
            generalPath.lineTo((float)point2D4.getX(), (float)point2D4.getY());
            generalPath.lineTo((float)point2D3.getX(), (float)point2D3.getY());
            generalPath.closePath();
            graphics2D.setPaint(this.fillPaint);
            graphics2D.fill(generalPath);
            graphics2D.setPaint(this.outlinePaint);
            Line2D.Double double_4 = new Line2D.Double(rectangle2D.getCenterX(), rectangle2D.getCenterY(), point2D.getX(), point2D.getY());
            graphics2D.draw(double_4);
            double_4.setLine(point2D2, point2D3);
            graphics2D.draw(double_4);
            double_4.setLine(point2D3, point2D);
            graphics2D.draw(double_4);
            double_4.setLine(point2D2, point2D);
            graphics2D.draw(double_4);
            double_4.setLine(point2D2, point2D4);
            graphics2D.draw(double_4);
            double_4.setLine(point2D3, point2D4);
            graphics2D.draw(double_4);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Pointer)) {
                return false;
            }
            Pointer pointer = (Pointer)object;
            if (this.widthRadius != pointer.widthRadius) {
                return false;
            }
            if (!PaintUtilities.equal(this.fillPaint, pointer.fillPaint)) {
                return false;
            }
            if (!PaintUtilities.equal(this.outlinePaint, pointer.outlinePaint)) {
                return false;
            }
            return super.equals(object);
        }

        public int hashCode() {
            int n = super.hashCode();
            n = HashUtilities.hashCode(n, this.widthRadius);
            n = HashUtilities.hashCode(n, this.fillPaint);
            n = HashUtilities.hashCode(n, this.outlinePaint);
            return n;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            SerialUtilities.writePaint(this.fillPaint, objectOutputStream);
            SerialUtilities.writePaint(this.outlinePaint, objectOutputStream);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.fillPaint = SerialUtilities.readPaint(objectInputStream);
            this.outlinePaint = SerialUtilities.readPaint(objectInputStream);
        }
    }

    public static class Pin
    extends DialPointer {
        static final long serialVersionUID = -8445860485367689750L;
        private transient Paint paint = Color.red;
        private transient Stroke stroke = new BasicStroke(3.0f, 1, 2);

        public Pin() {
            this(0);
        }

        public Pin(int n) {
            super(n);
        }

        public Paint getPaint() {
            return this.paint;
        }

        public void setPaint(Paint paint) {
            if (paint == null) {
                throw new IllegalArgumentException("Null 'paint' argument.");
            }
            this.paint = paint;
            this.notifyListeners(new DialLayerChangeEvent(this));
        }

        public Stroke getStroke() {
            return this.stroke;
        }

        public void setStroke(Stroke stroke) {
            if (stroke == null) {
                throw new IllegalArgumentException("Null 'stroke' argument.");
            }
            this.stroke = stroke;
            this.notifyListeners(new DialLayerChangeEvent(this));
        }

        public void draw(Graphics2D graphics2D, DialPlot dialPlot, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
            graphics2D.setPaint(this.paint);
            graphics2D.setStroke(this.stroke);
            Rectangle2D rectangle2D3 = DialPlot.rectangleByRadius(rectangle2D, this.radius, this.radius);
            double d = dialPlot.getValue(this.datasetIndex);
            DialScale dialScale = dialPlot.getScaleForDataset(this.datasetIndex);
            double d2 = dialScale.valueToAngle(d);
            Arc2D.Double double_ = new Arc2D.Double(rectangle2D3, d2, 0.0, 0);
            Point2D point2D = double_.getEndPoint();
            Line2D.Double double_2 = new Line2D.Double(rectangle2D.getCenterX(), rectangle2D.getCenterY(), point2D.getX(), point2D.getY());
            graphics2D.draw(double_2);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Pin)) {
                return false;
            }
            Pin pin = (Pin)object;
            if (!PaintUtilities.equal(this.paint, pin.paint)) {
                return false;
            }
            if (!this.stroke.equals(pin.stroke)) {
                return false;
            }
            return super.equals(object);
        }

        public int hashCode() {
            int n = super.hashCode();
            n = HashUtilities.hashCode(n, this.paint);
            n = HashUtilities.hashCode(n, this.stroke);
            return n;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            SerialUtilities.writePaint(this.paint, objectOutputStream);
            SerialUtilities.writeStroke(this.stroke, objectOutputStream);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.paint = SerialUtilities.readPaint(objectInputStream);
            this.stroke = SerialUtilities.readStroke(objectInputStream);
        }
    }
}

