/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.plot.dial;

import ai.org.jfree.chart.HashUtilities;
import ai.org.jfree.chart.plot.dial.AbstractDialLayer;
import ai.org.jfree.chart.plot.dial.DialFrame;
import ai.org.jfree.chart.plot.dial.DialLayerChangeEvent;
import ai.org.jfree.chart.plot.dial.DialPlot;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.util.PaintUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ArcDialFrame
extends AbstractDialLayer
implements DialFrame,
Cloneable,
PublicCloneable,
Serializable {
    static final long serialVersionUID = -4089176959553523499L;
    private transient Paint backgroundPaint = Color.gray;
    private transient Paint foregroundPaint = new Color(100, 100, 150);
    private transient Stroke stroke = new BasicStroke(2.0f);
    private double startAngle;
    private double extent;
    private double innerRadius = 0.25;
    private double outerRadius = 0.75;

    public ArcDialFrame() {
        this(0.0, 180.0);
    }

    public ArcDialFrame(double d, double d2) {
        this.startAngle = d;
        this.extent = d2;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.backgroundPaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Paint getForegroundPaint() {
        return this.foregroundPaint;
    }

    public void setForegroundPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.foregroundPaint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.stroke = stroke;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getInnerRadius() {
        return this.innerRadius;
    }

    public void setInnerRadius(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Negative 'radius' argument.");
        }
        this.innerRadius = d;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getOuterRadius() {
        return this.outerRadius;
    }

    public void setOuterRadius(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Negative 'radius' argument.");
        }
        this.outerRadius = d;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double d) {
        this.startAngle = d;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getExtent() {
        return this.extent;
    }

    public void setExtent(double d) {
        this.extent = d;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public Shape getWindow(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = DialPlot.rectangleByRadius(rectangle2D, this.innerRadius, this.innerRadius);
        Rectangle2D rectangle2D3 = DialPlot.rectangleByRadius(rectangle2D, this.outerRadius, this.outerRadius);
        Arc2D.Double double_ = new Arc2D.Double(rectangle2D2, this.startAngle, this.extent, 0);
        Arc2D.Double double_2 = new Arc2D.Double(rectangle2D3, this.startAngle + this.extent, -this.extent, 0);
        GeneralPath generalPath = new GeneralPath();
        Point2D point2D = double_.getStartPoint();
        generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
        generalPath.append(double_, true);
        generalPath.append(double_2, true);
        generalPath.closePath();
        return generalPath;
    }

    protected Shape getOuterWindow(Rectangle2D rectangle2D) {
        double d = 0.02;
        double d2 = 1.5;
        Rectangle2D rectangle2D2 = DialPlot.rectangleByRadius(rectangle2D, this.innerRadius - d, this.innerRadius - d);
        Rectangle2D rectangle2D3 = DialPlot.rectangleByRadius(rectangle2D, this.outerRadius + d, this.outerRadius + d);
        Arc2D.Double double_ = new Arc2D.Double(rectangle2D2, this.startAngle - d2, this.extent + 2.0 * d2, 0);
        Arc2D.Double double_2 = new Arc2D.Double(rectangle2D3, this.startAngle + d2 + this.extent, -this.extent - 2.0 * d2, 0);
        GeneralPath generalPath = new GeneralPath();
        Point2D point2D = double_.getStartPoint();
        generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
        generalPath.append(double_, true);
        generalPath.append(double_2, true);
        generalPath.closePath();
        return generalPath;
    }

    public void draw(Graphics2D graphics2D, DialPlot dialPlot, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        Shape shape = this.getWindow(rectangle2D);
        Shape shape2 = this.getOuterWindow(rectangle2D);
        Area area = new Area(shape2);
        Area area2 = new Area(shape);
        area.subtract(area2);
        graphics2D.setPaint(Color.lightGray);
        graphics2D.fill(area);
        graphics2D.setStroke(this.stroke);
        graphics2D.setPaint(this.foregroundPaint);
        graphics2D.draw(shape);
        graphics2D.draw(shape2);
    }

    public boolean isClippedToWindow() {
        return false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ArcDialFrame)) {
            return false;
        }
        ArcDialFrame arcDialFrame = (ArcDialFrame)object;
        if (!PaintUtilities.equal(this.backgroundPaint, arcDialFrame.backgroundPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.foregroundPaint, arcDialFrame.foregroundPaint)) {
            return false;
        }
        if (this.startAngle != arcDialFrame.startAngle) {
            return false;
        }
        if (this.extent != arcDialFrame.extent) {
            return false;
        }
        if (this.innerRadius != arcDialFrame.innerRadius) {
            return false;
        }
        if (this.outerRadius != arcDialFrame.outerRadius) {
            return false;
        }
        if (!this.stroke.equals(arcDialFrame.stroke)) {
            return false;
        }
        return super.equals(object);
    }

    public int hashCode() {
        int n = 193;
        long l = Double.doubleToLongBits(this.startAngle);
        n = 37 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.extent);
        n = 37 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.innerRadius);
        n = 37 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.outerRadius);
        n = 37 * n + (int)(l ^ l >>> 32);
        n = 37 * n + HashUtilities.hashCodeForPaint(this.backgroundPaint);
        n = 37 * n + HashUtilities.hashCodeForPaint(this.foregroundPaint);
        n = 37 * n + this.stroke.hashCode();
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.backgroundPaint, objectOutputStream);
        SerialUtilities.writePaint(this.foregroundPaint, objectOutputStream);
        SerialUtilities.writeStroke(this.stroke, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.backgroundPaint = SerialUtilities.readPaint(objectInputStream);
        this.foregroundPaint = SerialUtilities.readPaint(objectInputStream);
        this.stroke = SerialUtilities.readStroke(objectInputStream);
    }
}

