/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.plot;

import ai.org.jfree.chart.LegendItemCollection;
import ai.org.jfree.chart.axis.NumberAxis;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.PlotState;
import ai.org.jfree.chart.plot.ValueAxisPlot;
import ai.org.jfree.chart.plot.Zoomable;
import ai.org.jfree.chart.util.ResourceBundleWrapper;
import ai.org.jfree.data.Range;
import ai.org.jfree.data.general.DatasetChangeEvent;
import ai.org.jfree.data.general.DefaultValueDataset;
import ai.org.jfree.data.general.ValueDataset;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.ui.RectangleInsets;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PaintUtilities;
import ai.org.jfree.util.UnitType;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.ResourceBundle;

public class ThermometerPlot
extends Plot
implements ValueAxisPlot,
Zoomable,
Cloneable,
Serializable {
    private static final long serialVersionUID = 4087093313147984390L;
    public static final int UNITS_NONE = 0;
    public static final int UNITS_FAHRENHEIT = 1;
    public static final int UNITS_CELCIUS = 2;
    public static final int UNITS_KELVIN = 3;
    public static final int NONE = 0;
    public static final int RIGHT = 1;
    public static final int LEFT = 2;
    public static final int BULB = 3;
    public static final int NORMAL = 0;
    public static final int WARNING = 1;
    public static final int CRITICAL = 2;
    protected static final int BULB_RADIUS = 40;
    protected static final int BULB_DIAMETER = 80;
    protected static final int COLUMN_RADIUS = 20;
    protected static final int COLUMN_DIAMETER = 40;
    protected static final int GAP_RADIUS = 5;
    protected static final int GAP_DIAMETER = 10;
    protected static final int AXIS_GAP = 10;
    protected static final String[] UNITS = new String[]{"", "\u00b0F", "\u00b0C", "\u00b0K"};
    protected static final int RANGE_LOW = 0;
    protected static final int RANGE_HIGH = 1;
    protected static final int DISPLAY_LOW = 2;
    protected static final int DISPLAY_HIGH = 3;
    protected static final double DEFAULT_LOWER_BOUND = 0.0;
    protected static final double DEFAULT_UPPER_BOUND = 100.0;
    protected static final int DEFAULT_BULB_RADIUS = 40;
    protected static final int DEFAULT_COLUMN_RADIUS = 20;
    protected static final int DEFAULT_GAP = 5;
    private ValueDataset dataset;
    private ValueAxis rangeAxis;
    private double lowerBound = 0.0;
    private double upperBound = 100.0;
    private int bulbRadius = 40;
    private int columnRadius = 20;
    private int gap = 5;
    private RectangleInsets padding;
    private transient Stroke thermometerStroke = new BasicStroke(1.0f);
    private transient Paint thermometerPaint = Color.black;
    private int units = 2;
    private int valueLocation = 3;
    private int axisLocation = 2;
    private Font valueFont = new Font("SansSerif", 1, 16);
    private transient Paint valuePaint = Color.white;
    private NumberFormat valueFormat = new DecimalFormat();
    private transient Paint mercuryPaint = Color.lightGray;
    private boolean showValueLines = false;
    private int subrange = -1;
    private double[][] subrangeInfo = new double[][]{{0.0, 50.0, 0.0, 50.0}, {50.0, 75.0, 50.0, 75.0}, {75.0, 100.0, 75.0, 100.0}};
    private boolean followDataInSubranges = false;
    private boolean useSubrangePaint = true;
    private transient Paint[] subrangePaint = new Paint[]{Color.green, Color.orange, Color.red};
    private boolean subrangeIndicatorsVisible = true;
    private transient Stroke subrangeIndicatorStroke = new BasicStroke(2.0f);
    private transient Stroke rangeIndicatorStroke = new BasicStroke(3.0f);
    protected static ResourceBundle localizationResources = ResourceBundleWrapper.getBundle("ai.org.jfree.chart.plot.LocalizationBundle");

    public ThermometerPlot() {
        this(new DefaultValueDataset());
    }

    public ThermometerPlot(ValueDataset valueDataset) {
        this.padding = new RectangleInsets(UnitType.RELATIVE, 0.05, 0.05, 0.05, 0.05);
        this.dataset = valueDataset;
        if (valueDataset != null) {
            valueDataset.addChangeListener(this);
        }
        NumberAxis numberAxis = new NumberAxis(null);
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        numberAxis.setAxisLineVisible(false);
        numberAxis.setPlot(this);
        numberAxis.addChangeListener(this);
        this.rangeAxis = numberAxis;
        this.setAxisRange();
    }

    public ValueDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(ValueDataset valueDataset) {
        ValueDataset valueDataset2 = this.dataset;
        if (valueDataset2 != null) {
            valueDataset2.removeChangeListener(this);
        }
        this.dataset = valueDataset;
        if (valueDataset != null) {
            this.setDatasetGroup(valueDataset.getGroup());
            valueDataset.addChangeListener(this);
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, valueDataset);
        this.datasetChanged(datasetChangeEvent);
    }

    public ValueAxis getRangeAxis() {
        return this.rangeAxis;
    }

    public void setRangeAxis(ValueAxis valueAxis) {
        if (valueAxis == null) {
            throw new IllegalArgumentException("Null 'axis' argument.");
        }
        this.rangeAxis.removeChangeListener(this);
        valueAxis.setPlot(this);
        valueAxis.addChangeListener(this);
        this.rangeAxis = valueAxis;
        this.fireChangeEvent();
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(double d) {
        this.lowerBound = d;
        this.setAxisRange();
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(double d) {
        this.upperBound = d;
        this.setAxisRange();
    }

    public void setRange(double d, double d2) {
        this.lowerBound = d;
        this.upperBound = d2;
        this.setAxisRange();
    }

    public RectangleInsets getPadding() {
        return this.padding;
    }

    public void setPadding(RectangleInsets rectangleInsets) {
        if (rectangleInsets == null) {
            throw new IllegalArgumentException("Null 'padding' argument.");
        }
        this.padding = rectangleInsets;
        this.fireChangeEvent();
    }

    public Stroke getThermometerStroke() {
        return this.thermometerStroke;
    }

    public void setThermometerStroke(Stroke stroke) {
        if (stroke != null) {
            this.thermometerStroke = stroke;
            this.fireChangeEvent();
        }
    }

    public Paint getThermometerPaint() {
        return this.thermometerPaint;
    }

    public void setThermometerPaint(Paint paint) {
        if (paint != null) {
            this.thermometerPaint = paint;
            this.fireChangeEvent();
        }
    }

    public int getUnits() {
        return this.units;
    }

    public void setUnits(int n) {
        if (n >= 0 && n < UNITS.length && this.units != n) {
            this.units = n;
            this.fireChangeEvent();
        }
    }

    public void setUnits(String string) {
        if (string == null) {
            return;
        }
        string = string.toUpperCase().trim();
        for (int i = 0; i < UNITS.length; ++i) {
            if (!string.equals(UNITS[i].toUpperCase().trim())) continue;
            this.setUnits(i);
            i = UNITS.length;
        }
    }

    public int getValueLocation() {
        return this.valueLocation;
    }

    public void setValueLocation(int n) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("Location not recognised.");
        }
        this.valueLocation = n;
        this.fireChangeEvent();
    }

    public int getAxisLocation() {
        return this.axisLocation;
    }

    public void setAxisLocation(int n) {
        if (n < 0 || n >= 3) {
            throw new IllegalArgumentException("Location not recognised.");
        }
        this.axisLocation = n;
        this.fireChangeEvent();
    }

    public Font getValueFont() {
        return this.valueFont;
    }

    public void setValueFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        if (!this.valueFont.equals(font)) {
            this.valueFont = font;
            this.fireChangeEvent();
        }
    }

    public Paint getValuePaint() {
        return this.valuePaint;
    }

    public void setValuePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        if (!this.valuePaint.equals(paint)) {
            this.valuePaint = paint;
            this.fireChangeEvent();
        }
    }

    public void setValueFormat(NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new IllegalArgumentException("Null 'formatter' argument.");
        }
        this.valueFormat = numberFormat;
        this.fireChangeEvent();
    }

    public Paint getMercuryPaint() {
        return this.mercuryPaint;
    }

    public void setMercuryPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.mercuryPaint = paint;
        this.fireChangeEvent();
    }

    public boolean getShowValueLines() {
        return this.showValueLines;
    }

    public void setShowValueLines(boolean bl) {
        this.showValueLines = bl;
        this.fireChangeEvent();
    }

    public void setSubrangeInfo(int n, double d, double d2) {
        this.setSubrangeInfo(n, d, d2, d, d2);
    }

    public void setSubrangeInfo(int n, double d, double d2, double d3, double d4) {
        if (n >= 0 && n < 3) {
            this.setSubrange(n, d, d2);
            this.setDisplayRange(n, d3, d4);
            this.setAxisRange();
            this.fireChangeEvent();
        }
    }

    public void setSubrange(int n, double d, double d2) {
        if (n >= 0 && n < 3) {
            this.subrangeInfo[n][1] = d2;
            this.subrangeInfo[n][0] = d;
        }
    }

    public void setDisplayRange(int n, double d, double d2) {
        if (n >= 0 && n < this.subrangeInfo.length && ThermometerPlot.isValidNumber(d2) && ThermometerPlot.isValidNumber(d)) {
            if (d2 > d) {
                this.subrangeInfo[n][3] = d2;
                this.subrangeInfo[n][2] = d;
            } else {
                this.subrangeInfo[n][3] = d;
                this.subrangeInfo[n][2] = d2;
            }
        }
    }

    public Paint getSubrangePaint(int n) {
        if (n >= 0 && n < this.subrangePaint.length) {
            return this.subrangePaint[n];
        }
        return this.mercuryPaint;
    }

    public void setSubrangePaint(int n, Paint paint) {
        if (n >= 0 && n < this.subrangePaint.length && paint != null) {
            this.subrangePaint[n] = paint;
            this.fireChangeEvent();
        }
    }

    public boolean getFollowDataInSubranges() {
        return this.followDataInSubranges;
    }

    public void setFollowDataInSubranges(boolean bl) {
        this.followDataInSubranges = bl;
        this.fireChangeEvent();
    }

    public boolean getUseSubrangePaint() {
        return this.useSubrangePaint;
    }

    public void setUseSubrangePaint(boolean bl) {
        this.useSubrangePaint = bl;
        this.fireChangeEvent();
    }

    public int getBulbRadius() {
        return this.bulbRadius;
    }

    public void setBulbRadius(int n) {
        this.bulbRadius = n;
        this.fireChangeEvent();
    }

    public int getBulbDiameter() {
        return this.getBulbRadius() * 2;
    }

    public int getColumnRadius() {
        return this.columnRadius;
    }

    public void setColumnRadius(int n) {
        this.columnRadius = n;
        this.fireChangeEvent();
    }

    public int getColumnDiameter() {
        return this.getColumnRadius() * 2;
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int n) {
        this.gap = n;
        this.fireChangeEvent();
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double();
        RoundRectangle2D.Double double_2 = new RoundRectangle2D.Double();
        RoundRectangle2D.Double double_3 = new RoundRectangle2D.Double();
        Ellipse2D.Double double_4 = new Ellipse2D.Double();
        Ellipse2D.Double double_5 = new Ellipse2D.Double();
        String string = null;
        FontMetrics fontMetrics = null;
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        this.drawBackground(graphics2D, rectangle2D);
        Rectangle2D rectangle2D2 = (Rectangle2D)rectangle2D.clone();
        this.padding.trim(rectangle2D2);
        int n = (int)(rectangle2D2.getX() + rectangle2D2.getWidth() / 2.0);
        int n2 = (int)(rectangle2D2.getY() + rectangle2D2.getHeight() / 2.0);
        int n3 = (int)(rectangle2D2.getMinY() + (double)this.getBulbRadius());
        int n4 = (int)(rectangle2D2.getMaxY() - (double)this.getBulbDiameter());
        Rectangle2D.Double double_6 = new Rectangle2D.Double(n - this.getColumnRadius(), n3, this.getColumnRadius(), n4 - n3);
        ((RectangularShape)double_4).setFrame(n - this.getBulbRadius(), n4, this.getBulbDiameter(), this.getBulbDiameter());
        ((RoundRectangle2D)double_).setRoundRect(n - this.getColumnRadius(), rectangle2D2.getMinY(), this.getColumnDiameter(), n4 + this.getBulbDiameter() - n3, this.getColumnDiameter(), this.getColumnDiameter());
        Area area = new Area(double_4);
        Area area2 = new Area(double_);
        area.add(area2);
        ((RectangularShape)double_5).setFrame(n - this.getBulbRadius() + this.getGap(), n4 + this.getGap(), this.getBulbDiameter() - this.getGap() * 2, this.getBulbDiameter() - this.getGap() * 2);
        ((RoundRectangle2D)double_2).setRoundRect(n - this.getColumnRadius() + this.getGap(), rectangle2D2.getMinY() + (double)this.getGap(), this.getColumnDiameter() - this.getGap() * 2, n4 + this.getBulbDiameter() - this.getGap() * 2 - n3, this.getColumnDiameter() - this.getGap() * 2, this.getColumnDiameter() - this.getGap() * 2);
        Area area3 = new Area(double_5);
        area2 = new Area(double_2);
        area3.add(area2);
        if (this.dataset != null && this.dataset.getValue() != null) {
            Object object;
            double d = this.dataset.getValue().doubleValue();
            double d2 = this.rangeAxis.valueToJava2D(d, double_6, RectangleEdge.LEFT);
            int n5 = this.getColumnDiameter() - this.getGap() * 2;
            int n6 = this.getColumnRadius() - this.getGap();
            int n7 = n5 / 2;
            int n8 = (int)Math.round(d2);
            if ((double)n8 < (double)this.getGap() + rectangle2D2.getMinY()) {
                n8 = (int)((double)this.getGap() + rectangle2D2.getMinY());
                n7 = this.getBulbRadius();
            }
            Area area4 = new Area(double_5);
            if (n8 < n4 + this.getBulbRadius()) {
                ((RoundRectangle2D)double_3).setRoundRect(n - n6, n8, n5, n4 + this.getBulbRadius() - n8, n7, n7);
                area2 = new Area(double_3);
                area4.add(area2);
            }
            graphics2D.setPaint(this.getCurrentPaint());
            graphics2D.fill(area4);
            if (this.subrangeIndicatorsVisible) {
                Line2D.Double double_7;
                double d3;
                double d4;
                graphics2D.setStroke(this.subrangeIndicatorStroke);
                object = this.rangeAxis.getRange();
                double d5 = this.subrangeInfo[0][0];
                if (((Range)object).contains(d5)) {
                    d4 = n + this.getColumnRadius() + 2;
                    d3 = this.rangeAxis.valueToJava2D(d5, double_6, RectangleEdge.LEFT);
                    double_7 = new Line2D.Double(d4, d3, d4 + 10.0, d3);
                    graphics2D.setPaint(this.subrangePaint[0]);
                    graphics2D.draw(double_7);
                }
                if (((Range)object).contains(d5 = this.subrangeInfo[1][0])) {
                    d4 = n + this.getColumnRadius() + 2;
                    d3 = this.rangeAxis.valueToJava2D(d5, double_6, RectangleEdge.LEFT);
                    double_7 = new Line2D.Double(d4, d3, d4 + 10.0, d3);
                    graphics2D.setPaint(this.subrangePaint[1]);
                    graphics2D.draw(double_7);
                }
                if (((Range)object).contains(d5 = this.subrangeInfo[2][0])) {
                    d4 = n + this.getColumnRadius() + 2;
                    d3 = this.rangeAxis.valueToJava2D(d5, double_6, RectangleEdge.LEFT);
                    double_7 = new Line2D.Double(d4, d3, d4 + 10.0, d3);
                    graphics2D.setPaint(this.subrangePaint[2]);
                    graphics2D.draw(double_7);
                }
            }
            if (this.rangeAxis != null && this.axisLocation != 0) {
                int n9 = 10;
                if (this.showValueLines) {
                    n9 += this.getColumnDiameter();
                }
                double d6 = 0.0;
                switch (this.axisLocation) {
                    case 1: {
                        d6 = n + this.getColumnRadius();
                        Rectangle2D.Double double_8 = new Rectangle2D.Double(d6, n3, n9, n4 - n3 + 1);
                        this.rangeAxis.draw(graphics2D, d6, rectangle2D, double_8, RectangleEdge.RIGHT, null);
                        break;
                    }
                    default: {
                        d6 = n - this.getColumnRadius();
                        Rectangle2D.Double double_9 = new Rectangle2D.Double(d6, n3, n9, n4 - n3 + 1);
                        this.rangeAxis.draw(graphics2D, d6, rectangle2D, double_9, RectangleEdge.LEFT, null);
                    }
                }
            }
            graphics2D.setFont(this.valueFont);
            graphics2D.setPaint(this.valuePaint);
            fontMetrics = graphics2D.getFontMetrics();
            switch (this.valueLocation) {
                case 1: {
                    graphics2D.drawString(this.valueFormat.format(d), n + this.getColumnRadius() + this.getGap(), n2);
                    break;
                }
                case 2: {
                    object = this.valueFormat.format(d);
                    int n10 = fontMetrics.stringWidth((String)object);
                    graphics2D.drawString((String)object, n - this.getColumnRadius() - this.getGap() - n10, n2);
                    break;
                }
                case 3: {
                    string = this.valueFormat.format(d);
                    n5 = fontMetrics.stringWidth(string) / 2;
                    graphics2D.drawString(string, n - n5, n4 + this.getBulbRadius() + this.getGap());
                    break;
                }
            }
        }
        graphics2D.setPaint(this.thermometerPaint);
        graphics2D.setFont(this.valueFont);
        fontMetrics = graphics2D.getFontMetrics();
        int n11 = n - this.getColumnRadius() - this.getGap() * 2 - fontMetrics.stringWidth(UNITS[this.units]);
        if ((double)n11 > rectangle2D.getMinX()) {
            graphics2D.drawString(UNITS[this.units], n11, (int)(rectangle2D.getMinY() + 20.0));
        }
        graphics2D.setStroke(this.thermometerStroke);
        graphics2D.draw(area);
        graphics2D.draw(area3);
        this.drawOutline(graphics2D, rectangle2D);
    }

    public void zoom(double d) {
    }

    public String getPlotType() {
        return localizationResources.getString("Thermometer_Plot");
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        Number number;
        if (this.dataset != null && (number = this.dataset.getValue()) != null) {
            double d = number.doubleValue();
            this.subrange = this.inSubrange(0, d) ? 0 : (this.inSubrange(1, d) ? 1 : (this.inSubrange(2, d) ? 2 : -1));
            this.setAxisRange();
        }
        super.datasetChanged(datasetChangeEvent);
    }

    public Number getMinimumVerticalDataValue() {
        return new Double(this.lowerBound);
    }

    public Number getMaximumVerticalDataValue() {
        return new Double(this.upperBound);
    }

    public Range getDataRange(ValueAxis valueAxis) {
        return new Range(this.lowerBound, this.upperBound);
    }

    protected void setAxisRange() {
        if (this.subrange >= 0 && this.followDataInSubranges) {
            this.rangeAxis.setRange(new Range(this.subrangeInfo[this.subrange][2], this.subrangeInfo[this.subrange][3]));
        } else {
            this.rangeAxis.setRange(this.lowerBound, this.upperBound);
        }
    }

    public LegendItemCollection getLegendItems() {
        return null;
    }

    public PlotOrientation getOrientation() {
        return PlotOrientation.VERTICAL;
    }

    protected static boolean isValidNumber(double d) {
        return !Double.isNaN(d) && !Double.isInfinite(d);
    }

    private boolean inSubrange(int n, double d) {
        return d > this.subrangeInfo[n][0] && d <= this.subrangeInfo[n][1];
    }

    private Paint getCurrentPaint() {
        Paint paint = this.mercuryPaint;
        if (this.useSubrangePaint) {
            double d = this.dataset.getValue().doubleValue();
            if (this.inSubrange(0, d)) {
                paint = this.subrangePaint[0];
            } else if (this.inSubrange(1, d)) {
                paint = this.subrangePaint[1];
            } else if (this.inSubrange(2, d)) {
                paint = this.subrangePaint[2];
            }
        }
        return paint;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ThermometerPlot)) {
            return false;
        }
        ThermometerPlot thermometerPlot = (ThermometerPlot)object;
        if (!super.equals(object)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.rangeAxis, thermometerPlot.rangeAxis)) {
            return false;
        }
        if (this.axisLocation != thermometerPlot.axisLocation) {
            return false;
        }
        if (this.lowerBound != thermometerPlot.lowerBound) {
            return false;
        }
        if (this.upperBound != thermometerPlot.upperBound) {
            return false;
        }
        if (!ObjectUtilities.equal(this.padding, thermometerPlot.padding)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.thermometerStroke, thermometerPlot.thermometerStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.thermometerPaint, thermometerPlot.thermometerPaint)) {
            return false;
        }
        if (this.units != thermometerPlot.units) {
            return false;
        }
        if (this.valueLocation != thermometerPlot.valueLocation) {
            return false;
        }
        if (!ObjectUtilities.equal(this.valueFont, thermometerPlot.valueFont)) {
            return false;
        }
        if (!PaintUtilities.equal(this.valuePaint, thermometerPlot.valuePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.valueFormat, thermometerPlot.valueFormat)) {
            return false;
        }
        if (!PaintUtilities.equal(this.mercuryPaint, thermometerPlot.mercuryPaint)) {
            return false;
        }
        if (this.showValueLines != thermometerPlot.showValueLines) {
            return false;
        }
        if (this.subrange != thermometerPlot.subrange) {
            return false;
        }
        if (this.followDataInSubranges != thermometerPlot.followDataInSubranges) {
            return false;
        }
        if (!ThermometerPlot.equal(this.subrangeInfo, thermometerPlot.subrangeInfo)) {
            return false;
        }
        if (this.useSubrangePaint != thermometerPlot.useSubrangePaint) {
            return false;
        }
        if (this.bulbRadius != thermometerPlot.bulbRadius) {
            return false;
        }
        if (this.columnRadius != thermometerPlot.columnRadius) {
            return false;
        }
        if (this.gap != thermometerPlot.gap) {
            return false;
        }
        for (int i = 0; i < this.subrangePaint.length; ++i) {
            if (PaintUtilities.equal(this.subrangePaint[i], thermometerPlot.subrangePaint[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean equal(double[][] dArray, double[][] dArray2) {
        if (dArray == null) {
            return dArray2 == null;
        }
        if (dArray2 == null) {
            return false;
        }
        if (dArray.length != dArray2.length) {
            return false;
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (Arrays.equals(dArray[i], dArray2[i])) continue;
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        ThermometerPlot thermometerPlot = (ThermometerPlot)super.clone();
        if (thermometerPlot.dataset != null) {
            thermometerPlot.dataset.addChangeListener(thermometerPlot);
        }
        thermometerPlot.rangeAxis = (ValueAxis)ObjectUtilities.clone(this.rangeAxis);
        if (thermometerPlot.rangeAxis != null) {
            thermometerPlot.rangeAxis.setPlot(thermometerPlot);
            thermometerPlot.rangeAxis.addChangeListener(thermometerPlot);
        }
        thermometerPlot.valueFormat = (NumberFormat)this.valueFormat.clone();
        thermometerPlot.subrangePaint = (Paint[])this.subrangePaint.clone();
        return thermometerPlot;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeStroke(this.thermometerStroke, objectOutputStream);
        SerialUtilities.writePaint(this.thermometerPaint, objectOutputStream);
        SerialUtilities.writePaint(this.valuePaint, objectOutputStream);
        SerialUtilities.writePaint(this.mercuryPaint, objectOutputStream);
        SerialUtilities.writeStroke(this.subrangeIndicatorStroke, objectOutputStream);
        SerialUtilities.writeStroke(this.rangeIndicatorStroke, objectOutputStream);
        for (int i = 0; i < 3; ++i) {
            SerialUtilities.writePaint(this.subrangePaint[i], objectOutputStream);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.thermometerStroke = SerialUtilities.readStroke(objectInputStream);
        this.thermometerPaint = SerialUtilities.readPaint(objectInputStream);
        this.valuePaint = SerialUtilities.readPaint(objectInputStream);
        this.mercuryPaint = SerialUtilities.readPaint(objectInputStream);
        this.subrangeIndicatorStroke = SerialUtilities.readStroke(objectInputStream);
        this.rangeIndicatorStroke = SerialUtilities.readStroke(objectInputStream);
        this.subrangePaint = new Paint[3];
        for (int i = 0; i < 3; ++i) {
            this.subrangePaint[i] = SerialUtilities.readPaint(objectInputStream);
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.addChangeListener(this);
        }
    }

    public void zoomDomainAxes(double d, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
    }

    public void zoomDomainAxes(double d, PlotRenderingInfo plotRenderingInfo, Point2D point2D, boolean bl) {
    }

    public void zoomRangeAxes(double d, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        this.rangeAxis.resizeRange(d);
    }

    public void zoomRangeAxes(double d, PlotRenderingInfo plotRenderingInfo, Point2D point2D, boolean bl) {
        double d2 = this.getRangeAxis().java2DToValue(point2D.getY(), plotRenderingInfo.getDataArea(), RectangleEdge.LEFT);
        this.rangeAxis.resizeRange(d, d2);
    }

    public void zoomDomainAxes(double d, double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
    }

    public void zoomRangeAxes(double d, double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        this.rangeAxis.zoomRange(d, d2);
    }

    public boolean isDomainZoomable() {
        return false;
    }

    public boolean isRangeZoomable() {
        return true;
    }
}

