/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.plot;

import ai.org.jfree.chart.LegendItem;
import ai.org.jfree.chart.LegendItemCollection;
import ai.org.jfree.chart.entity.CategoryItemEntity;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.labels.CategoryItemLabelGenerator;
import ai.org.jfree.chart.labels.CategoryToolTipGenerator;
import ai.org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import ai.org.jfree.chart.plot.DrawingSupplier;
import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.PlotState;
import ai.org.jfree.chart.urls.CategoryURLGenerator;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.data.general.DatasetChangeEvent;
import ai.org.jfree.data.general.DatasetUtilities;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.ui.RectangleInsets;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PaintList;
import ai.org.jfree.util.PaintUtilities;
import ai.org.jfree.util.Rotation;
import ai.org.jfree.util.ShapeUtilities;
import ai.org.jfree.util.StrokeList;
import ai.org.jfree.util.TableOrder;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

public class SpiderWebPlot
extends Plot
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -5376340422031599463L;
    public static final double DEFAULT_HEAD = 0.01;
    public static final double DEFAULT_AXIS_LABEL_GAP = 0.1;
    public static final double DEFAULT_INTERIOR_GAP = 0.25;
    public static final double MAX_INTERIOR_GAP = 0.4;
    public static final double DEFAULT_START_ANGLE = 90.0;
    public static final Font DEFAULT_LABEL_FONT = new Font("SansSerif", 0, 10);
    public static final Paint DEFAULT_LABEL_PAINT = Color.black;
    public static final Paint DEFAULT_LABEL_BACKGROUND_PAINT = new Color(255, 255, 192);
    public static final Paint DEFAULT_LABEL_OUTLINE_PAINT = Color.black;
    public static final Stroke DEFAULT_LABEL_OUTLINE_STROKE = new BasicStroke(0.5f);
    public static final Paint DEFAULT_LABEL_SHADOW_PAINT = Color.lightGray;
    public static final double DEFAULT_MAX_VALUE = -1.0;
    protected double headPercent;
    private double interiorGap;
    private double axisLabelGap;
    private transient Paint axisLinePaint;
    private transient Stroke axisLineStroke;
    private CategoryDataset dataset;
    private double maxValue;
    private TableOrder dataExtractOrder;
    private double startAngle;
    private Rotation direction;
    private transient Shape legendItemShape;
    private transient Paint seriesPaint;
    private PaintList seriesPaintList;
    private transient Paint baseSeriesPaint;
    private transient Paint seriesOutlinePaint;
    private PaintList seriesOutlinePaintList;
    private transient Paint baseSeriesOutlinePaint;
    private transient Stroke seriesOutlineStroke;
    private StrokeList seriesOutlineStrokeList;
    private transient Stroke baseSeriesOutlineStroke;
    private Font labelFont;
    private transient Paint labelPaint;
    private CategoryItemLabelGenerator labelGenerator;
    private boolean webFilled = true;
    private CategoryToolTipGenerator toolTipGenerator;
    private CategoryURLGenerator urlGenerator;

    public SpiderWebPlot() {
        this(null);
    }

    public SpiderWebPlot(CategoryDataset categoryDataset) {
        this(categoryDataset, TableOrder.BY_ROW);
    }

    public SpiderWebPlot(CategoryDataset categoryDataset, TableOrder tableOrder) {
        if (tableOrder == null) {
            throw new IllegalArgumentException("Null 'extract' argument.");
        }
        this.dataset = categoryDataset;
        if (categoryDataset != null) {
            categoryDataset.addChangeListener(this);
        }
        this.dataExtractOrder = tableOrder;
        this.headPercent = 0.01;
        this.axisLabelGap = 0.1;
        this.axisLinePaint = Color.black;
        this.axisLineStroke = new BasicStroke(1.0f);
        this.interiorGap = 0.25;
        this.startAngle = 90.0;
        this.direction = Rotation.CLOCKWISE;
        this.maxValue = -1.0;
        this.seriesPaint = null;
        this.seriesPaintList = new PaintList();
        this.baseSeriesPaint = null;
        this.seriesOutlinePaint = null;
        this.seriesOutlinePaintList = new PaintList();
        this.baseSeriesOutlinePaint = DEFAULT_OUTLINE_PAINT;
        this.seriesOutlineStroke = null;
        this.seriesOutlineStrokeList = new StrokeList();
        this.baseSeriesOutlineStroke = DEFAULT_OUTLINE_STROKE;
        this.labelFont = DEFAULT_LABEL_FONT;
        this.labelPaint = DEFAULT_LABEL_PAINT;
        this.labelGenerator = new StandardCategoryItemLabelGenerator();
        this.legendItemShape = DEFAULT_LEGEND_ITEM_CIRCLE;
    }

    public String getPlotType() {
        return "Spider Web Plot";
    }

    public CategoryDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(CategoryDataset categoryDataset) {
        if (this.dataset != null) {
            this.dataset.removeChangeListener(this);
        }
        this.dataset = categoryDataset;
        if (categoryDataset != null) {
            this.setDatasetGroup(categoryDataset.getGroup());
            categoryDataset.addChangeListener(this);
        }
        this.datasetChanged(new DatasetChangeEvent(this, categoryDataset));
    }

    public boolean isWebFilled() {
        return this.webFilled;
    }

    public void setWebFilled(boolean bl) {
        this.webFilled = bl;
        this.fireChangeEvent();
    }

    public TableOrder getDataExtractOrder() {
        return this.dataExtractOrder;
    }

    public void setDataExtractOrder(TableOrder tableOrder) {
        if (tableOrder == null) {
            throw new IllegalArgumentException("Null 'order' argument");
        }
        this.dataExtractOrder = tableOrder;
        this.fireChangeEvent();
    }

    public double getHeadPercent() {
        return this.headPercent;
    }

    public void setHeadPercent(double d) {
        this.headPercent = d;
        this.fireChangeEvent();
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double d) {
        this.startAngle = d;
        this.fireChangeEvent();
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double d) {
        this.maxValue = d;
        this.fireChangeEvent();
    }

    public Rotation getDirection() {
        return this.direction;
    }

    public void setDirection(Rotation rotation) {
        if (rotation == null) {
            throw new IllegalArgumentException("Null 'direction' argument.");
        }
        this.direction = rotation;
        this.fireChangeEvent();
    }

    public double getInteriorGap() {
        return this.interiorGap;
    }

    public void setInteriorGap(double d) {
        if (d < 0.0 || d > 0.4) {
            throw new IllegalArgumentException("Percentage outside valid range.");
        }
        if (this.interiorGap != d) {
            this.interiorGap = d;
            this.fireChangeEvent();
        }
    }

    public double getAxisLabelGap() {
        return this.axisLabelGap;
    }

    public void setAxisLabelGap(double d) {
        this.axisLabelGap = d;
        this.fireChangeEvent();
    }

    public Paint getAxisLinePaint() {
        return this.axisLinePaint;
    }

    public void setAxisLinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.axisLinePaint = paint;
        this.fireChangeEvent();
    }

    public Stroke getAxisLineStroke() {
        return this.axisLineStroke;
    }

    public void setAxisLineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.axisLineStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getSeriesPaint() {
        return this.seriesPaint;
    }

    public void setSeriesPaint(Paint paint) {
        this.seriesPaint = paint;
        this.fireChangeEvent();
    }

    public Paint getSeriesPaint(int n) {
        if (this.seriesPaint != null) {
            return this.seriesPaint;
        }
        Paint paint = this.seriesPaintList.getPaint(n);
        if (paint == null) {
            DrawingSupplier drawingSupplier = this.getDrawingSupplier();
            if (drawingSupplier != null) {
                Paint paint2 = drawingSupplier.getNextPaint();
                this.seriesPaintList.setPaint(n, paint2);
                paint = paint2;
            } else {
                paint = this.baseSeriesPaint;
            }
        }
        return paint;
    }

    public void setSeriesPaint(int n, Paint paint) {
        this.seriesPaintList.setPaint(n, paint);
        this.fireChangeEvent();
    }

    public Paint getBaseSeriesPaint() {
        return this.baseSeriesPaint;
    }

    public void setBaseSeriesPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.baseSeriesPaint = paint;
        this.fireChangeEvent();
    }

    public Paint getSeriesOutlinePaint() {
        return this.seriesOutlinePaint;
    }

    public void setSeriesOutlinePaint(Paint paint) {
        this.seriesOutlinePaint = paint;
        this.fireChangeEvent();
    }

    public Paint getSeriesOutlinePaint(int n) {
        if (this.seriesOutlinePaint != null) {
            return this.seriesOutlinePaint;
        }
        Paint paint = this.seriesOutlinePaintList.getPaint(n);
        if (paint == null) {
            paint = this.baseSeriesOutlinePaint;
        }
        return paint;
    }

    public void setSeriesOutlinePaint(int n, Paint paint) {
        this.seriesOutlinePaintList.setPaint(n, paint);
        this.fireChangeEvent();
    }

    public Paint getBaseSeriesOutlinePaint() {
        return this.baseSeriesOutlinePaint;
    }

    public void setBaseSeriesOutlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.baseSeriesOutlinePaint = paint;
        this.fireChangeEvent();
    }

    public Stroke getSeriesOutlineStroke() {
        return this.seriesOutlineStroke;
    }

    public void setSeriesOutlineStroke(Stroke stroke) {
        this.seriesOutlineStroke = stroke;
        this.fireChangeEvent();
    }

    public Stroke getSeriesOutlineStroke(int n) {
        if (this.seriesOutlineStroke != null) {
            return this.seriesOutlineStroke;
        }
        Stroke stroke = this.seriesOutlineStrokeList.getStroke(n);
        if (stroke == null) {
            stroke = this.baseSeriesOutlineStroke;
        }
        return stroke;
    }

    public void setSeriesOutlineStroke(int n, Stroke stroke) {
        this.seriesOutlineStrokeList.setStroke(n, stroke);
        this.fireChangeEvent();
    }

    public Stroke getBaseSeriesOutlineStroke() {
        return this.baseSeriesOutlineStroke;
    }

    public void setBaseSeriesOutlineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.baseSeriesOutlineStroke = stroke;
        this.fireChangeEvent();
    }

    public Shape getLegendItemShape() {
        return this.legendItemShape;
    }

    public void setLegendItemShape(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        this.legendItemShape = shape;
        this.fireChangeEvent();
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.labelFont = font;
        this.fireChangeEvent();
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public void setLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.labelPaint = paint;
        this.fireChangeEvent();
    }

    public CategoryItemLabelGenerator getLabelGenerator() {
        return this.labelGenerator;
    }

    public void setLabelGenerator(CategoryItemLabelGenerator categoryItemLabelGenerator) {
        if (categoryItemLabelGenerator == null) {
            throw new IllegalArgumentException("Null 'generator' argument.");
        }
        this.labelGenerator = categoryItemLabelGenerator;
    }

    public CategoryToolTipGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    public void setToolTipGenerator(CategoryToolTipGenerator categoryToolTipGenerator) {
        this.toolTipGenerator = categoryToolTipGenerator;
        this.fireChangeEvent();
    }

    public CategoryURLGenerator getURLGenerator() {
        return this.urlGenerator;
    }

    public void setURLGenerator(CategoryURLGenerator categoryURLGenerator) {
        this.urlGenerator = categoryURLGenerator;
        this.fireChangeEvent();
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        if (this.getDataset() == null) {
            return legendItemCollection;
        }
        List list = null;
        if (this.dataExtractOrder == TableOrder.BY_ROW) {
            list = this.dataset.getRowKeys();
        } else if (this.dataExtractOrder == TableOrder.BY_COLUMN) {
            list = this.dataset.getColumnKeys();
        }
        if (list == null) {
            return legendItemCollection;
        }
        int n = 0;
        Iterator iterator = list.iterator();
        Shape shape = this.getLegendItemShape();
        while (iterator.hasNext()) {
            String string;
            Comparable comparable = (Comparable)iterator.next();
            String string2 = string = comparable.toString();
            Paint paint = this.getSeriesPaint(n);
            Paint paint2 = this.getSeriesOutlinePaint(n);
            Stroke stroke = this.getSeriesOutlineStroke(n);
            LegendItem legendItem = new LegendItem(string, string2, null, null, shape, paint, stroke, paint2);
            legendItem.setDataset(this.getDataset());
            legendItem.setSeriesKey(comparable);
            legendItem.setSeriesIndex(n);
            legendItemCollection.add(legendItem);
            ++n;
        }
        return legendItemCollection;
    }

    protected Point2D getWebPoint(Rectangle2D rectangle2D, double d, double d2) {
        double d3 = Math.toRadians(d);
        double d4 = Math.cos(d3) * d2 * rectangle2D.getWidth() / 2.0;
        double d5 = -Math.sin(d3) * d2 * rectangle2D.getHeight() / 2.0;
        return new Point2D.Double(rectangle2D.getX() + d4 + rectangle2D.getWidth() / 2.0, rectangle2D.getY() + d5 + rectangle2D.getHeight() / 2.0);
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
            plotRenderingInfo.setDataArea(rectangle2D);
        }
        this.drawBackground(graphics2D, rectangle2D);
        this.drawOutline(graphics2D, rectangle2D);
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D);
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        if (!DatasetUtilities.isEmptyOrNull(this.dataset)) {
            int n;
            int n2 = 0;
            int n3 = 0;
            if (this.dataExtractOrder == TableOrder.BY_ROW) {
                n2 = this.dataset.getRowCount();
                n3 = this.dataset.getColumnCount();
            } else {
                n2 = this.dataset.getColumnCount();
                n3 = this.dataset.getRowCount();
            }
            if (this.maxValue == -1.0) {
                this.calculateMaxValue(n2, n3);
            }
            double d = rectangle2D.getWidth() * this.getInteriorGap();
            double d2 = rectangle2D.getHeight() * this.getInteriorGap();
            double d3 = rectangle2D.getX() + d / 2.0;
            double d4 = rectangle2D.getY() + d2 / 2.0;
            double d5 = rectangle2D.getWidth() - d;
            double d6 = rectangle2D.getHeight() - d2;
            double d7 = rectangle2D.getWidth() * this.headPercent;
            double d8 = rectangle2D.getHeight() * this.headPercent;
            double d9 = Math.min(d5, d6) / 2.0;
            d3 = (d3 + d3 + d5) / 2.0 - d9;
            d4 = (d4 + d4 + d6) / 2.0 - d9;
            d5 = 2.0 * d9;
            d6 = 2.0 * d9;
            Point2D.Double double_ = new Point2D.Double(d3 + d5 / 2.0, d4 + d6 / 2.0);
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d3, d4, d5, d6);
            for (n = 0; n < n3; ++n) {
                double d10 = this.getStartAngle() + this.getDirection().getFactor() * (double)n * 360.0 / (double)n3;
                Point2D point2D2 = this.getWebPoint(double_2, d10, 1.0);
                Line2D.Double double_3 = new Line2D.Double(double_, point2D2);
                graphics2D.setPaint(this.axisLinePaint);
                graphics2D.setStroke(this.axisLineStroke);
                graphics2D.draw(double_3);
                this.drawLabel(graphics2D, double_2, 0.0, n, d10, 360.0 / (double)n3);
            }
            for (n = 0; n < n2; ++n) {
                this.drawRadarPoly(graphics2D, double_2, double_, plotRenderingInfo, n, n3, d8, d7);
            }
        } else {
            this.drawNoDataMessage(graphics2D, rectangle2D);
        }
        graphics2D.setClip(shape);
        graphics2D.setComposite(composite);
        this.drawOutline(graphics2D, rectangle2D);
    }

    private void calculateMaxValue(int n, int n2) {
        double d = 0.0;
        Number number = null;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                number = this.getPlotValue(i, j);
                if (number == null || !((d = number.doubleValue()) > this.maxValue)) continue;
                this.maxValue = d;
            }
        }
    }

    protected void drawRadarPoly(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotRenderingInfo plotRenderingInfo, int n, int n2, double d, double d2) {
        Polygon polygon = new Polygon();
        EntityCollection entityCollection = null;
        if (plotRenderingInfo != null) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        for (int i = 0; i < n2; ++i) {
            double d3;
            Number number = this.getPlotValue(n, i);
            if (number == null || !((d3 = number.doubleValue()) >= 0.0)) continue;
            double d4 = this.getStartAngle() + this.getDirection().getFactor() * (double)i * 360.0 / (double)n2;
            Point2D point2D2 = this.getWebPoint(rectangle2D, d4, d3 / this.maxValue);
            polygon.addPoint((int)point2D2.getX(), (int)point2D2.getY());
            Paint paint = this.getSeriesPaint(n);
            Paint paint2 = this.getSeriesOutlinePaint(n);
            Stroke stroke = this.getSeriesOutlineStroke(n);
            Ellipse2D.Double double_ = new Ellipse2D.Double(point2D2.getX() - d2 / 2.0, point2D2.getY() - d / 2.0, d2, d);
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint2);
            graphics2D.draw(double_);
            if (entityCollection == null) continue;
            int n3 = 0;
            int n4 = 0;
            if (this.dataExtractOrder == TableOrder.BY_ROW) {
                n3 = n;
                n4 = i;
            } else {
                n3 = i;
                n4 = n;
            }
            String string = null;
            if (this.toolTipGenerator != null) {
                string = this.toolTipGenerator.generateToolTip(this.dataset, n3, n4);
            }
            String string2 = null;
            if (this.urlGenerator != null) {
                string2 = this.urlGenerator.generateURL(this.dataset, n3, n4);
            }
            Rectangle rectangle = new Rectangle((int)(point2D2.getX() - d2), (int)(point2D2.getY() - d), (int)(d2 * 2.0), (int)(d * 2.0));
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity(rectangle, string, string2, this.dataset, this.dataset.getRowKey(n3), this.dataset.getColumnKey(n4));
            entityCollection.add(categoryItemEntity);
        }
        Paint paint = this.getSeriesPaint(n);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(this.getSeriesOutlineStroke(n));
        graphics2D.draw(polygon);
        if (this.webFilled) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.1f));
            graphics2D.fill(polygon);
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        }
    }

    protected Number getPlotValue(int n, int n2) {
        Number number = null;
        if (this.dataExtractOrder == TableOrder.BY_ROW) {
            number = this.dataset.getValue(n, n2);
        } else if (this.dataExtractOrder == TableOrder.BY_COLUMN) {
            number = this.dataset.getValue(n2, n);
        }
        return number;
    }

    protected void drawLabel(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, int n, double d2, double d3) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        String string = null;
        string = this.dataExtractOrder == TableOrder.BY_ROW ? this.labelGenerator.generateColumnLabel(this.dataset, n) : this.labelGenerator.generateRowLabel(this.dataset, n);
        Rectangle2D rectangle2D2 = this.getLabelFont().getStringBounds(string, fontRenderContext);
        LineMetrics lineMetrics = this.getLabelFont().getLineMetrics(string, fontRenderContext);
        double d4 = lineMetrics.getAscent();
        Point2D point2D = this.calculateLabelLocation(rectangle2D2, d4, rectangle2D, d2);
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        graphics2D.setPaint(this.getLabelPaint());
        graphics2D.setFont(this.getLabelFont());
        graphics2D.drawString(string, (float)point2D.getX(), (float)point2D.getY());
        graphics2D.setComposite(composite);
    }

    protected Point2D calculateLabelLocation(Rectangle2D rectangle2D, double d, Rectangle2D rectangle2D2, double d2) {
        Arc2D.Double double_ = new Arc2D.Double(rectangle2D2, d2, 0.0, 0);
        Point2D point2D = double_.getEndPoint();
        double d3 = -(point2D.getX() - rectangle2D2.getCenterX()) * this.axisLabelGap;
        double d4 = -(point2D.getY() - rectangle2D2.getCenterY()) * this.axisLabelGap;
        double d5 = point2D.getX() - d3;
        double d6 = point2D.getY() - d4;
        if (d5 < rectangle2D2.getCenterX()) {
            d5 -= rectangle2D.getWidth();
        }
        if (d5 == rectangle2D2.getCenterX()) {
            d5 -= rectangle2D.getWidth() / 2.0;
        }
        if (d6 > rectangle2D2.getCenterY()) {
            d6 += d;
        }
        return new Point2D.Double(d5, d6);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SpiderWebPlot)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        SpiderWebPlot spiderWebPlot = (SpiderWebPlot)object;
        if (!this.dataExtractOrder.equals(spiderWebPlot.dataExtractOrder)) {
            return false;
        }
        if (this.headPercent != spiderWebPlot.headPercent) {
            return false;
        }
        if (this.interiorGap != spiderWebPlot.interiorGap) {
            return false;
        }
        if (this.startAngle != spiderWebPlot.startAngle) {
            return false;
        }
        if (!this.direction.equals(spiderWebPlot.direction)) {
            return false;
        }
        if (this.maxValue != spiderWebPlot.maxValue) {
            return false;
        }
        if (this.webFilled != spiderWebPlot.webFilled) {
            return false;
        }
        if (this.axisLabelGap != spiderWebPlot.axisLabelGap) {
            return false;
        }
        if (!PaintUtilities.equal(this.axisLinePaint, spiderWebPlot.axisLinePaint)) {
            return false;
        }
        if (!this.axisLineStroke.equals(spiderWebPlot.axisLineStroke)) {
            return false;
        }
        if (!ShapeUtilities.equal(this.legendItemShape, spiderWebPlot.legendItemShape)) {
            return false;
        }
        if (!PaintUtilities.equal(this.seriesPaint, spiderWebPlot.seriesPaint)) {
            return false;
        }
        if (!this.seriesPaintList.equals(spiderWebPlot.seriesPaintList)) {
            return false;
        }
        if (!PaintUtilities.equal(this.baseSeriesPaint, spiderWebPlot.baseSeriesPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.seriesOutlinePaint, spiderWebPlot.seriesOutlinePaint)) {
            return false;
        }
        if (!this.seriesOutlinePaintList.equals(spiderWebPlot.seriesOutlinePaintList)) {
            return false;
        }
        if (!PaintUtilities.equal(this.baseSeriesOutlinePaint, spiderWebPlot.baseSeriesOutlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.seriesOutlineStroke, spiderWebPlot.seriesOutlineStroke)) {
            return false;
        }
        if (!this.seriesOutlineStrokeList.equals(spiderWebPlot.seriesOutlineStrokeList)) {
            return false;
        }
        if (!this.baseSeriesOutlineStroke.equals(spiderWebPlot.baseSeriesOutlineStroke)) {
            return false;
        }
        if (!this.labelFont.equals(spiderWebPlot.labelFont)) {
            return false;
        }
        if (!PaintUtilities.equal(this.labelPaint, spiderWebPlot.labelPaint)) {
            return false;
        }
        if (!this.labelGenerator.equals(spiderWebPlot.labelGenerator)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.toolTipGenerator, spiderWebPlot.toolTipGenerator)) {
            return false;
        }
        return ObjectUtilities.equal(this.urlGenerator, spiderWebPlot.urlGenerator);
    }

    public Object clone() throws CloneNotSupportedException {
        SpiderWebPlot spiderWebPlot = (SpiderWebPlot)super.clone();
        spiderWebPlot.legendItemShape = ShapeUtilities.clone(this.legendItemShape);
        spiderWebPlot.seriesPaintList = (PaintList)this.seriesPaintList.clone();
        spiderWebPlot.seriesOutlinePaintList = (PaintList)this.seriesOutlinePaintList.clone();
        spiderWebPlot.seriesOutlineStrokeList = (StrokeList)this.seriesOutlineStrokeList.clone();
        return spiderWebPlot;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.legendItemShape, objectOutputStream);
        SerialUtilities.writePaint(this.seriesPaint, objectOutputStream);
        SerialUtilities.writePaint(this.baseSeriesPaint, objectOutputStream);
        SerialUtilities.writePaint(this.seriesOutlinePaint, objectOutputStream);
        SerialUtilities.writePaint(this.baseSeriesOutlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.seriesOutlineStroke, objectOutputStream);
        SerialUtilities.writeStroke(this.baseSeriesOutlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.labelPaint, objectOutputStream);
        SerialUtilities.writePaint(this.axisLinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.axisLineStroke, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.legendItemShape = SerialUtilities.readShape(objectInputStream);
        this.seriesPaint = SerialUtilities.readPaint(objectInputStream);
        this.baseSeriesPaint = SerialUtilities.readPaint(objectInputStream);
        this.seriesOutlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.baseSeriesOutlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.seriesOutlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.baseSeriesOutlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.labelPaint = SerialUtilities.readPaint(objectInputStream);
        this.axisLinePaint = SerialUtilities.readPaint(objectInputStream);
        this.axisLineStroke = SerialUtilities.readStroke(objectInputStream);
        if (this.dataset != null) {
            this.dataset.addChangeListener(this);
        }
    }
}

