/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.plot;

import ai.org.jfree.chart.ChartRenderingInfo;
import ai.org.jfree.chart.JFreeChart;
import ai.org.jfree.chart.LegendItem;
import ai.org.jfree.chart.LegendItemCollection;
import ai.org.jfree.chart.plot.PiePlot;
import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.PlotState;
import ai.org.jfree.chart.title.TextTitle;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.data.category.CategoryToPieDataset;
import ai.org.jfree.data.general.DatasetChangeEvent;
import ai.org.jfree.data.general.DatasetUtilities;
import ai.org.jfree.data.general.PieDataset;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.ui.RectangleInsets;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PaintUtilities;
import ai.org.jfree.util.ShapeUtilities;
import ai.org.jfree.util.TableOrder;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiplePiePlot
extends Plot
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -355377800470807389L;
    private JFreeChart pieChart;
    private CategoryDataset dataset;
    private TableOrder dataExtractOrder;
    private double limit = 0.0;
    private Comparable aggregatedItemsKey;
    private transient Paint aggregatedItemsPaint;
    private transient Map sectionPaints;
    private transient Shape legendItemShape;

    public MultiplePiePlot() {
        this(null);
    }

    public MultiplePiePlot(CategoryDataset categoryDataset) {
        this.setDataset(categoryDataset);
        PiePlot piePlot = new PiePlot(null);
        piePlot.setIgnoreNullValues(true);
        this.pieChart = new JFreeChart(piePlot);
        this.pieChart.removeLegend();
        this.dataExtractOrder = TableOrder.BY_COLUMN;
        this.pieChart.setBackgroundPaint(null);
        TextTitle textTitle = new TextTitle("Series Title", new Font("SansSerif", 1, 12));
        textTitle.setPosition(RectangleEdge.BOTTOM);
        this.pieChart.setTitle(textTitle);
        this.aggregatedItemsKey = "Other";
        this.aggregatedItemsPaint = Color.lightGray;
        this.sectionPaints = new HashMap();
        this.legendItemShape = new Ellipse2D.Double(-4.0, -4.0, 8.0, 8.0);
    }

    public CategoryDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(CategoryDataset categoryDataset) {
        if (this.dataset != null) {
            this.dataset.removeChangeListener(this);
        }
        this.dataset = categoryDataset;
        if (categoryDataset != null) {
            this.setDatasetGroup(categoryDataset.getGroup());
            categoryDataset.addChangeListener(this);
        }
        this.datasetChanged(new DatasetChangeEvent(this, categoryDataset));
    }

    public JFreeChart getPieChart() {
        return this.pieChart;
    }

    public void setPieChart(JFreeChart jFreeChart) {
        if (jFreeChart == null) {
            throw new IllegalArgumentException("Null 'pieChart' argument.");
        }
        if (!(jFreeChart.getPlot() instanceof PiePlot)) {
            throw new IllegalArgumentException("The 'pieChart' argument must be a chart based on a PiePlot.");
        }
        this.pieChart = jFreeChart;
        this.fireChangeEvent();
    }

    public TableOrder getDataExtractOrder() {
        return this.dataExtractOrder;
    }

    public void setDataExtractOrder(TableOrder tableOrder) {
        if (tableOrder == null) {
            throw new IllegalArgumentException("Null 'order' argument");
        }
        this.dataExtractOrder = tableOrder;
        this.fireChangeEvent();
    }

    public double getLimit() {
        return this.limit;
    }

    public void setLimit(double d) {
        this.limit = d;
        this.fireChangeEvent();
    }

    public Comparable getAggregatedItemsKey() {
        return this.aggregatedItemsKey;
    }

    public void setAggregatedItemsKey(Comparable comparable) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        this.aggregatedItemsKey = comparable;
        this.fireChangeEvent();
    }

    public Paint getAggregatedItemsPaint() {
        return this.aggregatedItemsPaint;
    }

    public void setAggregatedItemsPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.aggregatedItemsPaint = paint;
        this.fireChangeEvent();
    }

    public String getPlotType() {
        return "Multiple Pie Plot";
    }

    public Shape getLegendItemShape() {
        return this.legendItemShape;
    }

    public void setLegendItemShape(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        this.legendItemShape = shape;
        this.fireChangeEvent();
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        int n;
        int n2;
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        this.drawBackground(graphics2D, rectangle2D);
        this.drawOutline(graphics2D, rectangle2D);
        if (DatasetUtilities.isEmptyOrNull(this.dataset)) {
            this.drawNoDataMessage(graphics2D, rectangle2D);
            return;
        }
        int n3 = 0;
        n3 = this.dataExtractOrder == TableOrder.BY_ROW ? this.dataset.getRowCount() : this.dataset.getColumnCount();
        int n4 = (int)Math.ceil(Math.sqrt(n3));
        if (n4 > (n2 = (int)Math.ceil((double)n3 / (double)n4)) && rectangle2D.getWidth() < rectangle2D.getHeight()) {
            n = n4;
            n4 = n2;
            n2 = n;
        }
        this.prefetchSectionPaints();
        n = (int)rectangle2D.getX();
        int n5 = (int)rectangle2D.getY();
        int n6 = (int)rectangle2D.getWidth() / n4;
        int n7 = (int)rectangle2D.getHeight() / n2;
        int n8 = 0;
        int n9 = 0;
        int n10 = n2 * n4 - n3;
        int n11 = 0;
        Rectangle rectangle = new Rectangle();
        for (int i = 0; i < n3; ++i) {
            rectangle.setBounds(n + n11 + n6 * n9, n5 + n7 * n8, n6, n7);
            String string = null;
            string = this.dataExtractOrder == TableOrder.BY_ROW ? this.dataset.getRowKey(i).toString() : this.dataset.getColumnKey(i).toString();
            this.pieChart.setTitle(string);
            PieDataset pieDataset = null;
            CategoryToPieDataset categoryToPieDataset = new CategoryToPieDataset(this.dataset, this.dataExtractOrder, i);
            pieDataset = this.limit > 0.0 ? DatasetUtilities.createConsolidatedPieDataset(categoryToPieDataset, this.aggregatedItemsKey, this.limit) : categoryToPieDataset;
            PiePlot piePlot = (PiePlot)this.pieChart.getPlot();
            piePlot.setDataset(pieDataset);
            piePlot.setPieIndex(i);
            for (int j = 0; j < pieDataset.getItemCount(); ++j) {
                Comparable comparable = pieDataset.getKey(j);
                Paint paint = comparable.equals(this.aggregatedItemsKey) ? this.aggregatedItemsPaint : (Paint)this.sectionPaints.get(comparable);
                piePlot.setSectionPaint(comparable, paint);
            }
            ChartRenderingInfo chartRenderingInfo = null;
            if (plotRenderingInfo != null) {
                chartRenderingInfo = new ChartRenderingInfo();
            }
            this.pieChart.draw(graphics2D, rectangle, chartRenderingInfo);
            if (plotRenderingInfo != null) {
                plotRenderingInfo.getOwner().getEntityCollection().addAll(chartRenderingInfo.getEntityCollection());
                plotRenderingInfo.addSubplotInfo(chartRenderingInfo.getPlotInfo());
            }
            if (++n9 != n4) continue;
            n9 = 0;
            if (++n8 != n2 - 1 || n10 == 0) continue;
            n11 = n10 * n6 / 2;
        }
    }

    private void prefetchSectionPaints() {
        PiePlot piePlot = (PiePlot)this.getPieChart().getPlot();
        if (this.dataExtractOrder == TableOrder.BY_ROW) {
            for (int i = 0; i < this.dataset.getColumnCount(); ++i) {
                Comparable comparable = this.dataset.getColumnKey(i);
                Paint paint = piePlot.getSectionPaint(comparable);
                if (paint == null && (paint = (Paint)this.sectionPaints.get(comparable)) == null) {
                    paint = this.getDrawingSupplier().getNextPaint();
                }
                this.sectionPaints.put(comparable, paint);
            }
        } else {
            for (int i = 0; i < this.dataset.getRowCount(); ++i) {
                Comparable comparable = this.dataset.getRowKey(i);
                Paint paint = piePlot.getSectionPaint(comparable);
                if (paint == null && (paint = (Paint)this.sectionPaints.get(comparable)) == null) {
                    paint = this.getDrawingSupplier().getNextPaint();
                }
                this.sectionPaints.put(comparable, paint);
            }
        }
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        if (this.dataset == null) {
            return legendItemCollection;
        }
        List list = null;
        this.prefetchSectionPaints();
        if (this.dataExtractOrder == TableOrder.BY_ROW) {
            list = this.dataset.getColumnKeys();
        } else if (this.dataExtractOrder == TableOrder.BY_COLUMN) {
            list = this.dataset.getRowKeys();
        }
        if (list == null) {
            return legendItemCollection;
        }
        int n = 0;
        for (Object object : list) {
            String string;
            String string2 = string = object.toString();
            Paint paint = (Paint)this.sectionPaints.get(object);
            LegendItem legendItem = new LegendItem(string, string2, null, null, this.getLegendItemShape(), paint, Plot.DEFAULT_OUTLINE_STROKE, paint);
            legendItem.setSeriesKey((Comparable)object);
            legendItem.setSeriesIndex(n);
            legendItem.setDataset(this.getDataset());
            legendItemCollection.add(legendItem);
            ++n;
        }
        if (this.limit > 0.0) {
            Object object;
            object = new LegendItem(this.aggregatedItemsKey.toString(), this.aggregatedItemsKey.toString(), null, null, this.getLegendItemShape(), this.aggregatedItemsPaint, Plot.DEFAULT_OUTLINE_STROKE, this.aggregatedItemsPaint);
            legendItemCollection.add((LegendItem)object);
        }
        return legendItemCollection;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MultiplePiePlot)) {
            return false;
        }
        MultiplePiePlot multiplePiePlot = (MultiplePiePlot)object;
        if (this.dataExtractOrder != multiplePiePlot.dataExtractOrder) {
            return false;
        }
        if (this.limit != multiplePiePlot.limit) {
            return false;
        }
        if (!this.aggregatedItemsKey.equals(multiplePiePlot.aggregatedItemsKey)) {
            return false;
        }
        if (!PaintUtilities.equal(this.aggregatedItemsPaint, multiplePiePlot.aggregatedItemsPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.pieChart, multiplePiePlot.pieChart)) {
            return false;
        }
        if (!ShapeUtilities.equal(this.legendItemShape, multiplePiePlot.legendItemShape)) {
            return false;
        }
        return super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        MultiplePiePlot multiplePiePlot = (MultiplePiePlot)super.clone();
        multiplePiePlot.pieChart = (JFreeChart)this.pieChart.clone();
        multiplePiePlot.sectionPaints = new HashMap(this.sectionPaints);
        multiplePiePlot.legendItemShape = ShapeUtilities.clone(this.legendItemShape);
        return multiplePiePlot;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.aggregatedItemsPaint, objectOutputStream);
        SerialUtilities.writeShape(this.legendItemShape, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.aggregatedItemsPaint = SerialUtilities.readPaint(objectInputStream);
        this.legendItemShape = SerialUtilities.readShape(objectInputStream);
        this.sectionPaints = new HashMap();
    }
}

