/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.plot;

import ai.org.jfree.chart.event.MarkerChangeEvent;
import ai.org.jfree.chart.event.MarkerChangeListener;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.ui.LengthAdjustmentType;
import ai.org.jfree.ui.RectangleAnchor;
import ai.org.jfree.ui.RectangleInsets;
import ai.org.jfree.ui.TextAnchor;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PaintUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public abstract class Marker
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -734389651405327166L;
    private transient Paint paint;
    private transient Stroke stroke;
    private transient Paint outlinePaint;
    private transient Stroke outlineStroke;
    private float alpha;
    private String label = null;
    private Font labelFont;
    private transient Paint labelPaint;
    private RectangleAnchor labelAnchor;
    private TextAnchor labelTextAnchor;
    private RectangleInsets labelOffset;
    private LengthAdjustmentType labelOffsetType;
    private transient EventListenerList listenerList;

    protected Marker() {
        this(Color.gray);
    }

    protected Marker(Paint paint) {
        this(paint, new BasicStroke(0.5f), Color.gray, new BasicStroke(0.5f), 0.8f);
    }

    protected Marker(Paint paint, Stroke stroke, Paint paint2, Stroke stroke2, float f) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("The 'alpha' value must be in the range 0.0f to 1.0f");
        }
        this.paint = paint;
        this.stroke = stroke;
        this.outlinePaint = paint2;
        this.outlineStroke = stroke2;
        this.alpha = f;
        this.labelFont = new Font("SansSerif", 0, 9);
        this.labelPaint = Color.black;
        this.labelAnchor = RectangleAnchor.TOP_LEFT;
        this.labelOffset = new RectangleInsets(3.0, 3.0, 3.0, 3.0);
        this.labelOffsetType = LengthAdjustmentType.CONTRACT;
        this.labelTextAnchor = TextAnchor.CENTER;
        this.listenerList = new EventListenerList();
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.paint = paint;
        this.notifyListeners(new MarkerChangeEvent(this));
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.stroke = stroke;
        this.notifyListeners(new MarkerChangeEvent(this));
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        this.outlinePaint = paint;
        this.notifyListeners(new MarkerChangeEvent(this));
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        this.outlineStroke = stroke;
        this.notifyListeners(new MarkerChangeEvent(this));
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("The 'alpha' value must be in the range 0.0f to 1.0f");
        }
        this.alpha = f;
        this.notifyListeners(new MarkerChangeEvent(this));
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
        this.notifyListeners(new MarkerChangeEvent(this));
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.labelFont = font;
        this.notifyListeners(new MarkerChangeEvent(this));
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public void setLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.labelPaint = paint;
        this.notifyListeners(new MarkerChangeEvent(this));
    }

    public RectangleAnchor getLabelAnchor() {
        return this.labelAnchor;
    }

    public void setLabelAnchor(RectangleAnchor rectangleAnchor) {
        if (rectangleAnchor == null) {
            throw new IllegalArgumentException("Null 'anchor' argument.");
        }
        this.labelAnchor = rectangleAnchor;
        this.notifyListeners(new MarkerChangeEvent(this));
    }

    public RectangleInsets getLabelOffset() {
        return this.labelOffset;
    }

    public void setLabelOffset(RectangleInsets rectangleInsets) {
        if (rectangleInsets == null) {
            throw new IllegalArgumentException("Null 'offset' argument.");
        }
        this.labelOffset = rectangleInsets;
        this.notifyListeners(new MarkerChangeEvent(this));
    }

    public LengthAdjustmentType getLabelOffsetType() {
        return this.labelOffsetType;
    }

    public void setLabelOffsetType(LengthAdjustmentType lengthAdjustmentType) {
        if (lengthAdjustmentType == null) {
            throw new IllegalArgumentException("Null 'adj' argument.");
        }
        this.labelOffsetType = lengthAdjustmentType;
        this.notifyListeners(new MarkerChangeEvent(this));
    }

    public TextAnchor getLabelTextAnchor() {
        return this.labelTextAnchor;
    }

    public void setLabelTextAnchor(TextAnchor textAnchor) {
        if (textAnchor == null) {
            throw new IllegalArgumentException("Null 'anchor' argument.");
        }
        this.labelTextAnchor = textAnchor;
        this.notifyListeners(new MarkerChangeEvent(this));
    }

    public void addChangeListener(MarkerChangeListener markerChangeListener) {
        this.listenerList.add(MarkerChangeListener.class, markerChangeListener);
    }

    public void removeChangeListener(MarkerChangeListener markerChangeListener) {
        this.listenerList.remove(MarkerChangeListener.class, markerChangeListener);
    }

    public void notifyListeners(MarkerChangeEvent markerChangeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != MarkerChangeListener.class) continue;
            ((MarkerChangeListener)objectArray[i + 1]).markerChanged(markerChangeEvent);
        }
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Marker)) {
            return false;
        }
        Marker marker = (Marker)object;
        if (!PaintUtilities.equal(this.paint, marker.paint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.stroke, marker.stroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.outlinePaint, marker.outlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.outlineStroke, marker.outlineStroke)) {
            return false;
        }
        if (this.alpha != marker.alpha) {
            return false;
        }
        if (!ObjectUtilities.equal(this.label, marker.label)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.labelFont, marker.labelFont)) {
            return false;
        }
        if (!PaintUtilities.equal(this.labelPaint, marker.labelPaint)) {
            return false;
        }
        if (this.labelAnchor != marker.labelAnchor) {
            return false;
        }
        if (this.labelTextAnchor != marker.labelTextAnchor) {
            return false;
        }
        if (!ObjectUtilities.equal(this.labelOffset, marker.labelOffset)) {
            return false;
        }
        return this.labelOffsetType.equals(marker.labelOffsetType);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.paint, objectOutputStream);
        SerialUtilities.writeStroke(this.stroke, objectOutputStream);
        SerialUtilities.writePaint(this.outlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.outlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.labelPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.paint = SerialUtilities.readPaint(objectInputStream);
        this.stroke = SerialUtilities.readStroke(objectInputStream);
        this.outlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.outlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.labelPaint = SerialUtilities.readPaint(objectInputStream);
        this.listenerList = new EventListenerList();
    }
}

