/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.plot;

import ai.org.jfree.chart.LegendItemCollection;
import ai.org.jfree.chart.axis.AxisSpace;
import ai.org.jfree.chart.axis.AxisState;
import ai.org.jfree.chart.axis.CategoryAxis;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.event.PlotChangeEvent;
import ai.org.jfree.chart.event.PlotChangeListener;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.PlotState;
import ai.org.jfree.data.Range;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.ui.RectangleInsets;
import ai.org.jfree.util.ObjectUtilities;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CombinedDomainCategoryPlot
extends CategoryPlot
implements PlotChangeListener {
    private static final long serialVersionUID = 8207194522653701572L;
    private List subplots = new ArrayList();
    private double gap = 5.0;
    private transient Rectangle2D[] subplotAreas;

    public CombinedDomainCategoryPlot() {
        this(new CategoryAxis());
    }

    public CombinedDomainCategoryPlot(CategoryAxis categoryAxis) {
        super(null, categoryAxis, null, null);
    }

    public double getGap() {
        return this.gap;
    }

    public void setGap(double d) {
        this.gap = d;
        this.fireChangeEvent();
    }

    public void add(CategoryPlot categoryPlot) {
        this.add(categoryPlot, 1);
    }

    public void add(CategoryPlot categoryPlot, int n) {
        if (categoryPlot == null) {
            throw new IllegalArgumentException("Null 'subplot' argument.");
        }
        if (n < 1) {
            throw new IllegalArgumentException("Require weight >= 1.");
        }
        categoryPlot.setParent(this);
        categoryPlot.setWeight(n);
        categoryPlot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        categoryPlot.setDomainAxis(null);
        categoryPlot.setOrientation(this.getOrientation());
        categoryPlot.addChangeListener(this);
        this.subplots.add(categoryPlot);
        CategoryAxis categoryAxis = this.getDomainAxis();
        if (categoryAxis != null) {
            categoryAxis.configure();
        }
        this.fireChangeEvent();
    }

    public void remove(CategoryPlot categoryPlot) {
        if (categoryPlot == null) {
            throw new IllegalArgumentException("Null 'subplot' argument.");
        }
        int n = -1;
        int n2 = this.subplots.size();
        for (int i = 0; n == -1 && i < n2; ++i) {
            if (this.subplots.get(i) != categoryPlot) continue;
            n = i;
        }
        if (n != -1) {
            this.subplots.remove(n);
            categoryPlot.setParent(null);
            categoryPlot.removeChangeListener(this);
            CategoryAxis categoryAxis = this.getDomainAxis();
            if (categoryAxis != null) {
                categoryAxis.configure();
            }
            this.fireChangeEvent();
        }
    }

    public List getSubplots() {
        if (this.subplots != null) {
            return Collections.unmodifiableList(this.subplots);
        }
        return Collections.EMPTY_LIST;
    }

    public CategoryPlot findSubplot(PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        if (plotRenderingInfo == null) {
            throw new IllegalArgumentException("Null 'info' argument.");
        }
        if (point2D == null) {
            throw new IllegalArgumentException("Null 'source' argument.");
        }
        CategoryPlot categoryPlot = null;
        int n = plotRenderingInfo.getSubplotIndex(point2D);
        if (n >= 0) {
            categoryPlot = (CategoryPlot)this.subplots.get(n);
        }
        return categoryPlot;
    }

    public void zoomRangeAxes(double d, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        this.zoomRangeAxes(d, plotRenderingInfo, point2D, false);
    }

    public void zoomRangeAxes(double d, PlotRenderingInfo plotRenderingInfo, Point2D point2D, boolean bl) {
        CategoryPlot categoryPlot2 = this.findSubplot(plotRenderingInfo, point2D);
        if (categoryPlot2 != null) {
            categoryPlot2.zoomRangeAxes(d, plotRenderingInfo, point2D, bl);
        } else {
            for (CategoryPlot categoryPlot2 : this.getSubplots()) {
                categoryPlot2.zoomRangeAxes(d, plotRenderingInfo, point2D, bl);
            }
        }
    }

    public void zoomRangeAxes(double d, double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        CategoryPlot categoryPlot2 = this.findSubplot(plotRenderingInfo, point2D);
        if (categoryPlot2 != null) {
            categoryPlot2.zoomRangeAxes(d, d2, plotRenderingInfo, point2D);
        } else {
            for (CategoryPlot categoryPlot2 : this.getSubplots()) {
                categoryPlot2.zoomRangeAxes(d, d2, plotRenderingInfo, point2D);
            }
        }
    }

    protected AxisSpace calculateAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Cloneable cloneable;
        AxisSpace axisSpace = new AxisSpace();
        PlotOrientation plotOrientation = this.getOrientation();
        AxisSpace axisSpace2 = this.getFixedDomainAxisSpace();
        if (axisSpace2 != null) {
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                axisSpace.setLeft(axisSpace2.getLeft());
                axisSpace.setRight(axisSpace2.getRight());
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                axisSpace.setTop(axisSpace2.getTop());
                axisSpace.setBottom(axisSpace2.getBottom());
            }
        } else {
            cloneable = this.getDomainAxis();
            RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(this.getDomainAxisLocation(), plotOrientation);
            if (cloneable != null) {
                axisSpace = ((CategoryAxis)cloneable).reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            } else if (this.getDrawSharedDomainAxis()) {
                axisSpace = this.getDomainAxis().reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            }
        }
        cloneable = axisSpace.shrink(rectangle2D, null);
        int n = this.subplots.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            CategoryPlot categoryPlot = (CategoryPlot)this.subplots.get(i);
            n2 += categoryPlot.getWeight();
        }
        this.subplotAreas = new Rectangle2D[n];
        double d = ((RectangularShape)cloneable).getX();
        double d2 = ((RectangularShape)cloneable).getY();
        double d3 = 0.0;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d3 = ((RectangularShape)cloneable).getWidth() - this.gap * (double)(n - 1);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            d3 = ((RectangularShape)cloneable).getHeight() - this.gap * (double)(n - 1);
        }
        for (int i = 0; i < n; ++i) {
            CategoryPlot categoryPlot = (CategoryPlot)this.subplots.get(i);
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double d4 = d3 * (double)categoryPlot.getWeight() / (double)n2;
                this.subplotAreas[i] = new Rectangle2D.Double(d, d2, d4, ((RectangularShape)cloneable).getHeight());
                d = d + d4 + this.gap;
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double d5 = d3 * (double)categoryPlot.getWeight() / (double)n2;
                this.subplotAreas[i] = new Rectangle2D.Double(d, d2, ((RectangularShape)cloneable).getWidth(), d5);
                d2 = d2 + d5 + this.gap;
            }
            AxisSpace axisSpace3 = categoryPlot.calculateRangeAxisSpace(graphics2D, this.subplotAreas[i], null);
            axisSpace.ensureAtLeast(axisSpace3);
        }
        return axisSpace;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        RectangleInsets rectangleInsets = this.getInsets();
        rectangle2D.setRect(rectangle2D.getX() + rectangleInsets.getLeft(), rectangle2D.getY() + rectangleInsets.getTop(), rectangle2D.getWidth() - rectangleInsets.getLeft() - rectangleInsets.getRight(), rectangle2D.getHeight() - rectangleInsets.getTop() - rectangleInsets.getBottom());
        this.setFixedRangeAxisSpaceForSubplots(null);
        AxisSpace axisSpace = this.calculateAxisSpace(graphics2D, rectangle2D);
        Rectangle2D rectangle2D2 = axisSpace.shrink(rectangle2D, null);
        this.setFixedRangeAxisSpaceForSubplots(axisSpace);
        CategoryAxis categoryAxis = this.getDomainAxis();
        RectangleEdge rectangleEdge = this.getDomainAxisEdge();
        double d = RectangleEdge.coordinate(rectangle2D2, rectangleEdge);
        AxisState axisState = categoryAxis.draw(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge, plotRenderingInfo);
        if (plotState == null) {
            plotState = new PlotState();
        }
        plotState.getSharedAxisStates().put(categoryAxis, axisState);
        for (int i = 0; i < this.subplots.size(); ++i) {
            CategoryPlot categoryPlot = (CategoryPlot)this.subplots.get(i);
            PlotRenderingInfo plotRenderingInfo2 = null;
            if (plotRenderingInfo != null) {
                plotRenderingInfo2 = new PlotRenderingInfo(plotRenderingInfo.getOwner());
                plotRenderingInfo.addSubplotInfo(plotRenderingInfo2);
            }
            Point2D point2D2 = null;
            if (point2D != null && this.subplotAreas[i].contains(point2D)) {
                point2D2 = point2D;
            }
            categoryPlot.draw(graphics2D, this.subplotAreas[i], point2D2, plotState, plotRenderingInfo2);
        }
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setDataArea(rectangle2D2);
        }
    }

    protected void setFixedRangeAxisSpaceForSubplots(AxisSpace axisSpace) {
        for (CategoryPlot categoryPlot : this.subplots) {
            categoryPlot.setFixedRangeAxisSpace(axisSpace, false);
        }
    }

    public void setOrientation(PlotOrientation plotOrientation) {
        super.setOrientation(plotOrientation);
        for (CategoryPlot categoryPlot : this.subplots) {
            categoryPlot.setOrientation(plotOrientation);
        }
    }

    public Range getDataRange(ValueAxis valueAxis) {
        return super.getDataRange(valueAxis);
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = this.getFixedLegendItems();
        if (legendItemCollection == null) {
            legendItemCollection = new LegendItemCollection();
            if (this.subplots != null) {
                for (CategoryPlot categoryPlot : this.subplots) {
                    LegendItemCollection legendItemCollection2 = categoryPlot.getLegendItems();
                    legendItemCollection.addAll(legendItemCollection2);
                }
            }
        }
        return legendItemCollection;
    }

    public List getCategories() {
        ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
        if (this.subplots != null) {
            for (CategoryPlot categoryPlot : this.subplots) {
                List list = categoryPlot.getCategories();
                for (Comparable comparable : list) {
                    if (arrayList.contains(comparable)) continue;
                    arrayList.add(comparable);
                }
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List getCategoriesForAxis(CategoryAxis categoryAxis) {
        return this.getCategories();
    }

    public void handleClick(int n, int n2, PlotRenderingInfo plotRenderingInfo) {
        Rectangle2D rectangle2D = plotRenderingInfo.getDataArea();
        if (rectangle2D.contains(n, n2)) {
            for (int i = 0; i < this.subplots.size(); ++i) {
                CategoryPlot categoryPlot = (CategoryPlot)this.subplots.get(i);
                PlotRenderingInfo plotRenderingInfo2 = plotRenderingInfo.getSubplotInfo(i);
                categoryPlot.handleClick(n, n2, plotRenderingInfo2);
            }
        }
    }

    public void plotChanged(PlotChangeEvent plotChangeEvent) {
        this.notifyListeners(plotChangeEvent);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CombinedDomainCategoryPlot)) {
            return false;
        }
        CombinedDomainCategoryPlot combinedDomainCategoryPlot = (CombinedDomainCategoryPlot)object;
        if (this.gap != combinedDomainCategoryPlot.gap) {
            return false;
        }
        if (!ObjectUtilities.equal(this.subplots, combinedDomainCategoryPlot.subplots)) {
            return false;
        }
        return super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        CombinedDomainCategoryPlot combinedDomainCategoryPlot = (CombinedDomainCategoryPlot)super.clone();
        combinedDomainCategoryPlot.subplots = (List)ObjectUtilities.deepClone(this.subplots);
        for (Plot plot : combinedDomainCategoryPlot.subplots) {
            plot.setParent(combinedDomainCategoryPlot);
        }
        return combinedDomainCategoryPlot;
    }
}

