/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.panel;

import ai.org.jfree.chart.ChartPanel;
import ai.org.jfree.chart.JFreeChart;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.panel.AbstractOverlay;
import ai.org.jfree.chart.panel.Overlay;
import ai.org.jfree.chart.plot.Crosshair;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.text.TextUtilities;
import ai.org.jfree.ui.RectangleAnchor;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.ui.TextAnchor;
import ai.org.jfree.util.ObjectUtilities;
import ai.org.jfree.util.PublicCloneable;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CrosshairOverlay
extends AbstractOverlay
implements Overlay,
PropertyChangeListener,
PublicCloneable,
Cloneable,
Serializable {
    private List xCrosshairs = new ArrayList();
    private List yCrosshairs = new ArrayList();

    public void addDomainCrosshair(Crosshair crosshair) {
        if (crosshair == null) {
            throw new IllegalArgumentException("Null 'crosshair' argument.");
        }
        this.xCrosshairs.add(crosshair);
        crosshair.addPropertyChangeListener(this);
        this.fireOverlayChanged();
    }

    public void removeDomainCrosshair(Crosshair crosshair) {
        if (crosshair == null) {
            throw new IllegalArgumentException("Null 'crosshair' argument.");
        }
        if (this.xCrosshairs.remove(crosshair)) {
            crosshair.removePropertyChangeListener(this);
            this.fireOverlayChanged();
        }
    }

    public void clearDomainCrosshairs() {
        if (this.xCrosshairs.isEmpty()) {
            return;
        }
        List list = this.getDomainCrosshairs();
        for (int i = 0; i < list.size(); ++i) {
            Crosshair crosshair = (Crosshair)list.get(i);
            this.xCrosshairs.remove(crosshair);
            crosshair.removePropertyChangeListener(this);
        }
        this.fireOverlayChanged();
    }

    public List getDomainCrosshairs() {
        return new ArrayList(this.xCrosshairs);
    }

    public void addRangeCrosshair(Crosshair crosshair) {
        if (crosshair == null) {
            throw new IllegalArgumentException("Null 'crosshair' argument.");
        }
        this.yCrosshairs.add(crosshair);
        crosshair.addPropertyChangeListener(this);
        this.fireOverlayChanged();
    }

    public void removeRangeCrosshair(Crosshair crosshair) {
        if (crosshair == null) {
            throw new IllegalArgumentException("Null 'crosshair' argument.");
        }
        if (this.yCrosshairs.remove(crosshair)) {
            crosshair.removePropertyChangeListener(this);
            this.fireOverlayChanged();
        }
    }

    public void clearRangeCrosshairs() {
        if (this.yCrosshairs.isEmpty()) {
            return;
        }
        List list = this.getRangeCrosshairs();
        for (int i = 0; i < list.size(); ++i) {
            Crosshair crosshair = (Crosshair)list.get(i);
            this.yCrosshairs.remove(crosshair);
            crosshair.removePropertyChangeListener(this);
        }
        this.fireOverlayChanged();
    }

    public List getRangeCrosshairs() {
        return new ArrayList(this.yCrosshairs);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.fireOverlayChanged();
    }

    public void paintOverlay(Graphics2D graphics2D, ChartPanel chartPanel) {
        double d;
        PublicCloneable publicCloneable2;
        Shape shape = graphics2D.getClip();
        Rectangle2D rectangle2D = chartPanel.getScreenDataArea();
        graphics2D.clip(rectangle2D);
        JFreeChart jFreeChart = chartPanel.getChart();
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        ValueAxis valueAxis = xYPlot.getDomainAxis();
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        for (PublicCloneable publicCloneable2 : this.xCrosshairs) {
            if (!((Crosshair)publicCloneable2).isVisible()) continue;
            double d2 = ((Crosshair)publicCloneable2).getValue();
            d = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
            if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                this.drawVerticalCrosshair(graphics2D, rectangle2D, d, (Crosshair)publicCloneable2);
                continue;
            }
            this.drawHorizontalCrosshair(graphics2D, rectangle2D, d, (Crosshair)publicCloneable2);
        }
        publicCloneable2 = xYPlot.getRangeAxis();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        for (Crosshair crosshair : this.yCrosshairs) {
            if (!crosshair.isVisible()) continue;
            d = crosshair.getValue();
            double d3 = ((ValueAxis)publicCloneable2).valueToJava2D(d, rectangle2D, rectangleEdge2);
            if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                this.drawHorizontalCrosshair(graphics2D, rectangle2D, d3, crosshair);
                continue;
            }
            this.drawVerticalCrosshair(graphics2D, rectangle2D, d3, crosshair);
        }
        graphics2D.setClip(shape);
    }

    protected void drawHorizontalCrosshair(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, Crosshair crosshair) {
        if (d >= rectangle2D.getMinY() && d <= rectangle2D.getMaxY()) {
            Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d, rectangle2D.getMaxX(), d);
            Paint paint = graphics2D.getPaint();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setPaint(crosshair.getPaint());
            graphics2D.setStroke(crosshair.getStroke());
            graphics2D.draw(double_);
            if (crosshair.isLabelVisible()) {
                TextAnchor textAnchor;
                float f;
                RectangleAnchor rectangleAnchor;
                Point2D point2D;
                float f2;
                String string = crosshair.getLabelGenerator().generateLabel(crosshair);
                Shape shape = TextUtilities.calculateRotatedStringBounds(string, graphics2D, f2 = (float)(point2D = this.calculateLabelPoint(double_, rectangleAnchor = crosshair.getLabelAnchor(), 5.0, 5.0)).getX(), f = (float)point2D.getY(), textAnchor = this.textAlignPtForLabelAnchorH(rectangleAnchor), 0.0, TextAnchor.CENTER);
                if (!rectangle2D.contains(shape.getBounds2D())) {
                    rectangleAnchor = this.flipAnchorV(rectangleAnchor);
                    point2D = this.calculateLabelPoint(double_, rectangleAnchor, 5.0, 5.0);
                    f2 = (float)point2D.getX();
                    f = (float)point2D.getY();
                    textAnchor = this.textAlignPtForLabelAnchorH(rectangleAnchor);
                    shape = TextUtilities.calculateRotatedStringBounds(string, graphics2D, f2, f, textAnchor, 0.0, TextAnchor.CENTER);
                }
                graphics2D.setPaint(crosshair.getLabelBackgroundPaint());
                graphics2D.fill(shape);
                graphics2D.setPaint(crosshair.getLabelOutlinePaint());
                graphics2D.draw(shape);
                TextUtilities.drawAlignedString(string, graphics2D, f2, f, textAnchor);
            }
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
        }
    }

    protected void drawVerticalCrosshair(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, Crosshair crosshair) {
        if (d >= rectangle2D.getMinX() && d <= rectangle2D.getMaxX()) {
            Line2D.Double double_ = new Line2D.Double(d, rectangle2D.getMinY(), d, rectangle2D.getMaxY());
            Paint paint = graphics2D.getPaint();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setPaint(crosshair.getPaint());
            graphics2D.setStroke(crosshair.getStroke());
            graphics2D.draw(double_);
            if (crosshair.isLabelVisible()) {
                TextAnchor textAnchor;
                float f;
                RectangleAnchor rectangleAnchor;
                Point2D point2D;
                float f2;
                String string = crosshair.getLabelGenerator().generateLabel(crosshair);
                Shape shape = TextUtilities.calculateRotatedStringBounds(string, graphics2D, f2 = (float)(point2D = this.calculateLabelPoint(double_, rectangleAnchor = crosshair.getLabelAnchor(), 5.0, 5.0)).getX(), f = (float)point2D.getY(), textAnchor = this.textAlignPtForLabelAnchorV(rectangleAnchor), 0.0, TextAnchor.CENTER);
                if (!rectangle2D.contains(shape.getBounds2D())) {
                    rectangleAnchor = this.flipAnchorH(rectangleAnchor);
                    point2D = this.calculateLabelPoint(double_, rectangleAnchor, 5.0, 5.0);
                    f2 = (float)point2D.getX();
                    f = (float)point2D.getY();
                    textAnchor = this.textAlignPtForLabelAnchorV(rectangleAnchor);
                    shape = TextUtilities.calculateRotatedStringBounds(string, graphics2D, f2, f, textAnchor, 0.0, TextAnchor.CENTER);
                }
                graphics2D.setPaint(crosshair.getLabelBackgroundPaint());
                graphics2D.fill(shape);
                graphics2D.setPaint(crosshair.getLabelOutlinePaint());
                graphics2D.draw(shape);
                TextUtilities.drawAlignedString(string, graphics2D, f2, f, textAnchor);
            }
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
        }
    }

    private Point2D calculateLabelPoint(Line2D line2D, RectangleAnchor rectangleAnchor, double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl = rectangleAnchor == RectangleAnchor.BOTTOM_LEFT || rectangleAnchor == RectangleAnchor.LEFT || rectangleAnchor == RectangleAnchor.TOP_LEFT;
        boolean bl2 = rectangleAnchor == RectangleAnchor.BOTTOM_RIGHT || rectangleAnchor == RectangleAnchor.RIGHT || rectangleAnchor == RectangleAnchor.TOP_RIGHT;
        boolean bl3 = rectangleAnchor == RectangleAnchor.TOP_LEFT || rectangleAnchor == RectangleAnchor.TOP || rectangleAnchor == RectangleAnchor.TOP_RIGHT;
        boolean bl4 = rectangleAnchor == RectangleAnchor.BOTTOM_LEFT || rectangleAnchor == RectangleAnchor.BOTTOM || rectangleAnchor == RectangleAnchor.BOTTOM_RIGHT;
        Rectangle rectangle = line2D.getBounds();
        if (line2D.getX1() == line2D.getX2()) {
            d3 = line2D.getX1();
            d4 = (line2D.getY1() + line2D.getY2()) / 2.0;
            if (bl) {
                d3 -= d;
            }
            if (bl2) {
                d3 += d;
            }
            if (bl3) {
                d4 = Math.min(line2D.getY1(), line2D.getY2()) + d2;
            }
            if (bl4) {
                d4 = Math.max(line2D.getY1(), line2D.getY2()) - d2;
            }
        } else {
            d3 = (line2D.getX1() + line2D.getX2()) / 2.0;
            d4 = line2D.getY1();
            if (bl) {
                d3 = Math.min(line2D.getX1(), line2D.getX2()) + d;
            }
            if (bl2) {
                d3 = Math.max(line2D.getX1(), line2D.getX2()) - d;
            }
            if (bl3) {
                d4 -= d2;
            }
            if (bl4) {
                d4 += d2;
            }
        }
        return new Point2D.Double(d3, d4);
    }

    private TextAnchor textAlignPtForLabelAnchorV(RectangleAnchor rectangleAnchor) {
        TextAnchor textAnchor = TextAnchor.CENTER;
        if (rectangleAnchor.equals(RectangleAnchor.TOP_LEFT)) {
            textAnchor = TextAnchor.TOP_RIGHT;
        } else if (rectangleAnchor.equals(RectangleAnchor.TOP)) {
            textAnchor = TextAnchor.TOP_CENTER;
        } else if (rectangleAnchor.equals(RectangleAnchor.TOP_RIGHT)) {
            textAnchor = TextAnchor.TOP_LEFT;
        } else if (rectangleAnchor.equals(RectangleAnchor.LEFT)) {
            textAnchor = TextAnchor.HALF_ASCENT_RIGHT;
        } else if (rectangleAnchor.equals(RectangleAnchor.RIGHT)) {
            textAnchor = TextAnchor.HALF_ASCENT_LEFT;
        } else if (rectangleAnchor.equals(RectangleAnchor.BOTTOM_LEFT)) {
            textAnchor = TextAnchor.BOTTOM_RIGHT;
        } else if (rectangleAnchor.equals(RectangleAnchor.BOTTOM)) {
            textAnchor = TextAnchor.BOTTOM_CENTER;
        } else if (rectangleAnchor.equals(RectangleAnchor.BOTTOM_RIGHT)) {
            textAnchor = TextAnchor.BOTTOM_LEFT;
        }
        return textAnchor;
    }

    private TextAnchor textAlignPtForLabelAnchorH(RectangleAnchor rectangleAnchor) {
        TextAnchor textAnchor = TextAnchor.CENTER;
        if (rectangleAnchor.equals(RectangleAnchor.TOP_LEFT)) {
            textAnchor = TextAnchor.BOTTOM_LEFT;
        } else if (rectangleAnchor.equals(RectangleAnchor.TOP)) {
            textAnchor = TextAnchor.BOTTOM_CENTER;
        } else if (rectangleAnchor.equals(RectangleAnchor.TOP_RIGHT)) {
            textAnchor = TextAnchor.BOTTOM_RIGHT;
        } else if (rectangleAnchor.equals(RectangleAnchor.LEFT)) {
            textAnchor = TextAnchor.HALF_ASCENT_LEFT;
        } else if (rectangleAnchor.equals(RectangleAnchor.RIGHT)) {
            textAnchor = TextAnchor.HALF_ASCENT_RIGHT;
        } else if (rectangleAnchor.equals(RectangleAnchor.BOTTOM_LEFT)) {
            textAnchor = TextAnchor.TOP_LEFT;
        } else if (rectangleAnchor.equals(RectangleAnchor.BOTTOM)) {
            textAnchor = TextAnchor.TOP_CENTER;
        } else if (rectangleAnchor.equals(RectangleAnchor.BOTTOM_RIGHT)) {
            textAnchor = TextAnchor.TOP_RIGHT;
        }
        return textAnchor;
    }

    private RectangleAnchor flipAnchorH(RectangleAnchor rectangleAnchor) {
        RectangleAnchor rectangleAnchor2 = rectangleAnchor;
        if (rectangleAnchor.equals(RectangleAnchor.TOP_LEFT)) {
            rectangleAnchor2 = RectangleAnchor.TOP_RIGHT;
        } else if (rectangleAnchor.equals(RectangleAnchor.TOP_RIGHT)) {
            rectangleAnchor2 = RectangleAnchor.TOP_LEFT;
        } else if (rectangleAnchor.equals(RectangleAnchor.LEFT)) {
            rectangleAnchor2 = RectangleAnchor.RIGHT;
        } else if (rectangleAnchor.equals(RectangleAnchor.RIGHT)) {
            rectangleAnchor2 = RectangleAnchor.LEFT;
        } else if (rectangleAnchor.equals(RectangleAnchor.BOTTOM_LEFT)) {
            rectangleAnchor2 = RectangleAnchor.BOTTOM_RIGHT;
        } else if (rectangleAnchor.equals(RectangleAnchor.BOTTOM_RIGHT)) {
            rectangleAnchor2 = RectangleAnchor.BOTTOM_LEFT;
        }
        return rectangleAnchor2;
    }

    private RectangleAnchor flipAnchorV(RectangleAnchor rectangleAnchor) {
        RectangleAnchor rectangleAnchor2 = rectangleAnchor;
        if (rectangleAnchor.equals(RectangleAnchor.TOP_LEFT)) {
            rectangleAnchor2 = RectangleAnchor.BOTTOM_LEFT;
        } else if (rectangleAnchor.equals(RectangleAnchor.TOP_RIGHT)) {
            rectangleAnchor2 = RectangleAnchor.BOTTOM_RIGHT;
        } else if (rectangleAnchor.equals(RectangleAnchor.TOP)) {
            rectangleAnchor2 = RectangleAnchor.BOTTOM;
        } else if (rectangleAnchor.equals(RectangleAnchor.BOTTOM)) {
            rectangleAnchor2 = RectangleAnchor.TOP;
        } else if (rectangleAnchor.equals(RectangleAnchor.BOTTOM_LEFT)) {
            rectangleAnchor2 = RectangleAnchor.TOP_LEFT;
        } else if (rectangleAnchor.equals(RectangleAnchor.BOTTOM_RIGHT)) {
            rectangleAnchor2 = RectangleAnchor.TOP_RIGHT;
        }
        return rectangleAnchor2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CrosshairOverlay)) {
            return false;
        }
        CrosshairOverlay crosshairOverlay = (CrosshairOverlay)object;
        if (!this.xCrosshairs.equals(crosshairOverlay.xCrosshairs)) {
            return false;
        }
        return this.yCrosshairs.equals(crosshairOverlay.yCrosshairs);
    }

    public Object clone() throws CloneNotSupportedException {
        CrosshairOverlay crosshairOverlay = (CrosshairOverlay)super.clone();
        crosshairOverlay.xCrosshairs = (List)ObjectUtilities.deepClone(this.xCrosshairs);
        crosshairOverlay.yCrosshairs = (List)ObjectUtilities.deepClone(this.yCrosshairs);
        return crosshairOverlay;
    }
}

