/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.panel;

import ai.org.jfree.chart.event.OverlayChangeEvent;
import ai.org.jfree.chart.event.OverlayChangeListener;
import javax.swing.event.EventListenerList;

public class AbstractOverlay {
    private transient EventListenerList changeListeners = new EventListenerList();

    public void addChangeListener(OverlayChangeListener overlayChangeListener) {
        if (overlayChangeListener == null) {
            throw new IllegalArgumentException("Null 'listener' argument.");
        }
        this.changeListeners.add(OverlayChangeListener.class, overlayChangeListener);
    }

    public void removeChangeListener(OverlayChangeListener overlayChangeListener) {
        if (overlayChangeListener == null) {
            throw new IllegalArgumentException("Null 'listener' argument.");
        }
        this.changeListeners.remove(OverlayChangeListener.class, overlayChangeListener);
    }

    public void fireOverlayChanged() {
        OverlayChangeEvent overlayChangeEvent = new OverlayChangeEvent(this);
        this.notifyListeners(overlayChangeEvent);
    }

    protected void notifyListeners(OverlayChangeEvent overlayChangeEvent) {
        Object[] objectArray = this.changeListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != OverlayChangeListener.class) continue;
            ((OverlayChangeListener)objectArray[i + 1]).overlayChanged(overlayChangeEvent);
        }
    }
}

