/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.labels;

import ai.org.jfree.chart.labels.StandardXYToolTipGenerator;
import ai.org.jfree.chart.labels.XYZToolTipGenerator;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.data.xy.XYZDataset;
import ai.org.jfree.util.ObjectUtilities;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;

public class StandardXYZToolTipGenerator
extends StandardXYToolTipGenerator
implements XYZToolTipGenerator,
Serializable {
    private static final long serialVersionUID = -2961577421889473503L;
    public static final String DEFAULT_TOOL_TIP_FORMAT = "{0}: ({1}, {2}, {3})";
    private NumberFormat zFormat;
    private DateFormat zDateFormat;

    public StandardXYZToolTipGenerator() {
        this(DEFAULT_TOOL_TIP_FORMAT, NumberFormat.getNumberInstance(), NumberFormat.getNumberInstance(), NumberFormat.getNumberInstance());
    }

    public StandardXYZToolTipGenerator(String string, NumberFormat numberFormat, NumberFormat numberFormat2, NumberFormat numberFormat3) {
        super(string, numberFormat, numberFormat2);
        if (numberFormat3 == null) {
            throw new IllegalArgumentException("Null 'zFormat' argument.");
        }
        this.zFormat = numberFormat3;
    }

    public StandardXYZToolTipGenerator(String string, DateFormat dateFormat, DateFormat dateFormat2, DateFormat dateFormat3) {
        super(string, dateFormat, dateFormat2);
        if (dateFormat3 == null) {
            throw new IllegalArgumentException("Null 'zFormat' argument.");
        }
        this.zDateFormat = dateFormat3;
    }

    public NumberFormat getZFormat() {
        return this.zFormat;
    }

    public DateFormat getZDateFormat() {
        return this.zDateFormat;
    }

    public String generateToolTip(XYZDataset xYZDataset, int n, int n2) {
        return this.generateLabelString(xYZDataset, n, n2);
    }

    public String generateLabelString(XYDataset xYDataset, int n, int n2) {
        String string = null;
        Object[] objectArray = this.createItemArray((XYZDataset)xYDataset, n, n2);
        string = MessageFormat.format(this.getFormatString(), objectArray);
        return string;
    }

    protected Object[] createItemArray(XYZDataset xYZDataset, int n, int n2) {
        Object[] objectArray = new Object[4];
        objectArray[0] = xYZDataset.getSeriesKey(n).toString();
        Number number = xYZDataset.getX(n, n2);
        DateFormat dateFormat = this.getXDateFormat();
        objectArray[1] = dateFormat != null ? dateFormat.format(number) : this.getXFormat().format(number);
        Number number2 = xYZDataset.getY(n, n2);
        DateFormat dateFormat2 = this.getYDateFormat();
        objectArray[2] = dateFormat2 != null ? dateFormat2.format(number2) : this.getYFormat().format(number2);
        Number number3 = xYZDataset.getZ(n, n2);
        objectArray[3] = this.zDateFormat != null ? this.zDateFormat.format(number3) : this.zFormat.format(number3);
        return objectArray;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardXYZToolTipGenerator)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        StandardXYZToolTipGenerator standardXYZToolTipGenerator = (StandardXYZToolTipGenerator)object;
        if (!ObjectUtilities.equal(this.zFormat, standardXYZToolTipGenerator.zFormat)) {
            return false;
        }
        return ObjectUtilities.equal(this.zDateFormat, standardXYZToolTipGenerator.zDateFormat);
    }
}

