/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.labels;

import ai.org.jfree.chart.HashUtilities;
import ai.org.jfree.chart.labels.XYSeriesLabelGenerator;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.util.PublicCloneable;
import java.io.Serializable;
import java.text.MessageFormat;

public class StandardXYSeriesLabelGenerator
implements XYSeriesLabelGenerator,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 1916017081848400024L;
    public static final String DEFAULT_LABEL_FORMAT = "{0}";
    private String formatPattern;

    public StandardXYSeriesLabelGenerator() {
        this(DEFAULT_LABEL_FORMAT);
    }

    public StandardXYSeriesLabelGenerator(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'format' argument.");
        }
        this.formatPattern = string;
    }

    public String generateLabel(XYDataset xYDataset, int n) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        String string = MessageFormat.format(this.formatPattern, this.createItemArray(xYDataset, n));
        return string;
    }

    protected Object[] createItemArray(XYDataset xYDataset, int n) {
        Object[] objectArray = new Object[]{xYDataset.getSeriesKey(n).toString()};
        return objectArray;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardXYSeriesLabelGenerator)) {
            return false;
        }
        StandardXYSeriesLabelGenerator standardXYSeriesLabelGenerator = (StandardXYSeriesLabelGenerator)object;
        return this.formatPattern.equals(standardXYSeriesLabelGenerator.formatPattern);
    }

    public int hashCode() {
        int n = 127;
        n = HashUtilities.hashCode(n, this.formatPattern);
        return n;
    }
}

