/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.labels;

import ai.org.jfree.chart.HashUtilities;
import ai.org.jfree.chart.labels.XYSeriesLabelGenerator;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.util.PublicCloneable;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultipleXYSeriesLabelGenerator
implements XYSeriesLabelGenerator,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 138976236941898560L;
    public static final String DEFAULT_LABEL_FORMAT = "{0}";
    private String formatPattern;
    private String additionalFormatPattern;
    private Map seriesLabelLists;

    public MultipleXYSeriesLabelGenerator() {
        this(DEFAULT_LABEL_FORMAT);
    }

    public MultipleXYSeriesLabelGenerator(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'format' argument.");
        }
        this.formatPattern = string;
        this.additionalFormatPattern = "\n{0}";
        this.seriesLabelLists = new HashMap();
    }

    public void addSeriesLabel(int n, String string) {
        Integer n2 = new Integer(n);
        ArrayList<String> arrayList = (ArrayList<String>)this.seriesLabelLists.get(n2);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            this.seriesLabelLists.put(n2, arrayList);
        }
        arrayList.add(string);
    }

    public void clearSeriesLabels(int n) {
        Integer n2 = new Integer(n);
        this.seriesLabelLists.put(n2, null);
    }

    public String generateLabel(XYDataset xYDataset, int n) {
        if (xYDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(MessageFormat.format(this.formatPattern, this.createItemArray(xYDataset, n)));
        Integer n2 = new Integer(n);
        List list = (List)this.seriesLabelLists.get(n2);
        if (list != null) {
            Object[] objectArray = new Object[1];
            for (int i = 0; i < list.size(); ++i) {
                objectArray[0] = list.get(i);
                String string = MessageFormat.format(this.additionalFormatPattern, objectArray);
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    protected Object[] createItemArray(XYDataset xYDataset, int n) {
        Object[] objectArray = new Object[]{xYDataset.getSeriesKey(n).toString()};
        return objectArray;
    }

    public Object clone() throws CloneNotSupportedException {
        MultipleXYSeriesLabelGenerator multipleXYSeriesLabelGenerator = (MultipleXYSeriesLabelGenerator)super.clone();
        multipleXYSeriesLabelGenerator.seriesLabelLists = new HashMap();
        Set set = this.seriesLabelLists.keySet();
        for (Object k : set) {
            Object v;
            Object object = v = this.seriesLabelLists.get(k);
            if (v instanceof PublicCloneable) {
                PublicCloneable publicCloneable = (PublicCloneable)v;
                object = publicCloneable.clone();
            }
            multipleXYSeriesLabelGenerator.seriesLabelLists.put(k, object);
        }
        return multipleXYSeriesLabelGenerator;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MultipleXYSeriesLabelGenerator)) {
            return false;
        }
        MultipleXYSeriesLabelGenerator multipleXYSeriesLabelGenerator = (MultipleXYSeriesLabelGenerator)object;
        if (!this.formatPattern.equals(multipleXYSeriesLabelGenerator.formatPattern)) {
            return false;
        }
        if (!this.additionalFormatPattern.equals(multipleXYSeriesLabelGenerator.additionalFormatPattern)) {
            return false;
        }
        return this.seriesLabelLists.equals(multipleXYSeriesLabelGenerator.seriesLabelLists);
    }

    public int hashCode() {
        int n = 127;
        n = HashUtilities.hashCode(n, this.formatPattern);
        n = HashUtilities.hashCode(n, this.additionalFormatPattern);
        n = HashUtilities.hashCode(n, this.seriesLabelLists);
        return n;
    }
}

