/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.labels;

import ai.org.jfree.chart.HashUtilities;
import ai.org.jfree.chart.labels.XYItemLabelGenerator;
import ai.org.jfree.chart.labels.XYToolTipGenerator;
import ai.org.jfree.data.xy.OHLCDataset;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.util.PublicCloneable;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;

public class HighLowItemLabelGenerator
implements XYItemLabelGenerator,
XYToolTipGenerator,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 5617111754832211830L;
    private DateFormat dateFormatter;
    private NumberFormat numberFormatter;

    public HighLowItemLabelGenerator() {
        this(DateFormat.getInstance(), NumberFormat.getInstance());
    }

    public HighLowItemLabelGenerator(DateFormat dateFormat, NumberFormat numberFormat) {
        if (dateFormat == null) {
            throw new IllegalArgumentException("Null 'dateFormatter' argument.");
        }
        if (numberFormat == null) {
            throw new IllegalArgumentException("Null 'numberFormatter' argument.");
        }
        this.dateFormatter = dateFormat;
        this.numberFormatter = numberFormat;
    }

    public String generateToolTip(XYDataset xYDataset, int n, int n2) {
        String string = null;
        if (xYDataset instanceof OHLCDataset) {
            OHLCDataset oHLCDataset = (OHLCDataset)xYDataset;
            Number number = oHLCDataset.getHigh(n, n2);
            Number number2 = oHLCDataset.getLow(n, n2);
            Number number3 = oHLCDataset.getOpen(n, n2);
            Number number4 = oHLCDataset.getClose(n, n2);
            Number number5 = oHLCDataset.getX(n, n2);
            string = oHLCDataset.getSeriesKey(n).toString();
            if (number5 != null) {
                Date date = new Date(number5.longValue());
                string = string + "--> Date=" + this.dateFormatter.format(date);
                if (number != null) {
                    string = string + " High=" + this.numberFormatter.format(number.doubleValue());
                }
                if (number2 != null) {
                    string = string + " Low=" + this.numberFormatter.format(number2.doubleValue());
                }
                if (number3 != null) {
                    string = string + " Open=" + this.numberFormatter.format(number3.doubleValue());
                }
                if (number4 != null) {
                    string = string + " Close=" + this.numberFormatter.format(number4.doubleValue());
                }
            }
        }
        return string;
    }

    public String generateLabel(XYDataset xYDataset, int n, int n2) {
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        HighLowItemLabelGenerator highLowItemLabelGenerator = (HighLowItemLabelGenerator)super.clone();
        if (this.dateFormatter != null) {
            highLowItemLabelGenerator.dateFormatter = (DateFormat)this.dateFormatter.clone();
        }
        if (this.numberFormatter != null) {
            highLowItemLabelGenerator.numberFormatter = (NumberFormat)this.numberFormatter.clone();
        }
        return highLowItemLabelGenerator;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HighLowItemLabelGenerator)) {
            return false;
        }
        HighLowItemLabelGenerator highLowItemLabelGenerator = (HighLowItemLabelGenerator)object;
        if (!this.dateFormatter.equals(highLowItemLabelGenerator.dateFormatter)) {
            return false;
        }
        return this.numberFormatter.equals(highLowItemLabelGenerator.numberFormatter);
    }

    public int hashCode() {
        int n = 127;
        n = HashUtilities.hashCode(n, this.dateFormatter);
        n = HashUtilities.hashCode(n, this.numberFormatter);
        return n;
    }
}

