/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.imagemap;

import ai.org.jfree.chart.ChartRenderingInfo;
import ai.org.jfree.chart.entity.ChartEntity;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.imagemap.OverLIBToolTipTagFragmentGenerator;
import ai.org.jfree.chart.imagemap.StandardToolTipTagFragmentGenerator;
import ai.org.jfree.chart.imagemap.StandardURLTagFragmentGenerator;
import ai.org.jfree.chart.imagemap.ToolTipTagFragmentGenerator;
import ai.org.jfree.chart.imagemap.URLTagFragmentGenerator;
import ai.org.jfree.util.StringUtils;
import java.io.IOException;
import java.io.PrintWriter;

public class ImageMapUtilities {
    public static void writeImageMap(PrintWriter printWriter, String string, ChartRenderingInfo chartRenderingInfo) throws IOException {
        ImageMapUtilities.writeImageMap(printWriter, string, chartRenderingInfo, new StandardToolTipTagFragmentGenerator(), new StandardURLTagFragmentGenerator());
    }

    public static void writeImageMap(PrintWriter printWriter, String string, ChartRenderingInfo chartRenderingInfo, boolean bl) throws IOException {
        ToolTipTagFragmentGenerator toolTipTagFragmentGenerator = null;
        toolTipTagFragmentGenerator = bl ? new OverLIBToolTipTagFragmentGenerator() : new StandardToolTipTagFragmentGenerator();
        ImageMapUtilities.writeImageMap(printWriter, string, chartRenderingInfo, toolTipTagFragmentGenerator, new StandardURLTagFragmentGenerator());
    }

    public static void writeImageMap(PrintWriter printWriter, String string, ChartRenderingInfo chartRenderingInfo, ToolTipTagFragmentGenerator toolTipTagFragmentGenerator, URLTagFragmentGenerator uRLTagFragmentGenerator) throws IOException {
        printWriter.println(ImageMapUtilities.getImageMap(string, chartRenderingInfo, toolTipTagFragmentGenerator, uRLTagFragmentGenerator));
    }

    public static String getImageMap(String string, ChartRenderingInfo chartRenderingInfo) {
        return ImageMapUtilities.getImageMap(string, chartRenderingInfo, new StandardToolTipTagFragmentGenerator(), new StandardURLTagFragmentGenerator());
    }

    public static String getImageMap(String string, ChartRenderingInfo chartRenderingInfo, ToolTipTagFragmentGenerator toolTipTagFragmentGenerator, URLTagFragmentGenerator uRLTagFragmentGenerator) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<map id=\"" + ImageMapUtilities.htmlEscape(string) + "\" name=\"" + ImageMapUtilities.htmlEscape(string) + "\">");
        stringBuffer.append(StringUtils.getLineSeparator());
        EntityCollection entityCollection = chartRenderingInfo.getEntityCollection();
        if (entityCollection != null) {
            int n = entityCollection.getEntityCount();
            for (int i = n - 1; i >= 0; --i) {
                String string2;
                ChartEntity chartEntity = entityCollection.getEntity(i);
                if (chartEntity.getToolTipText() == null && chartEntity.getURLText() == null || (string2 = chartEntity.getImageMapAreaTag(toolTipTagFragmentGenerator, uRLTagFragmentGenerator)).length() <= 0) continue;
                stringBuffer.append(string2);
                stringBuffer.append(StringUtils.getLineSeparator());
            }
        }
        stringBuffer.append("</map>");
        return stringBuffer.toString();
    }

    public static String htmlEscape(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'input' argument.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            if (c == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '\'') {
                stringBuffer.append("&#39;");
                continue;
            }
            if (c == '\\') {
                stringBuffer.append("&#092;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String javascriptEscape(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'input' argument.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuffer.append("\\\"");
                continue;
            }
            if (c == '\'') {
                stringBuffer.append("\\'");
                continue;
            }
            if (c == '\\') {
                stringBuffer.append("\\\\");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

