/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.entity;

import ai.org.jfree.chart.HashUtilities;
import ai.org.jfree.chart.entity.ChartEntity;
import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.util.ObjectUtilities;
import java.awt.Shape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class PlotEntity
extends ChartEntity {
    private static final long serialVersionUID = -4445994133561919083L;
    private Plot plot;

    public PlotEntity(Shape shape, Plot plot) {
        this(shape, plot, null);
    }

    public PlotEntity(Shape shape, Plot plot, String string) {
        this(shape, plot, string, null);
    }

    public PlotEntity(Shape shape, Plot plot, String string, String string2) {
        super(shape, string, string2);
        if (plot == null) {
            throw new IllegalArgumentException("Null 'plot' argument.");
        }
        this.plot = plot;
    }

    public Plot getPlot() {
        return this.plot;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("PlotEntity: ");
        stringBuffer.append("tooltip = ");
        stringBuffer.append(this.getToolTipText());
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PlotEntity)) {
            return false;
        }
        PlotEntity plotEntity = (PlotEntity)object;
        if (!this.getArea().equals(plotEntity.getArea())) {
            return false;
        }
        if (!ObjectUtilities.equal(this.getToolTipText(), plotEntity.getToolTipText())) {
            return false;
        }
        if (!ObjectUtilities.equal(this.getURLText(), plotEntity.getURLText())) {
            return false;
        }
        return this.plot.equals(plotEntity.plot);
    }

    public int hashCode() {
        int n = 39;
        n = HashUtilities.hashCode(n, this.getToolTipText());
        n = HashUtilities.hashCode(n, this.getURLText());
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.getArea(), objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setArea(SerialUtilities.readShape(objectInputStream));
    }
}

