/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.entity;

import ai.org.jfree.chart.entity.ChartEntity;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.util.ObjectUtilities;
import java.awt.Shape;
import java.io.Serializable;

public class CategoryItemEntity
extends ChartEntity
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -8657249457902337349L;
    private CategoryDataset dataset;
    private int series;
    private Object category;
    private int categoryIndex;
    private Comparable rowKey;
    private Comparable columnKey;

    public CategoryItemEntity(Shape shape, String string, String string2, CategoryDataset categoryDataset, int n, Object object, int n2) {
        super(shape, string, string2);
        if (categoryDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        this.dataset = categoryDataset;
        this.series = n;
        this.category = object;
        this.categoryIndex = n2;
        this.rowKey = categoryDataset.getRowKey(n);
        this.columnKey = categoryDataset.getColumnKey(n2);
    }

    public CategoryItemEntity(Shape shape, String string, String string2, CategoryDataset categoryDataset, Comparable comparable, Comparable comparable2) {
        super(shape, string, string2);
        if (categoryDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        this.dataset = categoryDataset;
        this.rowKey = comparable;
        this.columnKey = comparable2;
        this.series = categoryDataset.getRowIndex(comparable);
        this.category = comparable2;
        this.categoryIndex = categoryDataset.getColumnIndex(comparable2);
    }

    public CategoryDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(CategoryDataset categoryDataset) {
        if (categoryDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        this.dataset = categoryDataset;
    }

    public Comparable getRowKey() {
        return this.rowKey;
    }

    public void setRowKey(Comparable comparable) {
        this.rowKey = comparable;
        this.series = this.dataset.getRowIndex(comparable);
    }

    public Comparable getColumnKey() {
        return this.columnKey;
    }

    public void setColumnKey(Comparable comparable) {
        this.columnKey = comparable;
        this.category = comparable;
        this.categoryIndex = this.dataset.getColumnIndex(comparable);
    }

    public int getSeries() {
        return this.series;
    }

    public void setSeries(int n) {
        this.series = n;
    }

    public Object getCategory() {
        return this.category;
    }

    public void setCategory(Object object) {
        this.category = object;
    }

    public int getCategoryIndex() {
        return this.categoryIndex;
    }

    public void setCategoryIndex(int n) {
        this.categoryIndex = n;
    }

    public String toString() {
        return "CategoryItemEntity: rowKey=" + this.rowKey + ", columnKey=" + this.columnKey + ", dataset=" + this.dataset;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CategoryItemEntity)) {
            return false;
        }
        CategoryItemEntity categoryItemEntity = (CategoryItemEntity)object;
        if (!this.rowKey.equals(categoryItemEntity.rowKey)) {
            return false;
        }
        if (!this.columnKey.equals(categoryItemEntity.columnKey)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.dataset, categoryItemEntity.dataset)) {
            return false;
        }
        if (this.categoryIndex != categoryItemEntity.categoryIndex) {
            return false;
        }
        if (this.series != categoryItemEntity.series) {
            return false;
        }
        if (!ObjectUtilities.equal(this.category, categoryItemEntity.category)) {
            return false;
        }
        return super.equals(object);
    }
}

