/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.block;

import ai.org.jfree.chart.block.Arrangement;
import ai.org.jfree.chart.block.Block;
import ai.org.jfree.chart.block.BlockContainer;
import ai.org.jfree.chart.block.LengthConstraintType;
import ai.org.jfree.chart.block.RectangleConstraint;
import ai.org.jfree.ui.Size2D;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.List;

public class GridArrangement
implements Arrangement,
Serializable {
    private static final long serialVersionUID = -2563758090144655938L;
    private int rows;
    private int columns;

    public GridArrangement(int n, int n2) {
        this.rows = n;
        this.columns = n2;
    }

    public void add(Block block, Object object) {
    }

    public Size2D arrange(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        LengthConstraintType lengthConstraintType = rectangleConstraint.getWidthConstraintType();
        LengthConstraintType lengthConstraintType2 = rectangleConstraint.getHeightConstraintType();
        if (lengthConstraintType == LengthConstraintType.NONE) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                return this.arrangeNN(blockContainer, graphics2D);
            }
            if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                return this.arrangeNF(blockContainer, graphics2D, rectangleConstraint);
            }
            if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                return this.arrangeNR(blockContainer, graphics2D, rectangleConstraint);
            }
        } else if (lengthConstraintType == LengthConstraintType.FIXED) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                return this.arrangeFN(blockContainer, graphics2D, rectangleConstraint);
            }
            if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                return this.arrangeFF(blockContainer, graphics2D, rectangleConstraint);
            }
            if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                return this.arrangeFR(blockContainer, graphics2D, rectangleConstraint);
            }
        } else if (lengthConstraintType == LengthConstraintType.RANGE) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                return this.arrangeRN(blockContainer, graphics2D, rectangleConstraint);
            }
            if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                return this.arrangeRF(blockContainer, graphics2D, rectangleConstraint);
            }
            if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                return this.arrangeRR(blockContainer, graphics2D, rectangleConstraint);
            }
        }
        throw new RuntimeException("Should never get to here!");
    }

    protected Size2D arrangeNN(BlockContainer blockContainer, Graphics2D graphics2D) {
        double d = 0.0;
        double d2 = 0.0;
        List list = blockContainer.getBlocks();
        for (Block block : list) {
            if (block == null) continue;
            Size2D size2D = block.arrange(graphics2D, RectangleConstraint.NONE);
            d = Math.max(d, size2D.width);
            d2 = Math.max(d2, size2D.height);
        }
        double d3 = (double)this.columns * d;
        double d4 = (double)this.rows * d2;
        RectangleConstraint rectangleConstraint = new RectangleConstraint(d3, d4);
        return this.arrangeFF(blockContainer, graphics2D, rectangleConstraint);
    }

    protected Size2D arrangeFF(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        double d = rectangleConstraint.getWidth() / (double)this.columns;
        double d2 = rectangleConstraint.getHeight() / (double)this.rows;
        List list = blockContainer.getBlocks();
        for (int i = 0; i < this.columns; ++i) {
            int n;
            for (int j = 0; j < this.rows && (n = j * this.columns + i) < list.size(); ++j) {
                Block block = (Block)list.get(n);
                if (block == null) continue;
                block.setBounds(new Rectangle2D.Double((double)i * d, (double)j * d2, d, d2));
            }
        }
        return new Size2D((double)this.columns * d, (double)this.rows * d2);
    }

    protected Size2D arrangeFR(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        RectangleConstraint rectangleConstraint2 = rectangleConstraint.toUnconstrainedHeight();
        Size2D size2D = this.arrange(blockContainer, graphics2D, rectangleConstraint2);
        if (rectangleConstraint.getHeightRange().contains(size2D.getHeight())) {
            return size2D;
        }
        double d = rectangleConstraint.getHeightRange().constrain(size2D.getHeight());
        RectangleConstraint rectangleConstraint3 = rectangleConstraint.toFixedHeight(d);
        return this.arrange(blockContainer, graphics2D, rectangleConstraint3);
    }

    protected Size2D arrangeRF(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        RectangleConstraint rectangleConstraint2 = rectangleConstraint.toUnconstrainedWidth();
        Size2D size2D = this.arrange(blockContainer, graphics2D, rectangleConstraint2);
        if (rectangleConstraint.getWidthRange().contains(size2D.getWidth())) {
            return size2D;
        }
        double d = rectangleConstraint.getWidthRange().constrain(size2D.getWidth());
        RectangleConstraint rectangleConstraint3 = rectangleConstraint.toFixedWidth(d);
        return this.arrange(blockContainer, graphics2D, rectangleConstraint3);
    }

    protected Size2D arrangeRN(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        RectangleConstraint rectangleConstraint2 = rectangleConstraint.toUnconstrainedWidth();
        Size2D size2D = this.arrange(blockContainer, graphics2D, rectangleConstraint2);
        if (rectangleConstraint.getWidthRange().contains(size2D.getWidth())) {
            return size2D;
        }
        double d = rectangleConstraint.getWidthRange().constrain(size2D.getWidth());
        RectangleConstraint rectangleConstraint3 = rectangleConstraint.toFixedWidth(d);
        return this.arrange(blockContainer, graphics2D, rectangleConstraint3);
    }

    protected Size2D arrangeNR(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        RectangleConstraint rectangleConstraint2 = rectangleConstraint.toUnconstrainedHeight();
        Size2D size2D = this.arrange(blockContainer, graphics2D, rectangleConstraint2);
        if (rectangleConstraint.getHeightRange().contains(size2D.getHeight())) {
            return size2D;
        }
        double d = rectangleConstraint.getHeightRange().constrain(size2D.getHeight());
        RectangleConstraint rectangleConstraint3 = rectangleConstraint.toFixedHeight(d);
        return this.arrange(blockContainer, graphics2D, rectangleConstraint3);
    }

    protected Size2D arrangeRR(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        Size2D size2D = this.arrange(blockContainer, graphics2D, RectangleConstraint.NONE);
        if (rectangleConstraint.getWidthRange().contains(size2D.getWidth())) {
            if (rectangleConstraint.getHeightRange().contains(size2D.getHeight())) {
                return size2D;
            }
            double d = rectangleConstraint.getHeightRange().constrain(size2D.getHeight());
            RectangleConstraint rectangleConstraint2 = new RectangleConstraint(size2D.getWidth(), d);
            return this.arrangeFF(blockContainer, graphics2D, rectangleConstraint2);
        }
        if (rectangleConstraint.getHeightRange().contains(size2D.getHeight())) {
            double d = rectangleConstraint.getWidthRange().constrain(size2D.getWidth());
            RectangleConstraint rectangleConstraint3 = new RectangleConstraint(d, size2D.getHeight());
            return this.arrangeFF(blockContainer, graphics2D, rectangleConstraint3);
        }
        double d = rectangleConstraint.getWidthRange().constrain(size2D.getWidth());
        double d2 = rectangleConstraint.getHeightRange().constrain(size2D.getHeight());
        RectangleConstraint rectangleConstraint4 = new RectangleConstraint(d, d2);
        return this.arrangeFF(blockContainer, graphics2D, rectangleConstraint4);
    }

    protected Size2D arrangeFN(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        double d = rectangleConstraint.getWidth() / (double)this.columns;
        RectangleConstraint rectangleConstraint2 = rectangleConstraint.toFixedWidth(d);
        List list = blockContainer.getBlocks();
        double d2 = 0.0;
        for (int i = 0; i < this.rows; ++i) {
            int n;
            for (int j = 0; j < this.columns && (n = i * this.columns + j) < list.size(); ++j) {
                Block block = (Block)list.get(n);
                if (block == null) continue;
                Size2D size2D = block.arrange(graphics2D, rectangleConstraint2);
                d2 = Math.max(d2, size2D.getHeight());
            }
        }
        RectangleConstraint rectangleConstraint3 = rectangleConstraint.toFixedHeight(d2 * (double)this.rows);
        return this.arrange(blockContainer, graphics2D, rectangleConstraint3);
    }

    protected Size2D arrangeNF(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        double d = rectangleConstraint.getHeight() / (double)this.rows;
        RectangleConstraint rectangleConstraint2 = rectangleConstraint.toFixedHeight(d);
        List list = blockContainer.getBlocks();
        double d2 = 0.0;
        for (int i = 0; i < this.rows; ++i) {
            int n;
            for (int j = 0; j < this.columns && (n = i * this.columns + j) < list.size(); ++j) {
                Block block = (Block)list.get(n);
                if (block == null) continue;
                Size2D size2D = block.arrange(graphics2D, rectangleConstraint2);
                d2 = Math.max(d2, size2D.getWidth());
            }
        }
        RectangleConstraint rectangleConstraint3 = rectangleConstraint.toFixedWidth(d2 * (double)this.columns);
        return this.arrange(blockContainer, graphics2D, rectangleConstraint3);
    }

    public void clear() {
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GridArrangement)) {
            return false;
        }
        GridArrangement gridArrangement = (GridArrangement)object;
        if (this.columns != gridArrangement.columns) {
            return false;
        }
        return this.rows == gridArrangement.rows;
    }
}

