/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.block;

import ai.org.jfree.chart.block.Arrangement;
import ai.org.jfree.chart.block.Block;
import ai.org.jfree.chart.block.BlockContainer;
import ai.org.jfree.chart.block.LengthConstraintType;
import ai.org.jfree.chart.block.RectangleConstraint;
import ai.org.jfree.ui.HorizontalAlignment;
import ai.org.jfree.ui.Size2D;
import ai.org.jfree.ui.VerticalAlignment;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class FlowArrangement
implements Arrangement,
Serializable {
    private static final long serialVersionUID = 4543632485478613800L;
    private HorizontalAlignment horizontalAlignment;
    private VerticalAlignment verticalAlignment;
    private double horizontalGap;
    private double verticalGap;

    public FlowArrangement() {
        this(HorizontalAlignment.CENTER, VerticalAlignment.CENTER, 2.0, 2.0);
    }

    public FlowArrangement(HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, double d, double d2) {
        this.horizontalAlignment = horizontalAlignment;
        this.verticalAlignment = verticalAlignment;
        this.horizontalGap = d;
        this.verticalGap = d2;
    }

    public void add(Block block, Object object) {
    }

    public Size2D arrange(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        LengthConstraintType lengthConstraintType = rectangleConstraint.getWidthConstraintType();
        LengthConstraintType lengthConstraintType2 = rectangleConstraint.getHeightConstraintType();
        if (lengthConstraintType == LengthConstraintType.NONE) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                return this.arrangeNN(blockContainer, graphics2D);
            }
            if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                return this.arrangeNF(blockContainer, graphics2D, rectangleConstraint);
            }
            if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                throw new RuntimeException("Not implemented.");
            }
        } else if (lengthConstraintType == LengthConstraintType.FIXED) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                return this.arrangeFN(blockContainer, graphics2D, rectangleConstraint);
            }
            if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                return this.arrangeFF(blockContainer, graphics2D, rectangleConstraint);
            }
            if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                return this.arrangeFR(blockContainer, graphics2D, rectangleConstraint);
            }
        } else if (lengthConstraintType == LengthConstraintType.RANGE) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                return this.arrangeRN(blockContainer, graphics2D, rectangleConstraint);
            }
            if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                return this.arrangeRF(blockContainer, graphics2D, rectangleConstraint);
            }
            if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                return this.arrangeRR(blockContainer, graphics2D, rectangleConstraint);
            }
        }
        throw new RuntimeException("Unrecognised constraint type.");
    }

    protected Size2D arrangeFN(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        List list = blockContainer.getBlocks();
        double d = rectangleConstraint.getWidth();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        ArrayList<Block> arrayList = new ArrayList<Block>();
        for (int i = 0; i < list.size(); ++i) {
            Block block = (Block)list.get(i);
            Size2D size2D = block.arrange(graphics2D, RectangleConstraint.NONE);
            if (d2 + size2D.width <= d) {
                arrayList.add(block);
                block.setBounds(new Rectangle2D.Double(d2, d3, size2D.width, size2D.height));
                d2 = d2 + size2D.width + this.horizontalGap;
                d4 = Math.max(d4, size2D.height);
                continue;
            }
            if (arrayList.isEmpty()) {
                block.setBounds(new Rectangle2D.Double(d2, d3, Math.min(size2D.width, d - d2), size2D.height));
                d2 = 0.0;
                d3 = d3 + size2D.height + this.verticalGap;
                continue;
            }
            arrayList.clear();
            d2 = 0.0;
            d3 = d3 + d4 + this.verticalGap;
            d4 = size2D.height;
            block.setBounds(new Rectangle2D.Double(d2, d3, Math.min(size2D.width, d), size2D.height));
            d2 = size2D.width + this.horizontalGap;
            arrayList.add(block);
        }
        return new Size2D(rectangleConstraint.getWidth(), d3 + d4);
    }

    protected Size2D arrangeFR(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        Size2D size2D = this.arrangeFN(blockContainer, graphics2D, rectangleConstraint);
        if (rectangleConstraint.getHeightRange().contains(size2D.height)) {
            return size2D;
        }
        RectangleConstraint rectangleConstraint2 = rectangleConstraint.toFixedHeight(rectangleConstraint.getHeightRange().constrain(size2D.getHeight()));
        return this.arrangeFF(blockContainer, graphics2D, rectangleConstraint2);
    }

    protected Size2D arrangeFF(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        return this.arrangeFN(blockContainer, graphics2D, rectangleConstraint);
    }

    protected Size2D arrangeRR(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        Size2D size2D = this.arrangeNN(blockContainer, graphics2D);
        if (rectangleConstraint.getWidthRange().contains(size2D.width)) {
            return size2D;
        }
        RectangleConstraint rectangleConstraint2 = rectangleConstraint.toFixedWidth(rectangleConstraint.getWidthRange().getUpperBound());
        return this.arrangeFR(blockContainer, graphics2D, rectangleConstraint2);
    }

    protected Size2D arrangeRF(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        Size2D size2D = this.arrangeNF(blockContainer, graphics2D, rectangleConstraint);
        if (rectangleConstraint.getWidthRange().contains(size2D.width)) {
            return size2D;
        }
        RectangleConstraint rectangleConstraint2 = rectangleConstraint.toFixedWidth(rectangleConstraint.getWidthRange().constrain(size2D.getWidth()));
        return this.arrangeFF(blockContainer, graphics2D, rectangleConstraint2);
    }

    protected Size2D arrangeRN(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        Size2D size2D = this.arrangeNN(blockContainer, graphics2D);
        if (rectangleConstraint.getWidthRange().contains(size2D.width)) {
            return size2D;
        }
        RectangleConstraint rectangleConstraint2 = rectangleConstraint.toFixedWidth(rectangleConstraint.getWidthRange().getUpperBound());
        return this.arrangeFN(blockContainer, graphics2D, rectangleConstraint2);
    }

    protected Size2D arrangeNN(BlockContainer blockContainer, Graphics2D graphics2D) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        List list = blockContainer.getBlocks();
        int n = list.size();
        if (n > 0) {
            int n2;
            Size2D[] size2DArray = new Size2D[list.size()];
            for (n2 = 0; n2 < list.size(); ++n2) {
                Block block = (Block)list.get(n2);
                size2DArray[n2] = block.arrange(graphics2D, RectangleConstraint.NONE);
                d2 += size2DArray[n2].getWidth();
                d3 = Math.max(size2DArray[n2].height, d3);
                block.setBounds(new Rectangle2D.Double(d, 0.0, size2DArray[n2].width, size2DArray[n2].height));
                d = d + size2DArray[n2].width + this.horizontalGap;
            }
            if (n > 1) {
                d2 += this.horizontalGap * (double)(n - 1);
            }
            if (this.verticalAlignment != VerticalAlignment.TOP) {
                for (n2 = 0; n2 < list.size(); ++n2) {
                    if (this.verticalAlignment != VerticalAlignment.CENTER && this.verticalAlignment != VerticalAlignment.BOTTOM) continue;
                }
            }
        }
        return new Size2D(d2, d3);
    }

    protected Size2D arrangeNF(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        return this.arrangeNN(blockContainer, graphics2D);
    }

    public void clear() {
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FlowArrangement)) {
            return false;
        }
        FlowArrangement flowArrangement = (FlowArrangement)object;
        if (this.horizontalAlignment != flowArrangement.horizontalAlignment) {
            return false;
        }
        if (this.verticalAlignment != flowArrangement.verticalAlignment) {
            return false;
        }
        if (this.horizontalGap != flowArrangement.horizontalGap) {
            return false;
        }
        return this.verticalGap == flowArrangement.verticalGap;
    }
}

