/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.axis;

import ai.org.jfree.chart.axis.AxisState;
import ai.org.jfree.chart.axis.NumberAxis;
import ai.org.jfree.chart.axis.NumberTick;
import ai.org.jfree.chart.axis.ValueTick;
import ai.org.jfree.chart.event.AxisChangeEvent;
import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.ValueAxisPlot;
import ai.org.jfree.data.Range;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.text.TextUtilities;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.ui.TextAnchor;
import ai.org.jfree.util.PaintUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SymbolAxis
extends NumberAxis
implements Serializable {
    private static final long serialVersionUID = 7216330468770619716L;
    public static final Paint DEFAULT_GRID_BAND_PAINT = new Color(232, 234, 232, 128);
    public static final Paint DEFAULT_GRID_BAND_ALTERNATE_PAINT = new Color(0, 0, 0, 0);
    private List symbols;
    private boolean gridBandsVisible;
    private transient Paint gridBandPaint;
    private transient Paint gridBandAlternatePaint;

    public SymbolAxis(String string, String[] stringArray) {
        super(string);
        this.symbols = Arrays.asList(stringArray);
        this.gridBandsVisible = true;
        this.gridBandPaint = DEFAULT_GRID_BAND_PAINT;
        this.gridBandAlternatePaint = DEFAULT_GRID_BAND_ALTERNATE_PAINT;
        this.setAutoTickUnitSelection(false, false);
        this.setAutoRangeStickyZero(false);
    }

    public String[] getSymbols() {
        String[] stringArray = new String[this.symbols.size()];
        stringArray = this.symbols.toArray(stringArray);
        return stringArray;
    }

    public boolean isGridBandsVisible() {
        return this.gridBandsVisible;
    }

    public void setGridBandsVisible(boolean bl) {
        if (this.gridBandsVisible != bl) {
            this.gridBandsVisible = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Paint getGridBandPaint() {
        return this.gridBandPaint;
    }

    public void setGridBandPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.gridBandPaint = paint;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Paint getGridBandAlternatePaint() {
        return this.gridBandAlternatePaint;
    }

    public void setGridBandAlternatePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.gridBandAlternatePaint = paint;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    protected void selectAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        throw new UnsupportedOperationException();
    }

    public AxisState draw(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, PlotRenderingInfo plotRenderingInfo) {
        AxisState axisState = new AxisState(d);
        if (this.isVisible()) {
            axisState = super.draw(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge, plotRenderingInfo);
        }
        if (this.gridBandsVisible) {
            this.drawGridBands(graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState.getTicks());
        }
        return axisState;
    }

    protected void drawGridBands(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, List list) {
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D2);
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            this.drawGridBandsHorizontal(graphics2D, rectangle2D, rectangle2D2, true, list);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            this.drawGridBandsVertical(graphics2D, rectangle2D, rectangle2D2, true, list);
        }
        graphics2D.setClip(shape);
    }

    protected void drawGridBandsHorizontal(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl, List list) {
        boolean bl2 = bl;
        double d = rectangle2D2.getY();
        double d2 = this.getPlot().getOutlineStroke() != null ? (double)((BasicStroke)this.getPlot().getOutlineStroke()).getLineWidth() : 1.0;
        for (ValueTick valueTick : list) {
            double d3 = this.valueToJava2D(valueTick.getValue() - 0.5, rectangle2D2, RectangleEdge.BOTTOM);
            double d4 = this.valueToJava2D(valueTick.getValue() + 0.5, rectangle2D2, RectangleEdge.BOTTOM);
            if (bl2) {
                graphics2D.setPaint(this.gridBandPaint);
            } else {
                graphics2D.setPaint(this.gridBandAlternatePaint);
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double(d3, d + d2, d4 - d3, rectangle2D2.getMaxY() - d - d2);
            graphics2D.fill(double_);
            bl2 = !bl2;
        }
        graphics2D.setPaintMode();
    }

    protected void drawGridBandsVertical(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl, List list) {
        boolean bl2 = bl;
        double d = rectangle2D2.getX();
        Stroke stroke = this.getPlot().getOutlineStroke();
        double d2 = stroke != null && stroke instanceof BasicStroke ? (double)((BasicStroke)stroke).getLineWidth() : 1.0;
        for (ValueTick valueTick : list) {
            double d3 = this.valueToJava2D(valueTick.getValue() + 0.5, rectangle2D2, RectangleEdge.LEFT);
            double d4 = this.valueToJava2D(valueTick.getValue() - 0.5, rectangle2D2, RectangleEdge.LEFT);
            if (bl2) {
                graphics2D.setPaint(this.gridBandPaint);
            } else {
                graphics2D.setPaint(this.gridBandAlternatePaint);
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double(d + d2, d3, rectangle2D2.getMaxX() - d - d2, d4 - d3);
            graphics2D.fill(double_);
            bl2 = !bl2;
        }
        graphics2D.setPaintMode();
    }

    protected void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof ValueAxisPlot) {
            double d;
            double d2;
            double d3 = this.symbols.size() - 1;
            double d4 = d3 - (d2 = 0.0);
            if (d4 < (d = this.getAutoRangeMinimumSize())) {
                d3 = (d3 + d2 + d) / 2.0;
                d2 = (d3 + d2 - d) / 2.0;
            }
            double d5 = 0.5;
            double d6 = 0.5;
            if (this.getAutoRangeIncludesZero()) {
                if (this.getAutoRangeStickyZero()) {
                    d3 = d3 <= 0.0 ? 0.0 : (d3 += d5);
                    d2 = d2 >= 0.0 ? 0.0 : (d2 -= d6);
                } else {
                    d3 = Math.max(0.0, d3 + d5);
                    d2 = Math.min(0.0, d2 - d6);
                }
            } else if (this.getAutoRangeStickyZero()) {
                d3 = d3 <= 0.0 ? Math.min(0.0, d3 + d5) : (d3 += d5 * d4);
                d2 = d2 >= 0.0 ? Math.max(0.0, d2 - d6) : (d2 -= d6);
            } else {
                d3 += d5;
                d2 -= d6;
            }
            this.setRange(new Range(d2, d3), false, false);
        }
    }

    public List refreshTicks(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        List list = null;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            list = this.refreshTicksHorizontal(graphics2D, rectangle2D, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            list = this.refreshTicksVertical(graphics2D, rectangle2D, rectangleEdge);
        }
        return list;
    }

    protected List refreshTicksHorizontal(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        ArrayList<NumberTick> arrayList = new ArrayList<NumberTick>();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        double d = this.getTickUnit().getSize();
        int n = this.calculateVisibleTickCount();
        double d2 = this.calculateLowestVisibleTickValue();
        double d3 = 0.0;
        double d4 = 0.0;
        if (n <= 500) {
            for (int i = 0; i < n; ++i) {
                double d5 = d2 + (double)i * d;
                double d6 = this.valueToJava2D(d5, rectangle2D, rectangleEdge);
                NumberFormat numberFormat = this.getNumberFormatOverride();
                String string = numberFormat != null ? numberFormat.format(d5) : this.valueToString(d5);
                Rectangle2D rectangle2D2 = TextUtilities.getTextBounds(string, graphics2D, graphics2D.getFontMetrics());
                double d7 = this.isVerticalTickLabels() ? rectangle2D2.getHeight() : rectangle2D2.getWidth();
                boolean bl = false;
                if (i > 0) {
                    double d8 = (d4 + d7) / 2.0;
                    if (Math.abs(d6 - d3) < d8) {
                        bl = true;
                    }
                }
                if (bl) {
                    string = "";
                } else {
                    d3 = d6;
                    d4 = d7;
                }
                TextAnchor textAnchor = null;
                TextAnchor textAnchor2 = null;
                double d9 = 0.0;
                if (this.isVerticalTickLabels()) {
                    textAnchor = TextAnchor.CENTER_RIGHT;
                    textAnchor2 = TextAnchor.CENTER_RIGHT;
                    d9 = rectangleEdge == RectangleEdge.TOP ? 1.5707963267948966 : -1.5707963267948966;
                } else if (rectangleEdge == RectangleEdge.TOP) {
                    textAnchor = TextAnchor.BOTTOM_CENTER;
                    textAnchor2 = TextAnchor.BOTTOM_CENTER;
                } else {
                    textAnchor = TextAnchor.TOP_CENTER;
                    textAnchor2 = TextAnchor.TOP_CENTER;
                }
                NumberTick numberTick = new NumberTick(new Double(d5), string, textAnchor, textAnchor2, d9);
                arrayList.add(numberTick);
            }
        }
        return arrayList;
    }

    protected List refreshTicksVertical(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        ArrayList<NumberTick> arrayList = new ArrayList<NumberTick>();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        double d = this.getTickUnit().getSize();
        int n = this.calculateVisibleTickCount();
        double d2 = this.calculateLowestVisibleTickValue();
        double d3 = 0.0;
        double d4 = 0.0;
        if (n <= 500) {
            for (int i = 0; i < n; ++i) {
                double d5 = d2 + (double)i * d;
                double d6 = this.valueToJava2D(d5, rectangle2D, rectangleEdge);
                NumberFormat numberFormat = this.getNumberFormatOverride();
                String string = numberFormat != null ? numberFormat.format(d5) : this.valueToString(d5);
                Rectangle2D rectangle2D2 = TextUtilities.getTextBounds(string, graphics2D, graphics2D.getFontMetrics());
                double d7 = this.isVerticalTickLabels() ? rectangle2D2.getWidth() : rectangle2D2.getHeight();
                boolean bl = false;
                if (i > 0) {
                    double d8 = (d4 + d7) / 2.0;
                    if (Math.abs(d6 - d3) < d8) {
                        bl = true;
                    }
                }
                if (bl) {
                    string = "";
                } else {
                    d3 = d6;
                    d4 = d7;
                }
                TextAnchor textAnchor = null;
                TextAnchor textAnchor2 = null;
                double d9 = 0.0;
                if (this.isVerticalTickLabels()) {
                    textAnchor = TextAnchor.BOTTOM_CENTER;
                    textAnchor2 = TextAnchor.BOTTOM_CENTER;
                    d9 = rectangleEdge == RectangleEdge.LEFT ? -1.5707963267948966 : 1.5707963267948966;
                } else if (rectangleEdge == RectangleEdge.LEFT) {
                    textAnchor = TextAnchor.CENTER_RIGHT;
                    textAnchor2 = TextAnchor.CENTER_RIGHT;
                } else {
                    textAnchor = TextAnchor.CENTER_LEFT;
                    textAnchor2 = TextAnchor.CENTER_LEFT;
                }
                NumberTick numberTick = new NumberTick(new Double(d5), string, textAnchor, textAnchor2, d9);
                arrayList.add(numberTick);
            }
        }
        return arrayList;
    }

    public String valueToString(double d) {
        String string;
        try {
            string = (String)this.symbols.get((int)d);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            string = "";
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SymbolAxis)) {
            return false;
        }
        SymbolAxis symbolAxis = (SymbolAxis)object;
        if (!this.symbols.equals(symbolAxis.symbols)) {
            return false;
        }
        if (this.gridBandsVisible != symbolAxis.gridBandsVisible) {
            return false;
        }
        if (!PaintUtilities.equal(this.gridBandPaint, symbolAxis.gridBandPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.gridBandAlternatePaint, symbolAxis.gridBandAlternatePaint)) {
            return false;
        }
        return super.equals(object);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.gridBandPaint, objectOutputStream);
        SerialUtilities.writePaint(this.gridBandAlternatePaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.gridBandPaint = SerialUtilities.readPaint(objectInputStream);
        this.gridBandAlternatePaint = SerialUtilities.readPaint(objectInputStream);
    }
}

