/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.axis;

import ai.org.jfree.chart.axis.Timeline;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class SegmentedTimeline
implements Timeline,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1093779862539903110L;
    public static final long DAY_SEGMENT_SIZE = 86400000L;
    public static final long HOUR_SEGMENT_SIZE = 3600000L;
    public static final long FIFTEEN_MINUTE_SEGMENT_SIZE = 900000L;
    public static final long MINUTE_SEGMENT_SIZE = 60000L;
    public static long FIRST_MONDAY_AFTER_1900;
    public static TimeZone NO_DST_TIME_ZONE;
    public static TimeZone DEFAULT_TIME_ZONE;
    private Calendar workingCalendarNoDST;
    private Calendar workingCalendar = Calendar.getInstance();
    private long segmentSize;
    private int segmentsIncluded;
    private int segmentsExcluded;
    private int groupSegmentCount;
    private long startTime;
    private long segmentsIncludedSize;
    private long segmentsExcludedSize;
    private long segmentsGroupSize;
    private List exceptionSegments = new ArrayList();
    private SegmentedTimeline baseTimeline;
    private boolean adjustForDaylightSaving = false;

    public SegmentedTimeline(long l, int n, int n2) {
        this.segmentSize = l;
        this.segmentsIncluded = n;
        this.segmentsExcluded = n2;
        this.groupSegmentCount = this.segmentsIncluded + this.segmentsExcluded;
        this.segmentsIncludedSize = (long)this.segmentsIncluded * this.segmentSize;
        this.segmentsExcludedSize = (long)this.segmentsExcluded * this.segmentSize;
        this.segmentsGroupSize = this.segmentsIncludedSize + this.segmentsExcludedSize;
        int n3 = TimeZone.getDefault().getRawOffset();
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(n3, "UTC-" + n3);
        this.workingCalendarNoDST = new GregorianCalendar(simpleTimeZone, Locale.getDefault());
    }

    public static long firstMondayAfter1900() {
        int n = TimeZone.getDefault().getRawOffset();
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(n, "UTC-" + n);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(simpleTimeZone);
        gregorianCalendar.set(1900, 0, 1, 0, 0, 0);
        gregorianCalendar.set(14, 0);
        while (gregorianCalendar.get(7) != 2) {
            ((Calendar)gregorianCalendar).add(5, 1);
        }
        return gregorianCalendar.getTime().getTime();
    }

    public static SegmentedTimeline newMondayThroughFridayTimeline() {
        SegmentedTimeline segmentedTimeline = new SegmentedTimeline(86400000L, 5, 2);
        segmentedTimeline.setStartTime(SegmentedTimeline.firstMondayAfter1900());
        return segmentedTimeline;
    }

    public static SegmentedTimeline newFifteenMinuteTimeline() {
        SegmentedTimeline segmentedTimeline = new SegmentedTimeline(900000L, 28, 68);
        segmentedTimeline.setStartTime(SegmentedTimeline.firstMondayAfter1900() + 36L * segmentedTimeline.getSegmentSize());
        segmentedTimeline.setBaseTimeline(SegmentedTimeline.newMondayThroughFridayTimeline());
        return segmentedTimeline;
    }

    public boolean getAdjustForDaylightSaving() {
        return this.adjustForDaylightSaving;
    }

    public void setAdjustForDaylightSaving(boolean bl) {
        this.adjustForDaylightSaving = bl;
    }

    public void setStartTime(long l) {
        this.startTime = l;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int getSegmentsExcluded() {
        return this.segmentsExcluded;
    }

    public long getSegmentsExcludedSize() {
        return this.segmentsExcludedSize;
    }

    public int getGroupSegmentCount() {
        return this.groupSegmentCount;
    }

    public long getSegmentsGroupSize() {
        return this.segmentsGroupSize;
    }

    public int getSegmentsIncluded() {
        return this.segmentsIncluded;
    }

    public long getSegmentsIncludedSize() {
        return this.segmentsIncludedSize;
    }

    public long getSegmentSize() {
        return this.segmentSize;
    }

    public List getExceptionSegments() {
        return Collections.unmodifiableList(this.exceptionSegments);
    }

    public void setExceptionSegments(List list) {
        this.exceptionSegments = list;
    }

    public SegmentedTimeline getBaseTimeline() {
        return this.baseTimeline;
    }

    public void setBaseTimeline(SegmentedTimeline segmentedTimeline) {
        if (segmentedTimeline != null) {
            if (segmentedTimeline.getSegmentSize() < this.segmentSize) {
                throw new IllegalArgumentException("baseTimeline.getSegmentSize() is smaller than segmentSize");
            }
            if (segmentedTimeline.getStartTime() > this.startTime) {
                throw new IllegalArgumentException("baseTimeline.getStartTime() is after startTime");
            }
            if (segmentedTimeline.getSegmentSize() % this.segmentSize != 0L) {
                throw new IllegalArgumentException("baseTimeline.getSegmentSize() is not multiple of segmentSize");
            }
            if ((this.startTime - segmentedTimeline.getStartTime()) % this.segmentSize != 0L) {
                throw new IllegalArgumentException("baseTimeline is not aligned");
            }
        }
        this.baseTimeline = segmentedTimeline;
    }

    public long toTimelineValue(long l) {
        long l2;
        long l3 = l - this.startTime;
        long l4 = l3 % this.segmentsGroupSize;
        long l5 = l3 / this.segmentsGroupSize;
        if (l4 >= this.segmentsIncludedSize) {
            l2 = this.toTimelineValue(this.startTime + this.segmentsGroupSize * (l5 + 1L));
        } else {
            Segment segment = this.getSegment(l);
            if (segment.inExceptionSegments()) {
                int n;
                while ((n = this.binarySearchExceptionSegments(segment)) >= 0) {
                    l = ((Segment)this.exceptionSegments.get(n)).getSegmentEnd() + 1L;
                    segment = this.getSegment(l);
                }
                l2 = this.toTimelineValue(l);
            } else {
                long l6 = l - this.startTime;
                long l7 = l6 % this.segmentsGroupSize;
                long l8 = l6 / this.segmentsGroupSize;
                long l9 = this.getExceptionSegmentCount(this.startTime, l - 1L);
                l2 = l7 < this.segmentsIncludedSize ? this.segmentsIncludedSize * l8 + l7 - l9 * this.segmentSize : this.segmentsIncludedSize * (l8 + 1L) - l9 * this.segmentSize;
            }
        }
        return l2;
    }

    public long toTimelineValue(Date date) {
        return this.toTimelineValue(this.getTime(date));
    }

    public long toMillisecond(long l) {
        Segment segment = new Segment(this.startTime + l + l / this.segmentsIncludedSize * this.segmentsExcludedSize);
        for (long i = this.startTime; i <= segment.segmentStart; ++i) {
            long l2;
            while ((l2 = this.getExceptionSegmentCount(i, segment.millisecond / this.segmentSize * this.segmentSize - 1L)) > 0L) {
                i = segment.segmentStart;
                int n = 0;
                while ((long)n < l2) {
                    do {
                        segment.inc();
                    } while (segment.inExcludeSegments());
                    ++n;
                }
            }
            i = segment.segmentStart;
            while (segment.inExceptionSegments() || segment.inExcludeSegments()) {
                segment.inc();
                i += this.segmentSize;
            }
        }
        return this.getTimeFromLong(segment.millisecond);
    }

    public long getTimeFromLong(long l) {
        long l2 = l;
        if (this.adjustForDaylightSaving) {
            this.workingCalendarNoDST.setTime(new Date(l));
            this.workingCalendar.set(this.workingCalendarNoDST.get(1), this.workingCalendarNoDST.get(2), this.workingCalendarNoDST.get(5), this.workingCalendarNoDST.get(11), this.workingCalendarNoDST.get(12), this.workingCalendarNoDST.get(13));
            this.workingCalendar.set(14, this.workingCalendarNoDST.get(14));
            l2 = this.workingCalendar.getTime().getTime();
        }
        return l2;
    }

    public boolean containsDomainValue(long l) {
        Segment segment = this.getSegment(l);
        return segment.inIncludeSegments();
    }

    public boolean containsDomainValue(Date date) {
        return this.containsDomainValue(this.getTime(date));
    }

    public boolean containsDomainRange(long l, long l2) {
        if (l2 < l) {
            throw new IllegalArgumentException("domainValueEnd (" + l2 + ") < domainValueStart (" + l + ")");
        }
        Segment segment = this.getSegment(l);
        boolean bl = true;
        do {
            bl = segment.inIncludeSegments();
            if (segment.contains(l2)) break;
            segment.inc();
        } while (bl);
        return bl;
    }

    public boolean containsDomainRange(Date date, Date date2) {
        return this.containsDomainRange(this.getTime(date), this.getTime(date2));
    }

    public void addException(long l) {
        this.addException(new Segment(l));
    }

    public void addException(long l, long l2) {
        this.addException(new SegmentRange(l, l2));
    }

    public void addException(Date date) {
        this.addException(this.getTime(date));
    }

    public void addExceptions(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addException((Date)iterator.next());
        }
    }

    private void addException(Segment segment) {
        if (segment.inIncludeSegments()) {
            int n = this.binarySearchExceptionSegments(segment);
            this.exceptionSegments.add(-(n + 1), segment);
        }
    }

    public void addBaseTimelineException(long l) {
        Segment segment = this.baseTimeline.getSegment(l);
        if (segment.inIncludeSegments()) {
            Segment segment2 = this.getSegment(segment.getSegmentStart());
            while (segment2.getSegmentStart() <= segment.getSegmentEnd()) {
                if (segment2.inIncludeSegments()) {
                    long l2;
                    long l3 = segment2.getSegmentStart();
                    do {
                        l2 = segment2.getSegmentEnd();
                        segment2.inc();
                    } while (segment2.inIncludeSegments());
                    this.addException(l3, l2);
                    continue;
                }
                segment2.inc();
            }
        }
    }

    public void addBaseTimelineException(Date date) {
        this.addBaseTimelineException(this.getTime(date));
    }

    public void addBaseTimelineExclusions(long l, long l2) {
        Segment segment = this.baseTimeline.getSegment(l);
        while (segment.getSegmentStart() <= l2 && !segment.inExcludeSegments()) {
            segment.inc();
        }
        while (segment.getSegmentStart() <= l2) {
            long l3 = segment.getSegmentStart() + (long)this.baseTimeline.getSegmentsExcluded() * this.baseTimeline.getSegmentSize() - 1L;
            Segment segment2 = this.getSegment(segment.getSegmentStart());
            while (segment2.getSegmentStart() <= l3) {
                if (segment2.inIncludeSegments()) {
                    long l4;
                    long l5 = segment2.getSegmentStart();
                    do {
                        l4 = segment2.getSegmentEnd();
                        segment2.inc();
                    } while (segment2.inIncludeSegments());
                    this.addException(new BaseTimelineSegmentRange(l5, l4));
                    continue;
                }
                segment2.inc();
            }
            segment.inc(this.baseTimeline.getGroupSegmentCount());
        }
    }

    public long getExceptionSegmentCount(long l, long l2) {
        if (l2 < l) {
            return 0L;
        }
        int n = 0;
        for (Segment segment : this.exceptionSegments) {
            Segment segment2 = segment.intersect(l, l2);
            if (segment2 == null) continue;
            n = (int)((long)n + segment2.getSegmentCount());
        }
        return n;
    }

    public Segment getSegment(long l) {
        return new Segment(l);
    }

    public Segment getSegment(Date date) {
        return this.getSegment(this.getTime(date));
    }

    private boolean equals(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public boolean equals(Object object) {
        if (object instanceof SegmentedTimeline) {
            SegmentedTimeline segmentedTimeline = (SegmentedTimeline)object;
            boolean bl = this.segmentSize == segmentedTimeline.getSegmentSize();
            boolean bl2 = this.segmentsIncluded == segmentedTimeline.getSegmentsIncluded();
            boolean bl3 = this.segmentsExcluded == segmentedTimeline.getSegmentsExcluded();
            boolean bl4 = this.startTime == segmentedTimeline.getStartTime();
            boolean bl5 = this.equals(this.exceptionSegments, segmentedTimeline.getExceptionSegments());
            return bl && bl2 && bl3 && bl4 && bl5;
        }
        return false;
    }

    public int hashCode() {
        int n = 19;
        n = 37 * n + (int)(this.segmentSize ^ this.segmentSize >>> 32);
        n = 37 * n + (int)(this.startTime ^ this.startTime >>> 32);
        return n;
    }

    private int binarySearchExceptionSegments(Segment segment) {
        int n = 0;
        int n2 = this.exceptionSegments.size() - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            Segment segment2 = (Segment)this.exceptionSegments.get(n3);
            if (segment.contains(segment2) || segment2.contains(segment)) {
                return n3;
            }
            if (segment2.before(segment)) {
                n = n3 + 1;
                continue;
            }
            if (segment2.after(segment)) {
                n2 = n3 - 1;
                continue;
            }
            throw new IllegalStateException("Invalid condition.");
        }
        return -(n + 1);
    }

    public long getTime(Date date) {
        long l = date.getTime();
        if (this.adjustForDaylightSaving) {
            this.workingCalendar.setTime(date);
            this.workingCalendarNoDST.set(this.workingCalendar.get(1), this.workingCalendar.get(2), this.workingCalendar.get(5), this.workingCalendar.get(11), this.workingCalendar.get(12), this.workingCalendar.get(13));
            this.workingCalendarNoDST.set(14, this.workingCalendar.get(14));
            Date date2 = this.workingCalendarNoDST.getTime();
            l = date2.getTime();
        }
        return l;
    }

    public Date getDate(long l) {
        this.workingCalendarNoDST.setTime(new Date(l));
        return this.workingCalendarNoDST.getTime();
    }

    public Object clone() throws CloneNotSupportedException {
        SegmentedTimeline segmentedTimeline = (SegmentedTimeline)super.clone();
        return segmentedTimeline;
    }

    static {
        DEFAULT_TIME_ZONE = TimeZone.getDefault();
        int n = TimeZone.getDefault().getRawOffset();
        NO_DST_TIME_ZONE = new SimpleTimeZone(n, "UTC-" + n);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(NO_DST_TIME_ZONE);
        gregorianCalendar.set(1900, 0, 1, 0, 0, 0);
        gregorianCalendar.set(14, 0);
        while (gregorianCalendar.get(7) != 2) {
            ((Calendar)gregorianCalendar).add(5, 1);
        }
        FIRST_MONDAY_AFTER_1900 = gregorianCalendar.getTime().getTime();
    }

    protected class BaseTimelineSegmentRange
    extends SegmentRange {
        public BaseTimelineSegmentRange(long l, long l2) {
            super(l, l2);
        }
    }

    protected class SegmentRange
    extends Segment {
        private long segmentCount;

        public SegmentRange(long l, long l2) {
            Segment segment = SegmentedTimeline.this.getSegment(l);
            Segment segment2 = SegmentedTimeline.this.getSegment(l2);
            this.millisecond = l;
            this.segmentNumber = this.calculateSegmentNumber(l);
            this.segmentStart = segment.segmentStart;
            this.segmentEnd = segment2.segmentEnd;
            this.segmentCount = segment2.getSegmentNumber() - segment.getSegmentNumber() + 1L;
        }

        public long getSegmentCount() {
            return this.segmentCount;
        }

        public Segment intersect(long l, long l2) {
            long l3;
            long l4 = Math.max(l, this.segmentStart);
            if (l4 <= (l3 = Math.min(l2, this.segmentEnd))) {
                return new SegmentRange(l4, l3);
            }
            return null;
        }

        public boolean inIncludeSegments() {
            Segment segment = SegmentedTimeline.this.getSegment(this.segmentStart);
            while (segment.getSegmentStart() < this.segmentEnd) {
                if (!segment.inIncludeSegments()) {
                    return false;
                }
                segment.inc();
            }
            return true;
        }

        public boolean inExcludeSegments() {
            Segment segment = SegmentedTimeline.this.getSegment(this.segmentStart);
            while (segment.getSegmentStart() < this.segmentEnd) {
                if (!segment.inExceptionSegments()) {
                    return false;
                }
                segment.inc();
            }
            return true;
        }

        public void inc(long l) {
            throw new IllegalArgumentException("Not implemented in SegmentRange");
        }
    }

    public class Segment
    implements Comparable,
    Cloneable,
    Serializable {
        protected long segmentNumber;
        protected long segmentStart;
        protected long segmentEnd;
        protected long millisecond;

        protected Segment() {
        }

        protected Segment(long l) {
            this.segmentNumber = this.calculateSegmentNumber(l);
            this.segmentStart = SegmentedTimeline.this.startTime + this.segmentNumber * SegmentedTimeline.this.segmentSize;
            this.segmentEnd = this.segmentStart + SegmentedTimeline.this.segmentSize - 1L;
            this.millisecond = l;
        }

        public long calculateSegmentNumber(long l) {
            if (l >= SegmentedTimeline.this.startTime) {
                return (l - SegmentedTimeline.this.startTime) / SegmentedTimeline.this.segmentSize;
            }
            return (l - SegmentedTimeline.this.startTime) / SegmentedTimeline.this.segmentSize - 1L;
        }

        public long getSegmentNumber() {
            return this.segmentNumber;
        }

        public long getSegmentCount() {
            return 1L;
        }

        public long getSegmentStart() {
            return this.segmentStart;
        }

        public long getSegmentEnd() {
            return this.segmentEnd;
        }

        public long getMillisecond() {
            return this.millisecond;
        }

        public Date getDate() {
            return SegmentedTimeline.this.getDate(this.millisecond);
        }

        public boolean contains(long l) {
            return this.segmentStart <= l && l <= this.segmentEnd;
        }

        public boolean contains(long l, long l2) {
            return this.segmentStart <= l && l2 <= this.segmentEnd;
        }

        public boolean contains(Segment segment) {
            return this.contains(segment.getSegmentStart(), segment.getSegmentEnd());
        }

        public boolean contained(long l, long l2) {
            return l <= this.segmentStart && this.segmentEnd <= l2;
        }

        public Segment intersect(long l, long l2) {
            if (l <= this.segmentStart && this.segmentEnd <= l2) {
                return this;
            }
            return null;
        }

        public boolean before(Segment segment) {
            return this.segmentEnd < segment.getSegmentStart();
        }

        public boolean after(Segment segment) {
            return this.segmentStart > segment.getSegmentEnd();
        }

        public boolean equals(Object object) {
            if (object instanceof Segment) {
                Segment segment = (Segment)object;
                return this.segmentNumber == segment.getSegmentNumber() && this.segmentStart == segment.getSegmentStart() && this.segmentEnd == segment.getSegmentEnd() && this.millisecond == segment.getMillisecond();
            }
            return false;
        }

        public Segment copy() {
            try {
                return (Segment)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public int compareTo(Object object) {
            Segment segment = (Segment)object;
            if (this.before(segment)) {
                return -1;
            }
            if (this.after(segment)) {
                return 1;
            }
            return 0;
        }

        public boolean inIncludeSegments() {
            if (this.getSegmentNumberRelativeToGroup() < (long)SegmentedTimeline.this.segmentsIncluded) {
                return !this.inExceptionSegments();
            }
            return false;
        }

        public boolean inExcludeSegments() {
            return this.getSegmentNumberRelativeToGroup() >= (long)SegmentedTimeline.this.segmentsIncluded;
        }

        private long getSegmentNumberRelativeToGroup() {
            long l = this.segmentNumber % (long)SegmentedTimeline.this.groupSegmentCount;
            if (l < 0L) {
                l += (long)SegmentedTimeline.this.groupSegmentCount;
            }
            return l;
        }

        public boolean inExceptionSegments() {
            return SegmentedTimeline.this.binarySearchExceptionSegments(this) >= 0;
        }

        public void inc(long l) {
            this.segmentNumber += l;
            long l2 = l * SegmentedTimeline.this.segmentSize;
            this.segmentStart += l2;
            this.segmentEnd += l2;
            this.millisecond += l2;
        }

        public void inc() {
            this.inc(1L);
        }

        public void dec(long l) {
            this.segmentNumber -= l;
            long l2 = l * SegmentedTimeline.this.segmentSize;
            this.segmentStart -= l2;
            this.segmentEnd -= l2;
            this.millisecond -= l2;
        }

        public void dec() {
            this.dec(1L);
        }

        public void moveIndexToStart() {
            this.millisecond = this.segmentStart;
        }

        public void moveIndexToEnd() {
            this.millisecond = this.segmentEnd;
        }
    }
}

