/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart.axis;

import ai.org.jfree.chart.axis.DateTickUnitType;
import ai.org.jfree.chart.axis.TickUnit;
import ai.org.jfree.util.ObjectUtilities;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateTickUnit
extends TickUnit
implements Serializable {
    private static final long serialVersionUID = -7289292157229621901L;
    private DateTickUnitType unitType;
    private int count;
    private DateTickUnitType rollUnitType;
    private int rollCount;
    private DateFormat formatter;
    public static final int YEAR = 0;
    public static final int MONTH = 1;
    public static final int DAY = 2;
    public static final int HOUR = 3;
    public static final int MINUTE = 4;
    public static final int SECOND = 5;
    public static final int MILLISECOND = 6;
    private int unit;
    private int rollUnit;

    public DateTickUnit(DateTickUnitType dateTickUnitType, int n) {
        this(dateTickUnitType, n, DateFormat.getDateInstance(3));
    }

    public DateTickUnit(DateTickUnitType dateTickUnitType, int n, DateFormat dateFormat) {
        this(dateTickUnitType, n, dateTickUnitType, n, dateFormat);
    }

    public DateTickUnit(DateTickUnitType dateTickUnitType, int n, DateTickUnitType dateTickUnitType2, int n2, DateFormat dateFormat) {
        super(DateTickUnit.getMillisecondCount(dateTickUnitType, n));
        if (dateFormat == null) {
            throw new IllegalArgumentException("Null 'formatter' argument.");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Requires 'multiple' > 0.");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Requires 'rollMultiple' > 0.");
        }
        this.unitType = dateTickUnitType;
        this.count = n;
        this.rollUnitType = dateTickUnitType2;
        this.rollCount = n2;
        this.formatter = dateFormat;
        this.unit = DateTickUnit.unitTypeToInt(dateTickUnitType);
        this.rollUnit = DateTickUnit.unitTypeToInt(dateTickUnitType2);
    }

    public DateTickUnitType getUnitType() {
        return this.unitType;
    }

    public int getMultiple() {
        return this.count;
    }

    public DateTickUnitType getRollUnitType() {
        return this.rollUnitType;
    }

    public int getRollMultiple() {
        return this.rollCount;
    }

    public String valueToString(double d) {
        return this.formatter.format(new Date((long)d));
    }

    public String dateToString(Date date) {
        return this.formatter.format(date);
    }

    public Date addToDate(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        calendar.add(this.unitType.getCalendarField(), this.count);
        return calendar.getTime();
    }

    public Date rollDate(Date date) {
        return this.rollDate(date, TimeZone.getDefault());
    }

    public Date rollDate(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        calendar.add(this.rollUnitType.getCalendarField(), this.rollCount);
        return calendar.getTime();
    }

    public int getCalendarField() {
        return this.unitType.getCalendarField();
    }

    private static long getMillisecondCount(DateTickUnitType dateTickUnitType, int n) {
        if (dateTickUnitType.equals(DateTickUnitType.YEAR)) {
            return 31536000000L * (long)n;
        }
        if (dateTickUnitType.equals(DateTickUnitType.MONTH)) {
            return 2678400000L * (long)n;
        }
        if (dateTickUnitType.equals(DateTickUnitType.DAY)) {
            return 86400000L * (long)n;
        }
        if (dateTickUnitType.equals(DateTickUnitType.HOUR)) {
            return 3600000L * (long)n;
        }
        if (dateTickUnitType.equals(DateTickUnitType.MINUTE)) {
            return 60000L * (long)n;
        }
        if (dateTickUnitType.equals(DateTickUnitType.SECOND)) {
            return 1000L * (long)n;
        }
        if (dateTickUnitType.equals(DateTickUnitType.MILLISECOND)) {
            return n;
        }
        throw new IllegalArgumentException("The 'unit' argument has a value that is not recognised.");
    }

    private static DateTickUnitType intToUnitType(int n) {
        switch (n) {
            case 0: {
                return DateTickUnitType.YEAR;
            }
            case 1: {
                return DateTickUnitType.MONTH;
            }
            case 2: {
                return DateTickUnitType.DAY;
            }
            case 3: {
                return DateTickUnitType.HOUR;
            }
            case 4: {
                return DateTickUnitType.MINUTE;
            }
            case 5: {
                return DateTickUnitType.SECOND;
            }
            case 6: {
                return DateTickUnitType.MILLISECOND;
            }
        }
        throw new IllegalArgumentException("Unrecognised 'unit' value " + n + ".");
    }

    private static int unitTypeToInt(DateTickUnitType dateTickUnitType) {
        if (dateTickUnitType == null) {
            throw new IllegalArgumentException("Null 'unitType' argument.");
        }
        if (dateTickUnitType.equals(DateTickUnitType.YEAR)) {
            return 0;
        }
        if (dateTickUnitType.equals(DateTickUnitType.MONTH)) {
            return 1;
        }
        if (dateTickUnitType.equals(DateTickUnitType.DAY)) {
            return 2;
        }
        if (dateTickUnitType.equals(DateTickUnitType.HOUR)) {
            return 3;
        }
        if (dateTickUnitType.equals(DateTickUnitType.MINUTE)) {
            return 4;
        }
        if (dateTickUnitType.equals(DateTickUnitType.SECOND)) {
            return 5;
        }
        if (dateTickUnitType.equals(DateTickUnitType.MILLISECOND)) {
            return 6;
        }
        throw new IllegalArgumentException("The 'unitType' is not recognised");
    }

    private static DateFormat notNull(DateFormat dateFormat) {
        if (dateFormat == null) {
            return DateFormat.getDateInstance(3);
        }
        return dateFormat;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DateTickUnit)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DateTickUnit dateTickUnit = (DateTickUnit)object;
        if (!this.unitType.equals(dateTickUnit.unitType)) {
            return false;
        }
        if (this.count != dateTickUnit.count) {
            return false;
        }
        return ObjectUtilities.equal(this.formatter, dateTickUnit.formatter);
    }

    public int hashCode() {
        int n = 19;
        n = 37 * n + this.unitType.hashCode();
        n = 37 * n + this.count;
        n = 37 * n + this.formatter.hashCode();
        return n;
    }

    public String toString() {
        return "DateTickUnit[" + this.unitType.toString() + ", " + this.count + "]";
    }

    public DateTickUnit(int n, int n2, DateFormat dateFormat) {
        this(n, n2, n, n2, dateFormat);
    }

    public DateTickUnit(int n, int n2) {
        this(n, n2, null);
    }

    public DateTickUnit(int n, int n2, int n3, int n4, DateFormat dateFormat) {
        this(DateTickUnit.intToUnitType(n), n2, DateTickUnit.intToUnitType(n3), n4, DateTickUnit.notNull(dateFormat));
    }

    public int getUnit() {
        return this.unit;
    }

    public int getCount() {
        return this.count;
    }

    public int getRollUnit() {
        return this.rollUnit;
    }

    public int getRollCount() {
        return this.rollCount;
    }

    public Date addToDate(Date date) {
        return this.addToDate(date, TimeZone.getDefault());
    }
}

