/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart;

import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.util.ObjectUtilities;
import java.awt.Stroke;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class StrokeMap
implements Cloneable,
Serializable {
    static final long serialVersionUID = -8148916785963525169L;
    private transient Map store = new TreeMap();

    public Stroke getStroke(Comparable comparable) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        return (Stroke)this.store.get(comparable);
    }

    public boolean containsKey(Comparable comparable) {
        return this.store.containsKey(comparable);
    }

    public void put(Comparable comparable, Stroke stroke) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        this.store.put(comparable, stroke);
    }

    public void clear() {
        this.store.clear();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StrokeMap)) {
            return false;
        }
        StrokeMap strokeMap = (StrokeMap)object;
        if (this.store.size() != strokeMap.store.size()) {
            return false;
        }
        Set set = this.store.keySet();
        for (Comparable comparable : set) {
            Stroke stroke;
            Stroke stroke2 = this.getStroke(comparable);
            if (ObjectUtilities.equal(stroke2, stroke = strokeMap.getStroke(comparable))) continue;
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.store.size());
        Set set = this.store.keySet();
        for (Comparable comparable : set) {
            objectOutputStream.writeObject(comparable);
            Stroke stroke = this.getStroke(comparable);
            SerialUtilities.writeStroke(stroke, objectOutputStream);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.store = new TreeMap();
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            Comparable comparable = (Comparable)objectInputStream.readObject();
            Stroke stroke = SerialUtilities.readStroke(objectInputStream);
            this.store.put(comparable, stroke);
        }
    }
}

