/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart;

import ai.org.jfree.chart.JFreeChart;
import java.awt.Graphics2D;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class ChartTransferable
implements Transferable {
    final DataFlavor imageFlavor = new DataFlavor("image/x-java-image; class=java.awt.Image", "Image");
    private JFreeChart chart;
    private int width;
    private int height;
    private int minDrawWidth;
    private int minDrawHeight;
    private int maxDrawWidth;
    private int maxDrawHeight;

    public ChartTransferable(JFreeChart jFreeChart, int n, int n2) {
        this(jFreeChart, n, n2, true);
    }

    public ChartTransferable(JFreeChart jFreeChart, int n, int n2, boolean bl) {
        this(jFreeChart, n, n2, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE, true);
    }

    public ChartTransferable(JFreeChart jFreeChart, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        try {
            this.chart = (JFreeChart)jFreeChart.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            this.chart = jFreeChart;
        }
        this.width = n;
        this.height = n2;
        this.minDrawWidth = n3;
        this.minDrawHeight = n4;
        this.maxDrawWidth = n5;
        this.maxDrawHeight = n6;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{this.imageFlavor};
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.imageFlavor.equals(dataFlavor);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (this.imageFlavor.equals(dataFlavor)) {
            return this.createBufferedImage(this.chart, this.width, this.height, this.minDrawWidth, this.minDrawHeight, this.maxDrawWidth, this.maxDrawHeight);
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    private BufferedImage createBufferedImage(JFreeChart jFreeChart, int n, int n2, int n3, int n4, int n5, int n6) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        boolean bl = false;
        double d = n;
        double d2 = n2;
        double d3 = 1.0;
        double d4 = 1.0;
        if (d < (double)n3) {
            d3 = d / (double)n3;
            d = n3;
            bl = true;
        } else if (d > (double)n5) {
            d3 = d / (double)n5;
            d = n5;
            bl = true;
        }
        if (d2 < (double)n4) {
            d4 = d2 / (double)n4;
            d2 = n4;
            bl = true;
        } else if (d2 > (double)n6) {
            d4 = d2 / (double)n6;
            d2 = n6;
            bl = true;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, d, d2);
        if (bl) {
            AffineTransform affineTransform = AffineTransform.getScaleInstance(d3, d4);
            graphics2D.transform(affineTransform);
        }
        jFreeChart.draw(graphics2D, double_, null, null);
        graphics2D.dispose();
        return bufferedImage;
    }
}

