/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart;

import ai.org.jfree.chart.ChartMouseEvent;
import ai.org.jfree.chart.ChartMouseListener;
import ai.org.jfree.chart.ChartRenderingInfo;
import ai.org.jfree.chart.ChartTransferable;
import ai.org.jfree.chart.ChartUtilities;
import ai.org.jfree.chart.JFreeChart;
import ai.org.jfree.chart.editor.ChartEditor;
import ai.org.jfree.chart.editor.ChartEditorManager;
import ai.org.jfree.chart.entity.ChartEntity;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.event.ChartChangeEvent;
import ai.org.jfree.chart.event.ChartChangeListener;
import ai.org.jfree.chart.event.ChartProgressEvent;
import ai.org.jfree.chart.event.ChartProgressListener;
import ai.org.jfree.chart.event.OverlayChangeEvent;
import ai.org.jfree.chart.event.OverlayChangeListener;
import ai.org.jfree.chart.panel.Overlay;
import ai.org.jfree.chart.plot.Pannable;
import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.Zoomable;
import ai.org.jfree.chart.util.ResourceBundleWrapper;
import ai.org.jfree.io.SerialUtilities;
import ai.org.jfree.ui.ExtensionFileFilter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.EventListenerList;

public class ChartPanel
extends JPanel
implements ChartChangeListener,
ChartProgressListener,
ActionListener,
MouseListener,
MouseMotionListener,
OverlayChangeListener,
Printable,
Serializable {
    private static final long serialVersionUID = 6046366297214274674L;
    public static final boolean DEFAULT_BUFFER_USED = true;
    public static final int DEFAULT_WIDTH = 680;
    public static final int DEFAULT_HEIGHT = 420;
    public static final int DEFAULT_MINIMUM_DRAW_WIDTH = 300;
    public static final int DEFAULT_MINIMUM_DRAW_HEIGHT = 200;
    public static final int DEFAULT_MAXIMUM_DRAW_WIDTH = 1024;
    public static final int DEFAULT_MAXIMUM_DRAW_HEIGHT = 768;
    public static final int DEFAULT_ZOOM_TRIGGER_DISTANCE = 10;
    public static final String PROPERTIES_COMMAND = "PROPERTIES";
    public static final String COPY_COMMAND = "COPY";
    public static final String SAVE_COMMAND = "SAVE";
    public static final String PRINT_COMMAND = "PRINT";
    public static final String ZOOM_IN_BOTH_COMMAND = "ZOOM_IN_BOTH";
    public static final String ZOOM_IN_DOMAIN_COMMAND = "ZOOM_IN_DOMAIN";
    public static final String ZOOM_IN_RANGE_COMMAND = "ZOOM_IN_RANGE";
    public static final String ZOOM_OUT_BOTH_COMMAND = "ZOOM_OUT_BOTH";
    public static final String ZOOM_OUT_DOMAIN_COMMAND = "ZOOM_DOMAIN_BOTH";
    public static final String ZOOM_OUT_RANGE_COMMAND = "ZOOM_RANGE_BOTH";
    public static final String ZOOM_RESET_BOTH_COMMAND = "ZOOM_RESET_BOTH";
    public static final String ZOOM_RESET_DOMAIN_COMMAND = "ZOOM_RESET_DOMAIN";
    public static final String ZOOM_RESET_RANGE_COMMAND = "ZOOM_RESET_RANGE";
    private JFreeChart chart;
    private transient EventListenerList chartMouseListeners;
    private boolean useBuffer;
    private boolean refreshBuffer;
    private transient Image chartBuffer;
    private int chartBufferHeight;
    private int chartBufferWidth;
    private int minimumDrawWidth;
    private int minimumDrawHeight;
    private int maximumDrawWidth;
    private int maximumDrawHeight;
    private JPopupMenu popup;
    private ChartRenderingInfo info;
    private Point2D anchor;
    private double scaleX;
    private double scaleY;
    private PlotOrientation orientation = PlotOrientation.VERTICAL;
    private boolean domainZoomable = false;
    private boolean rangeZoomable = false;
    private Point2D zoomPoint = null;
    private transient Rectangle2D zoomRectangle = null;
    private boolean fillZoomRectangle = true;
    private int zoomTriggerDistance;
    private boolean horizontalAxisTrace = false;
    private boolean verticalAxisTrace = false;
    private transient Line2D verticalTraceLine;
    private transient Line2D horizontalTraceLine;
    private JMenuItem zoomInBothMenuItem;
    private JMenuItem zoomInDomainMenuItem;
    private JMenuItem zoomInRangeMenuItem;
    private JMenuItem zoomOutBothMenuItem;
    private JMenuItem zoomOutDomainMenuItem;
    private JMenuItem zoomOutRangeMenuItem;
    private JMenuItem zoomResetBothMenuItem;
    private JMenuItem zoomResetDomainMenuItem;
    private JMenuItem zoomResetRangeMenuItem;
    private File defaultDirectoryForSaveAs;
    private boolean enforceFileExtensions;
    private boolean ownToolTipDelaysActive;
    private int originalToolTipInitialDelay;
    private int originalToolTipReshowDelay;
    private int originalToolTipDismissDelay;
    private int ownToolTipInitialDelay;
    private int ownToolTipReshowDelay;
    private int ownToolTipDismissDelay;
    private double zoomInFactor = 0.5;
    private double zoomOutFactor = 2.0;
    private boolean zoomAroundAnchor;
    private transient Paint zoomOutlinePaint;
    private transient Paint zoomFillPaint;
    protected static ResourceBundle localizationResources = ResourceBundleWrapper.getBundle("ai.org.jfree.chart.LocalizationBundle");
    private double panW;
    private double panH;
    private Point panLast;
    private int panMask = 2;
    private List overlays;
    private Object mouseWheelHandler;

    public ChartPanel(JFreeChart jFreeChart) {
        this(jFreeChart, 680, 420, 300, 200, 1024, 768, true, true, true, true, true, true);
    }

    public ChartPanel(JFreeChart jFreeChart, boolean bl) {
        this(jFreeChart, 680, 420, 300, 200, 1024, 768, bl, true, true, true, true, true);
    }

    public ChartPanel(JFreeChart jFreeChart, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this(jFreeChart, 680, 420, 300, 200, 1024, 768, true, bl, bl2, bl3, bl4, bl5);
    }

    public ChartPanel(JFreeChart jFreeChart, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this(jFreeChart, n, n2, n3, n4, n5, n6, bl, bl2, true, bl3, bl4, bl5, bl6);
    }

    public ChartPanel(JFreeChart jFreeChart, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        this.setChart(jFreeChart);
        this.chartMouseListeners = new EventListenerList();
        this.info = new ChartRenderingInfo();
        this.setPreferredSize(new Dimension(n, n2));
        this.useBuffer = bl;
        this.refreshBuffer = false;
        this.minimumDrawWidth = n3;
        this.minimumDrawHeight = n4;
        this.maximumDrawWidth = n5;
        this.maximumDrawHeight = n6;
        this.zoomTriggerDistance = 10;
        this.popup = null;
        if (bl2 || bl3 || bl4 || bl5 || bl6) {
            this.popup = this.createPopupMenu(bl2, bl3, bl4, bl5, bl6);
        }
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.setDisplayToolTips(bl7);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.defaultDirectoryForSaveAs = null;
        this.enforceFileExtensions = true;
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        this.ownToolTipInitialDelay = toolTipManager.getInitialDelay();
        this.ownToolTipDismissDelay = toolTipManager.getDismissDelay();
        this.ownToolTipReshowDelay = toolTipManager.getReshowDelay();
        this.zoomAroundAnchor = false;
        this.zoomOutlinePaint = Color.blue;
        this.zoomFillPaint = new Color(0, 0, 255, 63);
        this.panMask = 2;
        String string = System.getProperty("os.name").toLowerCase();
        if (string.startsWith("mac os x")) {
            this.panMask = 8;
        }
        this.overlays = new ArrayList();
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public void setChart(JFreeChart jFreeChart) {
        if (this.chart != null) {
            this.chart.removeChangeListener(this);
            this.chart.removeProgressListener(this);
        }
        this.chart = jFreeChart;
        if (jFreeChart != null) {
            this.chart.addChangeListener(this);
            this.chart.addProgressListener(this);
            Plot plot = jFreeChart.getPlot();
            this.domainZoomable = false;
            this.rangeZoomable = false;
            if (plot instanceof Zoomable) {
                Zoomable zoomable = (Zoomable)((Object)plot);
                this.domainZoomable = zoomable.isDomainZoomable();
                this.rangeZoomable = zoomable.isRangeZoomable();
                this.orientation = zoomable.getOrientation();
            }
        } else {
            this.domainZoomable = false;
            this.rangeZoomable = false;
        }
        if (this.useBuffer) {
            this.refreshBuffer = true;
        }
        this.repaint();
    }

    public int getMinimumDrawWidth() {
        return this.minimumDrawWidth;
    }

    public void setMinimumDrawWidth(int n) {
        this.minimumDrawWidth = n;
    }

    public int getMaximumDrawWidth() {
        return this.maximumDrawWidth;
    }

    public void setMaximumDrawWidth(int n) {
        this.maximumDrawWidth = n;
    }

    public int getMinimumDrawHeight() {
        return this.minimumDrawHeight;
    }

    public void setMinimumDrawHeight(int n) {
        this.minimumDrawHeight = n;
    }

    public int getMaximumDrawHeight() {
        return this.maximumDrawHeight;
    }

    public void setMaximumDrawHeight(int n) {
        this.maximumDrawHeight = n;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public Point2D getAnchor() {
        return this.anchor;
    }

    protected void setAnchor(Point2D point2D) {
        this.anchor = point2D;
    }

    public JPopupMenu getPopupMenu() {
        return this.popup;
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this.popup = jPopupMenu;
    }

    public ChartRenderingInfo getChartRenderingInfo() {
        return this.info;
    }

    public void setMouseZoomable(boolean bl) {
        this.setMouseZoomable(bl, true);
    }

    public void setMouseZoomable(boolean bl, boolean bl2) {
        this.setDomainZoomable(bl);
        this.setRangeZoomable(bl);
        this.setFillZoomRectangle(bl2);
    }

    public boolean isDomainZoomable() {
        return this.domainZoomable;
    }

    public void setDomainZoomable(boolean bl) {
        if (bl) {
            Plot plot = this.chart.getPlot();
            if (plot instanceof Zoomable) {
                Zoomable zoomable = (Zoomable)((Object)plot);
                this.domainZoomable = bl && zoomable.isDomainZoomable();
            }
        } else {
            this.domainZoomable = false;
        }
    }

    public boolean isRangeZoomable() {
        return this.rangeZoomable;
    }

    public void setRangeZoomable(boolean bl) {
        if (bl) {
            Plot plot = this.chart.getPlot();
            if (plot instanceof Zoomable) {
                Zoomable zoomable = (Zoomable)((Object)plot);
                this.rangeZoomable = bl && zoomable.isRangeZoomable();
            }
        } else {
            this.rangeZoomable = false;
        }
    }

    public boolean getFillZoomRectangle() {
        return this.fillZoomRectangle;
    }

    public void setFillZoomRectangle(boolean bl) {
        this.fillZoomRectangle = bl;
    }

    public int getZoomTriggerDistance() {
        return this.zoomTriggerDistance;
    }

    public void setZoomTriggerDistance(int n) {
        this.zoomTriggerDistance = n;
    }

    public boolean getHorizontalAxisTrace() {
        return this.horizontalAxisTrace;
    }

    public void setHorizontalAxisTrace(boolean bl) {
        this.horizontalAxisTrace = bl;
    }

    protected Line2D getHorizontalTraceLine() {
        return this.horizontalTraceLine;
    }

    protected void setHorizontalTraceLine(Line2D line2D) {
        this.horizontalTraceLine = line2D;
    }

    public boolean getVerticalAxisTrace() {
        return this.verticalAxisTrace;
    }

    public void setVerticalAxisTrace(boolean bl) {
        this.verticalAxisTrace = bl;
    }

    protected Line2D getVerticalTraceLine() {
        return this.verticalTraceLine;
    }

    protected void setVerticalTraceLine(Line2D line2D) {
        this.verticalTraceLine = line2D;
    }

    public File getDefaultDirectoryForSaveAs() {
        return this.defaultDirectoryForSaveAs;
    }

    public void setDefaultDirectoryForSaveAs(File file) {
        if (file != null && !file.isDirectory()) {
            throw new IllegalArgumentException("The 'directory' argument is not a directory.");
        }
        this.defaultDirectoryForSaveAs = file;
    }

    public boolean isEnforceFileExtensions() {
        return this.enforceFileExtensions;
    }

    public void setEnforceFileExtensions(boolean bl) {
        this.enforceFileExtensions = bl;
    }

    public boolean getZoomAroundAnchor() {
        return this.zoomAroundAnchor;
    }

    public void setZoomAroundAnchor(boolean bl) {
        this.zoomAroundAnchor = bl;
    }

    public Paint getZoomFillPaint() {
        return this.zoomFillPaint;
    }

    public void setZoomFillPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.zoomFillPaint = paint;
    }

    public Paint getZoomOutlinePaint() {
        return this.zoomOutlinePaint;
    }

    public void setZoomOutlinePaint(Paint paint) {
        this.zoomOutlinePaint = paint;
    }

    public boolean isMouseWheelEnabled() {
        return this.mouseWheelHandler != null;
    }

    public void setMouseWheelEnabled(boolean bl) {
        if (bl && this.mouseWheelHandler == null) {
            try {
                Class<?> clazz = Class.forName("ai.org.jfree.chart.MouseWheelHandler");
                Constructor<?> constructor = clazz.getConstructor(ChartPanel.class);
                Object obj = constructor.newInstance(this);
                this.mouseWheelHandler = obj;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        } else if (!bl && this.mouseWheelHandler != null) {
            try {
                Class<?> clazz = Class.forName("java.awt.event.MouseWheelListener");
                Class<ChartPanel> clazz2 = ChartPanel.class;
                Method method = clazz2.getMethod("removeMouseWheelListener", clazz);
                method.invoke((Object)this, this.mouseWheelHandler);
                this.mouseWheelHandler = null;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    public void addOverlay(Overlay overlay) {
        if (overlay == null) {
            throw new IllegalArgumentException("Null 'overlay' argument.");
        }
        this.overlays.add(overlay);
        overlay.addChangeListener(this);
        this.repaint();
    }

    public void removeOverlay(Overlay overlay) {
        if (overlay == null) {
            throw new IllegalArgumentException("Null 'overlay' argument.");
        }
        boolean bl = this.overlays.remove(overlay);
        if (bl) {
            overlay.removeChangeListener(this);
            this.repaint();
        }
    }

    public void overlayChanged(OverlayChangeEvent overlayChangeEvent) {
        this.repaint();
    }

    public void setDisplayToolTips(boolean bl) {
        if (bl) {
            ToolTipManager.sharedInstance().registerComponent(this);
        } else {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        EntityCollection entityCollection;
        String string = null;
        if (this.info != null && (entityCollection = this.info.getEntityCollection()) != null) {
            Insets insets = this.getInsets();
            ChartEntity chartEntity = entityCollection.getEntity((int)((double)(mouseEvent.getX() - insets.left) / this.scaleX), (int)((double)(mouseEvent.getY() - insets.top) / this.scaleY));
            if (chartEntity != null) {
                string = chartEntity.getToolTipText();
            }
        }
        return string;
    }

    public Point translateJava2DToScreen(Point2D point2D) {
        Insets insets = this.getInsets();
        int n = (int)(point2D.getX() * this.scaleX + (double)insets.left);
        int n2 = (int)(point2D.getY() * this.scaleY + (double)insets.top);
        return new Point(n, n2);
    }

    public Point2D translateScreenToJava2D(Point point) {
        Insets insets = this.getInsets();
        double d = (point.getX() - (double)insets.left) / this.scaleX;
        double d2 = (point.getY() - (double)insets.top) / this.scaleY;
        return new Point2D.Double(d, d2);
    }

    public Rectangle2D scale(Rectangle2D rectangle2D) {
        Insets insets = this.getInsets();
        double d = rectangle2D.getX() * this.getScaleX() + (double)insets.left;
        double d2 = rectangle2D.getY() * this.getScaleY() + (double)insets.top;
        double d3 = rectangle2D.getWidth() * this.getScaleX();
        double d4 = rectangle2D.getHeight() * this.getScaleY();
        return new Rectangle2D.Double(d, d2, d3, d4);
    }

    public ChartEntity getEntityForPoint(int n, int n2) {
        ChartEntity chartEntity = null;
        if (this.info != null) {
            Insets insets = this.getInsets();
            double d = (double)(n - insets.left) / this.scaleX;
            double d2 = (double)(n2 - insets.top) / this.scaleY;
            EntityCollection entityCollection = this.info.getEntityCollection();
            chartEntity = entityCollection != null ? entityCollection.getEntity(d, d2) : null;
        }
        return chartEntity;
    }

    public boolean getRefreshBuffer() {
        return this.refreshBuffer;
    }

    public void setRefreshBuffer(boolean bl) {
        this.refreshBuffer = bl;
    }

    public void paintComponent(Graphics graphics) {
        Object object3;
        Object object2;
        super.paintComponent(graphics);
        if (this.chart == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        Rectangle2D.Double double_ = new Rectangle2D.Double(insets.left, insets.top, dimension.getWidth() - (double)insets.left - (double)insets.right, dimension.getHeight() - (double)insets.top - (double)insets.bottom);
        boolean bl = false;
        double d = ((RectangularShape)double_).getWidth();
        double d2 = ((RectangularShape)double_).getHeight();
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        if (d < (double)this.minimumDrawWidth) {
            this.scaleX = d / (double)this.minimumDrawWidth;
            d = this.minimumDrawWidth;
            bl = true;
        } else if (d > (double)this.maximumDrawWidth) {
            this.scaleX = d / (double)this.maximumDrawWidth;
            d = this.maximumDrawWidth;
            bl = true;
        }
        if (d2 < (double)this.minimumDrawHeight) {
            this.scaleY = d2 / (double)this.minimumDrawHeight;
            d2 = this.minimumDrawHeight;
            bl = true;
        } else if (d2 > (double)this.maximumDrawHeight) {
            this.scaleY = d2 / (double)this.maximumDrawHeight;
            d2 = this.maximumDrawHeight;
            bl = true;
        }
        Rectangle2D.Double double_2 = new Rectangle2D.Double(0.0, 0.0, d, d2);
        if (this.useBuffer) {
            if (this.chartBuffer == null || (double)this.chartBufferWidth != ((RectangularShape)double_).getWidth() || (double)this.chartBufferHeight != ((RectangularShape)double_).getHeight()) {
                this.chartBufferWidth = (int)((RectangularShape)double_).getWidth();
                this.chartBufferHeight = (int)((RectangularShape)double_).getHeight();
                object2 = graphics2D.getDeviceConfiguration();
                this.chartBuffer = ((GraphicsConfiguration)object2).createCompatibleImage(this.chartBufferWidth, this.chartBufferHeight, 3);
                this.refreshBuffer = true;
            }
            if (this.refreshBuffer) {
                this.refreshBuffer = false;
                object2 = new Rectangle2D.Double(0.0, 0.0, this.chartBufferWidth, this.chartBufferHeight);
                object3 = (Graphics2D)this.chartBuffer.getGraphics();
                Composite composite = ((Graphics2D)object3).getComposite();
                ((Graphics2D)object3).setComposite(AlphaComposite.getInstance(1, 0.0f));
                Rectangle rectangle = new Rectangle(0, 0, this.chartBufferWidth, this.chartBufferHeight);
                ((Graphics2D)object3).fill(rectangle);
                ((Graphics2D)object3).setComposite(composite);
                if (bl) {
                    AffineTransform affineTransform = ((Graphics2D)object3).getTransform();
                    AffineTransform affineTransform2 = AffineTransform.getScaleInstance(this.scaleX, this.scaleY);
                    ((Graphics2D)object3).transform(affineTransform2);
                    this.chart.draw((Graphics2D)object3, double_2, this.anchor, this.info);
                    ((Graphics2D)object3).setTransform(affineTransform);
                } else {
                    this.chart.draw((Graphics2D)object3, (Rectangle2D)object2, this.anchor, this.info);
                }
            }
            graphics2D.drawImage(this.chartBuffer, insets.left, insets.top, this);
        } else {
            object2 = graphics2D.getTransform();
            graphics2D.translate(insets.left, insets.top);
            if (bl) {
                object3 = AffineTransform.getScaleInstance(this.scaleX, this.scaleY);
                graphics2D.transform((AffineTransform)object3);
            }
            this.chart.draw(graphics2D, double_2, this.anchor, this.info);
            graphics2D.setTransform((AffineTransform)object2);
        }
        for (Object object3 : this.overlays) {
            object3.paintOverlay(graphics2D, this);
        }
        this.drawZoomRectangle(graphics2D, !this.useBuffer);
        graphics2D.dispose();
        this.anchor = null;
        this.verticalTraceLine = null;
        this.horizontalTraceLine = null;
    }

    public void chartChanged(ChartChangeEvent chartChangeEvent) {
        this.refreshBuffer = true;
        Plot plot = this.chart.getPlot();
        if (plot instanceof Zoomable) {
            Zoomable zoomable = (Zoomable)((Object)plot);
            this.orientation = zoomable.getOrientation();
        }
        this.repaint();
    }

    public void chartProgress(ChartProgressEvent chartProgressEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        double d = -1.0;
        double d2 = -1.0;
        if (this.zoomPoint != null) {
            d = this.zoomPoint.getX();
            d2 = this.zoomPoint.getY();
        }
        if (string.equals(PROPERTIES_COMMAND)) {
            this.doEditChartProperties();
        } else if (string.equals(COPY_COMMAND)) {
            this.doCopy();
        } else if (string.equals(SAVE_COMMAND)) {
            try {
                this.doSaveAs();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (string.equals(PRINT_COMMAND)) {
            this.createChartPrintJob();
        } else if (string.equals(ZOOM_IN_BOTH_COMMAND)) {
            this.zoomInBoth(d, d2);
        } else if (string.equals(ZOOM_IN_DOMAIN_COMMAND)) {
            this.zoomInDomain(d, d2);
        } else if (string.equals(ZOOM_IN_RANGE_COMMAND)) {
            this.zoomInRange(d, d2);
        } else if (string.equals(ZOOM_OUT_BOTH_COMMAND)) {
            this.zoomOutBoth(d, d2);
        } else if (string.equals(ZOOM_OUT_DOMAIN_COMMAND)) {
            this.zoomOutDomain(d, d2);
        } else if (string.equals(ZOOM_OUT_RANGE_COMMAND)) {
            this.zoomOutRange(d, d2);
        } else if (string.equals(ZOOM_RESET_BOTH_COMMAND)) {
            this.restoreAutoBounds();
        } else if (string.equals(ZOOM_RESET_DOMAIN_COMMAND)) {
            this.restoreAutoDomainBounds();
        } else if (string.equals(ZOOM_RESET_RANGE_COMMAND)) {
            this.restoreAutoRangeBounds();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this.ownToolTipDelaysActive) {
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            this.originalToolTipInitialDelay = toolTipManager.getInitialDelay();
            toolTipManager.setInitialDelay(this.ownToolTipInitialDelay);
            this.originalToolTipReshowDelay = toolTipManager.getReshowDelay();
            toolTipManager.setReshowDelay(this.ownToolTipReshowDelay);
            this.originalToolTipDismissDelay = toolTipManager.getDismissDelay();
            toolTipManager.setDismissDelay(this.ownToolTipDismissDelay);
            this.ownToolTipDelaysActive = true;
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.ownToolTipDelaysActive) {
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            toolTipManager.setInitialDelay(this.originalToolTipInitialDelay);
            toolTipManager.setReshowDelay(this.originalToolTipReshowDelay);
            toolTipManager.setDismissDelay(this.originalToolTipDismissDelay);
            this.ownToolTipDelaysActive = false;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.chart == null) {
            return;
        }
        Plot plot = this.chart.getPlot();
        int n = mouseEvent.getModifiers();
        if ((n & this.panMask) == this.panMask) {
            Rectangle2D rectangle2D;
            Pannable pannable;
            if (plot instanceof Pannable && ((pannable = (Pannable)((Object)plot)).isDomainPannable() || pannable.isRangePannable()) && (rectangle2D = this.getScreenDataArea(mouseEvent.getX(), mouseEvent.getY())) != null && rectangle2D.contains(mouseEvent.getPoint())) {
                this.panW = rectangle2D.getWidth();
                this.panH = rectangle2D.getHeight();
                this.panLast = mouseEvent.getPoint();
                this.setCursor(Cursor.getPredefinedCursor(13));
            }
        } else if (this.zoomRectangle == null) {
            Rectangle2D rectangle2D = this.getScreenDataArea(mouseEvent.getX(), mouseEvent.getY());
            this.zoomPoint = rectangle2D != null ? this.getPointInRectangle(mouseEvent.getX(), mouseEvent.getY(), rectangle2D) : null;
            if (mouseEvent.isPopupTrigger() && this.popup != null) {
                this.displayPopupMenu(mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private Point2D getPointInRectangle(int n, int n2, Rectangle2D rectangle2D) {
        double d = Math.max(rectangle2D.getMinX(), Math.min((double)n, rectangle2D.getMaxX()));
        double d2 = Math.max(rectangle2D.getMinY(), Math.min((double)n2, rectangle2D.getMaxY()));
        return new Point2D.Double(d, d2);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.popup != null && this.popup.isShowing()) {
            return;
        }
        if (this.panLast != null) {
            double d = (double)mouseEvent.getX() - this.panLast.getX();
            double d2 = (double)mouseEvent.getY() - this.panLast.getY();
            if (d == 0.0 && d2 == 0.0) {
                return;
            }
            double d3 = -d / this.panW;
            double d4 = d2 / this.panH;
            boolean bl = this.chart.getPlot().isNotify();
            this.chart.getPlot().setNotify(false);
            Pannable pannable = (Pannable)((Object)this.chart.getPlot());
            if (pannable.getOrientation() == PlotOrientation.VERTICAL) {
                pannable.panDomainAxes(d3, this.info.getPlotInfo(), this.panLast);
                pannable.panRangeAxes(d4, this.info.getPlotInfo(), this.panLast);
            } else {
                pannable.panDomainAxes(d4, this.info.getPlotInfo(), this.panLast);
                pannable.panRangeAxes(d3, this.info.getPlotInfo(), this.panLast);
            }
            this.panLast = mouseEvent.getPoint();
            this.chart.getPlot().setNotify(bl);
            return;
        }
        if (this.zoomPoint == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        if (!this.useBuffer) {
            this.drawZoomRectangle(graphics2D, true);
        }
        boolean bl = false;
        boolean bl2 = false;
        if (this.orientation == PlotOrientation.HORIZONTAL) {
            bl = this.rangeZoomable;
            bl2 = this.domainZoomable;
        } else {
            bl = this.domainZoomable;
            bl2 = this.rangeZoomable;
        }
        Rectangle2D rectangle2D = this.getScreenDataArea((int)this.zoomPoint.getX(), (int)this.zoomPoint.getY());
        if (bl && bl2) {
            double d = Math.min((double)mouseEvent.getX(), rectangle2D.getMaxX());
            double d5 = Math.min((double)mouseEvent.getY(), rectangle2D.getMaxY());
            this.zoomRectangle = new Rectangle2D.Double(this.zoomPoint.getX(), this.zoomPoint.getY(), d - this.zoomPoint.getX(), d5 - this.zoomPoint.getY());
        } else if (bl) {
            double d = Math.min((double)mouseEvent.getX(), rectangle2D.getMaxX());
            this.zoomRectangle = new Rectangle2D.Double(this.zoomPoint.getX(), rectangle2D.getMinY(), d - this.zoomPoint.getX(), rectangle2D.getHeight());
        } else if (bl2) {
            double d = Math.min((double)mouseEvent.getY(), rectangle2D.getMaxY());
            this.zoomRectangle = new Rectangle2D.Double(rectangle2D.getMinX(), this.zoomPoint.getY(), rectangle2D.getWidth(), d - this.zoomPoint.getY());
        }
        if (this.useBuffer) {
            this.repaint();
        } else {
            this.drawZoomRectangle(graphics2D, true);
        }
        graphics2D.dispose();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.panLast != null) {
            this.panLast = null;
            this.setCursor(Cursor.getDefaultCursor());
        } else if (this.zoomRectangle != null) {
            boolean bl;
            boolean bl2 = false;
            boolean bl3 = false;
            if (this.orientation == PlotOrientation.HORIZONTAL) {
                bl2 = this.rangeZoomable;
                bl3 = this.domainZoomable;
            } else {
                bl2 = this.domainZoomable;
                bl3 = this.rangeZoomable;
            }
            boolean bl4 = bl2 && Math.abs((double)mouseEvent.getX() - this.zoomPoint.getX()) >= (double)this.zoomTriggerDistance;
            boolean bl5 = bl = bl3 && Math.abs((double)mouseEvent.getY() - this.zoomPoint.getY()) >= (double)this.zoomTriggerDistance;
            if (bl4 || bl) {
                if (bl2 && (double)mouseEvent.getX() < this.zoomPoint.getX() || bl3 && (double)mouseEvent.getY() < this.zoomPoint.getY()) {
                    this.restoreAutoBounds();
                } else {
                    double d;
                    double d2;
                    double d3;
                    double d4;
                    Rectangle2D rectangle2D = this.getScreenDataArea((int)this.zoomPoint.getX(), (int)this.zoomPoint.getY());
                    double d5 = rectangle2D.getMaxX();
                    double d6 = rectangle2D.getMaxY();
                    if (!bl3) {
                        d4 = this.zoomPoint.getX();
                        d3 = rectangle2D.getMinY();
                        d2 = Math.min(this.zoomRectangle.getWidth(), d5 - this.zoomPoint.getX());
                        d = rectangle2D.getHeight();
                    } else if (!bl2) {
                        d4 = rectangle2D.getMinX();
                        d3 = this.zoomPoint.getY();
                        d2 = rectangle2D.getWidth();
                        d = Math.min(this.zoomRectangle.getHeight(), d6 - this.zoomPoint.getY());
                    } else {
                        d4 = this.zoomPoint.getX();
                        d3 = this.zoomPoint.getY();
                        d2 = Math.min(this.zoomRectangle.getWidth(), d5 - this.zoomPoint.getX());
                        d = Math.min(this.zoomRectangle.getHeight(), d6 - this.zoomPoint.getY());
                    }
                    Rectangle2D.Double double_ = new Rectangle2D.Double(d4, d3, d2, d);
                    this.zoom(double_);
                }
                this.zoomPoint = null;
                this.zoomRectangle = null;
            } else {
                Graphics2D graphics2D = (Graphics2D)this.getGraphics();
                if (this.useBuffer) {
                    this.repaint();
                } else {
                    this.drawZoomRectangle(graphics2D, true);
                }
                graphics2D.dispose();
                this.zoomPoint = null;
                this.zoomRectangle = null;
            }
        } else if (mouseEvent.isPopupTrigger() && this.popup != null) {
            this.displayPopupMenu(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Object object;
        Insets insets = this.getInsets();
        int n = (int)((double)(mouseEvent.getX() - insets.left) / this.scaleX);
        int n2 = (int)((double)(mouseEvent.getY() - insets.top) / this.scaleY);
        this.anchor = new Point2D.Double(n, n2);
        if (this.chart == null) {
            return;
        }
        this.chart.setNotify(true);
        EventListener[] eventListenerArray = this.chartMouseListeners.getListeners(ChartMouseListener.class);
        if (eventListenerArray.length == 0) {
            return;
        }
        ChartEntity chartEntity = null;
        if (this.info != null && (object = this.info.getEntityCollection()) != null) {
            chartEntity = object.getEntity(n, n2);
        }
        object = new ChartMouseEvent(this.getChart(), mouseEvent, chartEntity);
        for (int i = eventListenerArray.length - 1; i >= 0; --i) {
            ((ChartMouseListener)eventListenerArray[i]).chartMouseClicked((ChartMouseEvent)object);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        if (this.horizontalAxisTrace) {
            this.drawHorizontalAxisTrace(graphics2D, mouseEvent.getX());
        }
        if (this.verticalAxisTrace) {
            this.drawVerticalAxisTrace(graphics2D, mouseEvent.getY());
        }
        graphics2D.dispose();
        EventListener[] eventListenerArray = this.chartMouseListeners.getListeners(ChartMouseListener.class);
        if (eventListenerArray.length == 0) {
            return;
        }
        Insets insets = this.getInsets();
        int n = (int)((double)(mouseEvent.getX() - insets.left) / this.scaleX);
        int n2 = (int)((double)(mouseEvent.getY() - insets.top) / this.scaleY);
        ChartEntity chartEntity = null;
        if (this.info != null && (object = this.info.getEntityCollection()) != null) {
            chartEntity = object.getEntity(n, n2);
        }
        if (this.chart != null) {
            object = new ChartMouseEvent(this.getChart(), mouseEvent, chartEntity);
            for (int i = eventListenerArray.length - 1; i >= 0; --i) {
                ((ChartMouseListener)eventListenerArray[i]).chartMouseMoved((ChartMouseEvent)object);
            }
        }
    }

    public void zoomInBoth(double d, double d2) {
        Plot plot = this.chart.getPlot();
        if (plot == null) {
            return;
        }
        boolean bl = plot.isNotify();
        plot.setNotify(false);
        this.zoomInDomain(d, d2);
        this.zoomInRange(d, d2);
        plot.setNotify(bl);
    }

    public void zoomInDomain(double d, double d2) {
        Plot plot = this.chart.getPlot();
        if (plot instanceof Zoomable) {
            boolean bl = plot.isNotify();
            plot.setNotify(false);
            Zoomable zoomable = (Zoomable)((Object)plot);
            zoomable.zoomDomainAxes(this.zoomInFactor, this.info.getPlotInfo(), this.translateScreenToJava2D(new Point((int)d, (int)d2)), this.zoomAroundAnchor);
            plot.setNotify(bl);
        }
    }

    public void zoomInRange(double d, double d2) {
        Plot plot = this.chart.getPlot();
        if (plot instanceof Zoomable) {
            boolean bl = plot.isNotify();
            plot.setNotify(false);
            Zoomable zoomable = (Zoomable)((Object)plot);
            zoomable.zoomRangeAxes(this.zoomInFactor, this.info.getPlotInfo(), this.translateScreenToJava2D(new Point((int)d, (int)d2)), this.zoomAroundAnchor);
            plot.setNotify(bl);
        }
    }

    public void zoomOutBoth(double d, double d2) {
        Plot plot = this.chart.getPlot();
        if (plot == null) {
            return;
        }
        boolean bl = plot.isNotify();
        plot.setNotify(false);
        this.zoomOutDomain(d, d2);
        this.zoomOutRange(d, d2);
        plot.setNotify(bl);
    }

    public void zoomOutDomain(double d, double d2) {
        Plot plot = this.chart.getPlot();
        if (plot instanceof Zoomable) {
            boolean bl = plot.isNotify();
            plot.setNotify(false);
            Zoomable zoomable = (Zoomable)((Object)plot);
            zoomable.zoomDomainAxes(this.zoomOutFactor, this.info.getPlotInfo(), this.translateScreenToJava2D(new Point((int)d, (int)d2)), this.zoomAroundAnchor);
            plot.setNotify(bl);
        }
    }

    public void zoomOutRange(double d, double d2) {
        Plot plot = this.chart.getPlot();
        if (plot instanceof Zoomable) {
            boolean bl = plot.isNotify();
            plot.setNotify(false);
            Zoomable zoomable = (Zoomable)((Object)plot);
            zoomable.zoomRangeAxes(this.zoomOutFactor, this.info.getPlotInfo(), this.translateScreenToJava2D(new Point((int)d, (int)d2)), this.zoomAroundAnchor);
            plot.setNotify(bl);
        }
    }

    public void zoom(Rectangle2D rectangle2D) {
        Point2D point2D = this.translateScreenToJava2D(new Point((int)Math.ceil(rectangle2D.getX()), (int)Math.ceil(rectangle2D.getY())));
        PlotRenderingInfo plotRenderingInfo = this.info.getPlotInfo();
        Rectangle2D rectangle2D2 = this.getScreenDataArea((int)rectangle2D.getCenterX(), (int)rectangle2D.getCenterY());
        if (rectangle2D.getHeight() > 0.0 && rectangle2D.getWidth() > 0.0) {
            double d = (rectangle2D.getMinX() - rectangle2D2.getMinX()) / rectangle2D2.getWidth();
            double d2 = (rectangle2D.getMaxX() - rectangle2D2.getMinX()) / rectangle2D2.getWidth();
            double d3 = (rectangle2D2.getMaxY() - rectangle2D.getMaxY()) / rectangle2D2.getHeight();
            double d4 = (rectangle2D2.getMaxY() - rectangle2D.getMinY()) / rectangle2D2.getHeight();
            Plot plot = this.chart.getPlot();
            if (plot instanceof Zoomable) {
                boolean bl = plot.isNotify();
                plot.setNotify(false);
                Zoomable zoomable = (Zoomable)((Object)plot);
                if (zoomable.getOrientation() == PlotOrientation.HORIZONTAL) {
                    zoomable.zoomDomainAxes(d3, d4, plotRenderingInfo, point2D);
                    zoomable.zoomRangeAxes(d, d2, plotRenderingInfo, point2D);
                } else {
                    zoomable.zoomDomainAxes(d, d2, plotRenderingInfo, point2D);
                    zoomable.zoomRangeAxes(d3, d4, plotRenderingInfo, point2D);
                }
                plot.setNotify(bl);
            }
        }
    }

    public void restoreAutoBounds() {
        Plot plot = this.chart.getPlot();
        if (plot == null) {
            return;
        }
        boolean bl = plot.isNotify();
        plot.setNotify(false);
        this.restoreAutoDomainBounds();
        this.restoreAutoRangeBounds();
        plot.setNotify(bl);
    }

    public void restoreAutoDomainBounds() {
        Plot plot = this.chart.getPlot();
        if (plot instanceof Zoomable) {
            Zoomable zoomable = (Zoomable)((Object)plot);
            boolean bl = plot.isNotify();
            plot.setNotify(false);
            Point2D point2D = this.zoomPoint != null ? this.zoomPoint : new Point();
            zoomable.zoomDomainAxes(0.0, this.info.getPlotInfo(), point2D);
            plot.setNotify(bl);
        }
    }

    public void restoreAutoRangeBounds() {
        Plot plot = this.chart.getPlot();
        if (plot instanceof Zoomable) {
            Zoomable zoomable = (Zoomable)((Object)plot);
            boolean bl = plot.isNotify();
            plot.setNotify(false);
            Point2D point2D = this.zoomPoint != null ? this.zoomPoint : new Point();
            zoomable.zoomRangeAxes(0.0, this.info.getPlotInfo(), point2D);
            plot.setNotify(bl);
        }
    }

    public Rectangle2D getScreenDataArea() {
        Rectangle2D rectangle2D = this.info.getPlotInfo().getDataArea();
        Insets insets = this.getInsets();
        double d = rectangle2D.getX() * this.scaleX + (double)insets.left;
        double d2 = rectangle2D.getY() * this.scaleY + (double)insets.top;
        double d3 = rectangle2D.getWidth() * this.scaleX;
        double d4 = rectangle2D.getHeight() * this.scaleY;
        return new Rectangle2D.Double(d, d2, d3, d4);
    }

    public Rectangle2D getScreenDataArea(int n, int n2) {
        Rectangle2D rectangle2D;
        PlotRenderingInfo plotRenderingInfo = this.info.getPlotInfo();
        if (plotRenderingInfo.getSubplotCount() == 0) {
            rectangle2D = this.getScreenDataArea();
        } else {
            Point2D point2D = this.translateScreenToJava2D(new Point(n, n2));
            int n3 = plotRenderingInfo.getSubplotIndex(point2D);
            if (n3 == -1) {
                return null;
            }
            rectangle2D = this.scale(plotRenderingInfo.getSubplotInfo(n3).getDataArea());
        }
        return rectangle2D;
    }

    public int getInitialDelay() {
        return this.ownToolTipInitialDelay;
    }

    public int getReshowDelay() {
        return this.ownToolTipReshowDelay;
    }

    public int getDismissDelay() {
        return this.ownToolTipDismissDelay;
    }

    public void setInitialDelay(int n) {
        this.ownToolTipInitialDelay = n;
    }

    public void setReshowDelay(int n) {
        this.ownToolTipReshowDelay = n;
    }

    public void setDismissDelay(int n) {
        this.ownToolTipDismissDelay = n;
    }

    public double getZoomInFactor() {
        return this.zoomInFactor;
    }

    public void setZoomInFactor(double d) {
        this.zoomInFactor = d;
    }

    public double getZoomOutFactor() {
        return this.zoomOutFactor;
    }

    public void setZoomOutFactor(double d) {
        this.zoomOutFactor = d;
    }

    private void drawZoomRectangle(Graphics2D graphics2D, boolean bl) {
        if (this.zoomRectangle != null) {
            if (bl) {
                graphics2D.setXORMode(Color.gray);
            }
            if (this.fillZoomRectangle) {
                graphics2D.setPaint(this.zoomFillPaint);
                graphics2D.fill(this.zoomRectangle);
            } else {
                graphics2D.setPaint(this.zoomOutlinePaint);
                graphics2D.draw(this.zoomRectangle);
            }
            if (bl) {
                graphics2D.setPaintMode();
            }
        }
    }

    private void drawHorizontalAxisTrace(Graphics2D graphics2D, int n) {
        Rectangle2D rectangle2D = this.getScreenDataArea();
        graphics2D.setXORMode(Color.orange);
        if ((int)rectangle2D.getMinX() < n && n < (int)rectangle2D.getMaxX()) {
            if (this.verticalTraceLine != null) {
                graphics2D.draw(this.verticalTraceLine);
                this.verticalTraceLine.setLine(n, (int)rectangle2D.getMinY(), n, (int)rectangle2D.getMaxY());
            } else {
                this.verticalTraceLine = new Line2D.Float(n, (int)rectangle2D.getMinY(), n, (int)rectangle2D.getMaxY());
            }
            graphics2D.draw(this.verticalTraceLine);
        }
        graphics2D.setPaintMode();
    }

    private void drawVerticalAxisTrace(Graphics2D graphics2D, int n) {
        Rectangle2D rectangle2D = this.getScreenDataArea();
        graphics2D.setXORMode(Color.orange);
        if ((int)rectangle2D.getMinY() < n && n < (int)rectangle2D.getMaxY()) {
            if (this.horizontalTraceLine != null) {
                graphics2D.draw(this.horizontalTraceLine);
                this.horizontalTraceLine.setLine((int)rectangle2D.getMinX(), n, (int)rectangle2D.getMaxX(), n);
            } else {
                this.horizontalTraceLine = new Line2D.Float((int)rectangle2D.getMinX(), n, (int)rectangle2D.getMaxX(), n);
            }
            graphics2D.draw(this.horizontalTraceLine);
        }
        graphics2D.setPaintMode();
    }

    public void doEditChartProperties() {
        ChartEditor chartEditor = ChartEditorManager.getChartEditor(this.chart);
        int n = JOptionPane.showConfirmDialog(this, chartEditor, localizationResources.getString("Chart_Properties"), 2, -1);
        if (n == 0) {
            chartEditor.updateChart(this.chart);
        }
    }

    public void doCopy() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Insets insets = this.getInsets();
        int n = this.getWidth() - insets.left - insets.right;
        int n2 = this.getHeight() - insets.top - insets.bottom;
        ChartTransferable chartTransferable = new ChartTransferable(this.chart, n, n2, this.getMinimumDrawWidth(), this.getMinimumDrawHeight(), this.getMaximumDrawWidth(), this.getMaximumDrawHeight(), true);
        clipboard.setContents(chartTransferable, null);
    }

    public void doSaveAs() throws IOException {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(this.defaultDirectoryForSaveAs);
        ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter(localizationResources.getString("PNG_Image_Files"), ".png");
        jFileChooser.addChoosableFileFilter(extensionFileFilter);
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            String string = jFileChooser.getSelectedFile().getPath();
            if (this.isEnforceFileExtensions() && !string.endsWith(".png")) {
                string = string + ".png";
            }
            ChartUtilities.saveChartAsPNG(new File(string), this.chart, this.getWidth(), this.getHeight());
        }
    }

    public void createChartPrintJob() {
        PageFormat pageFormat;
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat2 = printerJob.pageDialog(pageFormat = printerJob.defaultPage());
        if (pageFormat2 != pageFormat) {
            printerJob.setPrintable(this, pageFormat2);
            if (printerJob.printDialog()) {
                try {
                    printerJob.print();
                }
                catch (PrinterException printerException) {
                    JOptionPane.showMessageDialog(this, printerException);
                }
            }
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n != 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = pageFormat.getImageableX();
        double d2 = pageFormat.getImageableY();
        double d3 = pageFormat.getImageableWidth();
        double d4 = pageFormat.getImageableHeight();
        this.chart.draw(graphics2D, new Rectangle2D.Double(d, d2, d3, d4), this.anchor, null);
        return 0;
    }

    public void addChartMouseListener(ChartMouseListener chartMouseListener) {
        if (chartMouseListener == null) {
            throw new IllegalArgumentException("Null 'listener' argument.");
        }
        this.chartMouseListeners.add(ChartMouseListener.class, chartMouseListener);
    }

    public void removeChartMouseListener(ChartMouseListener chartMouseListener) {
        this.chartMouseListeners.remove(ChartMouseListener.class, chartMouseListener);
    }

    public EventListener[] getListeners(Class clazz) {
        if (clazz == ChartMouseListener.class) {
            return this.chartMouseListeners.getListeners(clazz);
        }
        return super.getListeners(clazz);
    }

    protected JPopupMenu createPopupMenu(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return this.createPopupMenu(bl, false, bl2, bl3, bl4);
    }

    protected JPopupMenu createPopupMenu(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        JMenuItem jMenuItem;
        JPopupMenu jPopupMenu = new JPopupMenu(localizationResources.getString("Chart") + ":");
        boolean bl6 = false;
        if (bl) {
            jMenuItem = new JMenuItem(localizationResources.getString("Properties..."));
            jMenuItem.setActionCommand(PROPERTIES_COMMAND);
            jMenuItem.addActionListener(this);
            jPopupMenu.add(jMenuItem);
            bl6 = true;
        }
        if (bl2) {
            if (bl6) {
                jPopupMenu.addSeparator();
                bl6 = false;
            }
            jMenuItem = new JMenuItem(localizationResources.getString("Copy"));
            jMenuItem.setActionCommand(COPY_COMMAND);
            jMenuItem.addActionListener(this);
            jPopupMenu.add(jMenuItem);
            boolean bl7 = bl6 = !bl3;
        }
        if (bl3) {
            if (bl6) {
                jPopupMenu.addSeparator();
                bl6 = false;
            }
            jMenuItem = new JMenuItem(localizationResources.getString("Save_as..."));
            jMenuItem.setActionCommand(SAVE_COMMAND);
            jMenuItem.addActionListener(this);
            jPopupMenu.add(jMenuItem);
            bl6 = true;
        }
        if (bl4) {
            if (bl6) {
                jPopupMenu.addSeparator();
                bl6 = false;
            }
            jMenuItem = new JMenuItem(localizationResources.getString("Print..."));
            jMenuItem.setActionCommand(PRINT_COMMAND);
            jMenuItem.addActionListener(this);
            jPopupMenu.add(jMenuItem);
            bl6 = true;
        }
        if (bl5) {
            if (bl6) {
                jPopupMenu.addSeparator();
                bl6 = false;
            }
            jMenuItem = new JMenu(localizationResources.getString("Zoom_In"));
            this.zoomInBothMenuItem = new JMenuItem(localizationResources.getString("All_Axes"));
            this.zoomInBothMenuItem.setActionCommand(ZOOM_IN_BOTH_COMMAND);
            this.zoomInBothMenuItem.addActionListener(this);
            ((JMenu)jMenuItem).add(this.zoomInBothMenuItem);
            ((JMenu)jMenuItem).addSeparator();
            this.zoomInDomainMenuItem = new JMenuItem(localizationResources.getString("Domain_Axis"));
            this.zoomInDomainMenuItem.setActionCommand(ZOOM_IN_DOMAIN_COMMAND);
            this.zoomInDomainMenuItem.addActionListener(this);
            ((JMenu)jMenuItem).add(this.zoomInDomainMenuItem);
            this.zoomInRangeMenuItem = new JMenuItem(localizationResources.getString("Range_Axis"));
            this.zoomInRangeMenuItem.setActionCommand(ZOOM_IN_RANGE_COMMAND);
            this.zoomInRangeMenuItem.addActionListener(this);
            ((JMenu)jMenuItem).add(this.zoomInRangeMenuItem);
            jPopupMenu.add(jMenuItem);
            JMenu jMenu = new JMenu(localizationResources.getString("Zoom_Out"));
            this.zoomOutBothMenuItem = new JMenuItem(localizationResources.getString("All_Axes"));
            this.zoomOutBothMenuItem.setActionCommand(ZOOM_OUT_BOTH_COMMAND);
            this.zoomOutBothMenuItem.addActionListener(this);
            jMenu.add(this.zoomOutBothMenuItem);
            jMenu.addSeparator();
            this.zoomOutDomainMenuItem = new JMenuItem(localizationResources.getString("Domain_Axis"));
            this.zoomOutDomainMenuItem.setActionCommand(ZOOM_OUT_DOMAIN_COMMAND);
            this.zoomOutDomainMenuItem.addActionListener(this);
            jMenu.add(this.zoomOutDomainMenuItem);
            this.zoomOutRangeMenuItem = new JMenuItem(localizationResources.getString("Range_Axis"));
            this.zoomOutRangeMenuItem.setActionCommand(ZOOM_OUT_RANGE_COMMAND);
            this.zoomOutRangeMenuItem.addActionListener(this);
            jMenu.add(this.zoomOutRangeMenuItem);
            jPopupMenu.add(jMenu);
            JMenu jMenu2 = new JMenu(localizationResources.getString("Auto_Range"));
            this.zoomResetBothMenuItem = new JMenuItem(localizationResources.getString("All_Axes"));
            this.zoomResetBothMenuItem.setActionCommand(ZOOM_RESET_BOTH_COMMAND);
            this.zoomResetBothMenuItem.addActionListener(this);
            jMenu2.add(this.zoomResetBothMenuItem);
            jMenu2.addSeparator();
            this.zoomResetDomainMenuItem = new JMenuItem(localizationResources.getString("Domain_Axis"));
            this.zoomResetDomainMenuItem.setActionCommand(ZOOM_RESET_DOMAIN_COMMAND);
            this.zoomResetDomainMenuItem.addActionListener(this);
            jMenu2.add(this.zoomResetDomainMenuItem);
            this.zoomResetRangeMenuItem = new JMenuItem(localizationResources.getString("Range_Axis"));
            this.zoomResetRangeMenuItem.setActionCommand(ZOOM_RESET_RANGE_COMMAND);
            this.zoomResetRangeMenuItem.addActionListener(this);
            jMenu2.add(this.zoomResetRangeMenuItem);
            jPopupMenu.addSeparator();
            jPopupMenu.add(jMenu2);
        }
        return jPopupMenu;
    }

    protected void displayPopupMenu(int n, int n2) {
        Plot plot;
        if (this.popup == null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        Plot plot2 = plot = this.chart != null ? this.chart.getPlot() : null;
        if (plot instanceof Zoomable) {
            Zoomable zoomable = (Zoomable)((Object)plot);
            bl = zoomable.isDomainZoomable();
            bl2 = zoomable.isRangeZoomable();
        }
        if (this.zoomInDomainMenuItem != null) {
            this.zoomInDomainMenuItem.setEnabled(bl);
        }
        if (this.zoomOutDomainMenuItem != null) {
            this.zoomOutDomainMenuItem.setEnabled(bl);
        }
        if (this.zoomResetDomainMenuItem != null) {
            this.zoomResetDomainMenuItem.setEnabled(bl);
        }
        if (this.zoomInRangeMenuItem != null) {
            this.zoomInRangeMenuItem.setEnabled(bl2);
        }
        if (this.zoomOutRangeMenuItem != null) {
            this.zoomOutRangeMenuItem.setEnabled(bl2);
        }
        if (this.zoomResetRangeMenuItem != null) {
            this.zoomResetRangeMenuItem.setEnabled(bl2);
        }
        if (this.zoomInBothMenuItem != null) {
            this.zoomInBothMenuItem.setEnabled(bl && bl2);
        }
        if (this.zoomOutBothMenuItem != null) {
            this.zoomOutBothMenuItem.setEnabled(bl && bl2);
        }
        if (this.zoomResetBothMenuItem != null) {
            this.zoomResetBothMenuItem.setEnabled(bl && bl2);
        }
        this.popup.show(this, n, n2);
    }

    public void updateUI() {
        if (this.popup != null) {
            SwingUtilities.updateComponentTreeUI(this.popup);
        }
        super.updateUI();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.zoomFillPaint, objectOutputStream);
        SerialUtilities.writePaint(this.zoomOutlinePaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.zoomFillPaint = SerialUtilities.readPaint(objectInputStream);
        this.zoomOutlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.chartMouseListeners = new EventListenerList();
        if (this.chart != null) {
            this.chart.addChangeListener(this);
        }
    }
}

