/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.chart;

import ai.org.jfree.chart.ChartTheme;
import ai.org.jfree.chart.JFreeChart;
import ai.org.jfree.chart.StandardChartTheme;
import ai.org.jfree.chart.axis.CategoryAxis;
import ai.org.jfree.chart.axis.CategoryAxis3D;
import ai.org.jfree.chart.axis.DateAxis;
import ai.org.jfree.chart.axis.NumberAxis;
import ai.org.jfree.chart.axis.NumberAxis3D;
import ai.org.jfree.chart.axis.Timeline;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.labels.BoxAndWhiskerToolTipGenerator;
import ai.org.jfree.chart.labels.CategoryToolTipGenerator;
import ai.org.jfree.chart.labels.HighLowItemLabelGenerator;
import ai.org.jfree.chart.labels.IntervalCategoryToolTipGenerator;
import ai.org.jfree.chart.labels.ItemLabelAnchor;
import ai.org.jfree.chart.labels.ItemLabelPosition;
import ai.org.jfree.chart.labels.PieToolTipGenerator;
import ai.org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import ai.org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import ai.org.jfree.chart.labels.StandardPieToolTipGenerator;
import ai.org.jfree.chart.labels.StandardXYToolTipGenerator;
import ai.org.jfree.chart.labels.StandardXYZToolTipGenerator;
import ai.org.jfree.chart.labels.XYToolTipGenerator;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.plot.MultiplePiePlot;
import ai.org.jfree.chart.plot.PiePlot;
import ai.org.jfree.chart.plot.PiePlot3D;
import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PolarPlot;
import ai.org.jfree.chart.plot.RingPlot;
import ai.org.jfree.chart.plot.ValueMarker;
import ai.org.jfree.chart.plot.WaferMapPlot;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.chart.renderer.DefaultPolarItemRenderer;
import ai.org.jfree.chart.renderer.WaferMapRenderer;
import ai.org.jfree.chart.renderer.category.AreaRenderer;
import ai.org.jfree.chart.renderer.category.BarRenderer;
import ai.org.jfree.chart.renderer.category.BarRenderer3D;
import ai.org.jfree.chart.renderer.category.BoxAndWhiskerRenderer;
import ai.org.jfree.chart.renderer.category.GanttRenderer;
import ai.org.jfree.chart.renderer.category.GradientBarPainter;
import ai.org.jfree.chart.renderer.category.LineAndShapeRenderer;
import ai.org.jfree.chart.renderer.category.LineRenderer3D;
import ai.org.jfree.chart.renderer.category.StackedAreaRenderer;
import ai.org.jfree.chart.renderer.category.StackedBarRenderer;
import ai.org.jfree.chart.renderer.category.StackedBarRenderer3D;
import ai.org.jfree.chart.renderer.category.StandardBarPainter;
import ai.org.jfree.chart.renderer.category.WaterfallBarRenderer;
import ai.org.jfree.chart.renderer.xy.CandlestickRenderer;
import ai.org.jfree.chart.renderer.xy.GradientXYBarPainter;
import ai.org.jfree.chart.renderer.xy.HighLowRenderer;
import ai.org.jfree.chart.renderer.xy.StackedXYAreaRenderer2;
import ai.org.jfree.chart.renderer.xy.StandardXYBarPainter;
import ai.org.jfree.chart.renderer.xy.WindItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYAreaRenderer;
import ai.org.jfree.chart.renderer.xy.XYBarRenderer;
import ai.org.jfree.chart.renderer.xy.XYBoxAndWhiskerRenderer;
import ai.org.jfree.chart.renderer.xy.XYBubbleRenderer;
import ai.org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import ai.org.jfree.chart.renderer.xy.XYStepAreaRenderer;
import ai.org.jfree.chart.renderer.xy.XYStepRenderer;
import ai.org.jfree.chart.title.TextTitle;
import ai.org.jfree.chart.title.Title;
import ai.org.jfree.chart.urls.PieURLGenerator;
import ai.org.jfree.chart.urls.StandardCategoryURLGenerator;
import ai.org.jfree.chart.urls.StandardPieURLGenerator;
import ai.org.jfree.chart.urls.StandardXYURLGenerator;
import ai.org.jfree.chart.urls.StandardXYZURLGenerator;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.data.category.IntervalCategoryDataset;
import ai.org.jfree.data.general.DefaultPieDataset;
import ai.org.jfree.data.general.PieDataset;
import ai.org.jfree.data.general.WaferMapDataset;
import ai.org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import ai.org.jfree.data.statistics.BoxAndWhiskerXYDataset;
import ai.org.jfree.data.xy.IntervalXYDataset;
import ai.org.jfree.data.xy.OHLCDataset;
import ai.org.jfree.data.xy.TableXYDataset;
import ai.org.jfree.data.xy.WindDataset;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.data.xy.XYZDataset;
import ai.org.jfree.ui.Layer;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.ui.RectangleInsets;
import ai.org.jfree.ui.TextAnchor;
import ai.org.jfree.util.PublicCloneable;
import ai.org.jfree.util.SortOrder;
import ai.org.jfree.util.TableOrder;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;

public abstract class ChartFactory {
    private static ChartTheme currentTheme = new StandardChartTheme("JFree");

    public static ChartTheme getChartTheme() {
        return currentTheme;
    }

    public static void setChartTheme(ChartTheme chartTheme) {
        if (chartTheme == null) {
            throw new IllegalArgumentException("Null 'theme' argument.");
        }
        currentTheme = chartTheme;
        if (chartTheme instanceof StandardChartTheme) {
            StandardChartTheme standardChartTheme = (StandardChartTheme)chartTheme;
            if (standardChartTheme.getName().equals("Legacy")) {
                BarRenderer.setDefaultBarPainter(new StandardBarPainter());
                XYBarRenderer.setDefaultBarPainter(new StandardXYBarPainter());
            } else {
                BarRenderer.setDefaultBarPainter(new GradientBarPainter());
                XYBarRenderer.setDefaultBarPainter(new GradientXYBarPainter());
            }
        }
    }

    public static JFreeChart createPieChart(String string, PieDataset pieDataset, boolean bl, boolean bl2, Locale locale) {
        PiePlot piePlot = new PiePlot(pieDataset);
        piePlot.setLabelGenerator(new StandardPieSectionLabelGenerator(locale));
        piePlot.setInsets(new RectangleInsets(0.0, 5.0, 5.0, 5.0));
        if (bl2) {
            piePlot.setToolTipGenerator(new StandardPieToolTipGenerator(locale));
        }
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, piePlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createPieChart(String string, PieDataset pieDataset, boolean bl, boolean bl2, boolean bl3) {
        PiePlot piePlot = new PiePlot(pieDataset);
        piePlot.setLabelGenerator(new StandardPieSectionLabelGenerator());
        piePlot.setInsets(new RectangleInsets(0.0, 5.0, 5.0, 5.0));
        if (bl2) {
            piePlot.setToolTipGenerator(new StandardPieToolTipGenerator());
        }
        if (bl3) {
            piePlot.setURLGenerator(new StandardPieURLGenerator());
        }
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, piePlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createPieChart(String string, PieDataset pieDataset, PieDataset pieDataset2, int n, boolean bl, boolean bl2, boolean bl3, Locale locale, boolean bl4, boolean bl5) {
        PiePlot piePlot = new PiePlot(pieDataset);
        piePlot.setLabelGenerator(new StandardPieSectionLabelGenerator(locale));
        piePlot.setInsets(new RectangleInsets(0.0, 5.0, 5.0, 5.0));
        if (bl3) {
            piePlot.setToolTipGenerator(new StandardPieToolTipGenerator(locale));
        }
        List list = pieDataset.getKeys();
        DefaultPieDataset defaultPieDataset = null;
        if (bl5) {
            defaultPieDataset = new DefaultPieDataset();
        }
        double d = 255.0 / (double)n;
        for (Object object : list) {
            double d2;
            Number number = pieDataset.getValue((Comparable)object);
            Number number2 = pieDataset2.getValue((Comparable)object);
            if (number2 == null) {
                if (bl) {
                    piePlot.setSectionPaint((Comparable)object, (Paint)Color.green);
                } else {
                    piePlot.setSectionPaint((Comparable)object, (Paint)Color.red);
                }
                if (!bl5) continue;
                defaultPieDataset.setValue((Comparable)((Object)(object + " (+100%)")), number);
                continue;
            }
            double d3 = (number.doubleValue() / number2.doubleValue() - 1.0) * 100.0;
            double d4 = d2 = Math.abs(d3) >= (double)n ? 255.0 : Math.abs(d3) * d;
            if (bl && number.doubleValue() > number2.doubleValue() || !bl && number.doubleValue() < number2.doubleValue()) {
                piePlot.setSectionPaint((Comparable)object, (Paint)new Color(0, (int)d2, 0));
            } else {
                piePlot.setSectionPaint((Comparable)object, (Paint)new Color((int)d2, 0, 0));
            }
            if (!bl5) continue;
            defaultPieDataset.setValue((Comparable)((Object)(object + " (" + (d3 >= 0.0 ? "+" : "") + NumberFormat.getPercentInstance().format(d3 / 100.0) + ")")), number);
        }
        if (bl5) {
            piePlot.setDataset(defaultPieDataset);
        }
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, piePlot, bl2);
        if (bl4) {
            Object object;
            object = null;
            object = new TextTitle("Bright " + (bl ? "red" : "green") + "=change >=-" + n + "%, Bright " + (!bl ? "red" : "green") + "=change >=+" + n + "%", new Font("SansSerif", 0, 10));
            jFreeChart.addSubtitle((Title)object);
        }
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createPieChart(String string, PieDataset pieDataset, PieDataset pieDataset2, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        PiePlot piePlot = new PiePlot(pieDataset);
        piePlot.setLabelGenerator(new StandardPieSectionLabelGenerator());
        piePlot.setInsets(new RectangleInsets(0.0, 5.0, 5.0, 5.0));
        if (bl3) {
            piePlot.setToolTipGenerator(new StandardPieToolTipGenerator());
        }
        if (bl4) {
            piePlot.setURLGenerator(new StandardPieURLGenerator());
        }
        List list = pieDataset.getKeys();
        DefaultPieDataset defaultPieDataset = null;
        if (bl6) {
            defaultPieDataset = new DefaultPieDataset();
        }
        double d = 255.0 / (double)n;
        for (Object object : list) {
            double d2;
            Number number = pieDataset.getValue((Comparable)object);
            Number number2 = pieDataset2.getValue((Comparable)object);
            if (number2 == null) {
                if (bl) {
                    piePlot.setSectionPaint((Comparable)object, (Paint)Color.green);
                } else {
                    piePlot.setSectionPaint((Comparable)object, (Paint)Color.red);
                }
                if (!bl6) continue;
                defaultPieDataset.setValue((Comparable)((Object)(object + " (+100%)")), number);
                continue;
            }
            double d3 = (number.doubleValue() / number2.doubleValue() - 1.0) * 100.0;
            double d4 = d2 = Math.abs(d3) >= (double)n ? 255.0 : Math.abs(d3) * d;
            if (bl && number.doubleValue() > number2.doubleValue() || !bl && number.doubleValue() < number2.doubleValue()) {
                piePlot.setSectionPaint((Comparable)object, (Paint)new Color(0, (int)d2, 0));
            } else {
                piePlot.setSectionPaint((Comparable)object, (Paint)new Color((int)d2, 0, 0));
            }
            if (!bl6) continue;
            defaultPieDataset.setValue((Comparable)((Object)(object + " (" + (d3 >= 0.0 ? "+" : "") + NumberFormat.getPercentInstance().format(d3 / 100.0) + ")")), number);
        }
        if (bl6) {
            piePlot.setDataset(defaultPieDataset);
        }
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, piePlot, bl2);
        if (bl5) {
            Object object;
            object = null;
            object = new TextTitle("Bright " + (bl ? "red" : "green") + "=change >=-" + n + "%, Bright " + (!bl ? "red" : "green") + "=change >=+" + n + "%", new Font("SansSerif", 0, 10));
            jFreeChart.addSubtitle((Title)object);
        }
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createRingChart(String string, PieDataset pieDataset, boolean bl, boolean bl2, Locale locale) {
        RingPlot ringPlot = new RingPlot(pieDataset);
        ringPlot.setLabelGenerator(new StandardPieSectionLabelGenerator(locale));
        ringPlot.setInsets(new RectangleInsets(0.0, 5.0, 5.0, 5.0));
        if (bl2) {
            ringPlot.setToolTipGenerator(new StandardPieToolTipGenerator(locale));
        }
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, ringPlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createRingChart(String string, PieDataset pieDataset, boolean bl, boolean bl2, boolean bl3) {
        RingPlot ringPlot = new RingPlot(pieDataset);
        ringPlot.setLabelGenerator(new StandardPieSectionLabelGenerator());
        ringPlot.setInsets(new RectangleInsets(0.0, 5.0, 5.0, 5.0));
        if (bl2) {
            ringPlot.setToolTipGenerator(new StandardPieToolTipGenerator());
        }
        if (bl3) {
            ringPlot.setURLGenerator(new StandardPieURLGenerator());
        }
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, ringPlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createMultiplePieChart(String string, CategoryDataset categoryDataset, TableOrder tableOrder, boolean bl, boolean bl2, boolean bl3) {
        PiePlot piePlot;
        Serializable serializable;
        if (tableOrder == null) {
            throw new IllegalArgumentException("Null 'order' argument.");
        }
        MultiplePiePlot multiplePiePlot = new MultiplePiePlot(categoryDataset);
        multiplePiePlot.setDataExtractOrder(tableOrder);
        multiplePiePlot.setBackgroundPaint(null);
        multiplePiePlot.setOutlineStroke(null);
        if (bl2) {
            serializable = new StandardPieToolTipGenerator();
            piePlot = (PiePlot)multiplePiePlot.getPieChart().getPlot();
            piePlot.setToolTipGenerator((PieToolTipGenerator)((Object)serializable));
        }
        if (bl3) {
            serializable = new StandardPieURLGenerator();
            piePlot = (PiePlot)multiplePiePlot.getPieChart().getPlot();
            piePlot.setURLGenerator((PieURLGenerator)((Object)serializable));
        }
        serializable = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, multiplePiePlot, bl);
        currentTheme.apply((JFreeChart)serializable);
        return serializable;
    }

    public static JFreeChart createPieChart3D(String string, PieDataset pieDataset, boolean bl, boolean bl2, Locale locale) {
        PiePlot3D piePlot3D = new PiePlot3D(pieDataset);
        piePlot3D.setInsets(new RectangleInsets(0.0, 5.0, 5.0, 5.0));
        if (bl2) {
            piePlot3D.setToolTipGenerator(new StandardPieToolTipGenerator(locale));
        }
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, piePlot3D, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createPieChart3D(String string, PieDataset pieDataset, boolean bl, boolean bl2, boolean bl3) {
        PiePlot3D piePlot3D = new PiePlot3D(pieDataset);
        piePlot3D.setInsets(new RectangleInsets(0.0, 5.0, 5.0, 5.0));
        if (bl2) {
            piePlot3D.setToolTipGenerator(new StandardPieToolTipGenerator());
        }
        if (bl3) {
            piePlot3D.setURLGenerator(new StandardPieURLGenerator());
        }
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, piePlot3D, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createMultiplePieChart3D(String string, CategoryDataset categoryDataset, TableOrder tableOrder, boolean bl, boolean bl2, boolean bl3) {
        PiePlot piePlot;
        Serializable serializable;
        if (tableOrder == null) {
            throw new IllegalArgumentException("Null 'order' argument.");
        }
        MultiplePiePlot multiplePiePlot = new MultiplePiePlot(categoryDataset);
        multiplePiePlot.setDataExtractOrder(tableOrder);
        multiplePiePlot.setBackgroundPaint(null);
        multiplePiePlot.setOutlineStroke(null);
        JFreeChart jFreeChart = new JFreeChart(new PiePlot3D(null));
        TextTitle textTitle = new TextTitle("Series Title", new Font("SansSerif", 1, 12));
        textTitle.setPosition(RectangleEdge.BOTTOM);
        jFreeChart.setTitle(textTitle);
        jFreeChart.removeLegend();
        jFreeChart.setBackgroundPaint(null);
        multiplePiePlot.setPieChart(jFreeChart);
        if (bl2) {
            serializable = new StandardPieToolTipGenerator();
            piePlot = (PiePlot)multiplePiePlot.getPieChart().getPlot();
            piePlot.setToolTipGenerator((PieToolTipGenerator)((Object)serializable));
        }
        if (bl3) {
            serializable = new StandardPieURLGenerator();
            piePlot = (PiePlot)multiplePiePlot.getPieChart().getPlot();
            piePlot.setURLGenerator((PieURLGenerator)((Object)serializable));
        }
        serializable = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, multiplePiePlot, bl);
        currentTheme.apply((JFreeChart)serializable);
        return serializable;
    }

    public static JFreeChart createBarChart(String string, String string2, String string3, CategoryDataset categoryDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        Serializable serializable;
        Serializable serializable2;
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        CategoryAxis categoryAxis = new CategoryAxis(string2);
        NumberAxis numberAxis = new NumberAxis(string3);
        BarRenderer barRenderer = new BarRenderer();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            serializable2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE3, TextAnchor.CENTER_LEFT);
            barRenderer.setBasePositiveItemLabelPosition((ItemLabelPosition)serializable2);
            serializable = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE9, TextAnchor.CENTER_RIGHT);
            barRenderer.setBaseNegativeItemLabelPosition((ItemLabelPosition)serializable);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            serializable2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER);
            barRenderer.setBasePositiveItemLabelPosition((ItemLabelPosition)serializable2);
            serializable = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.TOP_CENTER);
            barRenderer.setBaseNegativeItemLabelPosition((ItemLabelPosition)serializable);
        }
        if (bl2) {
            barRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        }
        if (bl3) {
            barRenderer.setBaseItemURLGenerator(new StandardCategoryURLGenerator());
        }
        serializable2 = new CategoryPlot(categoryDataset, categoryAxis, numberAxis, barRenderer);
        ((CategoryPlot)serializable2).setOrientation(plotOrientation);
        serializable = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, (Plot)serializable2, bl);
        currentTheme.apply((JFreeChart)serializable);
        return serializable;
    }

    public static JFreeChart createStackedBarChart(String string, String string2, String string3, CategoryDataset categoryDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        CategoryAxis categoryAxis = new CategoryAxis(string2);
        NumberAxis numberAxis = new NumberAxis(string3);
        StackedBarRenderer stackedBarRenderer = new StackedBarRenderer();
        if (bl2) {
            stackedBarRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        }
        if (bl3) {
            stackedBarRenderer.setBaseItemURLGenerator(new StandardCategoryURLGenerator());
        }
        CategoryPlot categoryPlot = new CategoryPlot(categoryDataset, categoryAxis, numberAxis, stackedBarRenderer);
        categoryPlot.setOrientation(plotOrientation);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, categoryPlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createBarChart3D(String string, String string2, String string3, CategoryDataset categoryDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        CategoryAxis3D categoryAxis3D = new CategoryAxis3D(string2);
        NumberAxis3D numberAxis3D = new NumberAxis3D(string3);
        BarRenderer3D barRenderer3D = new BarRenderer3D();
        if (bl2) {
            barRenderer3D.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        }
        if (bl3) {
            barRenderer3D.setBaseItemURLGenerator(new StandardCategoryURLGenerator());
        }
        CategoryPlot categoryPlot = new CategoryPlot(categoryDataset, categoryAxis3D, numberAxis3D, barRenderer3D);
        categoryPlot.setOrientation(plotOrientation);
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            categoryPlot.setRowRenderingOrder(SortOrder.DESCENDING);
            categoryPlot.setColumnRenderingOrder(SortOrder.DESCENDING);
        }
        categoryPlot.setForegroundAlpha(0.75f);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, categoryPlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createStackedBarChart3D(String string, String string2, String string3, CategoryDataset categoryDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        CategoryAxis3D categoryAxis3D = new CategoryAxis3D(string2);
        NumberAxis3D numberAxis3D = new NumberAxis3D(string3);
        StackedBarRenderer3D stackedBarRenderer3D = new StackedBarRenderer3D();
        if (bl2) {
            stackedBarRenderer3D.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        }
        if (bl3) {
            stackedBarRenderer3D.setBaseItemURLGenerator(new StandardCategoryURLGenerator());
        }
        CategoryPlot categoryPlot = new CategoryPlot(categoryDataset, categoryAxis3D, numberAxis3D, stackedBarRenderer3D);
        categoryPlot.setOrientation(plotOrientation);
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            categoryPlot.setColumnRenderingOrder(SortOrder.DESCENDING);
        }
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, categoryPlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createAreaChart(String string, String string2, String string3, CategoryDataset categoryDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        CategoryAxis categoryAxis = new CategoryAxis(string2);
        categoryAxis.setCategoryMargin(0.0);
        NumberAxis numberAxis = new NumberAxis(string3);
        AreaRenderer areaRenderer = new AreaRenderer();
        if (bl2) {
            areaRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        }
        if (bl3) {
            areaRenderer.setBaseItemURLGenerator(new StandardCategoryURLGenerator());
        }
        CategoryPlot categoryPlot = new CategoryPlot(categoryDataset, categoryAxis, numberAxis, areaRenderer);
        categoryPlot.setOrientation(plotOrientation);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, categoryPlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createStackedAreaChart(String string, String string2, String string3, CategoryDataset categoryDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        CategoryAxis categoryAxis = new CategoryAxis(string2);
        categoryAxis.setCategoryMargin(0.0);
        NumberAxis numberAxis = new NumberAxis(string3);
        StackedAreaRenderer stackedAreaRenderer = new StackedAreaRenderer();
        if (bl2) {
            stackedAreaRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        }
        if (bl3) {
            stackedAreaRenderer.setBaseItemURLGenerator(new StandardCategoryURLGenerator());
        }
        CategoryPlot categoryPlot = new CategoryPlot(categoryDataset, categoryAxis, numberAxis, stackedAreaRenderer);
        categoryPlot.setOrientation(plotOrientation);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, categoryPlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createLineChart(String string, String string2, String string3, CategoryDataset categoryDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        CategoryAxis categoryAxis = new CategoryAxis(string2);
        NumberAxis numberAxis = new NumberAxis(string3);
        LineAndShapeRenderer lineAndShapeRenderer = new LineAndShapeRenderer(true, false);
        if (bl2) {
            lineAndShapeRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        }
        if (bl3) {
            lineAndShapeRenderer.setBaseItemURLGenerator(new StandardCategoryURLGenerator());
        }
        CategoryPlot categoryPlot = new CategoryPlot(categoryDataset, categoryAxis, numberAxis, lineAndShapeRenderer);
        categoryPlot.setOrientation(plotOrientation);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, categoryPlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createLineChart3D(String string, String string2, String string3, CategoryDataset categoryDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        CategoryAxis3D categoryAxis3D = new CategoryAxis3D(string2);
        NumberAxis3D numberAxis3D = new NumberAxis3D(string3);
        LineRenderer3D lineRenderer3D = new LineRenderer3D();
        if (bl2) {
            lineRenderer3D.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
        }
        if (bl3) {
            lineRenderer3D.setBaseItemURLGenerator(new StandardCategoryURLGenerator());
        }
        CategoryPlot categoryPlot = new CategoryPlot(categoryDataset, categoryAxis3D, numberAxis3D, lineRenderer3D);
        categoryPlot.setOrientation(plotOrientation);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, categoryPlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createGanttChart(String string, String string2, String string3, IntervalCategoryDataset intervalCategoryDataset, boolean bl, boolean bl2, boolean bl3) {
        CategoryAxis categoryAxis = new CategoryAxis(string2);
        DateAxis dateAxis = new DateAxis(string3);
        GanttRenderer ganttRenderer = new GanttRenderer();
        if (bl2) {
            ganttRenderer.setBaseToolTipGenerator(new IntervalCategoryToolTipGenerator("{3} - {4}", DateFormat.getDateInstance()));
        }
        if (bl3) {
            ganttRenderer.setBaseItemURLGenerator(new StandardCategoryURLGenerator());
        }
        CategoryPlot categoryPlot = new CategoryPlot(intervalCategoryDataset, categoryAxis, dateAxis, ganttRenderer);
        categoryPlot.setOrientation(PlotOrientation.HORIZONTAL);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, categoryPlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createWaterfallChart(String string, String string2, String string3, CategoryDataset categoryDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        Serializable serializable;
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        CategoryAxis categoryAxis = new CategoryAxis(string2);
        categoryAxis.setCategoryMargin(0.0);
        NumberAxis numberAxis = new NumberAxis(string3);
        WaterfallBarRenderer waterfallBarRenderer = new WaterfallBarRenderer();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            serializable = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER, TextAnchor.CENTER, 1.5707963267948966);
            waterfallBarRenderer.setBasePositiveItemLabelPosition((ItemLabelPosition)serializable);
            waterfallBarRenderer.setBaseNegativeItemLabelPosition((ItemLabelPosition)serializable);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            serializable = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER, TextAnchor.CENTER, 0.0);
            waterfallBarRenderer.setBasePositiveItemLabelPosition((ItemLabelPosition)serializable);
            waterfallBarRenderer.setBaseNegativeItemLabelPosition((ItemLabelPosition)serializable);
        }
        if (bl2) {
            serializable = new StandardCategoryToolTipGenerator();
            waterfallBarRenderer.setBaseToolTipGenerator((CategoryToolTipGenerator)((Object)serializable));
        }
        if (bl3) {
            waterfallBarRenderer.setBaseItemURLGenerator(new StandardCategoryURLGenerator());
        }
        serializable = new CategoryPlot(categoryDataset, categoryAxis, numberAxis, waterfallBarRenderer);
        ((CategoryPlot)serializable).clearRangeMarkers();
        ValueMarker valueMarker = new ValueMarker(0.0);
        valueMarker.setPaint(Color.black);
        ((CategoryPlot)serializable).addRangeMarker(valueMarker, Layer.FOREGROUND);
        ((CategoryPlot)serializable).setOrientation(plotOrientation);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, (Plot)serializable, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createPolarChart(String string, XYDataset xYDataset, boolean bl, boolean bl2, boolean bl3) {
        PolarPlot polarPlot = new PolarPlot();
        polarPlot.setDataset(xYDataset);
        NumberAxis numberAxis = new NumberAxis();
        numberAxis.setAxisLineVisible(false);
        numberAxis.setTickMarksVisible(false);
        numberAxis.setTickLabelInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        polarPlot.setAxis(numberAxis);
        polarPlot.setRenderer(new DefaultPolarItemRenderer());
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, polarPlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createScatterPlot(String string, String string2, String string3, XYDataset xYDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        NumberAxis numberAxis = new NumberAxis(string2);
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxis numberAxis2 = new NumberAxis(string3);
        numberAxis2.setAutoRangeIncludesZero(false);
        XYPlot xYPlot = new XYPlot(xYDataset, numberAxis, numberAxis2, null);
        StandardXYToolTipGenerator standardXYToolTipGenerator = null;
        if (bl2) {
            standardXYToolTipGenerator = new StandardXYToolTipGenerator();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl3) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer(false, true);
        xYLineAndShapeRenderer.setBaseToolTipGenerator(standardXYToolTipGenerator);
        xYLineAndShapeRenderer.setURLGenerator(standardXYURLGenerator);
        xYPlot.setRenderer(xYLineAndShapeRenderer);
        xYPlot.setOrientation(plotOrientation);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createXYBarChart(String string, String string2, boolean bl, String string3, IntervalXYDataset intervalXYDataset, PlotOrientation plotOrientation, boolean bl2, boolean bl3, boolean bl4) {
        PublicCloneable publicCloneable;
        NumberAxis numberAxis;
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        ValueAxis valueAxis = null;
        if (bl) {
            valueAxis = new DateAxis(string2);
        } else {
            numberAxis = new NumberAxis(string2);
            numberAxis.setAutoRangeIncludesZero(false);
            valueAxis = numberAxis;
        }
        numberAxis = new NumberAxis(string3);
        XYBarRenderer xYBarRenderer = new XYBarRenderer();
        if (bl3) {
            publicCloneable = bl ? StandardXYToolTipGenerator.getTimeSeriesInstance() : new StandardXYToolTipGenerator();
            xYBarRenderer.setBaseToolTipGenerator((XYToolTipGenerator)((Object)publicCloneable));
        }
        if (bl4) {
            xYBarRenderer.setURLGenerator(new StandardXYURLGenerator());
        }
        publicCloneable = new XYPlot(intervalXYDataset, valueAxis, numberAxis, xYBarRenderer);
        ((XYPlot)publicCloneable).setOrientation(plotOrientation);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, (Plot)publicCloneable, bl2);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createXYAreaChart(String string, String string2, String string3, XYDataset xYDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        NumberAxis numberAxis = new NumberAxis(string2);
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxis numberAxis2 = new NumberAxis(string3);
        XYPlot xYPlot = new XYPlot(xYDataset, numberAxis, numberAxis2, null);
        xYPlot.setOrientation(plotOrientation);
        xYPlot.setForegroundAlpha(0.5f);
        StandardXYToolTipGenerator standardXYToolTipGenerator = null;
        if (bl2) {
            standardXYToolTipGenerator = new StandardXYToolTipGenerator();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl3) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        xYPlot.setRenderer(new XYAreaRenderer(4, standardXYToolTipGenerator, standardXYURLGenerator));
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createStackedXYAreaChart(String string, String string2, String string3, TableXYDataset tableXYDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        NumberAxis numberAxis = new NumberAxis(string2);
        numberAxis.setAutoRangeIncludesZero(false);
        numberAxis.setLowerMargin(0.0);
        numberAxis.setUpperMargin(0.0);
        NumberAxis numberAxis2 = new NumberAxis(string3);
        StandardXYToolTipGenerator standardXYToolTipGenerator = null;
        if (bl2) {
            standardXYToolTipGenerator = new StandardXYToolTipGenerator();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl3) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        StackedXYAreaRenderer2 stackedXYAreaRenderer2 = new StackedXYAreaRenderer2(standardXYToolTipGenerator, standardXYURLGenerator);
        stackedXYAreaRenderer2.setOutline(true);
        XYPlot xYPlot = new XYPlot(tableXYDataset, numberAxis, numberAxis2, stackedXYAreaRenderer2);
        xYPlot.setOrientation(plotOrientation);
        xYPlot.setRangeAxis(numberAxis2);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createXYLineChart(String string, String string2, String string3, XYDataset xYDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        NumberAxis numberAxis = new NumberAxis(string2);
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxis numberAxis2 = new NumberAxis(string3);
        XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer(true, false);
        XYPlot xYPlot = new XYPlot(xYDataset, numberAxis, numberAxis2, xYLineAndShapeRenderer);
        xYPlot.setOrientation(plotOrientation);
        if (bl2) {
            xYLineAndShapeRenderer.setBaseToolTipGenerator(new StandardXYToolTipGenerator());
        }
        if (bl3) {
            xYLineAndShapeRenderer.setURLGenerator(new StandardXYURLGenerator());
        }
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createXYStepChart(String string, String string2, String string3, XYDataset xYDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        DateAxis dateAxis = new DateAxis(string2);
        NumberAxis numberAxis = new NumberAxis(string3);
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        StandardXYToolTipGenerator standardXYToolTipGenerator = null;
        if (bl2) {
            standardXYToolTipGenerator = new StandardXYToolTipGenerator();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl3) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        XYStepRenderer xYStepRenderer = new XYStepRenderer(standardXYToolTipGenerator, standardXYURLGenerator);
        XYPlot xYPlot = new XYPlot(xYDataset, dateAxis, numberAxis, null);
        xYPlot.setRenderer(xYStepRenderer);
        xYPlot.setOrientation(plotOrientation);
        xYPlot.setDomainCrosshairVisible(false);
        xYPlot.setRangeCrosshairVisible(false);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createXYStepAreaChart(String string, String string2, String string3, XYDataset xYDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        NumberAxis numberAxis = new NumberAxis(string2);
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxis numberAxis2 = new NumberAxis(string3);
        StandardXYToolTipGenerator standardXYToolTipGenerator = null;
        if (bl2) {
            standardXYToolTipGenerator = new StandardXYToolTipGenerator();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl3) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        XYStepAreaRenderer xYStepAreaRenderer = new XYStepAreaRenderer(3, standardXYToolTipGenerator, standardXYURLGenerator);
        XYPlot xYPlot = new XYPlot(xYDataset, numberAxis, numberAxis2, null);
        xYPlot.setRenderer(xYStepAreaRenderer);
        xYPlot.setOrientation(plotOrientation);
        xYPlot.setDomainCrosshairVisible(false);
        xYPlot.setRangeCrosshairVisible(false);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createTimeSeriesChart(String string, String string2, String string3, XYDataset xYDataset, boolean bl, boolean bl2, boolean bl3) {
        DateAxis dateAxis = new DateAxis(string2);
        dateAxis.setLowerMargin(0.02);
        dateAxis.setUpperMargin(0.02);
        NumberAxis numberAxis = new NumberAxis(string3);
        numberAxis.setAutoRangeIncludesZero(false);
        XYPlot xYPlot = new XYPlot(xYDataset, dateAxis, numberAxis, null);
        StandardXYToolTipGenerator standardXYToolTipGenerator = null;
        if (bl2) {
            standardXYToolTipGenerator = StandardXYToolTipGenerator.getTimeSeriesInstance();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl3) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer(true, false);
        xYLineAndShapeRenderer.setBaseToolTipGenerator(standardXYToolTipGenerator);
        xYLineAndShapeRenderer.setURLGenerator(standardXYURLGenerator);
        xYPlot.setRenderer(xYLineAndShapeRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createCandlestickChart(String string, String string2, String string3, OHLCDataset oHLCDataset, boolean bl) {
        DateAxis dateAxis = new DateAxis(string2);
        NumberAxis numberAxis = new NumberAxis(string3);
        XYPlot xYPlot = new XYPlot(oHLCDataset, dateAxis, numberAxis, null);
        xYPlot.setRenderer(new CandlestickRenderer());
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createHighLowChart(String string, String string2, String string3, OHLCDataset oHLCDataset, boolean bl) {
        DateAxis dateAxis = new DateAxis(string2);
        NumberAxis numberAxis = new NumberAxis(string3);
        HighLowRenderer highLowRenderer = new HighLowRenderer();
        highLowRenderer.setBaseToolTipGenerator(new HighLowItemLabelGenerator());
        XYPlot xYPlot = new XYPlot(oHLCDataset, dateAxis, numberAxis, highLowRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createHighLowChart(String string, String string2, String string3, OHLCDataset oHLCDataset, Timeline timeline, boolean bl) {
        DateAxis dateAxis = new DateAxis(string2);
        dateAxis.setTimeline(timeline);
        NumberAxis numberAxis = new NumberAxis(string3);
        HighLowRenderer highLowRenderer = new HighLowRenderer();
        highLowRenderer.setBaseToolTipGenerator(new HighLowItemLabelGenerator());
        XYPlot xYPlot = new XYPlot(oHLCDataset, dateAxis, numberAxis, highLowRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createBubbleChart(String string, String string2, String string3, XYZDataset xYZDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        NumberAxis numberAxis = new NumberAxis(string2);
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxis numberAxis2 = new NumberAxis(string3);
        numberAxis2.setAutoRangeIncludesZero(false);
        XYPlot xYPlot = new XYPlot(xYZDataset, numberAxis, numberAxis2, null);
        XYBubbleRenderer xYBubbleRenderer = new XYBubbleRenderer(2);
        if (bl2) {
            xYBubbleRenderer.setBaseToolTipGenerator(new StandardXYZToolTipGenerator());
        }
        if (bl3) {
            xYBubbleRenderer.setURLGenerator(new StandardXYZURLGenerator());
        }
        xYPlot.setRenderer(xYBubbleRenderer);
        xYPlot.setOrientation(plotOrientation);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createHistogram(String string, String string2, String string3, IntervalXYDataset intervalXYDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        NumberAxis numberAxis = new NumberAxis(string2);
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxis numberAxis2 = new NumberAxis(string3);
        XYBarRenderer xYBarRenderer = new XYBarRenderer();
        if (bl2) {
            xYBarRenderer.setBaseToolTipGenerator(new StandardXYToolTipGenerator());
        }
        if (bl3) {
            xYBarRenderer.setURLGenerator(new StandardXYURLGenerator());
        }
        XYPlot xYPlot = new XYPlot(intervalXYDataset, numberAxis, numberAxis2, xYBarRenderer);
        xYPlot.setOrientation(plotOrientation);
        xYPlot.setDomainZeroBaselineVisible(true);
        xYPlot.setRangeZeroBaselineVisible(true);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createBoxAndWhiskerChart(String string, String string2, String string3, BoxAndWhiskerCategoryDataset boxAndWhiskerCategoryDataset, boolean bl) {
        CategoryAxis categoryAxis = new CategoryAxis(string2);
        NumberAxis numberAxis = new NumberAxis(string3);
        numberAxis.setAutoRangeIncludesZero(false);
        BoxAndWhiskerRenderer boxAndWhiskerRenderer = new BoxAndWhiskerRenderer();
        boxAndWhiskerRenderer.setBaseToolTipGenerator(new BoxAndWhiskerToolTipGenerator());
        CategoryPlot categoryPlot = new CategoryPlot(boxAndWhiskerCategoryDataset, categoryAxis, numberAxis, boxAndWhiskerRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, categoryPlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createBoxAndWhiskerChart(String string, String string2, String string3, BoxAndWhiskerXYDataset boxAndWhiskerXYDataset, boolean bl) {
        DateAxis dateAxis = new DateAxis(string2);
        NumberAxis numberAxis = new NumberAxis(string3);
        numberAxis.setAutoRangeIncludesZero(false);
        XYBoxAndWhiskerRenderer xYBoxAndWhiskerRenderer = new XYBoxAndWhiskerRenderer(10.0);
        XYPlot xYPlot = new XYPlot(boxAndWhiskerXYDataset, dateAxis, numberAxis, xYBoxAndWhiskerRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createWindPlot(String string, String string2, String string3, WindDataset windDataset, boolean bl, boolean bl2, boolean bl3) {
        DateAxis dateAxis = new DateAxis(string2);
        NumberAxis numberAxis = new NumberAxis(string3);
        numberAxis.setRange(-12.0, 12.0);
        WindItemRenderer windItemRenderer = new WindItemRenderer();
        if (bl2) {
            windItemRenderer.setBaseToolTipGenerator(new StandardXYToolTipGenerator());
        }
        if (bl3) {
            windItemRenderer.setURLGenerator(new StandardXYURLGenerator());
        }
        XYPlot xYPlot = new XYPlot(windDataset, dateAxis, numberAxis, windItemRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, xYPlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }

    public static JFreeChart createWaferMapChart(String string, WaferMapDataset waferMapDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        WaferMapPlot waferMapPlot = new WaferMapPlot(waferMapDataset);
        WaferMapRenderer waferMapRenderer = new WaferMapRenderer();
        waferMapPlot.setRenderer(waferMapRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChart.DEFAULT_TITLE_FONT, waferMapPlot, bl);
        currentTheme.apply(jFreeChart);
        return jFreeChart;
    }
}

